
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
(defun print-rule-summary (clauses)
  (mapc #'print-clause-summary clauses)
  (values))

(defun print-clause-summary (clause &aux c)
  (format t "~%---------New Clause---------~%")
  (do ((l clause (literal-next l)))
      ((null l))
    (setf c (copy-literal l))
    (setf (literal-next c) nil) ;;only print one literal
    (when  (literal-deleted? c) 
      (format t "~%DELETED DELETED DELETED DELETED DELETED"))
    (format t "~%~a in: ~20T+~a ~27T-~a out: ~40T+~a ~47T-~a"
            c (length (literal-pos c))(length (literal-neg c))
            (length (literal-new-pos c))(length (literal-new-neg c)))
    (format t "~%source ~a" (derivation-type (literal-derivation c)))
    (when (member (derivation-type (literal-derivation c)) '(:ebl :intensional))
      (pprint (mapcar #'(lambda(x)
                                 (if (and (consp x)
                                          (clause-p (car x)))
                                   (cdr x)
                                   x))
                             (derivation-path  (literal-derivation c)))))
    (format t "~%")))
            
