;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;Pict-Scrap.Lisp
;;
;;Copyright  1989, Apple Computer, Inc
;;
;;
;;  This file a scrap-handler for scraps of type PICT
;;
;;  Once this is installed, windows which copy and paste PICTs will
;;  be able to share their work with other applications
;;
;; Modified for 2.0 by Henry Lieberman


(in-package :ccl)

(defclass pict-scrap-handler (scrap-handler) ())

(defmethod set-internal-scrap ((self pict-scrap-handler) scrap)
  (let* ((old-pict (slot-value self 'internal-scrap)))
    (when (handlep old-pict)
      (#_KillPicture old-pict)))
  (call-next-method self scrap)
  (when scrap (pushnew :pict *scrap-state*)))

(defmethod externalize-scrap ((pict-scrap-handler pict-scrap-handler))
  (let* ((the-pict (slot-value pict-scrap-handler 'internal-scrap))
         (size (#_GetHandleSize the-pict)))
    (when the-pict
      (with-dereferenced-handles
        ((the-pict the-pict))
        (#_PutScrap size :pict the-pict)))))

(defmethod internalize-scrap ((pict-scrap-handler pict-scrap-handler))
  (let* ((the-pict (#_NewHandle 0)))
    (rlet ((junk :signed-long))
      (#_GetScrap the-pict :pict junk))
    (setf (slot-value pict-scrap-handler 'internal-scrap) the-pict)))

(defmethod get-internal-scrap ((pict-scrap-handler pict-scrap-handler))
  (slot-value pict-scrap-handler 'internal-scrap))

(pushnew `(:pict . ,(make-instance 'pict-scrap-handler))
         *scrap-handler-alist*
         :test #'equal)