
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; The code contained in this file was written by Cliff Brunk.

(in-package :user)

;;;________________________
;;;  File Menu

(setq *es-file-menu*             
  (make-instance 'menu
    :Menu-title "File"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Save Knowledge Base" :menu-item-action #'(lambda () (dump-kb-to-file))
                         :update-function #'(lambda (item) (if (and (or *intensional-preds* *extensional-preds*) (or *rules-changed* *facts-changed*) *kb-file*)
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Save Knowledge Base As" :menu-item-action #'(lambda () (dump-kb-to-file-as))
                         :update-function #'(lambda (item) (if (or *intensional-preds* *extensional-preds*)
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Clear Knowledge Base" :menu-item-action #'(lambda () (clear-kb))
                         :update-function #'(lambda (item) (if (or *intensional-preds* *extensional-preds*) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Load Knowledge Base" :menu-item-action  #'(lambda () (load-kb)))
          (make-instance 'menu-item :menu-item-title "Merge Knowledge Base" :menu-item-action  #'(lambda () (merge-kb))
                         :update-function #'(lambda (item) (if  *kb-file* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Import Lisp File" :menu-item-action #'(lambda () (load-kb nil)))
          (make-instance 'menu-item :menu-item-title "Compile File" :menu-item-action #'(lambda () (compile-a-file)))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Page Setup" :menu-item-action #'ccl::print-style-dialog)
          (make-instance 'window-menu-item :menu-item-title "Print" :menu-item-action #'window-hardcopy :command-key #\P)
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Preferences" :menu-item-action #'(lambda () (set-preferences)))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Quit" :menu-item-action #'(lambda () (quit-es)) :command-key #\Q))))


;;;________________________
;;;  Expert File Menu

(setq *es-expert-file-menu*             
  (make-instance 'menu
    :Menu-title "File"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Save Knowledge Base" :menu-item-action #'(lambda () (dump-kb-to-file))
                         :update-function #'(lambda (item) (if (and (or *intensional-preds* *extensional-preds*) (or *rules-changed* *facts-changed*) *kb-file*)
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Save Knowledge Base As" :menu-item-action #'(lambda () (dump-kb-to-file-as))
                         :update-function #'(lambda (item) (if (or *intensional-preds* *extensional-preds*)
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Clear Knowledge Base" :menu-item-action #'(lambda () (clear-kb))
                         :update-function #'(lambda (item) (if (or *intensional-preds* *extensional-preds*) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Load Knowledge Base" :menu-item-action  #'(lambda () (load-kb)))
          (make-instance 'menu-item :menu-item-title "Merge Knowledge Base" :menu-item-action  #'(lambda () (merge-kb))
                         :update-function #'(lambda (item) (if  *kb-file*
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Import Lisp File" :menu-item-action #'(lambda () (load-kb nil)))
          (make-instance 'menu-item :menu-item-title "Compile File" :menu-item-action #'(lambda () (compile-a-file)))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "New" :menu-item-action #'fred :command-key #\N)
          (make-instance 'menu-item :menu-item-title "Open" :menu-item-action #'edit-select-file :command-key #\O)
          (make-instance 'menu-item :menu-item-title "Open Selection" :menu-item-action #'ccl::open-selected-file :update-function #'ccl::open-selected-file-menu-item-update)
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'window-menu-item :menu-item-title "Close" :menu-item-action #'window-close :command-key #\W)
          (make-instance 'window-menu-item :menu-item-title "Save" :menu-item-action #'window-save :command-key #\S :update-function #'ccl::save-menu-item-update)
          (make-instance 'window-menu-item :menu-item-title "Save As" :menu-item-action #'window-save-as)
          (make-instance 'window-menu-item :menu-item-title "Save Copy As" :menu-item-action #'window-save-copy-as)
          (make-instance 'window-menu-item :menu-item-title "Revert" :menu-item-action #'window-revert :command-key #\R :update-function #'ccl::revert-menu-item-update)
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Page Setup" :menu-item-action #'ccl::print-style-dialog)
          (make-instance 'window-menu-item :menu-item-title "Print" :menu-item-action #'window-hardcopy :command-key #\P)
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Preferences" :menu-item-action #'(lambda () (set-preferences)))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Return To Lisp" :menu-item-action #'(lambda () (reset-menubar)))
          (make-instance 'menu-item :menu-item-title "Quit" :command-key #\Q :menu-item-action #'(lambda () (quit-es))))))


;;;________________________
;;;  Rules Menu

(setq *es-rules-menu*
  (make-instance
    'menu 
    :Menu-title "Rules"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Show Rule" :menu-item-action #'(lambda () (eval-enqueue '(show-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Show All Rules" :menu-item-action #'(lambda () (eval-enqueue '(show-rules)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "New Rule" :menu-item-action #'(lambda () (eval-enqueue '(new-rule))))
          (make-instance 'menu-item :menu-item-title "Copy Rule" :menu-item-action #'(lambda () (eval-enqueue '(copy-a-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Rename Rule" :menu-item-action #'(lambda () (eval-enqueue '(rename-a-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete Rule" :menu-item-action #'(lambda () (eval-enqueue '(delete-the-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Add Clause To Rule" :menu-item-action #'(lambda () (eval-enqueue '(add-clause-to-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
;          (make-instance 'menu-item :menu-item-title "Add Literal To Clause" :menu-item-action #'(lambda () (eval-enqueue '(add-literal-to-clause)))
;                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
;          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Delete Clause From Rule" :menu-item-action #'(lambda () (eval-enqueue '(delete-clause-from-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete Literal From Clause" :menu-item-action #'(lambda () (eval-enqueue '(delete-literal-from-clause)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Text Edit Clause" :menu-item-action #'(lambda () (eval-enqueue '(text-edit-clause)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Text Edit Rule" :menu-item-action #'(lambda () (eval-enqueue '(text-edit-rule)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Change Vars/English" :menu-item-action #'(lambda () (eval-enqueue '(changes-vars-and-questions)))
                         :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item)))))))


;;;________________________
;;;  Facts Menu

(setq *es-facts-menu*
  (make-instance 'menu 
    :Menu-title "Facts"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Show Fact" :menu-item-action #'(lambda () (eval-enqueue '(show-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Show All Facts" :menu-item-action #'(lambda () (eval-enqueue '(show-facts)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Show Example" :menu-item-action #'(lambda () (eval-enqueue '(show-facts-for-example)))
                         :update-function #'(lambda (item) (if *predicate-being-learned* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Show All Examples" :menu-item-action #'(lambda () (eval-enqueue '(show-all-examples)))
                         :update-function #'(lambda (item) (if *predicate-being-learned* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "New Fact" :menu-item-action #'(lambda () (eval-enqueue '(new-fact))))
          (make-instance 'menu-item :menu-item-title "Rename Fact" :menu-item-action #'(lambda () (eval-enqueue '(rename-a-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete Fact" :menu-item-action #'(lambda () (eval-enqueue '(delete-entire-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Delete Positive Fact" :menu-item-action #'(lambda () (eval-enqueue '(delete-fact)))
                             :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete Negative Fact" :menu-item-action #'(lambda () (eval-enqueue '(delete-negative-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Retract New Facts" :menu-item-action #'(lambda () (eval-enqueue '(record-changes-to-facts?)))
                         :update-function #'(lambda (item) (if (or *new-facts-pos* *new-facts-neg*) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete Example" :menu-item-action #'(lambda () (eval-enqueue '(show-facts-for-example :delete)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete All Examples" :menu-item-action #'(lambda () (eval-enqueue '(delete-all-examples)))
                         :update-function #'(lambda (item) (if *predicate-being-learned* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Text Edit Fact" :menu-item-action #'(lambda () (eval-enqueue '(text-edit-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Add English" :menu-item-action #'(lambda () (eval-enqueue '(add-questions-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Change English" :menu-item-action #'(lambda () (eval-enqueue '(change-questions-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete English" :menu-item-action #'(lambda () (eval-enqueue '(delete-questions-fact)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Change Variable Type" :menu-item-action #'(lambda () (eval-enqueue '(change-var-type)))
                         :update-function #'(lambda (item) (if *extensional-preds* (menu-item-enable item) (menu-item-disable item)))))))

;;;________________________
;;;  Type Menu

(setq *es-type-menu*
  (make-instance 'menu 
    :Menu-title "Types"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Show Type" :menu-item-action #'(lambda () (eval-enqueue '(list-a-type)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Show All Types" :menu-item-action #'(lambda () (eval-enqueue '(list-types)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "New Type" :menu-item-action  #'(lambda () (eval-enqueue '(new-type)))
                         :update-function #'(lambda (item) (menu-item-enable item)))
          (make-instance 'menu-item :menu-item-title "Copy Type" :menu-item-action #'(lambda () (eval-enqueue '(copy-type)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Rename Type" :menu-item-action #'(lambda () (eval-enqueue '(rename-type)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete Type" :menu-item-action #'(lambda () (eval-enqueue '(delete-type)))
                          :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Add To Type" :menu-item-action #'(lambda () (eval-enqueue '(add-to-type)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Delete From Type" :menu-item-action #'(lambda () (eval-enqueue '(delete-from-type)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-")
          (make-instance 'menu-item :menu-item-title "Text Edit Type" :menu-item-action #'(lambda () (eval-enqueue '(manipulate-type)))
                         :update-function #'(lambda (item) (if *all-types* (menu-item-enable item) (menu-item-disable item))))
          )))

;;;________________________
;;;  Run Menu

(setq *es-run-menu*
    (make-instance 'menu 
      :Menu-title "Run"
      :menu-items
      (list (make-instance 'menu-item :menu-item-title "Run On New Example" :menu-item-action #'(lambda () (eval-enqueue '(run-rules-on-examples t)))
                           :update-function #'(lambda (item) (reset-trace-deeply)  ;ugly- for sideffect
                                               (let ((r-struct (get-r-struct *predicate-being-learned*)))
                                                 (if (and *intensional-preds* *extensional-preds* (r-p r-struct))
                                                   (menu-item-enable item) (menu-item-disable item)))))
            (make-instance 'menu-item :menu-item-title "Run On Old Example" :menu-item-action #'(lambda () (eval-enqueue '(run-rules-on-examples)))
                           :update-function #'(lambda (item) (let ((r-struct (get-r-struct *predicate-being-learned*)))
                                                               (if (and *intensional-preds* *extensional-preds* (r-p r-struct)
                                                                        (or (r-pos  r-struct)
                                                                            (r-neg  r-struct)))
                                                                 (menu-item-enable item) (menu-item-disable item)))))
            (make-instance 'menu-item :menu-item-title "Test On All Examples" :menu-item-action #'(lambda () (eval-enqueue '(test-on-all-examples)))
                           :update-function #'(lambda (item) (let ((r-struct (get-r-struct *predicate-being-learned*)))
                                                               (if (and *intensional-preds* *extensional-preds* (r-p r-struct)
                                                                        (or (r-pos  r-struct)
                                                                            (r-neg  r-struct)))
                                                                 (menu-item-enable item) (menu-item-disable item)))))
            (make-instance 'menu-item :menu-item-title "-")
            (make-instance 'menu-item :menu-item-title "Analyze Coverage" :menu-item-action #'(lambda () (eval-enqueue '(analyze-coverage)))
                           :update-function #'(lambda (item) (if (and (fboundp 'analyze-coverage)
                                                                      (some #'rule-p *r-structs*)
                                                                      (some #'pred-p *r-structs*))
                                                               (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "-")
            (make-instance 'menu-item :menu-item-title "Prove Goal" :menu-item-action #'(lambda () (eval-enqueue '(create-prove-goal-window))))
            
            (make-instance 'menu-item :menu-item-title "Find All Proofs" :menu-item-action #'(lambda () (eval-enqueue '(bagof-on-example)))
                           :update-function #'(lambda (item) (let ((r-struct (get-r-struct *predicate-being-learned*)))
                                                               (if (and *intensional-preds* *extensional-preds* (r-p r-struct)
                                                                        (or (r-pos  r-struct)
                                                                            (r-neg  r-struct)))
                                                                 (menu-item-enable item) (menu-item-disable item)))))
            (make-instance 'menu-item :menu-item-title "-")
            (make-instance 'menu-item :menu-item-title "Who Calls" :menu-item-action #'(lambda () (eval-enqueue '(who-calls)))
                           :update-function #'(lambda (item) (if  *intensional-preds*  (menu-item-enable item) (menu-item-disable item)))) 
            ;(make-instance 'menu-item :menu-item-title "Edit Callers" :menu-item-action #'(lambda () (eval-enqueue '(who-calls nil t)))
            ;               :update-function #'(lambda (item) (if *intensional-preds*  (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "Check Rules" :menu-item-action #'(lambda () (eval-enqueue '(check-rules)))
                           :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "Edit Rule Warnings" :menu-item-action #'(lambda () (eval-enqueue '(check-rules t)))
                           :update-function #'(lambda (item) (if  *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "-")
            (make-instance 'menu-item :menu-item-title "Explain Last Proof" :menu-item-action  #'(lambda () (eval-enqueue '(explain-last)))
                           :update-function #'(lambda (item) (if (and *intensional-preds* *last-explanation*) (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "-")
            (make-instance 'menu-item :menu-item-title "Initialize Rules and Facts" :menu-item-action #'(lambda () (eval-enqueue '(initialize-everything))))
            (make-instance 'menu-item :menu-item-title "Change Top Level Predicate" :menu-item-action #'(lambda () (eval-enqueue '(change-top)))
                           :update-function #'(lambda (item) (if *intensional-preds* (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "-")
            (make-instance 'menu-item :menu-item-title "Trace All" :menu-item-action #'(lambda () (eval-enqueue '(trace-all)))
                           :update-function #'(lambda (item) (if (eq *traced-predicates* :all) (menu-item-disable item) (menu-item-enable item))))
            (make-instance 'menu-item :menu-item-title "Untrace All" :menu-item-action #'(lambda () (eval-enqueue '(untrace-all)))  
                           :update-function #'(lambda (item) (if *traced-predicates* (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "Add Trace" :menu-item-action #'(lambda () (eval-enqueue '(add-trace)))
                           :update-function #'(lambda (item) (if (eq *traced-predicates* :all) (menu-item-disable item) (menu-item-enable item))))
            (make-instance 'menu-item :menu-item-title "Remove Trace" :menu-item-action #'(lambda () (eval-enqueue '(remove-trace)))
                           :update-function #'(lambda (item) (if (and *traced-predicates* (not (eq *traced-predicates* :all))) (menu-item-enable item) (menu-item-disable item))))
            (make-instance 'menu-item :menu-item-title "Add Spy" :menu-item-action #'(lambda () (eval-enqueue '(add-spy))))
            (make-instance 'menu-item :menu-item-title "Remove Spy" :menu-item-action #'(lambda () (eval-enqueue '(remove-spy)))
                           :update-function #'(lambda (item) (if *spy-preds* (menu-item-enable item) (menu-item-disable item))))
            
            )))

;;;________________________
;;;  Windows Menu

(defparameter *close-inspect-windows-menu-item*
  (make-instance 
   'menu-item 
   :menu-item-title "Close Inspect & Backtrace Windows"
   :menu-item-action 
   #'(lambda ()
      (map-windows #'window-close :class 'inspector::backtrace-window :include-invisibles t)
      (map-windows #'window-close :class 'inspector::inspector-window :include-invisibles t)) ))

(defparameter *close-examples-windows-menu-item*
  (make-instance
   'menu-item 
   :menu-item-title "Close Example & Tuple Windows"
   :menu-item-action 
   #'(lambda ()
       (map-windows #'window-close :class 'examples-window :include-invisibles t)) ))

(defparameter *close-graph-windows-menu-item*
  (make-instance
   'menu-item 
   :menu-item-title "Close Graph Windows"
   :menu-item-action 
   #'(lambda ()
       (map-windows #'window-close :class 'graph-window :include-invisibles t)) ))

(defparameter *close-learning-windows-menu-item*
  (make-instance
   'menu-item 
   :menu-item-title "Close Learning Windows"
   :menu-item-action 
   #'(lambda ()
       (map-windows #'window-close :class 'learning-window :include-invisibles t)
       (map-windows #'window-close :class 'analyze-window :include-invisibles t)
       (if (window-open? *WORK-WINDOW*) (window-close *WORK-WINDOW*))) ))

(setq *es-windows-menu*
  (make-instance 
    'menu
    :menu-title "Windows"
    :update-function 
    #'(lambda (menu)
        (apply 'remove-menu-items menu (menu-items menu))
        (let ((backtrace-class (find-class 'INSPECTOR::BACKTRACE-WINDOW))
              (inspector-class (find-class 'INSPECTOR::INSPECTOR-WINDOW))
              (rule-edit-window-class (find-class 'rule-edit-window))
              (theory-edit-window-class (find-class 'theory-edit-window))
              (graph-window-class (find-class 'graph-window))
              (fred-window-class (find-class 'fred-window))
              (learning-window-class (find-class 'learning-window))
              (analyze-window-class (find-class 'analyze-window))
              (winners-window-class (find-class 'winners-window))
              (gain-window-class (find-class 'gain-window))
              (examples-window-class (find-class 'examples-window))
              (close-learning? (window-open? *WORK-WINDOW*))
              close-inspector? close-graph? close-examples? item window-class)
          (map-windows #'(lambda (w)
                           (let ((wc (class-of w)))
                             (cond ((eq wc backtrace-class) (setf close-inspector? t))
                                   ((eq wc inspector-class) (setf close-inspector? t))
                                   ((eq wc graph-window-class) (setf close-graph? t))
                                   ((eq wc learning-window-class) (setf close-learning? t))
                                   ((eq wc analyze-window-class) (setf close-learning? t))
                                   ((eq wc gain-window-class) (setf close-learning? t))
                                   ((eq wc examples-window-class) (setf close-examples? t)))))
                       :include-invisibles t)
          
          (when close-inspector? (add-menu-items menu *close-inspect-windows-menu-item*))
          (when close-examples? (add-menu-items menu *close-examples-windows-menu-item*))
          (when close-graph? (add-menu-items menu *close-graph-windows-menu-item*))
          (when close-learning? (add-menu-items menu *close-learning-windows-menu-item*))
          (when (or close-inspector? close-graph? close-learning? close-examples?)
            (add-menu-items menu (make-instance 'menu-item :menu-item-title "-" :disabled t)))
          (map-windows
           #'(lambda (window)
               (setf item (make-instance 'menu-item
                            :menu-item-title (window-title window)
                            :disabled (eq window (front-window)))
                     window-class (class-of window))
               (set-menu-item-action-function item #'(lambda ()
                                                       (window-show window)
                                                       (window-select window)))
               (cond ((eq window *top-listener*)
                      (set-command-key item #\L))
                     ((and (eq window-class fred-window-class)
                           (window-needs-saving-p window))
                      (set-menu-item-check-mark item #\))
                     ((or (eq window-class learning-window-class)
                          (eq window-class gain-window-class)
                          (eq window-class winners-window-class)
                          (eq window-class analyze-window-class)
                          (eq window *WORK-WINDOW*))
                      (set-menu-item-check-mark item #\))
                     ((or (eq window-class rule-edit-window-class)
                          (eq window-class theory-edit-window-class))
                      (set-menu-item-check-mark item #\))
                     ((eq window-class graph-window-class)
                      (set-menu-item-check-mark item #\))
                     ((eq window-class examples-window-class)
                      (set-menu-item-check-mark item #\)))
               (add-menu-items menu item))
           :include-invisibles t)))))

;;;________________________
;;;  Display Menu

(setq *es-display-menu* 
  (make-instance
    'menu
    :menu-title "Display"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Examples"
                         :menu-item-action #'(lambda () (display-top-level-examples))
                         :update-function #'(lambda (item) (if (and (get-pred (predicate-being-learned)) (fboundp 'display-examples))
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Templates" :menu-item-action #'(lambda () (manipulate-templates)))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Relations" :menu-item-action #'(lambda () (manipulate-relation)))
          (make-instance 'menu-item :menu-item-title "Types" :menu-item-action #'(lambda () (manipulate-type)))
          (make-instance 'menu-item :menu-item-title "Clichs" :menu-item-action #'(lambda () (manipulate-cliche)))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Goal Concept" :menu-item-action #'(lambda () (display-goal-concept))
                         :update-function #'(lambda (item) (if (get-rule (goal-concept-name)) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Domain Theory" :menu-item-action #'(lambda () (display-domain-theory))
                         :update-function #'(lambda (item) (if (some-relation-is-user-defined) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Learned Description" :menu-item-action #'(lambda () (display-learned-description))
                         :update-function #'(lambda (item) (if (and *learned-description-head* *learned-description*) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Window Setup" :menu-item-action #'(lambda () (window-setup (front-window)))
                         :update-function #'(lambda (item) (if (graph-scroller (front-window)) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Default Setup" :menu-item-action #'(lambda () (default-setup))))))

;;;_____________________________________________________________________
;;;  Learn Menu

(setq *es-learn-menu*  
  (make-instance 'menu
    :menu-title "Learn"
    :menu-items
    (list (make-instance 'menu-item :menu-item-title "Parameter Settings" :menu-item-action #'(lambda () (change-learning-parameters))
                         :update-function #'(lambda (item) (if (some #'pred-p *r-structs*) (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "Set Builtin Flags"
                         :menu-item-action #'(lambda () (eval-enqueue '(builtin-flags))))
          (make-instance 'menu-item :menu-item-title "Set Avaliable Clichs"
                         :menu-item-action #'(lambda () (eval-enqueue '(avaliable-cliches))))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Learn" :menu-item-action #'(lambda () (eval-enqueue '(learn)))
                         :update-function #'(lambda (item) (if (and (fboundp 'find-concept-description) (get-r-struct (predicate-being-learned)))
                                                             (menu-item-enable item) (menu-item-disable item))))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Revise" :menu-item-action #'(lambda () (eval-enqueue '(revise)))
                         :update-function #'(lambda (item) (if (and *learned-description* *goal-concept*
                                                                    (eq (current-status) :finished-learning)
                                                                    (eq *refinement* :leaves))
                                                             (menu-item-enable item) (menu-item-disable item)))))))


;;;_____________________________________________________________________
;;;  Learning Menu

(setq *es-learning-menu*  
  (make-instance 'menu
    :menu-title "Learning"
    :menu-items
    (list (make-instance 'menu-item :menu-item-action #'(lambda () (pause-resume))
                         :update-function #'(lambda (item) (set-menu-item-title item (if (> CCL::*BREAK-LEVEL* 0)  "Resume" "Pause"))))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Pause after Clause"
                         :menu-item-action #'(lambda () (setf *focl-display-level* (if (member :pause-after-clause *focl-display-level*)
                                                                                     (delete :pause-after-clause *focl-display-level*)
                                                                                     (push :pause-after-clause *focl-display-level*))))
                         :update-function #'(lambda (item) (if (member :pause-after-clause *focl-display-level*)
                                                             (set-menu-item-check-mark item t)
                                                             (set-menu-item-check-mark item nil))))
          (make-instance 'menu-item :menu-item-title "Pause after Literal"
                         :menu-item-action #'(lambda () (setf *focl-display-level* (if (member :pause-after-literal *focl-display-level*)
                                                                                     (delete :pause-after-literal *focl-display-level*)
                                                                                     (push :pause-after-literal *focl-display-level*))))
                         :update-function #'(lambda (item) (if (member :pause-after-literal *focl-display-level*)
                                                             (set-menu-item-check-mark item t)
                                                             (set-menu-item-check-mark item nil))))
          (make-instance 'menu-item :menu-item-title "-" :disabled t)
          (make-instance 'menu-item :menu-item-title "Current Gain"
                         :menu-item-action #'(lambda () (if (window-open? *CURRENT-GAIN-WINDOW*) (window-select *CURRENT-GAIN-WINDOW*) (setup-CURRENT-GAIN-WINDOW)))
                         :update-function #'(lambda (item) (set-menu-item-check-mark item (window-open? *CURRENT-GAIN-WINDOW*))))
          (make-instance 'menu-item :menu-item-title "Best Gain"
                         :menu-item-action #'(lambda () (if (window-open? *BEST-GAIN-WINDOW*) (window-select *BEST-GAIN-WINDOW*) (setup-BEST-GAIN-WINDOW)))
                         :update-function #'(lambda (item) (set-menu-item-check-mark item (window-open? *BEST-GAIN-WINDOW*))))
          (make-instance 'menu-item :menu-item-title "Operationalization"
                         :menu-item-action #'(lambda () (if (window-open? *EBL-WINDOW*) (window-select *EBL-WINDOW*) (setup-EBL-WINDOW)))
                         :update-function #'(lambda (item) (set-menu-item-check-mark item (window-open? *EBL-WINDOW*))))
          (make-instance 'menu-item :menu-item-title "Learned Description"
                         :menu-item-action #'(lambda () (if (window-open? *LEARNED-DESCRIPTION-WINDOW*) (window-select *LEARNED-DESCRIPTION-WINDOW*) (setup-LEARNED-DESCRIPTION-WINDOW)))
                         :update-function #'(lambda (item) (set-menu-item-check-mark item (window-open? *LEARNED-DESCRIPTION-WINDOW*))))
          (make-instance 'menu-item :menu-item-title "Work"
                         :menu-item-action #'(lambda () (if (window-open? *WORK-WINDOW*) (window-select *WORK-WINDOW*) (setup-WORK-WINDOW)))
                         :update-function #'(lambda (item) (set-menu-item-check-mark item (window-open? *WORK-WINDOW*))))
          )))
