
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; The code contained in this file was written by Cliff Brunk.

(in-package :user)

;;;_________________________________________________________
;;;  last-node-with-cell

(defun last-node-with-cell (conjunction view &optional (recursive nil) (node-with-cell nil))
  (let* ((last-node (first (last conjunction)))
         (last-node-antecedents (node-antecedents last-node)))
    (if (node-cell view last-node)
      (if (and last-node-antecedents recursive)
        (last-node-with-cell (first (last last-node-antecedents)) view last-node)
        last-node)
      node-with-cell)))


;;;_________________________________________________________
;;;  add-new-clause-to-lcd-graph

(defun add-new-clause-to-lcd-graph (literal pos neg)
  (when (window-open? *LEARNED-DESCRIPTION-WINDOW*)
    (without-interrupts
     (let* ((view (graph-view *LEARNED-DESCRIPTION-WINDOW*))
            (graph (graph view))
            (head (first (first (node-antecedents (root view)))))
            (clause-number (length (node-antecedents head)))
            (last-conjunction (connect-clause graph head literal clause-number nil :every-use *default-expand-depth*)))
       (setf (node-antecedents head) (append (node-antecedents head) (list last-conjunction)))
       (display-tree-cells view)
       (setf (cell-external-text (node-cell view (last-node-with-cell last-conjunction view)))
             (format nil "[~A+ ~A-]" pos neg))
       (position-cells view)
       (reset-graph-size view 70 0)  ;;  This is redundant but it works
       (if (grow-window-if-needed *LEARNED-DESCRIPTION-WINDOW*)
         (auto-position-window *LEARNED-DESCRIPTION-WINDOW*))
       (re-position-graph view :centered t)
       (reset-scroll-bars (graph-scroller *LEARNED-DESCRIPTION-WINDOW*))
       (invalidate-view view t)))))

;;;_________________________________________________________
;;; replace-last-clause-in-lcd-graph

(defun replace-last-clause-in-lcd-graph (new-clause pos neg)
  (when (window-open? *LEARNED-DESCRIPTION-WINDOW*)
    (without-interrupts
     (let* ((view (graph-view *LEARNED-DESCRIPTION-WINDOW*))
            (graph (graph view))
            (head (first (first (node-antecedents (root view))))))
       (free-node (first (last (node-antecedents head))) graph)
       (setf (node-antecedents head) (butlast (node-antecedents head))))
     (add-new-clause-to-lcd-graph new-clause pos neg))))

;;;_________________________________________________________
;;; add-literal-to-last-clause-in-lcd-graph

(defun add-literal-to-last-clause-in-lcd-graph (literal pos neg)
  (when (window-open? *LEARNED-DESCRIPTION-WINDOW*)
    (without-interrupts
     (let* ((view (graph-view *LEARNED-DESCRIPTION-WINDOW*))
            (graph (graph view))
            (head (first (first (node-antecedents (root view)))))
            (clause-number (- (length (node-antecedents head)) 1))
            (last-cons (last (node-antecedents head))))
       (setf (cell-external-text (node-cell view (last-node-with-cell (first last-cons) view))) nil)
       (rplaca last-cons (append (first last-cons) (connect-clause graph head literal clause-number nil :every-use *default-expand-depth*)))
       (display-tree-cells view)
       (setf (cell-external-text (node-cell view (last-node-with-cell (first last-cons) view)))
             (format nil "[~A+ ~A-]" pos neg))
       (position-cells view)
       (reset-graph-size view 70 0)  ;;  This is redundant but it works
       (if (grow-window-if-needed *LEARNED-DESCRIPTION-WINDOW*)
         (auto-position-window *LEARNED-DESCRIPTION-WINDOW*))
       (re-position-graph view :centered t)
       (reset-scroll-bars (graph-scroller *LEARNED-DESCRIPTION-WINDOW*))
       (invalidate-view view t)))))

;;;_________________________________________________________
;;;  display-learned-clause-coverage

(defun display-learned-clause-coverage (view learned-pred)
  (without-interrupts
   (let* ((head (first (first (node-antecedents (root view)))))
          (old-vars (node-vars head))
          (pos-tuples (r-pos learned-pred))
          (neg-tuples (r-neg learned-pred)))
     (dolist (conjunction (node-antecedents head))
       (let* ((clause (node-aux (first conjunction)))
              (prolog-function (convert-literals-to-prolog-function clause old-vars))
              (pp (count-prove-immediate prolog-function pos-tuples))
              (nn (count-prove-immediate prolog-function neg-tuples)))
         (dolist (cell (node-cells (first (last conjunction))))
           (setf (cell-external-text cell) (format nil "[~A+ ~A-]" pp nn))))))
   (invalidate-view view t)))

;;;_________________________________________________________
;;;  display-description-coverage

(defun display-description-coverage (initial-pos initial-neg covered-pos covered-neg)
  (when (window-open? *LEARNED-DESCRIPTION-WINDOW*)
    (let* ((view (graph-view *LEARNED-DESCRIPTION-WINDOW*))
           (head-cell (node-cell view (first (first (node-antecedents (root view)))))))
      (update-external-text
       head-cell
       (format nil "~3@A+ ~3@A- Examples~%~3@A+ ~3@A- Covered"
               initial-pos initial-neg covered-pos covered-neg)))))

;;;_________________________________________________________
;;;  display-learned-description

(defun display-learned-description
       (&optional (head *learned-description-head*)
                  (learned-definition *learned-description*)
                  (expand t)
                  (show-clause-coverage nil))
  (when (user-monitor-p *user-monitor*)
    (incf (user-monitor-display-learned-description *user-monitor*)))
  (let* ((graph (generate-learned-description-graph head learned-definition expand))
         (window (make-instance 'graph-window :window-show nil :kind :graph))
         (view (graph-view window)))
    (setf (graph view) graph
          (root view) (graph-root graph))
    (display-tree-cells view (root view))
    (when show-clause-coverage
      (display-learned-clause-coverage view (get-pred *predicate-being-learned*)))
    (size-all-cells view)
    (position-cells view)
    (resize-window window)
    (position-graph view :centered t)
    (auto-position-window window :centered t)
    (set-window-title window "Learned Description")
    (window-select window)
    window))

;;;_________________________________________________________
;;; setup-LEARNED-DESCRIPTION-WINDOW

(defun setup-LEARNED-DESCRIPTION-WINDOW
       (&optional (head *learned-description-head*)
                  (learned-definition *learned-description*)
                  (expand t))
  (without-interrupts
   (unless (window-open? *LEARNED-DESCRIPTION-WINDOW*)
     (setf *LEARNED-DESCRIPTION-WINDOW*
           (make-instance 'learning-window
                          :window-title "Learned Description"
                          :view-size #@(300 200)
                          :view-position (make-point (- *screen-width* 303) (- *screen-height* 203))))
     (add-subviews 
      *LEARNED-DESCRIPTION-WINDOW*
      (make-dialog-item
       'static-text-dialog-item #@(5 2) #@(400 16) "" nil :view-font '("Chicago" 12 :SRCOR :PLAIN) :view-nick-name :status)))
   
   (let* ((view (graph-view *LEARNED-DESCRIPTION-WINDOW*))
          (graph (generate-learned-description-graph head learned-definition expand))
          (root (graph-root graph)))
     (setf (graph view) graph
           (root view) root)
     (display-tree-cells view root)
     (display-learned-clause-coverage view (get-pred *predicate-being-learned*))
     (position-cells view)
     (when (grow-window-if-needed *LEARNED-DESCRIPTION-WINDOW*)
       (auto-position-window *LEARNED-DESCRIPTION-WINDOW*))
     (position-graph view :centered t)
     (invalidate-view view t))
   (window-select *LEARNED-DESCRIPTION-WINDOW*)))