
;;;======================================================
;;; KR-FOCL-ES Knowledge Base  (Relation Format)


;;;______________________________________________________
;;; Types

(def-type :ORGANIZATION
  occ
  smc
  uci
  ucla
  foreign_legion
  fire_department
  peace_corps
  air_force
  navy
  army
  marines
  )

(def-type :PERSON
  mark-robertson
  darron-ryan
  david-white
  sally-brown
  roger-hall
  laura-robinson
  mark-richman
  anita-sullivan
  robert-jones
  barbara-jones
  john-smith
  janet-smith
  clifford-brown
  donna-green
  william-white
  madeline-brandli
  raymond-fink
  erin-williams
  daniel-sullivan
  robin-sullivan
  robert-williams
  mary-hall
  daniel-neiman
  barbara-nelson
  edgar-sheppard
  lisa-ford
  michael-obrien
  michael-dixon
  barbara-einstein
  ryan-lamancha
  karen-davis
  david-tyson
  christine-gibbons
  michael-adams
  cindy-potter
  adam-williams
  natasha-adams
  richard-jones
  sharon-smith
  matthew-bird
  lorinda-barr
  robert-lewis
  deborah-winston
  richard-burstein
  sally-ryan
  mark-amers
  peggy-green
  lisa-harris
  thomas-bush
  lynn-teller
  warren-black
  )


;;;______________________________________________________
;;; Predicates - Extensionally Defined Relations

(def-pred no_payment_due_fact
  :vars  (?person)
  :type  (:person)
  :mode  nil
  :pos   ((mark-robertson) (david-white) (sally-brown) (roger-hall)
          (laura-robinson) (mark-richman) (anita-sullivan) (robert-jones)
          (barbara-jones) (john-smith) (janet-smith) (clifford-brown)
          (donna-green) (william-white) (madeline-brandli) (raymond-fink)
          (erin-williams) (daniel-sullivan) (robin-sullivan) (robert-williams)
          (daniel-neiman) (barbara-nelson) (edgar-sheppard) (lisa-ford)
          (michael-obrien))
  :neg   ((michael-dixon) (barbara-einstein) (karen-davis) (david-tyson)
          (christine-gibbons) (michael-adams) (cindy-potter) (adam-williams)
          (natasha-adams) (richard-jones) (sharon-smith) (matthew-bird)
          (lorinda-barr) (robert-lewis) (deborah-winston) (richard-burstein)
          (sally-ryan) (mark-amers) (peggy-green) (lisa-harris) (thomas-bush)
          (lynn-teller) (warren-black))
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    nil
   )

(def-pred male
  :vars  (?person)
  :type  (:person)
  :mode  nil
  :pos   ((michael-dixon) (david-white) (roger-hall) (david-tyson)
          (mark-richman) (michael-adams) (robert-jones) (adam-williams)
          (john-smith) (richard-jones) (clifford-brown) (matthew-bird)
          (william-white) (robert-lewis) (raymond-fink) (richard-burstein)
          (daniel-sullivan) (mark-amers) (robert-williams) (daniel-neiman)
          (thomas-bush) (edgar-sheppard))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?person is a male))
       (:question (is ?person a male))
     )
   )

(def-pred longest_absense_from_school
  :vars  (?person ?months)
  :type  (:person :number)
  :mode  nil
  :pos   ((mark-robertson 1) (darron-ryan 9) (david-white 3) (sally-brown 0)
          (roger-hall 0) (laura-robinson 3) (mark-richman 5)
          (anita-sullivan 12) (robert-jones 7) (barbara-jones 7) (john-smith 9)
          (janet-smith 9) (clifford-brown 9) (donna-green 9) (william-white 12)
          (madeline-brandli 11) (raymond-fink 9) (erin-williams 12)
          (daniel-sullivan 12) (robin-sullivan 12) (robert-williams 12)
          (mary-hall 7) (daniel-neiman 7) (barbara-nelson 0)
          (edgar-sheppard 12) (lisa-ford 3) (michael-obrien 9)
          (michael-dixon 3) (barbara-einstein 0) (karen-davis 5)
          (david-tyson 6) (christine-gibbons 6) (michael-adams 6)
          (cindy-potter 6) (adam-williams 7) (natasha-adams 7)
          (richard-jones 7) (sharon-smith 8) (matthew-bird 7) (lorinda-barr 12)
          (robert-lewis 12) (deborah-winston 12) (richard-burstein 12)
          (sally-ryan 12) (mark-amers 12) (peggy-green 7) (lisa-harris 0)
          (thomas-bush 7) (lynn-teller 9) (warren-black 9))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?months is the longest ?person has been away from school))
       (:question (is ?months the longest ?person has been away from school))
       (?months
        ((?person)
         (what is the longest period of time that ?person has left school
          (in months))
         :single-valued))
     )
   )

(def-pred enrolled
  :vars  (?person ?school ?units)
  :type  (:person :organization :number)
  :mode  nil
  :pos   ((mark-robertson ucla 5) (darron-ryan uci 12) (david-white ucla 9)
          (sally-brown uci 11) (roger-hall occ 11) (laura-robinson occ 5)
          (mark-richman uci 3) (anita-sullivan uci 3) (robert-jones smc 5)
          (barbara-jones smc 3) (john-smith ucla 2) (janet-smith ucla 6)
          (clifford-brown ucla 9) (donna-green smc 9) (william-white smc 3)
          (madeline-brandli ucla 4) (raymond-fink smc 9) (erin-williams ucla 9)
          (daniel-sullivan smc 10) (robin-sullivan ucla 11)
          (robert-williams smc 12) (mary-hall ucla 12) (daniel-neiman smc 12)
          (barbara-nelson uci 11) (edgar-sheppard uci 9) (lisa-ford occ 1)
          (michael-obrien smc 3) (michael-dixon uci 3) (barbara-einstein occ 1)
          (karen-davis ucla 5) (david-tyson occ 3) (christine-gibbons uci 5)
          (michael-adams uci 3) (cindy-potter uci 3) (adam-williams ucla 3)
          (natasha-adams smc 7) (richard-jones smc 9) (sharon-smith ucla 10)
          (matthew-bird occ 11) (lorinda-barr uci 9) (robert-lewis ucla 9)
          (deborah-winston occ 7) (richard-burstein ucla 7) (sally-ryan uci 10)
          (mark-amers uci 10) (peggy-green ucla 4) (lisa-harris smc 4)
          (thomas-bush occ 11) (lynn-teller uci 10) (warren-black uci 10))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?person is currently enrolled for ?units units at ?school))
       (:question (is ?person currently enrolled for ?units units at ?school))
       (?school ((?person) (what school is ?person enrolled in) :single-valued))
       (?units
        ((?person) (how many units is ?person currently enrolled in)
         :single-valued))
     )
   )

(def-pred enlist
  :vars  (?person ?organization)
  :type  (:person :organization)
  :mode  nil
  :pos   ((mark-robertson marines) (mark-richman army) (anita-sullivan army)
          (robert-jones navy) (barbara-jones navy) (john-smith air_force)
          (janet-smith marines) (clifford-brown peace_corps)
          (donna-green peace_corps) (lisa-ford fire_department)
          (barbara-einstein foreign_legion) (adam-williams fire_department))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?person is enlisted in ?organization))
       (:question (is ?person enlisted in ?organization))
       (?organization
        ((?person) (what service has ?person enlisted in) :multi-valued))
     )
   )

(def-pred unemployed
  :vars  (?person)
  :type  (:person)
  :mode  nil
  :pos   ((william-white) (madeline-brandli))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?person is unemployed))
       (:question (is ?person unemployed))
     )
   )

(def-pred filed_for_bankruptcy
  :vars  (?person)
  :type  (:person)
  :mode  nil
  :pos   ((robert-williams) (raymond-fink) (robin-sullivan) (lisa-ford))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?person has filed for bankruptcy))
       (:question (has ?person filed for bankruptcy))
     )
   )

(def-pred disabled
  :vars  (?person)
  :type  (:person)
  :mode  nil
  :pos   ((erin-williams) (daniel-sullivan) (robin-sullivan) (laura-robinson)
          (edgar-sheppard) (michael-obrien))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?person is disabled))
       (:question (is ?person disabled))
     )
   )

(def-pred school
  :vars  (?school)
  :type  (:organization)
  :mode  nil
  :pos   ((ucla) (uci) (occ) (smc))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?school is a school))
       (:question (is ?school a school))
     )
   )

(def-pred armed_forces
  :vars  (?organization)
  :type  (:organization)
  :mode  nil
  :pos   ((army) (navy) (air_force) (marines))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?organization is a branch of the armed forces))
       (:question (is ?organization a branch of the armed forces))
     )
   )

(def-pred peace_corps
  :vars  (?organization)
  :type  (:organization)
  :mode  nil
  :pos   ((peace_corps))
  :neg   nil
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions
     ( (:fact (?organization is the peace corp))
       (:question (is ?organization the peace corp))
     )
   )

;;;______________________________________________________
;;; Rules - Intensionally Defined Relations

(def-rule never_left_school
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((never_left_school ?person)
        (longest_absense_from_school ?person ?months) (> 6 ?months))
     )
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person has never left school)
  )

(def-rule enrolled_in_more_than_n_units
  :vars  (?person ?n)
  :type  (:person :number)
  :mode  (:? :?)
  :clauses
     ( ((enrolled_in_more_than_n_units ?person ?n)
        (enrolled ?person ?school ?units) (school ?school) (> ?units ?n))
     )
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is enrolled in more than ?n units)
  )

(def-rule no_payment_due
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((no_payment_due ?person) (continuously_enrolled ?person))
       ((no_payment_due ?person) (eligible_for_deferment ?person))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is not required to pay back a student loan)
  )

(def-rule continuously_enrolled
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((continuously_enrolled ?person)
        (enrolled_in_more_than_n_units ?person 5))
     )
  :induction    t
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person has been continuously enrolled in school since taking
                 out the loan)
  )

(def-rule eligible_for_deferment
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((eligible_for_deferment ?person) (military_deferment ?person))
       ((eligible_for_deferment ?person) (peace_corps_deferment ?person))
       ((eligible_for_deferment ?person) (financial_deferment ?person))
       ((eligible_for_deferment ?person) (student_deferment ?person))
       ((eligible_for_deferment ?person) (disability_deferment ?person))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is eligible for a deferment)
  )

(def-rule military_deferment
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((military_deferment ?person) (enlist ?person ?y) (armed_forces ?y))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is eligible for a military deferment)
  )

(def-rule peace_corps_deferment
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((peace_corps_deferment ?person) (enlist ?person ?organization)
        (peace_corps ?organization))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is eligible for a peace corps deferment)
  )

(def-rule financial_deferment
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((financial_deferment ?person) (enrolled ?person uci ?units))
       ((financial_deferment ?person) (filed_for_bankruptcy ?person))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is eligible for a financial deferment)
  )

(def-rule student_deferment
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((student_deferment ?person) (enrolled_in_more_than_n_units ?person 11))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is eligible for a student deferment)
  )

(def-rule disability_deferment
  :vars  (?person)
  :type  (:person)
  :mode  (:?)
  :clauses
     ( ((disability_deferment ?person) (not (male ?person)) (disabled ?person))
     )
  :induction    nil
  :constraint   nil
  :commutative  nil
  :determinacy  nil
  :questions    (?person is eligible for a disability deferment)
  )

;;;______________________________________________________
;;; Built-In Flag Settings

(set-builtin-flags '(STRING-LESSP EQL >= > MATH-= <= <)  ;; builtin relations
                   '(NIL NIL T T T T T)  ;; available for induction
                   '(NIL NIL NIL NIL NIL NIL T)) ;; try constants


;;;______________________________________________________
;;; Example Templates

(def-example-template NO_PAYMENT_DUE_FACT (?0)
  (longest_absense_from_school ?0 _)
  (enrolled ?0 _ _)
  (enlist ?0 _)
  (unemployed ?0)
  (filed_for_bankruptcy ?0)
  (disabled ?0)
  (male ?0)
  )

;;;______________________________________________________
;;; Learning Problem Specification and Parameter Settings

(def-focl-problem NO_PAYMENT_DUE_FACT
  :max-new-variables 2
  :intensional-induction T
  :refinement :LEAVES)

(def-focl-problem NO_PAYMENT_DUE_FACT
  :goal-concept-name NO_PAYMENT_DUE
  :max-new-variables 2
  :intensional-induction T
  :refinement :LEAVES)
