
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)

;(def-type :obj a b c d e f g h)
;(def-type :prt a1 a2 a3 a4 b1 b2 b3 b4 b5 c1 c2 c3 d1 d2 d3 d4 e1 e2 e3 e4 e5 f1 f2 f3 g1 g2 g3 g4 h1 h2 h3)
;(def-type :concavity upward downward)

(def-rule stable
  :vars (?object)
  :type (:obj)
  :clauses ( ((stable ?object) (partof ?bottom ?object) (bottom ?bottom) (flat ?bottom)) )
  :induction nil)

(def-rule open-vessel
  :vars (?object)
  :type (:obj)
  :clauses ( ((open-vessel ?object) (partof ?part ?object) (concavity ?part upward)))
  :induction nil)

(def-pred cup
  :vars (?object)
  :type (:obj)
  :pos ( (a) (b) (c) (d) )
  :neg ( (e) (f) (g) (h) )
  :induction nil)

(def-pred light
  :vars (?object)
  :type (:obj)
  :pos ( (a) (b) (c) (d) (f) (g) (h) )
  :neg ( (e) )
  :induction t)

(def-pred partof
  :vars (?part ?object)
  :type (:prt :obj)
  :pos ( (a1 a) (a2 a) (a3 a)        (a5 a)
         (b1 b) (b2 b) (b3 b) (b4 b) (b5 b)
         (c1 c) (c2 c) (c3 c)        (c5 c)
         (d1 d) (d2 d) (d3 d) (d4 d) (d5 d)
         (e1 e) (e2 e)               (e5 e)
         (f1 f) (f2 f)               (f5 f)
         (g1 g) (g2 g)        (g4 g) (g5 g)
         (h1 h) (h2 h)        (h4 h) (h5 h) )
  :induction t)

(def-pred bottom
  :vars (?part)
  :type (:prt)
  :pos ( (a1) (b1) (c1) (d1) (e1) (f1) (g1) (h1) ))

(def-pred small
  :vars (?part)
  :type (:prt)
  :pos ( (h1) (e2) (f2) (g2) (h2) (h4) (a3) (b3) (c3) (d3) (c1) (d1) (f1) )
  :induction t)

(def-pred flat
  :vars (?part)
  :type (:prt)
  :pos ( (a1) (c1) (d1) (f1) (b1) (e1) (g1) )
  :induction t)

(def-pred body
  :vars (?part)
  :type (:prt)
  :pos ( (a2) (b2) (c2) (d2) (e12) (f2) (g2) (h3) )
  :induction t)

(def-pred handle
  :vars (?part)
  :type (:prt)
  :pos ( (a3) (b3) (c3) (d3) ) ; deleted (g3)
  :induction t)

(def-pred support
  :vars (?part)
  :type (:prt)
  :pos ( (b4) (d4) (g4) (h4) )
  :induction t)

(def-pred above
  :vars (?part ?part)
  :type (:prt :prt)
  :pos ( (b1 b4) (d1 d4) (g1 g4) (h1 h4) )
  :induction t)

(def-pred concavity
  :vars (?part ?orientation-of-concavity)
  :type (:prt :concavity)
  :pos ((a5 upward) (b5 upward) (c5 upward) (d5 upward) (e5 downward)
        (f5 upward) (g5 upward) (h5 upward))
  :induction t)

(def-rule cup-rules
  :vars (?object)
  :type (:obj)
  :clauses (( (cup-rules ?object) (stable ?object) (open-vessel ?object) ))
  :induction nil)

(def-focl-problem
  cup
  :goal-concept-name cup-rules
  :prefer-theory t 
  :intensional-induction nil
  :simplify-operationalizations t
  :max-new-variables 1 
  :try-all-conjunctions nil
  :stop-when-all-pos-covered t
  :simplify-clauses nil
  :operationalize-intensional t
  :trace (:i :l)
  :use-cliches t
  :available-cliches (threshold-comparator partof))

#|
;; requires template induction code to work

(def-example-template cup (?object)
  (stable ?object)
  (open-vessel ?object)
  (light ?object)
  (partof ?part ?object)
  (bottom ?part)
  (body ?part)
  (small ?part)
  (handle ?part)
  (support ?part)
  (flat ?part)
  (concavity ?part)
  (above ?part ?part1)
  (above ?part2 ?part))
|#
  

(defun test-cup (&optional (trace '(:i :l)) &key try-all-conjunctions
                           (stop-when-all-pos-covered t) (use-cliches t)
                           (available-cliches '(threshold-comparator partof))
                           constructive-induction
                           create-preds-from-cliches) ; ges 1/20/92
  (focl 'cup :save-examples nil
        :prefer-theory t 
        :intensional-induction constructive-induction
	:simplify-operationalizations t
        :max-new-variables 1 
        :goal-concept-name 'cup-rules
        :try-all-conjunctions try-all-conjunctions
        :stop-when-all-pos-covered stop-when-all-pos-covered
	:simplify-clauses nil
        :operationalize-intensional t
        :trace trace
        :use-cliches use-cliches
        :available-cliches available-cliches
        :create-preds-from-cliches create-preds-from-cliches))
