/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	draw1.c	---	Main draw routines part 1.
 *			(draw literals and clauses)
 *
 */

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#define	PROTO_DRAW1_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
#undef	PROTO_DRAW1_C

#pragma segment	visual


void DrawContent()
{
  litrlrec *t;
  pphandle *cls;
  linkrec *link;

  for (t = Gcontrol.unsigned_preds; t != NULL; t = t->ctrl.nxt)
    t->mark = FALSE;
  for (t = Gcontrol.signed_preds; t != NULL; t = t->ctrl.nxt)
    t->mark = FALSE;
  for (t = Gcontrol.unsigned_preds; t != NULL; t = t->ctrl.nxt)
    if (t->mark == FALSE && t->pphndl != NULL) {
      cls = t->pphndl->begin;
      if (cls == NULL)
	continue;
      if (cls->vnode == NULL)
	CreateClauseNode(cls);
      DrawClause(cls->vnode);
    }
  for (t = Gcontrol.signed_preds; t != NULL; t = t->ctrl.nxt)
    if (t->mark == FALSE && t->pphndl != NULL) {
      cls = t->pphndl->begin;
      if (cls == NULL)
	continue;
      if (cls->vnode == NULL)
	CreateClauseNode(cls);
      DrawClause(cls->vnode);
    }

  for (link = Gcontrol.links; link != NULL; link = link->ctrl.nxt)
    if (link->tag == INFERENCE &&
	link->ptr[0]->joint->ltrl->tag != NUMBER &&
	link->ptr[0]->joint->ltrl->tag != SYMBOL &&
	link->ptr[1]->joint->ltrl->tag != NUMBER &&
	link->ptr[1]->joint->ltrl->tag != SYMBOL)
      switch (Global.linkmode) {
      case SUBSMD_LINK:
	if (link->sub >= 1.0)
	  DrawLink(link);
	break;
      case NOT_SUBSMD_LINK:
	if (link->sub < 1.0)
	  DrawLink(link);
	break;
      case HIGH_ACT_LINK:
	DrawLink(link);
	break;
      }
}


void DrawClause(clause)
     VNodeRec *clause;
{
  VNodeRec *ltrl;

  XDrawRectangle(Global.disp, Global.wind, Global.txt,
		 clause->region.x, clause->region.y,
		 clause->region.width, clause->region.height);
  for (ltrl = clause->next; ltrl != NULL; ltrl = ltrl->next)
    if (ltrl->body != NULL) {
      DrawDependencyMark(ltrl->body,
			 clause->region.x, clause->region.y);
      DrawLiteral(ltrl->body, clause->region.x, clause->region.y);
    } else
      DrawEquation(ltrl, clause->region.x, clause->region.y);
}


void CreateClauseNode(top)
     pphandle *top;
{
  pphandle *u;
  VNodeRec *newvnode;
  int ypos, max_width;

  ClearEquations(top);
  top->vnode = new_node();
  top->vnode->body = NULL;
  for (ypos = 10, max_width = 0, u = top; u != NULL; u = u->next) {
    if (u->body->tag == PSTERM ||
	u->body->tag == SYMBOL ||
	u->body->tag == NUMBER) {
      u->body->mark = TRUE;
      continue;
    }
    if (u->body->mark == FALSE) {
      u->body->mark = TRUE;
      newvnode = new_node();
      CreateLiteralText(newvnode->title, u->body);
      newvnode->body = u->body;
      u->body->vnode = newvnode;
      SetRegion(newvnode, top->vnode, ypos);
      ypos += FntInfo.ch + LITRL_V_MARGIN;
      max_width = MAX(max_width, newvnode->region.width);
      newvnode = new_node();
      if (CreateEquationsText(newvnode->title, u->body)) {
	newvnode->body = NULL;
	SetRegion(newvnode, top->vnode, ypos);
	ypos += FntInfo.ch + LITRL_V_MARGIN;
	max_width = MAX(max_width, newvnode->region.width);
      } else
	dispose_node(newvnode);
    }
  }
  /*	Set the pposition.	*/
  top->vnode->region.x = Global.prev.x;
  top->vnode->region.y = Global.prev.y;
  Global.prev.y += ypos + VSTEP;
  if (Global.prev.y > VMAX) {
    Global.prev.y = VMIN;
    Global.prev.x += HSTEP;
    if (Global.prev.x > HMAX)
      Global.prev.x = HMIN;
  }
  top->vnode->region.width = max_width + FntInfo.cw*6 + LITRL_H_MARGIN*2;
  top->vnode->region.height = ypos;
}


void ClearEquations(cls)
     pphandle *cls;
{
  pphandle *ltrl;
  litrlrec *ftr;
  jointrec *jnt;
  dependrec *dpnd;
  int i;

  for (ltrl = cls; ltrl != NULL; ltrl = ltrl->next)
    switch (ltrl->body->tag) {
    case SYMBOL:
    case NUMBER:
      break;
    case FUNCTION:
    case CONSTRAINT:
      for (i = 0; i < ltrl->body->body.afm.arity; i++)
	for (jnt = ltrl->body->body.afm.arg[i].body.val;
	     jnt != NULL; jnt = jnt->nxt)
	  jnt->depend->link->mark = FALSE;
      break;
    case PSTERM:
      for (ftr = ltrl->body->body.pst.nxt;
	   ftr != NULL; ftr = ftr->body.pst.nxt)
	for (jnt = ftr->body.pst.val; jnt != NULL; jnt = jnt->nxt)
	  jnt->depend->link->mark = FALSE;
      break;
    case FEATURE:
      for (jnt = ltrl->body->body.pst.val; jnt != NULL; jnt = jnt->nxt)
	jnt->depend->link->mark = FALSE;
      break;
    }
}


void SetRegion(vnode, vlist, ypos)
     VNodeRec *vnode;
     VNodeRec *vlist;
     int ypos;
{
  vnode->region.x = LITRL_H_MARGIN;
  vnode->region.y = ypos;
  vnode->region.height = FntInfo.ch;
  vnode->region.width = XTextWidth(FntInfo.fs,
				   vnode->title, strlen(vnode->title));
  vnode->begin = vlist;
  vnode->next = vlist->next;
  vlist->next = vnode;
}


void DrawLiteral(ltrl, ox, oy)
     litrlrec *ltrl;
     int ox, oy;
{
  char temp[BUFFSIZE];
  int x, y, dir, asc, desc;
  XCharStruct overall;

  sprintf(temp, "%s<%d>", ltrl->vnode->title, ltrl->lid);
  XTextExtents(FntInfo.fs,
	       temp, strlen(temp),
	       &dir, &asc, &desc, &overall);
  x = ltrl->vnode->region.x + FntInfo.cw;
  y = ltrl->vnode->region.y + asc;
  XDrawString(Global.disp, Global.wind,
	      Global.color[(int)(ltrl->act*(RESOLUTION-1)+0.5)],
	      ox+x, oy+y, temp, strlen(temp));
}


void DrawEquation(eqtn, ox, oy)
     VNodeRec *eqtn;
     int ox, oy;
{
  int x, y, dir, asc, desc;
  XCharStruct overall;

  XTextExtents(FntInfo.fs,
	       eqtn->title, strlen(eqtn->title),
	       &dir, &asc, &desc, &overall);
  x = eqtn->region.x + FntInfo.cw;
  y = eqtn->region.y + asc;
  XDrawString(Global.disp, Global.wind, Global.txt,
	      ox+x, oy+y, eqtn->title, strlen(eqtn->title));
}


void DrawDependencyMark(ltrl, ox, oy)
     litrlrec *ltrl;
     int ox, oy;
{
  jointrec *j;
  int x, y;

  x = ltrl->vnode->region.x;
  y = ltrl->vnode->region.y;
  for (j = ltrl->joint; j != NULL; j = j->nxt)
    if (j->total) {
      XDrawArc(Global.disp, Global.wind,
	       Global.color[(int)(ltrl->act*(RESOLUTION-1)+0.5)],
	       ox+x, oy+y, FntInfo.cw-1, FntInfo.ch-1, 0, 360*64);
      return;
    }
  XFillArc(Global.disp, Global.wind,
	   Global.color[(int)(ltrl->act*(RESOLUTION-1)+0.5)],
	   ox+x, oy+y, FntInfo.cw, FntInfo.ch, 0, 360*64);
}
