/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	speech.c	---	Stub-routines between DCP-system and HMM.
 *			(1992.10.23 (Fri))
 */

#include	<stdio.h>

#define	PROTO_STUB_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#include	"speech.h"
#undef	PROTO_STUB_C

#pragma segment	hmm


/*
 * advance_phoneme() gets the following clause.
 *
 *    SPEECH_i(X0,Y0) -#phon(X0)=X1 -SOUND_i(Y0,Y1) -SPEECH_j(X1,Y1) :.
 *
 * each variable denotes the followings:
 *   pivot    : ptr to link to #phon
 *   nextframe: index j
 *   phoneme  : ptr to #phon
 *   endframe : ptr to SPEECH_j
 */
void advance_phoneme(pivot)
     dependrec *pivot;
{
  int nextframe;
  dependrec *dpnd;
  litrlrec *phoneme, *endframe;

  phoneme = pivot->joint->ltrl;
  dpnd = phoneme->body.pst.val->depend;
  endframe = dpnd->link->ptr[dpnd->dir]->joint->ltrl;
  if (endframe->tag != CONSTRAINT ||
      strncmp(endframe->body.afm.name, SPEECH_STR, SPEECH_STR_N) != 0) {
    printf("%s_i() is expected, while advance_phoneme() received ", SPEECH_STR);
    print_literal(endframe);
    panic(".", 0);
  }
  nextframe = endframe->misc;
  hmm_score(nextframe);
  new_phonemes(nextframe, pivot);
}


/*
 * new_phonemes() creates new clauses in the following form.
 *
 *    SPEECH_i(X0,Y0) -#phon(X0)=X1 -SOUND_i(Y0,Y1) -SPEECH_j(X1,Y1) :.
 *
 * each variable denotes the followings:
 *   frame    : index i
 *   pivot    : ptr to link to #phon
 *   startframe : ptr to SPEECH_i
 *   endframe   : ptr to SPEECH_j
 *   time       : ptr to SOUND_i
 *   aux        : ptr to X0 (partially specified term)
 *   phoneme    : ptr to #phon
 */
void new_phonemes(frame, pivot)
     int frame;
     dependrec *pivot;
{
  int ph;
  pphandle *startframe, *endframe, *time, *aux, *phoneme;
  jointrec *jnt0, *jnt1;
  dependrec *dpnd0, *dpnd1;

  for (ph = 0; ph < N_PHONE; ph++) {
    if (hypo_list[ph].score < Gparams.subsTH)
      continue;
    /*
     * create literals and connect them to other ones
     */
    startframe = new_constraint(UNSIGNED);
    sprintf(startframe->body->body.afm.name, "%s%d", SPEECH_STR, frame);
    startframe->body->misc = frame;
    startframe->body->sbsm = TRUE;
    connect_to_other_frames(startframe->body, UNSIGNED);
    aux = new_aux();
    aux->body->sbsm = TRUE;
    phoneme = new_phoneme_literal(aux->body, ph);
    connect_to_other_phonemes(phoneme->body, pivot,
			      hypo_list[ph].score);
    phoneme->body->sbsm = TRUE;
    time = new_constraint(NEGATIVE);
    sprintf(time->body->body.afm.name, "%s%d", SOUND_STR, frame);
    time->body->misc = frame;
    time->body->sbsm = TRUE;
    connect_to_tops_time(time->body);
    endframe = new_constraint(NEGATIVE);
    sprintf(endframe->body->body.afm.name,
	    "%s%d", SPEECH_STR, hypo_list[ph].frame);
    endframe->body->misc = hypo_list[ph].frame;
    endframe->body->sbsm = TRUE;
    connect_to_other_frames(endframe->body, NEGATIVE);
    /*
     * connect equations
     */
    jnt0 = new_equation_joint(startframe->body, 0, "");
    jnt1 = new_equation_joint(time->body, 0, "");
    dpnd0 = new_dependency(jnt0);
    dpnd1 = new_dependency(jnt1);
    new_equation_link(dpnd0, dpnd1, TRUE);
    jnt0 = new_equation_joint(startframe->body, 1, "");
    jnt1 = new_equation_joint(aux->body, LEFTHAND, "");
    dpnd0 = new_dependency(jnt0);
    dpnd1 = new_dependency(jnt1);
    new_equation_link(dpnd0, dpnd1, TRUE);
    jnt0 = new_equation_joint(time->body, 1, "");
    jnt1 = new_equation_joint(endframe->body, 0, "");
    dpnd0 = new_dependency(jnt0);
    dpnd1 = new_dependency(jnt1);
    new_equation_link(dpnd0, dpnd1, TRUE);
    jnt0 = new_equation_joint(phoneme->body, PSTENTRY, "");
    jnt1 = new_equation_joint(endframe->body, 1, "");
    dpnd0 = new_dependency(jnt0);
    dpnd1 = new_dependency(jnt1);
    new_equation_link(dpnd0, dpnd1, TRUE);
    /*
     * serialize new literals
     */
    startframe->top = FALSE;
    startframe->begin = startframe;
    startframe->next = aux;
    aux->top = FALSE;
    aux->begin = startframe;
    aux->next = phoneme;
    phoneme->top = FALSE;
    phoneme->begin = startframe;
    phoneme->next = time;
    time->top = FALSE;
    time->begin = startframe;
    time->next = endframe;
    endframe->top = FALSE;
    endframe->begin = startframe;
    endframe->next = NULL;
    /*
     * set coefficients
     */
    startframe->body->rel = Gparams.sframeREL;
    startframe->body->coeff.disj = Gparams.frameDISJ;
    startframe->body->coeff.excl = Gparams.frameEXCL;
    endframe->body->rel = Gparams.eframeREL;
    endframe->body->coeff.disj = Gparams.frameDISJ;
    endframe->body->coeff.excl = Gparams.frameEXCL;
    time->body->rel = Gparams.timeREL;
    time->body->coeff.disj = Gparams.frameDISJ;
    time->body->coeff.excl = Gparams.frameEXCL;
    phoneme->body->rel = Gparams.phonemeREL;
    phoneme->body->coeff.disj = Gparams.frameDISJ;
    phoneme->body->coeff.excl = Gparams.frameEXCL;
  }
}


pphandle *new_constraint(pol)
     int pol;
{
  litrlrec *newcnstrt;

  newcnstrt = NEW_litrlrec();
  newcnstrt->tag = CONSTRAINT;
  newcnstrt->pol = pol;
  newcnstrt->rel = REL_DEFAULT;
  newcnstrt->coeff.nOmega = 4*OMEGA;
  newcnstrt->coeff.omegaN = OMEGA*OMEGA*OMEGA*OMEGA;
  newcnstrt->coeff.disj = DISJ_DEFAULT;
  newcnstrt->coeff.excl = EXCL_DEFAULT;
  newcnstrt->coeff.cmpl = CMPL_DEFAULT;
  newcnstrt->coeff.assm = ASSM_DEFAULT;
  newcnstrt->dfrc = 0.0;
  newcnstrt->path = NULL;
  newcnstrt->press = NULL;
  newcnstrt->act = LITERAL_INIT;
  newcnstrt->z = 0.0;
  newcnstrt->imp = 0.0;
  newcnstrt->body.afm.arity = 2;
  newcnstrt->body.afm.name = (char *)calloc(15, sizeof(char));
  newcnstrt->body.afm.arg = NEW_argument(2);
  newcnstrt->body.afm.arg[0].body.val = NULL;
  newcnstrt->body.afm.arg[0].body.print.embedded = FALSE;
  newcnstrt->body.afm.arg[0].body.print.varname = new_name('X');
  newcnstrt->body.afm.arg[1].body.val = NULL;
  newcnstrt->body.afm.arg[1].body.print.embedded = FALSE;
  newcnstrt->body.afm.arg[1].body.print.varname = new_name('X');
  newcnstrt->lefth = NULL;
  newcnstrt->print.varname = "";
  newcnstrt->joint = NULL;
  newcnstrt->handle = NULL;
  newcnstrt->pphndl = NEW_pphandle();
  newcnstrt->pphndl->body = newcnstrt;
  newcnstrt->pphndl->aux = NULL;
  newcnstrt->pphndl->vnode = NULL;
  newcnstrt->pphndl->next = NULL;
  newcnstrt->lid = Gcontrol.lid++;
  newcnstrt->mark = TRUE;
  newcnstrt->sbsm = FALSE;
  newcnstrt->misc = 0;
  newcnstrt->vnode = NULL;
  if (pol == UNSIGNED) {
    newcnstrt->ctrl.nxt = Gcontrol.unsigned_preds;
    Gcontrol.unsigned_preds = newcnstrt;
    if (newcnstrt->ctrl.nxt != NULL)
      newcnstrt->ctrl.nxt->ctrl.prv = newcnstrt;
  } else {
    newcnstrt->ctrl.nxt = Gcontrol.signed_preds;
    Gcontrol.signed_preds = newcnstrt;
    if (newcnstrt->ctrl.nxt != NULL)
      newcnstrt->ctrl.nxt->ctrl.prv = newcnstrt;
  }
  return newcnstrt->pphndl;
}


void connect_to_other_frames(frame, pol)
     litrlrec *frame;
     int pol;
{
  linkrec *l;
  dependrec *d0, *d1;
  jointrec *j0, *j1;
  litrlrec *q;

  if (pol == UNSIGNED) {
    for (q = Gcontrol.signed_preds; q != NULL; q = q->ctrl.nxt)
      if (frame->tag == q->tag &&
	  strcmp(frame->body.afm.name, q->body.afm.name) == 0 &&
	  frame->body.afm.arity == q->body.afm.arity) {
	if ((j0=frame->joint) == NULL)
	  j0 = new_inference_joint(frame, FALSE);
	if ((j1=q->joint) == NULL)
	  j1 = new_inference_joint(q, TRUE);
	d0 = new_dependency(j0);
	d1 = new_dependency(j1);
	l = new_inference_link(d0, d1, frame->body.afm.arity);
	l->sub = Gparams.ssub;
      }
  } else {
    for (q = Gcontrol.unsigned_preds; q != NULL; q = q->ctrl.nxt)
      if (frame->tag == q->tag &&
	  strcmp(frame->body.afm.name, q->body.afm.name) == 0 &&
	  frame->body.afm.arity == q->body.afm.arity) {
	if ((j0=frame->joint) == NULL)
	  j0 = new_inference_joint(frame, TRUE);
	if ((j1=q->joint) == NULL)
	  j1 = new_inference_joint(q, FALSE);
	d0 = new_dependency(j0);
	d1 = new_dependency(j1);
	l = new_inference_link(d0, d1, frame->body.afm.arity);
	l->sub = Gparams.ssub;
      }
  }
}


pphandle *new_aux()
{
  litrlrec *newpst;

  newpst = NEW_litrlrec();
  newpst->tag = PSTERM;
  newpst->pol = NEGATIVE;
  newpst->rel = 1.0;
  newpst->coeff.nOmega = 4*OMEGA;
  newpst->coeff.omegaN = OMEGA*OMEGA*OMEGA*OMEGA;
  newpst->coeff.disj = DISJ_DEFAULT;
  newpst->coeff.excl = EXCL_DEFAULT;
  newpst->coeff.cmpl = CMPL_DEFAULT;
  newpst->coeff.assm = ASSM_DEFAULT;
  newpst->dfrc = 0.0;
  newpst->path = NULL;
  newpst->press = NULL;
  newpst->act = 1.0;
  newpst->z = 0.0;
  newpst->imp = 0.0;
  newpst->body.pst.name = "";
  newpst->body.pst.val = NULL;
  newpst->body.pst.root = NULL;
  newpst->body.pst.prv = NULL;
  newpst->body.pst.nxt = NULL;
  newpst->body.pst.print.embedded = FALSE;
  newpst->body.pst.print.varname = "";
  newpst->lefth = NULL;
  newpst->joint = NULL;
  newpst->handle = NULL;
  newpst->pphndl = NEW_pphandle();
  newpst->pphndl->body = newpst;
  newpst->pphndl->aux = NULL;
  newpst->pphndl->vnode = NULL;
  newpst->lid = Gcontrol.lid++;
  newpst->mark = TRUE;
  newpst->sbsm = FALSE;
  newpst->misc = 0;
  newpst->vnode = NULL;
  newpst->print.varname = new_name('Y');
  newpst->ctrl.nxt = Gcontrol.signed_preds;
  Gcontrol.signed_preds = newpst;
  if (newpst->ctrl.nxt != NULL)
    newpst->ctrl.nxt->ctrl.prv = newpst;
  return newpst->pphndl;
}


pphandle *new_phoneme_literal(psterm, phoneme)
     litrlrec *psterm;
     int phoneme;
{
  litrlrec *newftr;

  newftr = NEW_litrlrec();
  newftr->tag = FEATURE;
  newftr->pol = NEGATIVE;
  newftr->rel = 1.0;
  newftr->coeff.nOmega = 4*OMEGA;
  newftr->coeff.omegaN = OMEGA*OMEGA*OMEGA*OMEGA;
  newftr->coeff.disj = DISJ_DEFAULT;
  newftr->coeff.excl = EXCL_DEFAULT;
  newftr->coeff.cmpl = CMPL_DEFAULT;
  newftr->coeff.assm = ASSM_DEFAULT;
  newftr->dfrc = 0.0;
  newftr->path = NULL;
  newftr->press = NULL;
  newftr->act = LITERAL_INIT;
  newftr->z = 0.0;
  newftr->imp = 0.0;
  newftr->body.pst.name = phoneme_name[phoneme];
  newftr->body.pst.val = NULL;
  newftr->body.pst.root = psterm;
  psterm->body.pst.prv = NULL;
  psterm->body.pst.nxt = newftr;
  newftr->body.pst.prv = psterm;
  newftr->body.pst.nxt = NULL;
  newftr->body.pst.print.embedded = FALSE;
  newftr->body.pst.print.varname = new_name('Z');
  newftr->lefth = NULL;
  newftr->joint = NULL;
  newftr->handle = NULL;
  newftr->pphndl = NEW_pphandle();
  newftr->pphndl->body = newftr;
  newftr->pphndl->aux = NULL;
  newftr->pphndl->vnode = NULL;
  newftr->pphndl->next = NULL;
  newftr->lid = Gcontrol.lid++;
  newftr->mark = TRUE;
  newftr->sbsm = FALSE;
  newftr->misc = -1;
  newftr->vnode = NULL;
  newftr->print.varname = psterm->print.varname;
  newftr->ctrl.nxt = Gcontrol.signed_preds;
  Gcontrol.signed_preds = newftr;
  if (newftr->ctrl.nxt != NULL)
    newftr->ctrl.nxt->ctrl.prv = newftr;
  return newftr->pphndl;
}


void connect_to_other_phonemes(phoneme, pivot, score)
     litrlrec *phoneme;
     dependrec *pivot;
     double score;
{
  linkrec *lnk;
  dependrec *dpnd, *d;
  litrlrec *lex, *left, *center, *right;

  if (pivot == NULL) {
    for (lex = Gcontrol.unsigned_preds;
	 lex != NULL; lex = lex->ctrl.nxt) {
      if (lex->tag != CONSTRAINT ||
	  lex->pol != UNSIGNED ||
	  lex->body.afm.arity != LEX_ARITY ||
	  strncmp(lex->body.afm.name, LEX_STR, LEX_STR_N) != 0)
	continue;
      d = lex->body.afm.arg[DLIST_BEGIN].body.val->depend;
      center = d->link->ptr[d->dir]->joint->ltrl;
      if (center->tag != PSTERM)
	continue;
      center = center->body.pst.nxt;
      lnk = connect_literals(phoneme, center, 2, Gparams.wsub);
      lnk->sub = score;
      lnk->confuse =
	ctable_lookup(phoneme->body.pst.name, center->body.pst.name);
      d = center->body.pst.val->depend;
      right = d->link->ptr[d->dir]->joint->ltrl;
      if (right->tag != PSTERM)
	continue;
      right = right->body.pst.nxt;
      lnk = connect_literals(phoneme, right, 2, Gparams.wsub);
      lnk->sub = score;
      lnk->confuse =
	ctable_lookup(phoneme->body.pst.name, right->body.pst.name);
    }
  } else {
    for (dpnd = pivot->joint->depend; dpnd != NULL; dpnd = dpnd->nxt) {
      center = dpnd->link->ptr[dpnd->dir]->joint->ltrl;
      lnk = connect_literals(phoneme, center, 2, Gparams.wsub);
      lnk->sub = score;
      lnk->confuse =
	ctable_lookup(phoneme->body.pst.name, center->body.pst.name);
      d = center->body.pst.root->lefth->depend;
      left = d->link->ptr[d->dir]->joint->ltrl;
      if (left->tag == FEATURE) {
	lnk = connect_literals(phoneme, left, 2, Gparams.wsub);
	lnk->sub = score;
	lnk->confuse =
	  ctable_lookup(phoneme->body.pst.name, left->body.pst.name);
      }
      /*
       * for efficiency, left word boundary is not considered.
       */
      d = center->body.pst.val->depend;
      right = d->link->ptr[d->dir]->joint->ltrl;
      if (right->tag == PSTERM) {
	right = right->body.pst.nxt;
	lnk = connect_literals(phoneme, right, 2, Gparams.wsub);
	lnk->sub = score;
	lnk->confuse =
	  ctable_lookup(phoneme->body.pst.name, right->body.pst.name);
      } else {
	for (lex = Gcontrol.unsigned_preds;
	     lex != NULL; lex = lex->ctrl.nxt) {
	  if (lex->tag != CONSTRAINT ||
	      lex->pol != UNSIGNED ||
	      lex->body.afm.arity != 3 ||
	      strncmp(lex->body.afm.name, LEX_STR, LEX_STR_N) != 0)
	    continue;
	  d = lex->body.afm.arg[DLIST_BEGIN].body.val->depend;
	  right = d->link->ptr[d->dir]->joint->ltrl;
	  if (right->tag != PSTERM)
	    continue;
	  right = right->body.pst.nxt;
	  lnk = connect_literals(phoneme, right, 2, Gparams.wsub);
	  lnk->sub = score;
	  lnk->confuse =
	    ctable_lookup(phoneme->body.pst.name, right->body.pst.name);
	}
      }
    }
  }
}


void connect_to_tops_time(time)
     litrlrec *time;
{
  jointrec *j0, *j1;
  dependrec *d0, *d1, *tonil, *tonext;
  linkrec *l;
  litrlrec *ltrl;
  pphandle *top, *nearestframe, *topframe, *newframe;
  int fn0, fn, nearest;

  fn0 = time->misc;
  for (ltrl = Gcontrol.unsigned_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
    ltrl->mark = FALSE;
  for (ltrl = Gcontrol.unsigned_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt) {
    if (ltrl->pphndl == NULL || ! ltrl->pphndl->top || ltrl->mark)
      continue;
    for (nearestframe = NULL, topframe = NULL,
	 nearest = -1, top = ltrl->pphndl->begin;
	 top != NULL; top = top->next) {
      top->body->mark = TRUE;
      top->body->coeff.nOmega += OMEGA;
      top->body->coeff.omegaN *= OMEGA;
      if (top->body->tag != CONSTRAINT)
	continue;
      if (strcmp(top->body->body.afm.name, SPEECH_START_S) == 0)
	topframe = top;
      /*
       * First, search a literal `SOUND_i'
       */
      if (top->body->body.afm.arity != time->body.afm.arity ||
	  strncmp(top->body->body.afm.name, SOUND_STR, SOUND_STR_N) != 0)
	continue;
      fn = top->body->misc;
      if (nearest < fn && fn < fn0) {
	nearestframe = top;
	nearest = fn;
      }
      /*
       * Second, connect a literal `SOUND_(i+1)' in the top clause and
       * a given literal `time'
       */
      if (strcmp(time->body.afm.name, top->body->body.afm.name) == 0) {
	if ((j0=time->joint) == NULL)
	  j0 = new_inference_joint(time, FALSE);
	if ((j1=top->body->joint) == NULL)
	  j1 = new_inference_joint(top->body, TRUE);
	d0 = new_dependency(j0);
	d1 = new_dependency(j1);
	l = new_inference_link(d0, d1, time->body.afm.arity);
	l->sub = 1.0;
	break;
      }
    }
    if (top != NULL)
      continue;
    /*
     * If there is no literal `SOUND_i', then create a new one.
     */
    newframe = new_constraint(COST_NEGATIVE);
    sprintf(newframe->body->body.afm.name, "%s%d", SOUND_STR, fn0);
    newframe->body->sbsm = TRUE;
    newframe->body->misc = fn0;
    newframe->top = TRUE;
    for (top = ltrl->pphndl->begin; top->next != NULL; top = top->next)
      DisposePPHandleVNode(top);
    DisposePPHandleVNode(top);
    top->next = newframe;
    newframe->begin = ltrl->pphndl->begin;
    newframe->next = NULL;
    if (nearest == -1) {
      /*
       * create the first time-frame literal `SOUND0' i.e.
       *
       * true() -SPEECH0(X,Y0) -terminate(Y0) :.
       * ==> true() -SPEECH0(X,Y0) -SOUND0(Y0)=Y1 -terminate(Y1) :.
       */
      if (topframe == NULL) {
	printf("cannot find starting frame `%s'", SPEECH_START_S);
	panic("", 0);
      }
      tonil = topframe->body->body.afm.arg[1].body.val->depend;
      j1 = new_equation_joint(newframe->body, 0, "");
      d0 = new_dependency(topframe->body->body.afm.arg[1].body.val);
      d1 = new_dependency(j1);
      new_equation_link(d0, d1, TRUE);
      disconnect_dependency(tonil);
      j0 = new_equation_joint(newframe->body, 1, "");
      connect_dependency(j0, tonil);
    } else {
      /*
       * insert a new time-frame literal `SOUND_i' i.e.
       *
       * true() -SPEECH0(X,Y0) -SOUND0(Y0,Y1) ...
       *             -SOUND_m(Z0,Z1) -SOUND_n(Z1,Z2) ...
       * ==> true() -SPEECH0(X,Y0) -SOUND0(Y0,Y1) ...
       *             -SOUND_m(Z0,Z1) -SOUND_i(Z1,Z2) -SOUND_n(Z2,Z3) ...
       */
      tonext = nearestframe->body->body.afm.arg[1].body.val->depend;
      j1 = new_equation_joint(newframe->body, 0, "");
      d0 = new_dependency(nearestframe->body->body.afm.arg[1].body.val);
      d1 = new_dependency(j1);
      new_equation_link(d0, d1, TRUE);
      disconnect_dependency(tonext);
      j0 = new_equation_joint(newframe->body, 1, "");
      connect_dependency(j0, tonext);
    }
    j0 = new_inference_joint(time, FALSE);
    j1 = new_inference_joint(newframe->body, FALSE);
    d0 = new_dependency(j0);
    d1 = new_dependency(j1);
    l = new_inference_link(d0, d1, time->body.afm.arity);
    l->sub = 1.0;
  }
}


double ctable_lookup(input, output)
     char *input;
     char *output;
{
  int i, j;

  for (i = 0; i < N_PHONE; i++)
    if (strcmp(input, phoneme_name[i]) == 0)
      break;
  for (j = 0; j < N_PHONE; j++)
    if (strcmp(output, phoneme_name[j]) == 0)
      break;
  if (i >= N_PHONE || j >= N_PHONE)
    return 0.0;
  else
    return c_table[i][j];
}


void init_hmm(lfile)
     char *lfile;
{
  FILE *fp;
  int c, i, j, k, startframe, endframe;
  double score;
  char phoneme[10];

  for (i = 0; i < N_BEST; i++)
    for (j = 0; j < N_PHONE;j++) {
      hypo_table[i][j].score = 0.0;
      hypo_table[i][j].frame = 0;
    }
  if ((fp=fopen(lfile, "r")) == NULL)
    panic("Can't open lattice file", 0);
  while (! feof(fp)) {
    c = fgetc(fp);
    if (c == '%')
      /* skip this line as comment */
      do {
	c = fgetc(fp);
      } while (c != '\n' && c != EOF);
    ungetc(c, fp);
    fscanf(fp, " %d, %d, %lf, %s",
	   &startframe, &endframe, &score, phoneme);
    if (0<= startframe && startframe < N_BEST &&
	0 <= endframe && endframe < N_BEST) {
      for (k = 0; k < N_PHONE; k++)
	if (strcmp(phoneme_name[k], phoneme) == 0)
	  break;
      if (k < N_PHONE) {
	hypo_table[k][startframe].score = score;
	hypo_table[k][startframe].frame = endframe;
      }
    }
  }
  fclose(fp);
}


int hmm_score(frame)
     int frame;
{
  int i;

  printf("frame=%d\n", frame);
  if (frame >= N_BEST)
    return 1;
  for (i = 0; i < N_PHONE; i++) {
    hypo_list[i].score = hypo_table[i][frame].score;
    hypo_list[i].frame = hypo_table[i][frame].frame;
  }
  return 0;
}


int hmm_score2(frame)
     int frame;
{
  int i, e;
  double s;
  char temp[10];

  for (i = 0; i < N_PHONE; i++) {
    hypo_list[i].score = 0.0;
    hypo_list[i].frame = 0;
  }
  printf("\nstartframe=%d\n", frame);
  printf("input triplet (score, endframe, phoneme)\n");
  do {
    scanf("%d, %lf, %s", &e, &s, temp);
    for (i = 0; i < N_PHONE; i++)
      if (strcmp(temp, phoneme_name[i]) == 0) {
	hypo_list[i].score = s;
	hypo_list[i].frame = frame+e;
	break;
      }
  } while (s > 0.0 && e > 0);
  gets();
  return 0;
}
