/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	print.c	---	Clause-printing routines.
 *
 */

#include	<stdio.h>

#define	PROTO_PRINT_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_PRINT_C

#pragma segment	parser


void print_clauses()
{
  int line = 1;
  litrlrec *top;

  for (top = Gcontrol.unsigned_preds; top != NULL; top = top->ctrl.nxt)
    if (top->mark == FALSE && top->pphndl != NULL) {
      printf("[%2d]:  ", line++);
      print_one_clause(top);
      printf(": %3.2lf / %3.2lf .\n", top->coeff.disj, top->coeff.excl);
    }
  for (top = Gcontrol.signed_preds; top != NULL; top = top->ctrl.nxt)
    if (top->mark == FALSE && top->pphndl != NULL) {
      printf("[%2d]:  ", line++);
      print_one_clause(top);
      printf(": %3.2lf / %3.2lf .\n", top->coeff.disj, top->coeff.excl);
    }
}


void print_one_clause(top)
     litrlrec *top;
{
  pphandle *ltrl;

  for (ltrl = top->pphndl->begin; ltrl != NULL; ltrl = ltrl->next) {
    if (ltrl->body->tag == PSTERM ||
	ltrl->body->tag == SYMBOL ||
	ltrl->body->tag == NUMBER) {
      ltrl->body->mark = TRUE;
      continue;
    }
    if (ltrl->body->mark == FALSE) {
      print_literal(ltrl->body);
      printf("\n\t\t");
      print_equations(ltrl->body);
      ltrl->body->mark = TRUE;
    } else if (ltrl->body->mark == MARKED) {
      print_equations(ltrl->body);
      ltrl->body->mark = TRUE;
    }
  }
}


void print_literal(literal)
     litrlrec *literal;
{
  char temp[BUFFSIZE];

  temp[0] = '\0';
  CreateLiteralText(temp, literal);
  printf("%s", temp);
  print_coeffs(literal);
}


void print_equations(literal)
     litrlrec *literal;
{
  char temp[BUFFSIZE];

  temp[0] = '\0';
  if (CreateEquationsText(temp, literal)) {
    printf("%s", temp);
    printf("\n\t\t");
  }
}


void print_coeffs(literal)
     litrlrec *literal;
{
  int first;
  jointrec *jnt;
  dependrec *dpnd;
  litrlrec *ltrl;

  printf(" %3.2lf,%10.8lf/%10.8lf", literal->rel, literal->act, literal->imp);
  printf(" <%d:", literal->lid);
  first = TRUE;
  for (jnt = literal->joint; jnt != NULL; jnt = jnt->nxt)
    if (jnt->total) {
      for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt) {
	ltrl = dpnd->link->ptr[dpnd->dir]->joint->ltrl;
	if (first) {
	  printf("%d", ltrl->lid);
	  first = FALSE;
	} else
	  printf(",%d", ltrl->lid);
      }
    }
  putchar('>');
}


void print_probe(prb, all)
     probe *prb;
     Boolean all;
{
  litrllst *t;

  if (prb == NULL)
    return;
  if (!all && !subsumable_probe(prb))
    return;
  print_literal(prb->link->ptr[0]->joint->ltrl);
  printf("\n\t");
  if (prb->dir == 0) {
    print_index(prb->nth, prb->ftr);
    printf("<===");
    if (prb->link->tag == EQUATION)
      print_index(prb->link->ptr[1]->joint->nth,
		  prb->link->ptr[1]->joint->ftr);
    else
      print_index(prb->nth, prb->ftr);
  } else {
    if (prb->link->tag == EQUATION)
      print_index(prb->link->ptr[0]->joint->nth,
		  prb->link->ptr[0]->joint->ftr);
    else
      print_index(prb->nth, prb->ftr);
    printf("===>");
    print_index(prb->nth, prb->ftr);
  }
  printf("  ");
  print_literal(prb->link->ptr[1]->joint->ltrl);
  putchar('\n');
  printf("  Origins : ");
  for (t = prb->orgns; t != NULL; t = t->nxt) {
    if (t->handle->body.ltrl == NULL)
      printf(" #missing# ");
    else
      print_literal(t->handle->body.ltrl);
  }
  printf("\n\n");
}


void print_index(nth, ftr)
     int nth;
     char *ftr;
{
  if (nth < 0) {
    if (nth == LEFTHAND)
      printf("[LeftH]");
    else if (nth == PSTENTRY)
      printf("[ftr=%s]", ftr);
    else
      printf("[??]");
  } else
    printf("[nth=%d]", nth);
}


void print_aconstr_forces()
{
  litrlrec *ltrl;

  /* mark all literals */
  for (ltrl = Gcontrol.unsigned_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
    ltrl->mark = FALSE;
  for (ltrl = Gcontrol.signed_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
    ltrl->mark = FALSE;
  /**** calculate other sorts of energy ****/
  for (ltrl = Gcontrol.unsigned_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
    if (ltrl->mark == FALSE && ltrl->pphndl != NULL)
      print_aconstr_forces_aux(ltrl->pphndl->begin);
  for (ltrl = Gcontrol.signed_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt) {
    if (ltrl->mark == FALSE && ltrl->pphndl != NULL)
      print_aconstr_forces_aux(ltrl->pphndl->begin);
  }
}


void print_aconstr_forces_aux(clause)
     pphandle *clause;
{
  pphandle *literal;
  double disj1, disj2, disjD, excl1, excl2, exclD;
  double assm1, assm2, assmD, cmpl1, cmpl2, cmplD;
  double psdo, imin, imax;

  for (literal = clause; literal != NULL; literal = literal->next) {
    if (literal->body->tag == PSTERM ||
	literal->body->tag == NUMBER || literal->body->tag == SYMBOL) {
      literal->body->act = 1.0;
      literal->body->mark = TRUE;
      continue;
    }
    calc_clausal_forces(clause, literal, &disj1, &excl1, &disjD, &exclD);
    calc_clausal_estimations(clause, literal, &disj2, &excl2);
    calc_literal_forces(literal->body, &assm1, &cmpl1, &assmD, &cmplD, &imin, &imax);
    calc_literal_estimations(literal->body, &assm2, &cmpl2, &psdo);
    print_literal(literal->body);
    printf("\n z: %11.8lf, dPds': %11.8lf\n", literal->body->z, literal->body->imp);
    printf("   :    Disj     :     Excl    :     Assm    :     Cmpl    :    Dpnd\n");
    printf("act: %11.8lf : %11.8lf : %11.8lf : %11.8lf : %11.8lf\n",
	   -Gparams.disjWT * disj1,
	   -Gparams.exclWT * excl1,
	   -Gparams.assmWT * assm1,
	   -Gparams.cmplWT * cmpl1,
	   Gparams.psdoWT * literal->body->dfrc);
    printf(" z : %11.8lf : %11.8lf : %11.8lf : %11.8lf : %11.8lf\n\n\n",
	   Gparams.disjWT * disj2,
	   Gparams.exclWT * excl2,
	   Gparams.assmWT * assm2,
	   Gparams.cmplWT * cmpl2,
	   -Gparams.psdoWT * psdo);
    literal->body->mark = TRUE;
  }
}


void print_link_forces(sw)
     int sw;
{
  int j;
  double assm1, assm2, assmD, eqlz1, eqlz2, eqlzD;
  double trns1, trns2, trnsD, dpnd1, dpnd2, dpndD;
  linkrec *link;

  for (link = Gcontrol.links; link != NULL; link = link->ctrl.nxt) {
    if (link->tag == EQUATION)
      continue;
    if (sw) {
      if (!link->ptr[0]->joint->total &&
	  !link->ptr[1]->joint->total)
	continue;
    } else {
      if (link->ptr[0]->joint->total ||
	  link->ptr[1]->joint->total)
	continue;
    }
    print_link(link);
    printf("\n nth:     act     :     Assm    :     Eqlz    :     Trns    :    Dpnd\n");
    for (j = 0; j < link->n; j++) {
      calc_link_forces(link, j,
		       &assm1, &eqlz1, &trns1, &dpnd1,
		       &assmD, &eqlzD, &trnsD, &dpndD);
      printf("[%2d]: %11.8lf : %11.8lf : %11.8lf : %11.8lf : %11.8lf\n",
	     j,
	     link->coeff[j].body.act,
	     -Gparams.assmWT * assm1,
	     -Gparams.eqlzWT * eqlz1,
	     -Gparams.trnsWT * trns1,
	     -Gparams.psdoWT * dpnd1);
    }
    printf(" nth:      z      :    Assm     :    Eqlz     :    Trns     :    Dpnd\n");
    for (j = 0; j < link->n; j++) {
      calc_link_estimations(link, j, &assm2, &eqlz2, &trns2, &dpnd2);
      printf("[%2d]: %11.8lf : %11.8lf : %11.8lf : %11.8lf : %11.8lf\n",
	     j,
	     link->coeff[j].body.z,
	     Gparams.assmWT * assm2,
	     Gparams.eqlzWT * eqlz2,
	     Gparams.trnsWT * trns2,
	     Gparams.psdoWT * dpnd2);
    }
    printf("\n\n");
  }
}


void print_link(link)
     linkrec *link;
{
  int nth0, nth1;

  print_literal(link->ptr[0]->joint->ltrl);
  nth0 = link->ptr[0]->joint->nth;
  nth1 = link->ptr[1]->joint->nth;
  if (link->tag == INFERENCE) {
    printf("\n%s (%s)<==INF==>(%s) %s\n",
	   (nth0 == PSTENTRY ? "PSTENT" :
	    (nth0 == INFERENCE ? "INF" : "?")),
	   (link->ptr[0]->joint->total ? "total" : "partial"),
	   (link->ptr[1]->joint->total ? "total" : "partial"),
	   (nth1 == PSTENTRY ? "PSTENT" :
	    (nth1 == INFERENCE ? "INF" : "?")));
  } else {
    if (nth0 == LEFTHAND)
      printf("\nLH");
    else
      printf("\n %d", nth0);
    printf(" <==EQU==> ");
    if (nth1 == LEFTHAND)
      printf("LH\n");
    else
      printf("%d\n", nth1);
  }
  print_literal(link->ptr[1]->joint->ltrl);
}
