/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	global.h	---	Declarations of global variables.
 *
 */

#ifdef	PROTO_MAIN_C

struct _Gparams {
  char   *appname;	/* name of this application           */
  char   fname[30];	/* file name of the program           */
  FILE   *infile;	/* file-pointer of the program        */
  int    window;	/* TRUE: use visualize window         */
  int    state;		/* current status                     */
  int    option;	/* switch of optional functions       */

  int    subsume;	/* TRUE: display info of subsumption  */
  int    delete;	/* TRUE: notify each literal-deletion */
  int    copy;		/* TRUE: notify each literal-copy     */
  int    disjSW;	/* TRUE: calculate disjunction E.     */
  int    exclSW;	/* TRUE: calculate exclusion E.       */
  int    cmplSW;	/* TRUE: calculate completion E.      */
  int    assmSW;	/* TRUE: calculate assimilation E.    */
  int    eqlzSW;	/* TRUE: calculate equalization E.    */
  int    trnsSW;	/* TRUE: calculate transitive E.      */
  int    psdoSW;	/* TRUE: calculate dependency E.      */
  int    fixact;	/* TRUE: fix act. after subsumption   */
  int    manual;	/* TRUE: choose probe manually        */

  int    copiedp;	/* TRUE: some literals are copied     */
  int    deletedp;	/* TRUE: some literals are deleted    */
  int    cnvrgdp;	/* TRUE: act. values are converged    */
  double ampl;		/* ampletude of divergence            */

  int    trace;		/* specify level of trace             */
  int    itrmax;	/* specify maximum # of iteration     */
  double disjWT;	/* weight of disjunction energy       */
  double exclWT;	/* weight of exclusion energy         */
  double cmplWT;	/* weight of completion energy        */
  double assmWT;	/* weight of assimilation energy      */
  double eqlzWT;	/* weight of equalization energy      */
  double trnsWT;	/* weight of transitive energy        */
  double psdoWT;	/* weight of dependency energy        */
  double tmprtr;	/* temperature                        */
  double theta;		/* threashold of transitive energy    */
  double epsilon;	/* convergence criterion              */
  double subsTH;	/* threshold of invoking subsumption  */
  double actTH;		/* threshold of invoking action       */
  double ssub;		/* subsumption coeff. of strong links */
  double wsub;		/* subsumption coeff. of weak links   */
  double atmp;		/* temperature of atomic constraints  */
  double stmp;		/* temperature of sigmoid function    */

  /* used only in simulation of speech-recognition */
  double sframeREL;	/* relevance coeff. of s-frame ltrl.  */
  double eframeREL;     /* relevance coeff. of e-frame ltrl.  */
  double timeREL;       /* relevance coeff. of time ltrl.     */
  double phonemeREL;    /* relevance coeff. of phoneme ltrl.  */
  double frameDISJ;	/* disjunction coeff. of frame clause */
  double frameEXCL;	/* exclusion coeff. of frame clause   */
} Gparams;

struct _Gbuffer {	/* used only in parsing */
  int      top;
  pphandle *literals;
  varblrec *variables;
  varblrec *constants;
} Gbuffer;

struct _Gcontrol {
  litrlrec *unsigned_preds;
  litrlrec *signed_preds;
  linkrec  *links;
  probe    *probes;
  index    *loops;
  int      lid;
  struct {
    int      c;
    linkrec  *link;
    int      dir;
    probe    *probe;
  } candidate;
} Gcontrol;


#else	/* PROTO_MAIN_C */

extern struct _Gparams {
  char   *appname;	/* name of this application           */
  char   fname[30];	/* file name of the program           */
  FILE   *infile;	/* file-pointer of the program        */
  int    window;	/* TRUE: use visualize window         */
  int    state;		/* current status                     */
  int    option;	/* switch of optional functions       */

  int    subsume;	/* TRUE: display info of subsumption  */
  int    delete;	/* TRUE: notify each literal-deletion */
  int    copy;		/* TRUE: notify each literal-copy     */
  int    disjSW;	/* TRUE: calculate disjunction E.     */
  int    exclSW;	/* TRUE: calculate exclusion E.       */
  int    cmplSW;	/* TRUE: calculate completion E.      */
  int    assmSW;	/* TRUE: calculate assimilation E.    */
  int    eqlzSW;	/* TRUE: calculate equalization E.    */
  int    trnsSW;	/* TRUE: calculate transitive E.      */
  int    psdoSW;	/* TRUE: calculate dependency E.      */
  int    fixact;	/* TRUE: fix act. after subsumption   */
  int    manual;	/* TRUE: choose probe manually        */

  int    copiedp;	/* TRUE: some literals are copied     */
  int    deletedp;	/* TRUE: some literals are deleted    */
  int    cnvrgdp;	/* TRUE: act. values are converged    */
  double ampl;		/* ampletude of divergence            */

  int    trace;		/* specify level of trace             */
  int    itrmax;	/* specify maximum # of iteration     */
  double disjWT;	/* weight of disjunction energy       */
  double exclWT;	/* weight of exclusion energy         */
  double cmplWT;	/* weight of completion energy        */
  double assmWT;	/* weight of assimilation energy      */
  double eqlzWT;	/* weight of equalization energy      */
  double trnsWT;	/* weight of transitive energy        */
  double psdoWT;	/* weight of dependency energy        */
  double tmprtr;	/* temperature                        */
  double theta;		/* threashold of transitive energy    */
  double epsilon;	/* convergence criterion              */
  double subsTH;	/* threshold of invoking subsumption  */
  double actTH;		/* threshold of invoking action       */
  double ssub;		/* subsumption coeff. of strong links */
  double wsub;		/* subsumption coeff. of weak links   */
  double atmp;		/* temperature of atomic constraints  */
  double stmp;		/* temperature of sigmoid function    */

  /* used only in simulation of speech-recognition */
  double sframeREL;	/* relevance coeff. of s-frame ltrl.  */
  double eframeREL;     /* relevance coeff. of e-frame ltrl.  */
  double timeREL;       /* relevance coeff. of time ltrl.     */
  double phonemeREL;    /* relevance coeff. of phoneme ltrl.  */
  double frameDISJ;	/* disjunction coeff. of frame clause */
  double frameEXCL;	/* exclusion coeff. of frame clause   */
} Gparams;

extern struct _Gbuffer {	/* used only in parsing */
  int      top;
  pphandle *literals;
  varblrec *variables;
  varblrec *constants;
} Gbuffer;

extern struct _Gcontrol {
  litrlrec *unsigned_preds;
  litrlrec *signed_preds;
  linkrec  *links;
  probe    *probes;
  index    *loops;
  int      lid;
  struct {
    int      c;
    linkrec  *link;
    int      dir;
    probe    *probe;
  } candidate;
} Gcontrol;

#endif	/* PROTO_MAIN_C */
