/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	expression.c	---	Expression handling routines.
 *
 */

#include	<stdio.h>

#define	PROTO_EXPRESSION_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_EXPRESSION_C

#pragma segment	parser


varblrec *num_node(num)
     int num;
{
  litrlrec *newltrl;
  varblrec *var;

  var = get_num(num);
  if (var == NULL) {
    newltrl = NEW_litrlrec();
    newltrl->tag = NUMBER;
    newltrl->pol = NEGATIVE;
    newltrl->rel = 1.0;
    newltrl->coeff.nOmega = 0.0;
    newltrl->coeff.omegaN = 1.0;
    newltrl->coeff.disj = DISJ_DEFAULT;
    newltrl->coeff.excl = EXCL_DEFAULT;
    newltrl->coeff.cmpl = CMPL_DEFAULT;
    newltrl->coeff.assm = ASSM_DEFAULT;
    newltrl->dfrc = 0.0;
    newltrl->path = NULL;
    newltrl->press = NULL;
    newltrl->act = 1.0;
    newltrl->z = 0.0;
    newltrl->imp = 0.0;
    newltrl->body.num = num;
    newltrl->lefth = NULL;
    newltrl->joint = NULL;
    newltrl->handle = NULL;
    newltrl->pphndl = NULL;
    newltrl->lid = Gcontrol.lid++;
    newltrl->mark = TRUE;
    newltrl->sbsm = FALSE;
    newltrl->misc = 0;
    newltrl->vnode = NULL;
    push_literal(&Gcontrol.signed_preds, newltrl);
    var = NEW_varblrec();
    var->name = new_name('Y');
    var->nth = LEFTHAND;
    var->ftr = "";
    var->paren = newltrl;
    var->brecs = NULL;
    var->nxt = Gbuffer.constants;
    Gbuffer.constants = var;
    newltrl->print.varname = var->name;
  }
  return var;
}


varblrec *get_num(num)
     int num;
{
  varblrec *p;

  for (p = Gbuffer.constants; p != NULL; p = p->nxt)
    if (p->nth == LEFTHAND &&
	p->paren->tag == NUMBER &&
	p->paren->body.num == num)
      return p;
  return NULL;
}


varblrec *sym_node(sym)
     char *sym;
{
  litrlrec *newltrl;
  varblrec *var;

  var = get_sym(sym);
  if (var == NULL) {
    newltrl = NEW_litrlrec();
    newltrl->tag = SYMBOL;
    newltrl->pol = NEGATIVE;
    newltrl->rel = 1.0;
    newltrl->coeff.nOmega = 0.0;
    newltrl->coeff.omegaN = 1.0;
    newltrl->coeff.disj = DISJ_DEFAULT;
    newltrl->coeff.excl = EXCL_DEFAULT;
    newltrl->coeff.cmpl = CMPL_DEFAULT;
    newltrl->coeff.assm = ASSM_DEFAULT;
    newltrl->dfrc = 0.0;
    newltrl->path = NULL;
    newltrl->press = NULL;
    newltrl->act = 1.0;
    newltrl->z = 0.0;
    newltrl->imp = 0.0;
    newltrl->body.sym = sym;
    newltrl->lefth = NULL;
    newltrl->joint = NULL;
    newltrl->handle = NULL;
    newltrl->pphndl = NULL;
    newltrl->lid = Gcontrol.lid++;
    newltrl->mark = TRUE;
    newltrl->sbsm = FALSE;
    newltrl->misc = 0;
    newltrl->vnode = NULL;
    push_literal(&Gcontrol.signed_preds, newltrl);
    var = NEW_varblrec();
    var->name = new_name('Y');
    var->nth = LEFTHAND;
    var->ftr = "";
    var->paren = newltrl;
    var->brecs = NULL;
    var->nxt = Gbuffer.constants;
    Gbuffer.constants = var;
    newltrl->print.varname = var->name;
  }
  return var;
}


varblrec *get_sym(sym)
     char *sym;
{
  varblrec *p;

  for (p = Gbuffer.constants; p != NULL; p = p->nxt)
    if (p->nth == LEFTHAND &&
	p->paren->tag == SYMBOL &&
	strcmp(p->paren->body.sym, sym) == 0)
      return p;
  return NULL;
}


varblrec *var_node(name)
     char *name;
{
  varblrec *var;

  var = get_var(name);
  if (var == NULL) {
    var = NEW_varblrec();
    var->name = name;
    var->nth = UNKNOWN;
    var->ftr = "";
    var->paren = NULL;
    var->brecs = NULL;
    var->nxt = Gbuffer.variables;
    Gbuffer.variables = var;
  }
  return var;
}


varblrec *get_var(name)
     char *name;
{
  varblrec *p;

  for (p = Gbuffer.variables; p != NULL; p = p->nxt)
    if (p->name != NULL && strcmp(p->name, name) == 0)
      return p;
  return NULL;
}

varblrec *pst_node(ftrlist)
     litrlrec *ftrlist;
{
  litrlrec *newpst, *ftr;
  varblrec *pvar;

  PST_NODE;
  newpst = NEW_litrlrec();
  newpst->tag = PSTERM;
  newpst->pol = NEGATIVE;
  newpst->rel = 1.0;
  newpst->coeff.nOmega = 0.0;
  newpst->coeff.omegaN = 1.0;
  newpst->coeff.disj = DISJ_DEFAULT;
  newpst->coeff.excl = EXCL_DEFAULT;
  newpst->coeff.cmpl = CMPL_DEFAULT;
  newpst->coeff.assm = ASSM_DEFAULT;
  newpst->dfrc = 0.0;
  newpst->path = NULL;
  newpst->press = NULL;
  newpst->act = 1.0;
  newpst->z = 0.0;
  newpst->imp = 0.0;
  newpst->body.pst.name = "";
  newpst->body.pst.val = NULL;
  newpst->body.pst.root = NULL;
  newpst->body.pst.prv = NULL;
  newpst->body.pst.nxt = ftrlist;
  newpst->body.pst.print.embedded = FALSE;
  newpst->body.pst.print.varname = "";
  newpst->lefth = NULL;
  newpst->joint = NULL;
  newpst->handle = NULL;
  newpst->pphndl = NEW_pphandle();
  newpst->pphndl->body = newpst;
  newpst->pphndl->aux = NULL;
  newpst->pphndl->vnode = NULL;
  newpst->lid = Gcontrol.lid++;
  newpst->mark = TRUE;
  newpst->sbsm = FALSE;
  newpst->misc = 0;
  newpst->vnode = NULL;
  pvar = var_node(new_name('X'));
  pvar->nth = LEFTHAND;
  pvar->ftr = "";
  pvar->paren = newpst;
  newpst->print.varname = pvar->name;
  for (ftr = ftrlist; ftr != NULL; ftr = ftr->body.pst.nxt) {
    ftr->print.varname = pvar->name;
    ftr->body.pst.root = newpst;
    ftr->pphndl->next = Gbuffer.literals;
    Gbuffer.literals = ftr->pphndl;
  }
  newpst->pphndl->next = Gbuffer.literals;
  Gbuffer.literals = newpst->pphndl;
  return pvar;
}


varblrec *fnc_node(aform)
     pphandle *aform;
{
  varblrec *var;

  aform->body->pol = NEGATIVE;
  aform->next = Gbuffer.literals;
  Gbuffer.literals = aform;
  var = var_node(new_name('X'));
  var->nth = LEFTHAND;
  var->ftr = "";
  var->paren = aform->body;
  aform->body->print.varname = var->name;
  return var;
}


varblrec *cons_node(exp1, exp2)
     varblrec *exp1;
     varblrec *exp2;
{
  char *tmpname;
  litrlrec *newltrl;
  varblrec *var;

  CONS_NODE;
  newltrl = NEW_litrlrec();
  newltrl->tag = FUNCTION;
  newltrl->pol = NEGATIVE;
  newltrl->rel = REL_DEFAULT;
  newltrl->coeff.nOmega = 0.0;
  newltrl->coeff.omegaN = 1.0;
  newltrl->coeff.disj = DISJ_DEFAULT;
  newltrl->coeff.excl = EXCL_DEFAULT;
  newltrl->coeff.cmpl = CMPL_DEFAULT;
  newltrl->coeff.assm = ASSM_DEFAULT;
  newltrl->dfrc = 0.0;
  newltrl->path = NULL;
  newltrl->press = NULL;
  newltrl->act = LITERAL_INIT;
  newltrl->z = 0.0;
  newltrl->imp = 0.0;
  newltrl->body.afm.name = CONS_NAME;
  newltrl->body.afm.arity = 2;
  newltrl->body.afm.arg = NEW_argument(2);
  newltrl->body.afm.arg[0].body.val = NULL;
  newltrl->body.afm.arg[1].body.val = NULL;
  newltrl->body.afm.arg[0].body.print.varname = exp1->name;
  newltrl->body.afm.arg[1].body.print.varname = exp2->name;
  newltrl->lefth = NULL;
  newltrl->joint = NULL;
  newltrl->handle = NULL;
  newltrl->pphndl = NEW_pphandle();
  newltrl->pphndl->body = newltrl;
  newltrl->pphndl->aux = NULL;
  newltrl->pphndl->vnode = NULL;
  newltrl->pphndl->next = Gbuffer.literals;
  Gbuffer.literals = newltrl->pphndl;
  newltrl->lid = Gcontrol.lid++;
  newltrl->mark = TRUE;
  newltrl->sbsm = FALSE;
  newltrl->misc = 0;
  newltrl->vnode = NULL;
  if (exp1->nth == UNKNOWN) {
    exp1->nth = 0;
    exp1->ftr = "";
    exp1->paren = newltrl;
  } else {
    tmpname = new_name('X');
    var = var_node(tmpname);
    var->nth = 0;
    var->ftr = "";
    var->paren = newltrl;
    make_binding(tmpname, exp1, FALSE);
    var->name = exp1->name;
  }
  if (exp2->nth == UNKNOWN) {
    exp2->nth = 1;
    exp2->ftr = "";
    exp2->paren = newltrl;
  } else {
    tmpname = new_name('X');
    var = var_node(tmpname);
    var->nth = 1;
    var->ftr = "";
    var->paren = newltrl;
    make_binding(tmpname, exp2, FALSE);
    var->name = exp2->name;
  }
  var = var_node(new_name('X'));
  var->nth = LEFTHAND;
  var->paren = newltrl;
  newltrl->print.varname = var->name;
  return var;
}


void push_literal(lst, ltrl)
     litrlrec **lst;
     litrlrec *ltrl;
{
  ltrl->ctrl.prv = NULL;
  ltrl->ctrl.nxt = *lst;
  if (ltrl->ctrl.nxt != NULL)
    ltrl->ctrl.nxt->ctrl.prv = ltrl;
  *lst = ltrl;
}


static int varnum = 0;

char *new_name(prefix)
     int prefix;
{
  char *new;
  int n;

  if (varnum >= MAXIDNUM)
    panic("# of temporary variables exceeds %d (`new_name')", varnum);
  n = varnum++;
  new = (char *) calloc(MAXIDEXP, sizeof(char));
  new[5] = '\0';
  new[4] = '0' + n % 10;
  n /= 10;
  new[3] = '0' + n % 10;
  n /= 10;
  new[2] = '0' + n % 10;
  n /= 10;
  new[1] = '0' + n % 10;
  n /= 10;
  new[0] = prefix;
  return new;
}
