/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>

#include "Objects.h"
#include "SearchP.h"
#include "DataBase.h"

#include "app_res.h"

#include "kappa_rpc1.h"

Display *display;

extern DataBase PIR_database;
extern DataBase PDB_database;


static char buf[BUF_LEN];
char *data = buf;


static String fallback_resources[] = {
/*  "*.font: -Adobe-New Century Schoolbook-Medium-R-Normal--20-*",*/
  NULL
  };

AppRes app_resources;

static XtResource resources[] =
{
#define offset(field) XtOffsetOf (AppRes, field)
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {
    "hostName",  "HostName", XtRString,
    sizeof(String), offset(hostname), XtRString,
    "psiux589",
  },
  {
    "filter",  "Filter", XtRString,
    sizeof(String), offset(filter), XtRString,
    "p_if",
  },
  {
    "howToDisplay",  "HowToDisplay", XtRInt,
    sizeof(int), offset(how_to_display), XtRImmediate,
    (XtPointer)1,
  },
  {
    "databaseNo",  "DatabaseNo", XtRString,
    sizeof(String), offset(database_no), XtRString,
    "64",
  },
  {
    "font0a",  XtCFont, XtRFontStruct,
    sizeof(XFontStruct *), offset(font_a[0]), XtRString,
    "-*-*-*-*-*-*-6-*-75-75-c-*-iso8859-1",
  },
  {
    "font1a",  XtCFont, XtRFontStruct,
    sizeof(XFontStruct *), offset(font_a[1]), XtRString,
    "-*-*-*-*-*-*-12-*-75-75-c-*-iso8859-1",
  },
  {
    "font2a",  XtCFont, XtRFontStruct,
    sizeof(XFontStruct *), offset(font_a[2]), XtRString,
    "-*-*-*-*-*-*-24-*-75-75-c-*-iso8859-1",
  },
#undef offset
};

XtAppContext app_con;

static Widget toplevel;
KPS *Kappa;
Pixmap protein_pixmap;

void main (argc, argv)
     int argc;
     char **argv;
{
  int ret;
  SearchWinData swd;

  toplevel = XtVaAppInitialize (&app_con, "Kappa", NULL, 0,
				&argc, argv, fallback_resources,
				NULL);
  if (argc != 1)
    {
      XtDestroyApplicationContext(app_con);
      fprintf (stderr, "What do you want to do?\n");
      exit (1);
    }

  display = XtDisplay (toplevel);

  data = buf;

  XtVaGetApplicationResources (toplevel,
			       &app_resources, resources, XtNumber (resources),
			       NULL);

  app_resources.database = PIR_database;
  swd = MakeSearchWindow (toplevel);
  XtRealizeWidget (toplevel);

  {
    Pixel fg, bg;
#include "protein.xbm"

    XtVaGetValues (swd->paned,
                   XmNforeground, &fg,
                   XmNbackground, &bg,
                   NULL);

    protein_pixmap =
      XCreatePixmapFromBitmapData (display,
                                   XtWindow (toplevel),
                                   protein_bits,
                                   protein_width,
                                   protein_height,
                                   fg, bg,
                                   DefaultDepth (display,
                                                 DefaultScreen(display)));
  }


  if ((Kappa = KappaMSOpen (app_resources.hostname, &ret))
       == NULL)
    {
      fprintf (stderr, "KappaMSOpen Error: %d\n",ret);
      exit (1);
    }
  XtAppMainLoop (app_con);
}
