/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <ctype.h>
extern char *data;
#include "ObjectsP.h"

int point;
int yylval;

int parseError (string)
     char *string;
{
  fprintf (stderr, "%s\n", string);
  exit (1);
}

int yylex ()
{
  int x;
  int c;
  int old_point;

  old_point = point;

  if (data[point] == 0)
    return 0;

  /* skip whitespaces */
  while (isspace (c = data[point]))
    {
      point++;
      old_point = point;
    }

  if (isalpha (c) || c == '_' || c == '#')
    {
      point++;
      while (isalpha (c = data[point]))
	point++;

      yylval = old_point;
      return WORD;
    }
  else if (c == '-')
    {
      point++;
      x = 0;
      while (isdigit (c = data[point]))
	{
	  x = x * 10 + c - '0';
	  point++;
	}

      yylval = x;
      return INTEGER;
    }
  else if (isdigit (c))
    {
      point++;
      x = c - '0';
      while (isdigit (c = data[point]))
	{
	  x = x * 10 + c - '0';
	  point++;
	}

      yylval = x;
      return INTEGER;
    }
  else if (c == '"')
    {
      point++;
      while ((c = data[point]) != '"')
	point++;

      point++;
      yylval = old_point + 1;
      return STRING;
    }
  else if (c == '\'')
    {
      point++;
      while ((c = data[point]) != '\'')
	point++;

      point++;
      yylval = old_point + 1;
      return ATOM;
    }
  else
    {
      point++;
      return c;
    }
}

int token;

void advance (t)
     int t;
{
  if (t && t != token)
    {
      fprintf (stderr, "%d: %s\n", point, data);
      parseError ("??advance");
    }
  token = yylex ();
}

char *parseSTRINGorWORD ()
{
  char *s;

  if (token == STRING)
    {
      if (yylval > point)
	parseError ("??string_word");
      if (yylval == point)
	s = XtNewString ("");
      else
	{
	  s = XtMalloc (point - yylval);
	  strncpy (s, data+yylval, point - yylval-1);
	  s[point-yylval-1] = '\0';
	}
      advance (STRING);
    }
  else if (token == WORD)
    {
      s = XtNewString ("");
      advance (WORD);
    }
  else
    {
      printf ("%d, %s\n", point, &data[point-10]);
      parseError ("??string_word2");
    }

  return s;
}

void parsePositionOrRegionListSUB (plp, rlp)
     PositionList *plp;
     RegionList *rlp;
{
  PositionList pl, pl_current;
  PositionList pl_top;
  Position p;
  RegionList rl, rl_current;
  RegionList rl_top;
  PirRegion r;

  int point1;
  int c;

  rl_top = NULL;
  pl_top = NULL;

  if (token != STRING)
    parseError ("??pos region");

  point1 = yylval;
  while (point1 < point &&
	 isspace (c=data[point1]))
    point1++;

  p = 0;
  while (point1 < point &&
	 isdigit (c=data[point1]))
    {
      p = p*10 + c - '0';
      point1++;
    }

  while (point1 < point &&
	 isspace (c=data[point1]))
    point1++;

  if (c == '-')
    { /* it's region */
      r = (PirRegion)XtMalloc (sizeof (RegionRec));
      r->start = p;

      point1++;
      while (point1 < point &&
	     isspace (c=data[point1]))
	point1++;
      p = 0;
      while (point1 < point &&
	     isdigit (c=data[point1]))
	{
	  p = p*10 + c - '0';
	  point1++;
	}

      r->end = p;

      rl = (RegionList)XtMalloc (sizeof (RegionListRec));
      rl->region = r;
      rl->next = NULL;
      rl_top = rl_current = rl;
    }
  else
    {
      pl = (PositionList)XtMalloc (sizeof (PositionListRec));
      pl->position = p;
      pl->next = NULL;
      pl_top = pl_current = pl;
    }

  advance (STRING);

  while (token == ',')
    {
      advance (',');

      if (token != STRING)
	parseError ("??pos region2");

      point1 = yylval;
      while (point1 < point &&
	     isspace (c=data[point1]))
	point1++;
      p = 0;
      while (point1 < point &&
	     isdigit (c=data[point1]))
	{
	  p = p*10 + c - '0';
	  point1++;
	}

      if (c == '-')
	{ /* it's region */
	  r = (PirRegion)XtMalloc (sizeof (RegionRec));
	  r->start = p;

          point1++;
	  while (point1 < point &&
		 isspace (c=data[point1]))
	    point1++;
	  p = 0;
	  while (point1 < point &&
		 isdigit (c=data[point1]))
	    {
	      p = p*10 + c - '0';
	      point1++;
	    }

	  r->end = p;

	  rl = (RegionList)XtMalloc (sizeof (RegionListRec));
	  rl->region = r;
	  rl->next = NULL;
	  if (rl_top)
	    rl_current->next = rl;
	  else
	    rl_top = rl;
	  rl_current = rl;
	}
      else
	{
	  pl = (PositionList)XtMalloc (sizeof (PositionListRec));
	  pl->position = p;
	  pl->next = NULL;
	  if (pl_top)
	    pl_current->next = pl;
	  else
	    pl_top = pl;
	  pl_current = pl;
	}

      advance (STRING);
    }

  *plp = pl_top;
  *rlp = rl_top;

  return;
}

void parsePositionOrRegionList (plp, rlp)
     PositionList *plp;
     RegionList *rlp;
{
  advance ('[');
  parsePositionOrRegionListSUB (plp, rlp);
  advance (']');

  return;
}

char * parseATOM ()
{
  char *s;

  if (token == ATOM)
    {
      if (yylval > point)
	parseError ("??atom");
      if (yylval == point)
	s = XtNewString ("");
      else
	{
	  s = XtMalloc (point - yylval);
	  strncpy (s, data+yylval, point - yylval-1);
	  s[point-yylval-1] = '\0';
	}
      advance (ATOM);
    }
  else
    parseError ("??atom2");

  return s;
}

int parseINTEGER ()
{
  int i = yylval;

  advance (INTEGER);
  return i;
}

int parseINTEGERorWORD ()
{
  int i;

  if (token == INTEGER)
    {
      i = yylval;
      advance (INTEGER);
    }
  else
    {
      i = 0;
      advance (WORD);
    }

  return i;
}

StringList parseStringListSUB ()
{
  char *s;
  StringList sl, sl_current;
  StringList sl_top;

  s = parseSTRINGorWORD ();
  sl_top = sl_current = sl = (StringList)XtMalloc (sizeof (StringListRec));
  sl->string = s;

  while (token == ',')
    {
      advance (',');
      s = parseSTRINGorWORD ();
      sl  = (StringList)XtMalloc (sizeof (StringListRec));
      sl->string = s;
      sl_current->next = sl;
      sl_current = sl;
    }

  sl_current->next = NULL;

  return sl_top;
}

StringList parseStringList ()
{
  StringList sl;

  advance ('[');
  if (token == ']')
    {
      sl = NULL;
    }
  else
    {
      sl = parseStringListSUB ();
    }
  advance (']');

  return sl;
}


StringList parseStringSetListSUB ()
{
  char *s;
  StringList sl, sl_current;
  StringList sl_top;

  advance ('{');
  s = parseSTRINGorWORD ();
  advance ('}');
  sl_top = sl_current = sl = (StringList)XtMalloc (sizeof (StringListRec));
  sl->string = s;

  while (token == ',')
    {
      advance (',');
      advance ('{');
      s = parseSTRINGorWORD ();
      advance ('}');
      sl  = (StringList)XtMalloc (sizeof (StringListRec));
      sl->string = s;
      sl_current->next = sl;
      sl_current = sl;
    }

  sl_current->next = NULL;

  return sl_top;
}

StringList parseStringSetList ()
{
  StringList sl;

  advance ('[');
  if (token == ']')
    {
      sl = NULL;
    }
  else
    {
      sl = parseStringSetListSUB ();
    }
  advance (']');

  return sl;
}

void printRegion (r)
     PirRegion r;
{
  printf ("%d-%d", r->start, r->end);
}

void printStringList (s, sl)
     char *s;
     StringList sl;
{
  StringList sl1;

  printf ("%s\n", s);
  for (sl1 = sl; sl1; sl1 = sl1->next)
    printf ("%s\n", sl1->string);
}

void printRegionList (rl)
     RegionList rl;
{
  RegionList rl1;

  for (rl1 = rl; rl1; rl1 = rl1->next)
    printRegion (rl1->region);
}

void printPositionList (pl)
     PositionList pl;
{
  PositionList pl1;

  for (pl1 = pl; pl1; pl1 = pl1->next)
    printf ("%d\n", pl1->position);
}

void freeRegion (r)
     PirRegion r;
{
  XtFree ((char *)r);
}

void freeStringList (sl)
     StringList sl;
{
  StringList sl1, sl2;

  for (sl1 = sl; sl1; sl1 = sl2)
    {
      sl2 = sl1->next;
      XtFree (sl1->string);
      XtFree ((char *)sl1);
    }
}

void freePositionList (pl)
     PositionList pl;
{
  PositionList pl1, pl2;

  for (pl1 = pl; pl1; pl1 = pl2)
    {
      pl2 = pl1->next;
      XtFree ((char *)pl1);
    }
}

void freeRegionList (rl)
     RegionList rl;
{
  RegionList rl1, rl2;

  for (rl1 = rl; rl1; rl1 = rl2)
    {
      rl2 = rl1->next;
      freeRegion (rl1->region);
      XtFree ((char *)rl1);
    }
}
