/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "FigObjectP.h"

static XtResource resources[] =
{
#define offset(field) XtOffsetOf (FigObjectRec, field)
  /* {name, class, type, size, offset, default_type, default_addr}, */
  {
    XtNforeground, XtCForeground, XtRPixel,
    sizeof(Pixel), offset(fig_object.foreground), XtRString,
    XtDefaultForeground,
  },
  {
    XtNbackground, XtCBackground, XtRPixel,
    sizeof(Pixel), offset(fig_object.background), XtRString,
    XtDefaultBackground,
  },
#undef offset
};

static void ClassInitialize ();
static void ClassPartInitialize ();
static Boolean SetValues ();
static void Initialize ();
static void Destroy ();

static void Redisplay ();
static void Draw ();

FigObjectClassRec figObjectClassRec = {
   {/* object fields */
    /* superclass */ (WidgetClass) &rectObjClassRec,
    /* class name */            "FigObject",
    /* size of widget */        sizeof (FigObjectRec),
    /* class_initialize */      ClassInitialize,
    /* class_part_initialize */ ClassPartInitialize,
    /* class_inited	*/	FALSE,
    /* initialize	*/	Initialize,
    /* initialize_hook	*/      NULL,
    /* 1 */      NULL,
    /* 2 */      NULL,
    /* 3 */      NULL,
    /* resources */	        resources,
    /* num_resources */	        XtNumber(resources),
    /* xrm_class */	        NULLQUARK,
    /* 4 */     NULL,
    /* 5 */     NULL,
    /* 6 */     NULL,
    /* 7 */     NULL,
    /* destroy		*/      Destroy,
    /* resize */                NULL,
    /* expose */                Redisplay,
    /* set_values	 */     SetValues,
    /* set_values_hook	 */	NULL,
    /* set_values_almost */     NULL,
    /* get_values_hook	 */	NULL,
    /* 9 */     NULL,
    /* version		*/	XtVersion,
    /* callback_private	*/	NULL,
    /* 10 */    NULL,
    /* query_geometry */        NULL,
    /* 11 */    NULL,
    /* extension	*/	NULL,
   },
   {/* fig object field */
    /* draw */      Draw,
   },
};

WidgetClass figObjectClass = (WidgetClass)&figObjectClassRec;

static void
ClassInitialize (wc)
WidgetClass wc;
{
    /* You can add resource converters HERE. */
    return;
}

static void
ClassPartInitialize (wc)
WidgetClass wc;
{
    FigObjectClass foc = (FigObjectClass) wc;

    /* solve inheritance */
    if (foc->fig_object_class.draw == GkInheritDraw)
	{
	    FigObjectClass superclass = (FigObjectClass) foc->rect_obj_class.superclass;
	    foc->fig_object_class.draw = superclass->fig_object_class.draw;
	}
}

static Boolean
SetValues (current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
    FigObject curfo = (FigObject) current;
    FigObject reqfo = (FigObject) request;
    FigObject newfo = (FigObject) new;
    Boolean redraw  = False;
    XGCValues values;
    XtGCMask mask;

    if (curfo->fig_object.background != newfo->fig_object.background ||
	curfo->fig_object.foreground != newfo->fig_object.foreground)
	{
	    mask = GCBackground | GCForeground;
	    values.foreground = newfo->fig_object.foreground;
	    values.background = newfo->fig_object.background;
	    XtReleaseGC (curfo->object.parent, curfo->fig_object.gc);
	    newfo->fig_object.gc = XtGetGC (newfo->object.parent,
					    mask, &values);
	    redraw = True;
	}

    return redraw;
}

static void
Initialize (treq, tnew, args, num_args)
Widget treq, tnew;
ArgList args;
Cardinal *num_args;
{
    FigObject reqfo = (FigObject) treq;
    FigObject newfo = (FigObject) tnew;
    XGCValues values;
    XtGCMask mask = GCForeground | GCBackground ;

    /* get a GC */

    values.background = newfo->fig_object.background;
    values.foreground = newfo->fig_object.foreground;
    newfo->fig_object.gc = XtGetGC (newfo->object.parent, mask, &values);
}

static void
Destroy (w)
Widget w;
{
    FigObject fo = (FigObject) w;

    /* release a GC */
    XtReleaseGC (fo->object.parent, fo->fig_object.gc);
}

static void
Redisplay (w, event, region)
Widget w;
XExposeEvent *event;
Region region;
{
    FigObject fo = (FigObject) w;

    (((FigObjectClass)fo->object.widget_class)->fig_object_class.draw)
	(w, event, region);
}

static void
Draw (w, event, region)
Widget w;
XExposeEvent *event;
Region region;
{
  XtWarning ("FigObject: Draw ??");
}
