/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
  
#include <X11/Shell.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ToggleBG.h>
#include <Xm/List.h>
  
#include "DataBaseP.h"
#include "ObjectsP.h"

#include "Attrib.h"
#include "DispWinP.h"

#include "app_res.h"

extern Display *display;
extern protein_pixmap;


static void free_features (features)
     Widget **features;
{
  Widget **wpp;

  if (features)
    {
      for (wpp = features; *wpp; wpp++)
	XtFree ((char *)*wpp);
      XtFree ((char *)features);
    }
}

static void free_feature_string_list (feature_string_list)
     String *feature_string_list;
{
  String *sl;

  if (feature_string_list)
    {
      for (sl = feature_string_list; *sl; sl++)
	XtFree (*sl);
      XtFree ((char *)feature_string_list);
    }
}

static void Quit (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd;
  int i;
  String *sl;
  Widget **wpp;

  dwd = (DispWinData) clientData;
  
  /* Destroy all widgets */
  XtDestroyWidget (dwd->top);
  
  if (dwd->attr_win_data)
    {
      DestroyAttrWin (dwd->attr_win_data);
      dwd->attr_win_data = NULL;
    }
  /* and free the memory */
  dwd->database->freeInfo (dwd->g);

  free_feature_string_list (dwd->feature_string_list);
  free_features (dwd->features);

  XtFree (dwd->hostname);
  XtFree (dwd->database_no);
  for (i=0; i<dwd->num_of_candidates; i++)
    {
      XtFree (dwd->candidate_list[i]);
    }
  XtFree ((char *)dwd->candidate_list);
  XtFree ((char *)dwd);
}

static void MakeDispWinInternal ();

static void  Prev (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  char title[50];
  DispWinData dwd;
  int i;
  
  dwd = (DispWinData)clientData;
  
  if (--dwd->current < 0)
    {
      ++dwd->current;
      return;
    }
  
  if (dwd->attr_win_data)
    {
      DestroyAttrWin (dwd->attr_win_data);
      dwd->attr_win_data = NULL;
    }
  
  dwd->database->freeInfo (dwd->g);
  
  dwd->database->getInfo (dwd);
  
  XtDestroyWidget (dwd->paned);

  free_features (dwd->features);
  free_feature_string_list (dwd->feature_string_list);
  dwd->database->getTitle (dwd, title);
  XtVaSetValues (dwd->top,
		 XtNtitle, title,
		 NULL);
  MakeDispWinInternal (dwd);
}

static void Next (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  char title[50];
  DispWinData dwd;
  int i;

  dwd = (DispWinData)clientData;

  if (++dwd->current >= dwd->num_of_candidates)
    {
      --dwd->current;
      return;
    }

  if (dwd->attr_win_data)
    {
      DestroyAttrWin (dwd->attr_win_data);
      dwd->attr_win_data = NULL;
    }

  dwd->database->freeInfo (dwd->g);
  dwd->database->getInfo (dwd);

  XtDestroyWidget (dwd->paned);

  free_features (dwd->features);
  free_feature_string_list (dwd->feature_string_list);

  dwd->database->getTitle (dwd, title);
  XtVaSetValues (dwd->top,
		 XtNtitle, title,
		 NULL);
  MakeDispWinInternal (dwd);
}

static void  Copy (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd;
  
  dwd = (DispWinData)clientData;
  
  dwd->database->printInfo (dwd->g);
}

static void Motif (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd = (DispWinData)clientData;
  
  /* not support yet */
  return;
}

static void Invoke3D (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd = (DispWinData)clientData;
  
  /* not support yet */
  return;
}

static void Etc (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd = (DispWinData)clientData;
  
  /* not support yet */
  return;
}

void Attr (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd = (DispWinData)clientData;

  if (dwd->attr_win_data)
    return;
  
  MakeAttrWin (dwd);
}

void RefreshSelection (dwd,
                       selected_item_count,
                       selected_item_positions)
     DispWinData dwd;
     int selected_item_count;
     int selected_item_positions[];
{
  int i,j,k;

  if (dwd->features)
    {
      for (i=0; dwd->features[i]; i++)
	for (j=0; dwd->features[i][j]; j++)
	  XtUnmanageChild (dwd->features[i][j]);

      for (i=0; i < selected_item_count; i++)
	{
	  int k;
	  k = selected_item_positions[i] -1;
	  for (j=0; dwd->features[k][j]; j++)
	    XtManageChild (dwd->features[k][j]);
	}
    }
}

static void FeatureSelect (widget, clientData, callData)
     Widget widget;
     XtPointer clientData;
     XmListCallbackStruct *callData;
{
  int item_count;
  DispWinData dwd = (DispWinData)clientData;

  RefreshSelection (dwd, callData->selected_item_count,
                    callData->selected_item_positions);
}

static void SelAll (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd = (DispWinData)clientData;
  int i,j;
  XmStringTable st;
  int count;

  XtVaGetValues (dwd->listbox,
                 XmNitems, &st,
                 XmNitemCount, &count,
                 NULL);

  XtVaSetValues (dwd->listbox,
                 XmNselectedItems, st,
                 XmNselectedItemCount, count,
                 NULL);
  if (dwd->features)
    for (i=0; i < count; i++)
      for (j=0; dwd->features[i][j]; j++)
	XtManageChild (dwd->features[i][j]);
}



static void MakeFig (dwd)
     DispWinData dwd;
{
  dwd->database->makeFig (dwd);
}

static void ChangeMag (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DispWinData dwd;
  int i;

  dwd = (DispWinData)clientData;
  
  if ((int)widget == (int)dwd->x4)
    {
      if (dwd->cur_mag != 2)
	{
	  XtDestroyWidget (dwd->fig);
	  free_features (dwd->features);
	  dwd->cur_mag = 2;
	  MakeFig (dwd);
	}
    }
  else if ((int)widget == (int)dwd->x2)
    {
      if (dwd->cur_mag != 1)
	{
	  XtDestroyWidget (dwd->fig);
	  free_features (dwd->features);
	  dwd->cur_mag = 1;
	  MakeFig (dwd);
	}
    }
  else /* x1 */
    {
      if (dwd->cur_mag != 0)
	{
	  XtDestroyWidget (dwd->fig);
	  free_features (dwd->features);
	  dwd->cur_mag = 0;
	  MakeFig (dwd);
	}
    }
}

static void MakeDispWinInternal (dwd)
     DispWinData dwd;
{
  DataBase database = dwd->database;
  int i;
  char ttl[50];
  XmString str;
  Widget paned, form0, form1, form2, form3, frame0, frame1;
  Widget listbox, protein, select_all, quit, prev, next, copy;
  Widget scrolled_window, frame2, rowcolumn;
  Widget x4, x2, x1;

  database->makeFeatureStringList (dwd);

  dwd->paned = paned =
    XtVaCreateWidget ("paned", xmPanedWindowWidgetClass, dwd->top,
		      XmNorientation, XmHORIZONTAL,
		      NULL);
  {
    form0 =
      XtVaCreateWidget ("form0", xmFormWidgetClass, paned,
                        XmNfractionBase, 10,
                        NULL);
    {
      frame1 =
        XtVaCreateWidget ("frame1", xmFrameWidgetClass, form0,
                          XmNtopAttachment,    XmATTACH_FORM,
                          XmNbottomAttachment, XmATTACH_NONE,
                          XmNleftAttachment,   XmATTACH_NONE,
                          XmNrightAttachment,  XmATTACH_FORM,
                          NULL);
      form2 =
        XtVaCreateWidget ("form2", xmFormWidgetClass, frame1,
                          NULL);
      quit =
        XtVaCreateManagedWidget ("quit",
                                 xmPushButtonWidgetClass, form2,
                                 XmNtopAttachment,    XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_NONE,
                                 XmNleftAttachment,   XmATTACH_FORM,
                                 XmNrightAttachment,  XmATTACH_FORM,
                                 NULL);
      XtAddCallback (quit,
                     XmNactivateCallback, Quit, (XtPointer)dwd);
  
      prev =
        XtVaCreateManagedWidget ("prev",
                                 xmPushButtonWidgetClass, form2,
                                 XmNtopAttachment,    XmATTACH_WIDGET,
                                 XmNtopWidget,        quit,
                                 XmNbottomAttachment, XmATTACH_NONE,
                                 XmNleftAttachment,   XmATTACH_FORM,
                                 XmNrightAttachment,  XmATTACH_FORM,
                                 NULL);
      XtAddCallback (prev,
                     XmNactivateCallback, Prev, (XtPointer)dwd);
  
      next =
        XtVaCreateManagedWidget ("next",
                                 xmPushButtonWidgetClass, form2,
                                 XmNtopAttachment,    XmATTACH_WIDGET,
                                 XmNtopWidget,        prev,
                                 XmNbottomAttachment, XmATTACH_NONE,
                                 XmNleftAttachment,   XmATTACH_FORM,
                                 XmNrightAttachment,  XmATTACH_FORM,
                                 NULL);
      XtAddCallback (next,
                     XmNactivateCallback, Next, (XtPointer)dwd);
  
      copy =
        XtVaCreateManagedWidget ("copy",
                                 xmPushButtonWidgetClass, form2,
                                 XmNtopAttachment,    XmATTACH_WIDGET,
                                 XmNtopWidget,        next,
                                 XmNbottomAttachment, XmATTACH_NONE,
                                 XmNleftAttachment,   XmATTACH_FORM,
                                 XmNrightAttachment,   XmATTACH_FORM,
                                 NULL);
      XtAddCallback (copy,
                     XmNactivateCallback, Copy, (XtPointer)dwd);

      if (!dwd->show_all)
        {
          XtVaSetValues (prev,
                         XtNsensitive, False,
                         NULL);
          XtVaSetValues (next,
                         XtNsensitive, False,
                         NULL);
        }

      XtManageChild (form2);
      XtManageChild (frame1);
    }
    {
      protein =
        XtVaCreateManagedWidget ("protein",
                                 xmLabelGadgetClass,  form0,
                                 XmNtopAttachment,    XmATTACH_POSITION,
                                 XmNtopPosition,      2,
                                 XmNlabelType,        XmPIXMAP,
                                 XmNlabelPixmap,      protein_pixmap,
                                 XmNrightAttachment,  XmATTACH_WIDGET,
                                 XmNrightWidget,      frame1,
                                 NULL);
    }
    {
      form1 =
        XtVaCreateWidget ("form1", xmFormWidgetClass, form0,
                          XmNfractionBase,     10,
                          XmNtopAttachment,    XmATTACH_FORM,
                          XmNbottomAttachment, XmATTACH_FORM,
                          XmNleftAttachment,   XmATTACH_FORM,
                          XmNrightAttachment,  XmATTACH_WIDGET,
                          XmNrightWidget,      protein,
                          NULL);
      {
        dwd->frame0 = frame0 =
          XtVaCreateWidget ("frame0", xmFrameWidgetClass, form1,
                            XmNtopAttachment,    XmATTACH_FORM,
                            XmNleftAttachment,   XmATTACH_FORM,
                            XmNrightAttachment,  XmATTACH_POSITION,
                            XmNrightPosition,    6,
                            NULL);
        database->makeDataWindow (dwd);
        XtManageChild (frame0);
      }
      {
        dwd->listbox = listbox =
          XmCreateScrolledList (form1, "listbox", NULL, 0);
        {
          XmStringTable str_table;
    
          str_table = (XmStringTable)
            XtMalloc (sizeof (XmString *) * dwd->num_of_features);

          for (i = 0; i < dwd->num_of_features; i++)
            str_table[i] = XmStringCreateSimple (dwd->feature_string_list[i]);

          XtVaSetValues (listbox,
                         XmNitems, str_table,
                         XmNitemCount, dwd->num_of_features,
                         XmNvisibleItemCount, 5,
                         XmNselectionPolicy, XmEXTENDED_SELECT,
                         NULL);

          for (i = 0; i < dwd->num_of_features; i++)
            XmStringFree (str_table[i]);
          XtFree (str_table);
        }
        XtAddCallback (listbox,
                       XmNextendedSelectionCallback, FeatureSelect, dwd);

        XtVaSetValues (XtParent (listbox),
                       XmNtopAttachment,    XmATTACH_FORM,
                       XmNbottomAttachment, XmATTACH_FORM,
                       XmNleftAttachment,   XmATTACH_POSITION,
                       XmNleftPosition,     6,
                       XmNrightAttachment,  XmATTACH_FORM,
                       NULL);
        XtManageChild (listbox);
      }
      XtManageChild (form1);
    }

    {
      select_all =
        XtVaCreateManagedWidget ("selectAll",
                                 xmPushButtonWidgetClass, form0,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 XmNleftAttachment,  XmATTACH_WIDGET,
                                 XmNleftWidget,       form1,
                                 NULL);
      XtAddCallback (select_all,
                     XmNactivateCallback, SelAll, dwd);
    }

    XtManageChild (form0);
  }

  {
    form3 =
      XtVaCreateWidget ("form3", xmFormWidgetClass, paned,
                        NULL);
    {
      frame2 =
        XtVaCreateWidget ("frame2", xmFrameWidgetClass, form3,
			  XmNtopAttachment,    XmATTACH_FORM,
			  XmNrightAttachment,  XmATTACH_FORM,
			  NULL);
      {
        rowcolumn =
          XtVaCreateWidget ("rowcolumn",
                            xmRowColumnWidgetClass, frame2,
                            XmNisHomogeneous, True,
                            XmNentryClass, xmToggleButtonGadgetClass,
                            XmNradioBehavior, True,
                            XmNpacking, XmPACK_COLUMN,
                            XmNnumColumns, 1,
                            NULL);
        dwd->x4 = x4 =
          XtVaCreateManagedWidget ("x4", xmToggleButtonGadgetClass, rowcolumn,
                                   NULL);
        XtAddCallback (x4, XmNvalueChangedCallback, ChangeMag, (XtPointer)dwd);
  
        dwd->x2 = x2 =
          XtVaCreateManagedWidget ("x2", xmToggleButtonGadgetClass, rowcolumn,
                                   NULL);
        XtAddCallback (x2, XmNvalueChangedCallback, ChangeMag, (XtPointer)dwd);
  
        dwd->x1 = x1 =
          XtVaCreateManagedWidget ("x1", xmToggleButtonGadgetClass, rowcolumn,
                                   NULL);
        XtAddCallback (x1, XmNvalueChangedCallback, ChangeMag, (XtPointer)dwd);

        XmToggleButtonGadgetSetState (x1, dwd->cur_mag == 0, False);
        XmToggleButtonGadgetSetState (x2, dwd->cur_mag == 1, False);
        XmToggleButtonGadgetSetState (x4, dwd->cur_mag == 2, False);
        XtManageChild (rowcolumn);
        XtManageChild (frame2);
      }

      dwd->scrolled_window = scrolled_window =
        XtVaCreateManagedWidget ("scrolledWindow",
                                 xmScrolledWindowWidgetClass, form3,
                                 XmNscrollingPolicy,  XmAUTOMATIC,
                                 XmNtopAttachment,    XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 XmNleftAttachment,   XmATTACH_FORM,
                                 XmNrightAttachment,  XmATTACH_WIDGET,
                                 XmNrightWidget,      frame2,
                                 NULL);
      MakeFig (dwd);
    }

    XtManageChild (form3);
  }

  XtManageChild (paned);
  XtRealizeWidget (dwd->top);
}

void MakeDispWin (string_list,
                  num_of_candidates,
                  current, show_all,
                  hostname, database, database_no)
     StringList string_list;
     int num_of_candidates;
     int current;
     int show_all;
     char *hostname;
     DataBase database;
     char *database_no;
{
  StringList sl;
  DispWinData dwd;
  int i;
  char title[50];

  dwd = (DispWinData)XtMalloc (sizeof (DispWinDataRec));

  dwd->candidate_list = (String *)XtMalloc (sizeof (String)*num_of_candidates);
  for (i=0, sl = string_list; sl; i++, sl=sl->next)
    {
      dwd->candidate_list[i] = XtNewString (sl->string);
    }

  dwd->num_of_candidates = num_of_candidates;
  dwd->current = current;
  dwd->show_all = show_all;
  dwd->attr_win_data = NULL;
  dwd->cur_mag = 0;

  dwd->hostname = XtNewString (hostname);
  dwd->database = database;
  dwd->database_no = XtNewString (database_no);

  dwd->database->getInfo (dwd);
  
  database->getTitle (dwd, title);
  dwd->top = 
    XtVaAppCreateShell (title, "KappaDisplay",
			applicationShellWidgetClass, display,
			NULL);
  MakeDispWinInternal (dwd);
}
