/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/ToggleBG.h>

#include "DefineP.h"
#include "DataBaseP.h"
#include "ObjectsP.h"
#include "SearchP.h"
#include "app_res.h"

#include "Pir.h"
#include "Pdb.h"


extern Display *display;

void DestroyDefineWin (dwd)
     DefineWinData dwd;
{
  SearchWinData swd = dwd->swd;

  XtDestroyWidget (dwd->define);

  if (swd->string_list)
    { int i;

      for (i=0; i < swd->number_of_hits; i++)
	XtFree (swd->string_list[i]);
      XtFree ((char *)swd->string_list);
    }
  swd->string_list = NULL;
  swd->number_of_hits = 0;

#if 0
  XtVaSetValues (swd->list,
                 XmNitems, NULL,
                 XmNitemCount, 0,
                 NULL);

  {
      XmString str;
      str  = XmStringCreateSimple ("0"); 
      XtVaSetValues (swd->total_hits,
		     XmNlabelString, str,
		     NULL);
      XmStringFree (str);
  }
#endif
  swd->dwd = NULL;
  XtFree ((char *)dwd);
}

static void  DefineQuit (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  DefineWinData dwd = (DefineWinData) clientData;
  char *string;
  DataBase database = app_resources.database;

  /* Set filter name */
  XtVaGetValues (dwd->filter_value,
                 XmNvalue, &string, NULL);
  app_resources.filter = XtNewString (string);

 /* database_no */
  XtVaGetValues (dwd->database_no,
                 XmNvalue, &string, NULL);
  app_resources.database_no = XtNewString (string);
  app_resources.how_to_display = XmToggleButtonGadgetGetState (dwd->all);
  if (XmToggleButtonGadgetGetState (dwd->pir_or_pdb))
    app_resources.database = PDB_database;
  else
    app_resources.database = PIR_database;

  database->freeSearchInfo (dwd->swd->s);
  XtDestroyWidget (dwd->swd->paned);
  MakeSearchWindowInternal (dwd->swd);
  DestroyDefineWin (dwd);
}

DefineWinData MakeDefineWin (swd)
     SearchWinData swd;
{
  DefineWinData dwd;
  Widget define;
  Widget rowcol;
  Widget filter;
  Widget single;
  Widget all;
  Widget quit;
  Widget radio_box;
  Widget pir, pdb;
  char name[50];

  dwd = (DefineWinData) XtMalloc (sizeof (struct _DefineWinDataRec));
  dwd->swd = swd;
  sprintf (name, "Define: %c%c%c_kappa",
	   app_resources.database->database_name[0],
	   app_resources.database->database_name[1],
	   app_resources.database->database_name[2]);
  dwd->define = define =
    XtVaAppCreateShell (name, "KappaDefine",
			applicationShellWidgetClass, display,
			XtNtransient, True,
			NULL);

  rowcol = XtVaCreateWidget ("define", xmRowColumnWidgetClass, define,
                             XmNpacking, XmPACK_COLUMN,
                             XmNorientation, XmHORIZONTAL,
                             XmNnumColumns, 5,
                             NULL);

  filter =
    XtVaCreateManagedWidget ("filter", xmLabelGadgetClass, rowcol,
                             NULL);

  dwd->filter_value =
    XtVaCreateManagedWidget ("filterValue", xmTextFieldWidgetClass, rowcol,
                             XmNalignment, XmALIGNMENT_END,
			     XmNvalue, app_resources.filter,
			     NULL);

  XtVaCreateManagedWidget ("database_no", xmLabelGadgetClass, rowcol,
                           XmNalignment, XmALIGNMENT_END,
			   NULL);

  dwd->database_no =
    XtVaCreateManagedWidget("database_no_value", xmTextFieldWidgetClass, rowcol,
                            XmNvalue, app_resources.database_no,
                            NULL);

  XtVaCreateManagedWidget ("display", xmLabelGadgetClass, rowcol,
			   NULL);

  radio_box = XtVaCreateWidget ("radio_box", xmRowColumnWidgetClass, rowcol,
                                XmNisHomogeneous, True,
                                XmNentryClass, xmToggleButtonGadgetClass,
                                XmNradioBehavior, True,
                                XmNpacking, XmPACK_COLUMN,
                                XmNnumColumns, 2,
                                NULL, 0);

  single =
    XtVaCreateManagedWidget ("single", xmToggleButtonGadgetClass, radio_box,
			     NULL);

  dwd->all = all =
    XtVaCreateManagedWidget ("all", xmToggleButtonGadgetClass, radio_box,
                             NULL);
  XmToggleButtonGadgetSetState (all, app_resources.how_to_display, False);
  XmToggleButtonGadgetSetState (single, !app_resources.how_to_display, False);

  XtManageChild (radio_box);

  XtVaCreateManagedWidget ("database", xmLabelGadgetClass, rowcol,
                           XmNalignment, XmALIGNMENT_END,
			   NULL);

  radio_box = XtVaCreateWidget ("radiobox", xmRowColumnWidgetClass, rowcol,
                                XmNisHomogeneous, True,
                                XmNentryClass, xmToggleButtonGadgetClass,
                                XmNradioBehavior, True,
                                XmNpacking, XmPACK_COLUMN,
                                XmNnumColumns, 2,
                                NULL, 0);

  pir =
      XtVaCreateManagedWidget ("pir", xmToggleButtonGadgetClass, radio_box,
			       NULL);

  dwd->pir_or_pdb = pdb =
    XtVaCreateManagedWidget ("pdb", xmToggleButtonGadgetClass, radio_box,
                             NULL);
  XmToggleButtonGadgetSetState (pir,
				app_resources.database == PIR_database,
				False);
  XmToggleButtonGadgetSetState (pdb,
				app_resources.database == PDB_database,
				False);

  XtManageChild (radio_box);

  quit = XtVaCreateManagedWidget ("ok", xmPushButtonWidgetClass, rowcol,
                                  XmNalignment, XmALIGNMENT_CENTER,
				  NULL);
  XtAddCallback (quit, XmNactivateCallback, DefineQuit, dwd);

  XtManageChild (rowcol);
  XtRealizeWidget (define);

  return dwd;
}
