/*
	(C)1994 Institute for New Generation Computer Technology
	$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
	(Read COPYRIGHT for detailed information.)
*/
#include "stdio.h"
#include "string.h"
#include "gmp.h"
#include "gmp-impl.h"
#include "longlong.h"
#include "cespFLI.h"

/* initial  */ 
struct MP_CMP{
  struct GMP_VAR *r;
  struct GMP_VAR *i;
};

struct GMP_VAR{
  int   tag;
  char *var;
};

int GMP_LONG_init_flag = 0;
char zero[2] = "0";
char one[2] = "1";
MP_INT mp_int_one;
MP_INT mp_int_max;
MP_RAT mp_rat_zero;
MP_RAT mp_rat_one;


/* commom function */

void check_init()
{
  if(GMP_LONG_init_flag==0){
    mpz_init_set_str(&mp_int_one,"1",10);
    mpz_init_set_si(&mp_int_max,10000);
    mpq_init(&mp_rat_zero);
    mpq_init(&mp_rat_one);
    mpq_set_num(&mp_rat_one,&mp_int_one);
    GMP_LONG_init_flag=1;
  }
}

int maxtype(a,b)
     int a,b;
{
  int q;
  
  if(a>=b)    q=a;
  else        q=b;
  
  return q;
}

int get_str2(var,n1,d1,n2,d2)
     struct GMP_VAR *var;
     char *n1[],*d1[],*n2[],*d2[];
{
  char *s1,*s2,**dummy1,**dummy2;
  MP_INT rn,rd,*in;
  struct MP_CMP *c;
  struct GMP_VAR *r,*i;
  MP_RAT *rat;
  int ret;

  switch (var->tag){
  case 3:
    c = (struct MP_CMP*)var->var;
    r = c->r;
    i = c->i;
    dummy1 = alloca(sizeof(char*));
    if(dummy1 == NULL) return NULL; 
    dummy2 = alloca(sizeof(char*));
    if(dummy2 == NULL) return NULL;  
    ret = get_str2(r,n1,d1,dummy1,dummy2);
    if(ret == NULL) return NULL; 
    ret = get_str2(i,n2,d2,dummy1,dummy2);
    if(ret == NULL) return NULL;  
    break;
  case 2:
    mpz_init(&rn);
    mpz_init(&rd);
    rat = (MP_RAT*)var->var;
    mpq_get_num(&rn,rat);
    mpq_get_den(&rd,rat);
    s1 = mpz_get_str(NULL,10,&rn);
    if(s1 == NULL) return NULL; 
    s2 = mpz_get_str(NULL,10,&rd);
    if(s2 == NULL) return NULL; 
    *n1 = s1;
    *d1 = s2;
    *n2 = zero;
    *d2 = one;
    break;
  case 1:
    in = (MP_INT*)var->var;
    s1 = mpz_get_str(NULL,10,in);
    if(s1 == NULL) return NULL;  
    *n1 = s1;
    *d1 = one;
    *n2 = zero;
    *d2 = one;
  }
  return 1;
}

void  get_si2(var,n1,d1,n2,d2)
     struct GMP_VAR *var;
     int *n1,*n2,*d1,*d2;
{
  int dummy1,dummy2;
  struct GMP_VAR *r,*i;
  struct MP_CMP *c;
  MP_INT rn,rd,*in;
  MP_RAT *rat;

  switch (var->tag){
  case 3:
    c = (struct MP_CMP*)var->var;
    r = c->r;
    i = c->i;
    get_si2(r,n1,d1,&dummy1,&dummy2);
    get_si2(i,n2,d2,&dummy1,&dummy2);
    break;
  case 2:
    mpz_init(&rn);
    mpz_init(&rd);
    rat = (MP_RAT*)var->var;
    mpq_get_num(&rn,rat);
    mpq_get_den(&rd,rat);
    *n1 = mpz_get_si(&rn);
    *d1 = mpz_get_si(&rd);
    *n2 = 0;
    *d2 = 1;
    mpz_clear(&rn);
    mpz_clear(&rd);
    break;
  case 1:
    in = (MP_INT*)var->var;
    *n1 = mpz_get_si(in);
    *d1 = 1;
    *n2 = 0;
    *d2 = 1;
  }
}

struct GMP_VAR *get_imag(v)
     struct GMP_VAR *v;
{
  struct MP_CMP *c;
  struct GMP_VAR *gzero,*q;
  MP_INT *izero;
  
  if(v->tag<3){
    izero = (MP_INT*)malloc(sizeof(MP_INT));
    if(izero==NULL) return NULL;  
    mpz_init(izero);
    gzero = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(gzero==NULL) return NULL;  
    gzero->tag=1;
    gzero->var = (char*)izero;
    q = gzero;
  }else{
    c = (struct MP_CMP*)v->var;
    q = c->i;
  }
  return q;
}

struct GMP_VAR* reduce_cmp(v)
     struct GMP_VAR *v;
{
  struct GMP_VAR *ret;
  struct MP_CMP *c;
  struct GMP_VAR *r,*i;

  check_init();

  ret = v;
  if((v->tag)==3){
    c = (struct MP_CMP*)v->var;
    r = c->r;
    i = c->i;
    switch(i->tag){
    case 2:
      if( mpq_cmp((MP_RAT*)i->var,mp_rat_zero)==0) ret = r;
      break;
    case 1:
      if( mpz_cmp_si((MP_INT*)i->var,(long)1)==0) ret = r;
    }
  }
  return ret;
}


struct GMP_VAR *make_real(v)
     struct GMP_VAR *v;
{
  struct GMP_VAR *gv,*q;
  MP_RAT *real;
  int tag;
  
  tag = v->tag;

  if(tag==2) q = v;
  else{
    real= (MP_RAT*)malloc(sizeof(MP_RAT));
    if(real == NULL) return NULL;  
    gv  = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(gv == NULL) return NULL;  
    mpq_init(real);
    mpq_set_num(real,(MP_INT*)v->var);
    gv->tag = 2;
    gv->var = (char*)real;
    q = gv;
  }
  return q;
}

struct GMP_VAR* int_to_rat(i)
int i;
{
  struct GMP_VAR *g;  
  MP_RAT *r;
  MP_INT n;

  g = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(g == NULL) return NULL;
  r = (MP_RAT*)malloc(sizeof(MP_RAT));
  if(r == NULL) return NULL;

  mpz_init_set_si(&n,i);

  mpq_init(r);
  mpq_set_num(r,n);
  g->tag = 2;
  g->var = (char*)r;
  return g;
}




struct GMP_VAR *pow2(a,b)
     struct GMP_VAR *a;
     long b;
{
  int m,at,bt;
  struct GMP_VAR *q;
  MP_INT n,d,rn,rd;
  struct MP_CMP *cq;
  MP_RAT *r;
  
  q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(q == NULL)  return NULL;
  switch (a->tag){
  case 3:
    q = NULL;
    break;
  case 2:
    q->tag = 2;
    q->var=malloc(sizeof(MP_RAT));
    if(q->var == NULL)  return NULL;
    mpq_init((MP_RAT*)q->var);
    mpz_init(&n);
    mpz_init(&d);
    mpz_init(&rn);
    mpz_init(&rd);
    mpq_get_num(&n,(MP_RAT*)a->var);
    mpq_get_den(&d,(MP_RAT*)a->var);
    mpz_pow_ui(&rn,&n,b);
    mpz_pow_ui(&rd,&d,b);
    mpq_get_num((MP_RAT*)q->var,&rn);
    mpq_get_den((MP_RAT*)q->var,&rd);
    mpz_clear(&n);
    mpz_clear(&d);
    mpz_clear(&rn);
    mpz_clear(&rd);
    break;
  case 1:
    q->tag = 1;
    q->var=malloc(sizeof(MP_INT));
    if(q->var == NULL)  return NULL;
    mpq_init((MP_INT*)q->var);
    mpz_pow_ui((MP_INT*)q->var,(MP_INT*)a->var,b);
  }
  return q;
}


int comp(a,b)
     FRGN *a,*b;
{
  FRGN space;
  struct GMP_VAR *ga,*gb, *ra,*rb;
  int ret;

  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;

  ra = make_real(ga);
  rb = make_real(gb);
  return  mpq_cmp(ra->var,rb->var);

}


int sign2(a)
struct GMP_VAR a;
{
  struct GMP_VAR  *ra;

  check_init();

  ra = make_real(a);
  return  mpq_cmp(ra->var,&mp_rat_zero);
}


struct GMP_VAR *minus2(v)
     struct GMP_VAR *v;
{
  struct MP_CMP *c,*r;
  struct GMP_VAR *q;
  MP_RAT *rr;
  MP_INT *ri;
  MP_INT n,d,qn,qd,g;

  q = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(q == NULL)  return NULL;
  switch(v->tag){
  case 3:
    r = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(r == NULL)  return NULL;
    c = (struct MP_CMP*)v->var;
    r->r = minus2(c->r);
    r->i = minus2(c->i);
    q->tag = 3;    
    q->var = (char*)r;    
    break;
  case 2:
    rr = (MP_RAT*)malloc(sizeof(MP_RAT));
    if(rr == NULL)  return NULL;
    mpq_init(rr);
    mpq_neg(rr,v->var);
    q->tag = 2;
    q->var = (char *)rr;
    break;
  case 1:
    ri = (MP_INT*)malloc(sizeof(MP_INT));
    if(ri == NULL)  return NULL;
    mpz_init(ri);
    mpz_neg(ri,v->var);
    q->tag = 1;
    q->var = (char *)ri;
  }
  return q;
}

struct GMP_VAR *standard(v)
     struct GMP_VAR *v;
{
  struct MP_CMP *c,*r;
  struct GMP_VAR *q;
  MP_RAT *rr;
  MP_INT n,d,qn,qd,g;
  
    q = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(q == NULL)  return NULL;
  switch(v->tag){
  case 3:
    r = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(r == NULL)  return NULL;
    c = (struct MP_CMP*)v->var;
    r->r = standard(c->r);
    r->i = standard(c->i);
    q->tag = 3;    
    q->var = (char*)r;    
    break;
  case 2:
    rr = (MP_RAT*)malloc(sizeof(MP_RAT));
    if(rr == NULL) return NULL;
    mpz_init(&g);
    mpz_init(&n);
    mpz_init(&d);
    mpz_init(&qn);
    mpz_init(&qd);
    mpq_init(rr);
    mpq_get_num(&n,v->var);
    mpq_get_den(&d,v->var);
    mpz_gcd(&g,n,d);
    mpz_div(&qn,&n,&g);
    mpz_div(&qd,&d,&g);
    mpq_set_num(rr,&qn);
    mpq_set_den(rr,&qd);
    q->tag = 2;
    q->var = (char *)rr;
    mpz_clear(&g);
    mpz_clear(&n);
    mpz_clear(&d);
    mpz_clear(&qn);
    mpz_clear(&qd);
    break;
  case 1:
    q = v;
  }
  return q;
}

struct GMP_VAR *get_real(v)
     struct GMP_VAR *v;
{
  struct MP_CMP *c;
  struct GMP_VAR* q;
  
  if(v->tag<3) q = v;
  else{
    c = (struct MP_CMP*)v->var;
    q = c->r;
  }
  return q;
}

LOGICAL get_str(var,n1,d1,n2,d2)
     FRGN *var;
     TERM n1,d1,n2,d2;
{
  struct GMP_VAR *gvar;
  char  **sn1,**sd1,**sn2,**sd2;
  TERM tn1,td1,tn2,td2;
  LOGICAL sts;
  int ists;

  sn1 = malloc(sizeof(char*));
  if(sn1 == NULL) CESPFLIexception;  
  sd1 = malloc(sizeof(char*));
  if(sd1==NULL) CESPFLIexception;  
  sn2 = malloc(sizeof(char*));
  if(sn2==NULL) CESPFLIexception;  
  sd2 = malloc(sizeof(char*));
  if(sd2==NULL) CESPFLIexception;  

  gvar = (struct GMP_VAR*)*var;
  ists = get_str2(gvar,sn1,sd1,sn2,sd2);
  if(ists==NULL)  CESPFLIexception;  

  sts=cespFLInewImpureString(strlen(*sn1),STR_TYPE_8,&tn1);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  
  sts=cespFLInewImpureString(strlen(*sd1),STR_TYPE_8,&td1);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  
  sts=cespFLInewImpureString(strlen(*sn2),STR_TYPE_8,&tn2);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  
  sts=cespFLInewImpureString(strlen(*sd2),STR_TYPE_8,&td2);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  

  sts=cespFLIsetImpureString(tn1,strlen(*sn1),STR_TYPE_8,*sn1);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  
  sts=cespFLIsetImpureString(td1,strlen(*sd1),STR_TYPE_8,*sd1);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  
  sts=cespFLIsetImpureString(tn2,strlen(*sn2),STR_TYPE_8,*sn2);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  
  sts=cespFLIsetImpureString(td2,strlen(*sd2),STR_TYPE_8,*sd2);
  if(!CESPFLIisSuccess(sts)) CESPFLIexception;  

  sts=cespFLIunify(tn1,n1);
  if(CESPFLIisFail(sts)) CESPFLIfail;  
  sts=cespFLIunify(td1,d1);
  if(CESPFLIisFail(sts)) CESPFLIfail;  
  sts=cespFLIunify(tn2,n2);
  if(CESPFLIisFail(sts)) CESPFLIfail;  
  sts=cespFLIunify(td2,d2);
  if(CESPFLIisFail(sts)) CESPFLIfail;  

  CESPFLIsuccess;
}

LOGICAL get_si(var,n1,d1,n2,d2)
     FRGN *var;
     int *n1,*d1,*n2,*d2;
{
  struct GMP_VAR *gvar;

  gvar = (struct GMP_VAR*)*var;
  get_si2(gvar,n1,d1,n2,d2);

  CESPFLIsuccess;
}


LOGICAL neg_var(a,q,iq)
     FRGN *a,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gq = minus2(ga);
  *iq = if_int(gq);
  if(*iq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

struct GMP_VAR *abs_var2(a)
     struct GMP_VAR *a;
{
  struct GMP_VAR *gq;

  if(sign2(a)<0){
    gq = minus2(a);
    if(gq == NULL) return NULL;
  }
  else
    gq = a;
  
  return gq;
}

LOGICAL abs_var(a,q,iq)
     FRGN *a,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gq = abs_var2(ga);
  if(gq == NULL) CESPFLIexception;  
  *iq = if_int(gq);
  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  
  *space = (UNIT)gq;
  *q = space;
  CESPFLIsuccess;
}

LOGICAL pow(a,b,q,iq)
     FRGN *a,*q;
     long b;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gq = pow2(ga,b);
  if(gq == NULL) CESPFLIexception;  
  *iq = if_int(gq);


  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

LOGICAL ripow(a,b,q,iq)
     FRGN *q;
     long b;
     int a,*iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = int_to_rat(a);
  gq = pow2(ga,b);
  if(gq == NULL) CESPFLIexception;  
  *iq = if_int(gq);


  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

int if_int(a)
     struct GMP_VAR *a;
{
  struct GMP_VAR g;
  MP_INT *i,n,d;
  MP_RAT *q;
  int ret,sts,s;

  check_init();
  switch (a->tag){
  case 3:
    ret = 99999;
    break;
  case 2:
    mpz_init(&n);
    mpz_init(&d);
    q = (MP_RAT*)a->var;
    s = mpq_cmp(q,&mp_rat_zero);
    mpq_get_num(&n,q);
    mpq_get_den(&d,q);
    sts = mpz_cmp(&d,&mp_int_one);
    if(sts != 0){
      ret = 99999;
      break;
    }
    g.tag = 1;
    g.var = (char*)&n;
    ret= if_int(g);
    mpz_clear(&d);
    mpz_clear(&n);
    break;
  case 1:
    mpz_init(&n);    
    mpz_abs(&n,a->var);
    sts = mpz_cmp(&n,&mp_int_max);
    if(0 >= sts ){
      ret = mpz_get_si(a->var);
    }
    else 
      ret = 99999;
    mpz_clear(&n);
  }
  return ret;
}

/* function for rational */

struct GMP_VAR *st_to_rat(n,d)
     char *n,*d;
{
  struct GMP_VAR *g;
  MP_INT vn,vd,*i_var;
  MP_RAT *g_var;
  
  g = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(g == NULL) return NULL;  
  g->tag = 2;
  g_var = (MP_RAT*)malloc(sizeof(MP_RAT));
  if(g_var == NULL) return NULL;  
  mpz_init_set_str(&vn,n,10);
  mpz_init_set_str(&vd,d,10);

  mpq_init(g_var);
  mpq_set_num(g_var,&vn);
  mpq_set_den(g_var,&vd);
  g->var = (char*)g_var;
  mpz_clear(&vn);
  mpz_clear(&vd);
  return(standard(g));
}




int sign(a)
     FRGN *a;
{
  FRGN space;
  struct GMP_VAR *ga, *ra;
  int ret;
  ga = (struct GMP_VAR*)*a;

  return sign2(ga);

}

struct GMP_VAR *radd2(a,b)
     struct GMP_VAR *a,*b;
{
  int m,at,bt;
  struct MP_CMP *cq;
  struct GMP_VAR *ra,*ia,*rb,*ib,*rq,*iq,*q,*red;
  
  m=maxtype(a->tag,b->tag);
  switch (m){
  case 3:
    ra=get_real(a);
    if(ra == NULL) return NULL;
    ia=get_imag(a);
    if(ia == NULL) return NULL;
    rb=get_real(b);
    if(rb == NULL) return NULL;
    ib=get_imag(b);
    if(ib == NULL) return NULL;
    rq=radd2(ra,rb);
    if(rq == NULL) return NULL;
    iq=radd2(ia,ib);
    if(iq == NULL) return NULL;
    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    q->tag = 3;
    cq=(struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(cq == NULL) return NULL;  
    cq->r =rq;
    cq->i =iq;   
    q->var = (char*)cq;
    q = reduce_cmp(q);
    break;
  case 2:
  case 1:
    ra = make_real(a);
    if(ra == NULL) return NULL;
    rb = make_real(b);
    if(rb == NULL) return NULL;
    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    q->tag = 2;
    q->var=malloc(sizeof(MP_RAT));
    if(q->var == NULL) return NULL;  
    mpq_init((MP_RAT*)q->var);
    mpq_add((MP_RAT*)q->var,(MP_RAT*)ra->var,(MP_RAT*)rb->var);
    break;
  }
  return q;
}

struct GMP_VAR *rsub2(a,b)
     struct GMP_VAR *a,*b;
{
  int m,at,bt;
  struct MP_CMP *cq;
  struct GMP_VAR *ra,*ia,*rb,*ib,*rq,*iq,*q,*red;
  
  m=maxtype(a->tag,b->tag);
  switch (m){
  case 3:
    ra=get_real(a);
    if(ra == NULL) return NULL;
    ia=get_imag(a);
    if(ia == NULL) return NULL;
    rb=get_real(b);
    if(rb == NULL) return NULL;
    ib=get_imag(b);
    if(ib == NULL) return NULL;
    rq=rsub2(ra,rb);
    if(rq == NULL) return NULL;
    iq=rsub2(ia,ib);
    if(iq == NULL) return NULL;
    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL; 
    q->tag = 3;
    cq=(struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(cq == NULL) return NULL;  
    cq->r =rq;
    cq->i =iq;   
    q->var = (char*)cq;
    q = reduce_cmp(q);
    break;
  case 2:
  case 1:
    ra = make_real(a);
    if(ra == NULL) return NULL;
    rb = make_real(b);
    if(rb == NULL) return NULL;
    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    q->tag = 2;
    q->var=malloc(sizeof(MP_RAT));
    if(q->var == NULL) return NULL;  
    mpq_init((MP_RAT*)q->var);
    mpq_sub((MP_RAT*)q->var,(MP_RAT*)ra->var,(MP_RAT*)rb->var);
    break;
  }
  return q;
}

struct GMP_VAR *rmul2(a,b)
     struct GMP_VAR *a,*b;
{
  int m,at,bt;
  struct MP_CMP *cq;
  struct GMP_VAR *ra,*ia,*rb,*ib,*rq,*iq,*r,*q,*red;
  
  m=maxtype(a->tag,b->tag);
  switch (m){
  case 3:
    ra=get_real(a);
    if(ra == NULL) return NULL;
    ia=get_imag(a);
    if(ia == NULL) return NULL;
    rb=get_real(b);
    if(rb == NULL) return NULL;
    ib=get_imag(b);
    if(ib == NULL) return NULL;
    rq=rmul2(ra,rb);
    if(rq == NULL) return NULL;
    iq=rmul2(ia,ib);
    if(iq == NULL) return NULL;

    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    q->tag = 3;
    cq=(struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(cq == NULL) return NULL;  
    cq->r = rsub2(rq,iq);
    if(cq->r == NULL) return NULL;
    rq=rmul2(ra,ib);
    if(rq == NULL) return NULL;
    iq=rmul2(ia,rb);
    if(iq == NULL) return NULL;
    cq->i = radd2(rq,iq);
    if(cq->i == NULL) return NULL;
    q->var = (char*)cq;
    r = reduce_cmp(q);
    break;
  case 2:
  case 1:
    ra = make_real(a);
    if(ra == NULL) return NULL;
    rb = make_real(b);
    if(rb == NULL) return NULL;

    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    q->tag = 2;
    q->var=malloc(sizeof(MP_RAT));
    if(q->var == NULL) return NULL;  
    mpq_init((MP_RAT*)q->var);
    mpq_mul((MP_RAT*)q->var,(MP_RAT*)ra->var,(MP_RAT*)rb->var);
    r = standard(q);
    break;
  }
  return r;
}

struct GMP_VAR *rdiv2(a,b)
     struct GMP_VAR *a,*b;
{
  int m,at,bt,s;
  struct MP_CMP *cq;
  struct GMP_VAR *ra,*ia,*rb,*ib,*rq,*iq,*q,*red,*den;

  check_init();
  m=maxtype(a->tag,b->tag);
  switch (m){
  case 3:
    ra=get_real(a);
    if(ra == NULL) return NULL;
    ia=get_imag(a);
    if(ia == NULL) return NULL;
    rb=get_real(b);
    if(rb == NULL) return NULL;
    ib=get_imag(b);
    if(ib == NULL) return NULL;

    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    cq=(struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(cq == NULL) return NULL;  

    den = radd2(rmul2(rb,rb),rmul2(ib,ib));
    if(den == NULL) return NULL;

    rq=rmul2(ra,rb);
    if(rq == NULL) return NULL;
    iq=rmul2(ia,ib);
    if(iq == NULL) return NULL;
    cq->r = rdiv2(radd2(rq,iq),den);
    if(cq->r == NULL) return NULL;

    rq=rmul2(ra,ib);
    if(rq == NULL) return NULL;
    iq=rmul2(ia,rb);
    if(iq == NULL) return NULL;
    cq->i = rdiv2(radd2(iq,rq),den);

    q->tag = 3;
    q->var = (char*)cq;

    q = reduce_cmp(q);
    break;
  case 2:
  case 1:
    ra = make_real(a);
    rb = make_real(b);
    q=(struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(q == NULL) return NULL;  
    q->tag = 2;
    q->var=malloc(sizeof(MP_RAT));
    if(q->var == NULL) return NULL; 
    mpq_init((MP_RAT*)q->var);
    mpq_div((MP_RAT*)q->var,(MP_RAT*)ra->var,(MP_RAT*)rb->var);
    s = mpq_cmp((MP_RAT*)q->var,&mp_rat_zero);
    break;
  }
  return q;
}


struct GMP_VAR *rgcd2(a,b)
     struct GMP_VAR *a,*b;
{
  int m,at,bt;
  struct MP_CMP *cq;
  struct GMP_VAR *rq,*iq,*q,*red,*den;
  MP_RAT *ra,*rb,r;
  MP_INT an,ad,bn,bd,t1,t2,t3;

  q = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR)); 
  if(q == NULL) return NULL;
  q->var=malloc(sizeof(MP_RAT));
  if(q->var == NULL) return NULL;  
  mpq_init((MP_RAT*)q->var);
  
  check_init();
  
  switch (maxtype(a->tag,b->tag)){
  case 3:
    mpq_set(q->var,&mp_rat_one);
    break;
  case 2:
  case 1:
    mpz_init(&an);
    mpz_init(&ad);
    mpz_init(&bn);
    mpz_init(&bd);
    mpz_init(&t1);
    mpz_init(&t2);
    mpz_init(&t3);
    mpq_init(&r);
    ra = (MP_RAT*)(make_real(a))->var;
    rb = (MP_RAT*)(make_real(b))->var;
    mpq_get_num(&an,ra);
    mpq_get_den(&ad,ra);
    mpq_get_num(&bn,rb);
    mpq_get_den(&bd,rb);
    mpz_gcd(&t1,&ad,&bd);
    mpz_div(&t2,&ad,&t1);
    mpz_div(&t3,&bd,&t1);
    mpz_mul(&t1,&an,&t3);
    mpz_mul(&t3,&bn,&t2);
    mpz_gcd(&an,&t1,&t3);
    mpz_mul(&ad,&bd,&t2);
    mpq_set_num(&r,&an);
    mpq_set_den(&r,&ad);
    mpq_add(q->var,&mp_rat_zero,&r);
    break;
  }
  q->tag = 2;
  return standard(q);
}

LOGICAL gcd_ext(a,b,g,qa,qb,ig,ia,ib)
FRGN *a,*b,*g,*qa,*qb;
int *ig,*ia,*ib;
{
  FRGN spg,spa,spb;
  struct GMP_VAR *ga,*gb,*gg,*gqa,*gqb;

  gqa = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(gqa == NULL) CESPFLIexception;
  gqb = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(gqb == NULL) CESPFLIexception;

  ga = (struct GMP_VAR*)*a;
  if(ga == NULL)  CESPFLIexception;
  gb = (struct GMP_VAR*)*b;
  if(gb == NULL)  CESPFLIexception;

  gg = rgcd2(ga,gb);
  if(gg == NULL)  CESPFLIexception;

  gqa = rdiv2(ga,gg);  
  if(gqa == NULL) CESPFLIexception;
  gqb = rdiv2(gb,gg);
  if(gqb == NULL) CESPFLIexception;

  *ig = if_int(g);
  *ia = if_int(qa);
  *ib = if_int(qb);

  cespFLInew(sizeof(struct GMP_VAR),&spg);
  cespFLInew(sizeof(struct GMP_VAR),&spa);
  cespFLInew(sizeof(struct GMP_VAR),&spb);

  *spg = (UNIT)gg;
  *g  = spg;
  *spa = (UNIT)gqa;
  *qa = spa;
  *spb = (UNIT)gqb;
  *qb = spb;

  CESPFLIsuccess;
}

LOGICAL rigcd_ext(a,b,g,qa,qb,ig,ia,ib)
FRGN *g,*qa,*qb;
int a,b,*ig,*ia,*ib;
{
  FRGN spg,spa,spb;
  struct GMP_VAR *ga,*gb,*gg,*gqa,*gqb;

  gqa = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(gqa == NULL) CESPFLIexception;
  gqb = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(gqb == NULL) CESPFLIexception;

  ga = int_to_rat(a);
  if(ga == NULL) return NULL;
  gb = int_to_rat(b);
  if(gb == NULL) return NULL;
  gg = rgcd2(ga,gb);
  if(gg == NULL) return NULL;

  gqa = rdiv2(ga,gg);  
  if(gqa == NULL) return NULL;
  gqb = rdiv2(gb,gg);
  if(gqb == NULL) return NULL;

  *ig = if_int(g);
  *ia = if_int(qa);
  *ib = if_int(qb);

  cespFLInew(sizeof(struct GMP_VAR),&spg);
  cespFLInew(sizeof(struct GMP_VAR),&spa);
  cespFLInew(sizeof(struct GMP_VAR),&spb);

  *spg = (UNIT)gg;
  *g  = spg;
  *spa = (UNIT)gqa;
  *qa = spa;
  *spb = (UNIT)gqb;
  *qb = spb;

  CESPFLIsuccess;
}


LOGICAL make_rat_var(n1,d1,n2,d2,q,iq)
     char *n1,*d1,*n2,*d2;
     FRGN *q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *v,*r,*i;
  struct MP_CMP *c;
  LOGICAL sts;

  sts = cespFLInew(sizeof(struct GMP_VAR),&space);
  if(CESPFLIisException(sts)) CESPFLIexception;  
  
  r = st_to_rat(n1,d1);
  if(r==NULL) CESPFLIexception;  

  if (strcmp(n2,"0")==0 ||strcmp(n2,"")==0){
    v = r;
  }else{
    i = st_to_rat(n2,d2);
    if(i==NULL) CESPFLIexception;  
    v = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(v == NULL) 
    v->tag = 3;
    c = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(c == NULL) CESPFLIexception;  
    c->r = r;
    c->i = i;
    v->var = (char*)c;
  }
  *iq = if_int(v);
  *space = (UNIT)v;
  *q = space;
  CESPFLIsuccess;
}


LOGICAL radd(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  gq = radd2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *space = (UNIT)gq;
  *iq = if_int(gq);
  *q = space;

  CESPFLIsuccess;
}

LOGICAL rsub(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  gq = rsub2(ga,gb);
  if(gq == NULL) CESPFLIexception; 

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *space = (UNIT)gq;
  *iq = if_int(gq);
  *q = space;

  CESPFLIsuccess;
}

LOGICAL rmul(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  gq = rmul2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *iq = if_int(gq);
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

LOGICAL rimul(a,b,q,iq)
     FRGN *q;
     int a,b,*iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = int_to_rat(a);
  if(ga == NULL) return NULL;
  gb = int_to_rat(b);
  if(gb == NULL) return NULL;
  gq = rmul2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *iq = if_int(gq);
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

LOGICAL rdiv(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  gq = rdiv2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *iq = if_int(gq);
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

LOGICAL ridiv(a,b,q,iq)
     FRGN *q;
     int a,b,*iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;

  ga = int_to_rat(a);
  if(ga == NULL) CESPFLIexception;
  gb = int_to_rat(b);
  if(gb == NULL) CESPFLIexception;

  gq = rdiv2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *iq = if_int(gq);
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}


LOGICAL rgcd(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  gq = rgcd2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *iq = if_int(gq);
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}

LOGICAL rigcd(a,b,q,iq)
     FRGN *q;
     int a,b,*iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = int_to_rat(a);
  if(ga == NULL) CESPFLIexception;
  gb = int_to_rat(b);
  if(gb == NULL) CESPFLIexception;
  gq = rgcd2(ga,gb);
  if(gq == NULL) CESPFLIexception;  

  sts=cespFLInew(sizeof(struct GMP_VAR),&space);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *iq = if_int(gq);
  *space = (UNIT)gq;
  *q = space;

  CESPFLIsuccess;
}
LOGICAL rdivo(a,b,q,r,iq,ir)
     FRGN *a,*b,*q,*r;
     int *iq,*ir;
{
  FRGN spq,spr;
  struct GMP_VAR *ga,*gb,gq,gr;
  MP_INT an,ad,bn,bd,t1,t2,t3;
  MP_RAT qq,qr;
  LOGICAL sts;
  
  check_init();

  ga = make_real((struct GMP_VAR*)*a);
  if(ga == NULL) CESPFLIexception;
  gb = make_real((struct GMP_VAR*)*b);
  if(gb == NULL) CESPFLIexception;
  mpz_init(&an);
  mpz_init(&ad);
  mpz_init(&bn);
  mpz_init(&bd);
  mpz_init(&t1);
  mpz_init(&t2);
  mpz_init(&t3);
  mpq_init(&qq);
  mpq_init(&qr);
  mpq_get_num(&an,ga->var);
  mpq_get_den(&ad,ga->var);
  mpq_get_num(&bn,gb->var);
  mpq_get_den(&bd,gb->var);
  mpz_mul(&t1,&an,&bd);
  mpz_mul(&t2,&ad,&bn);
  mpz_divmod(&an,&t3,&t1,&t2);
  mpz_mul(&bn,&ad,&bd);
  mpq_set_num(&qq,&an);
  mpq_set_den(&qq,&mp_rat_one);
  mpq_set_num(&qr,&t3);
  mpq_set_den(&qr,&bn);
  gq.tag = 2;
  gq.var = (char*)&qq;
  gr.tag = 2;
  gr.var = (char*)&qr;

  sts=cespFLInew(sizeof(struct GMP_VAR),&spq);  
  if(CESPFLIisException(sts)) CESPFLIexception;  
  sts=cespFLInew(sizeof(struct GMP_VAR),&spr);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  ga =standard(&gq);
  *spq = (UNIT)ga;
  *iq = if_int(ga);
  *q = spq;
  gb = standard(&gr);
  *spr = (UNIT)gb;
  *ir = if_int(gb);
  *r = spr;

  mpz_clear(&an);
  mpz_clear(&ad);
  mpz_clear(&bn);
  mpz_clear(&bd);
  mpz_clear(&t1);
  mpz_clear(&t2);
  mpz_clear(&t3);
  mpq_clear(&qq);
  mpq_clear(&qr);

  CESPFLIsuccess;
}
LOGICAL ridivo(a,b,q,r,iq,ir)
     FRGN *q,*r;
     int a,b,*iq,*ir;
{
  FRGN spq,spr;
  struct GMP_VAR *ga,*gb,gq,gr;
  MP_INT an,ad,bn,bd,t1,t2,t3;
  MP_RAT qq,qr;
  LOGICAL sts;
  
  check_init();

  
  ga = int_to_rat(a);
  gb = int_to_rat(b);

  mpz_init(&an);
  mpz_init(&bn);
  mpq_init(&qq);
  mpq_init(&qr);
  mpq_get_num(&an,ga->var);
  mpq_get_num(&bn,gb->var);
  mpz_mul(&t1,&an,&bd);
  mpz_mul(&t2,&ad,&bn);

  mpz_divmod(&qq,&qr,&an,&bn);

  gq.tag = 2;
  gq.var = (char*)make_real(&qq);
  if(gq.var == NULL) CESPFLIexception;  
  gr.tag = 2;
  gr.var = (char*)make_real(&qr);
  if(gr.var == NULL) CESPFLIexception;  
  
  sts=cespFLInew(sizeof(struct GMP_VAR),&spq);  
  if(CESPFLIisException(sts)) CESPFLIexception;  
  sts=cespFLInew(sizeof(struct GMP_VAR),&spr);  
  if(CESPFLIisException(sts)) CESPFLIexception;  

  *spq = (UNIT)standard(&gq);
  *iq = if_int(spq);
  *q = spq;
  *spr = (UNIT)standard(&gr);
  *ir = if_int(spr);
  *r = spr;

  mpz_clear(&an);
  mpz_clear(&bn);
  mpq_clear(&qq);
  mpq_clear(&qr);

  CESPFLIsuccess;
}

/* function for integer */

int chk_int(v)
     struct GMP_VAR *v;
{
  struct GMP_VAR *r,*i;
  struct MP_CMP *c;
  int ret;

  ret = 1;
  switch(v->tag){
 case 3:
    c = (struct MP_CMP*)v->var;
    r = c->r;
    i = c->i;
    if(chk_int(r)) ret = 0;
    if(chk_int(i)) ret = 0;
    break;
  case 2:
    break;
  case 1:
    ret = 0;
  }
  return ret;
}

struct GMP_VAR* iadd2(a,b)
     struct GMP_VAR *a,*b;
{
  MP_INT *ia,*ib,*iq;
  struct MP_CMP *c;
  struct GMP_VAR *ret,*rea,*ima,*reb,*imb;

  switch (maxtype(a->tag,b->tag)){
  case 3:
    rea = get_real(a);
    ima = get_imag(a);
    reb = get_real(b);
    imb = get_imag(b);
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    c = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(c == NULL) return NULL;  
    c->r = iadd2(rea,reb);
    if(c->r == NULL) return NULL;  
    c->i = iadd2(ima,imb);
    if(c->i == NULL) return NULL;
    ret->tag = 3;
    ret->var = (char*)c;
    ret = reduce_cmp(ret);
    break;
  case 1:
    ia = (MP_INT*)a->var;
    ib = (MP_INT*)b->var;
    iq = (MP_INT*)malloc(sizeof(MP_INT));
    if(iq == NULL) return NULL;  
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    mpz_init(iq);
    mpz_add(iq,ia,ib);
    ret->tag = 1;
    ret->var = (char*)iq;
  }
    return ret;
}

struct GMP_VAR* isub2(a,b)
     struct GMP_VAR *a,*b;
{
  MP_INT *ia,*ib,*iq;
  struct MP_CMP *c;
  struct GMP_VAR *ret,*rea,*ima,*reb,*imb;

  switch (maxtype(a->tag,b->tag)){
  case 3:
    rea = get_real(a);
    if(rea == NULL) return NULL;
    ima = get_imag(a);
    if(ima == NULL) return NULL;
    reb = get_real(b);
    if(reb == NULL) return NULL;
    imb = get_imag(b);
    if(imb == NULL) return NULL;
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    c = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(c == NULL) return NULL;  
    c->r = isub2(rea,reb);
    if(c->r == NULL) return NULL;  
    c->i = isub2(ima,imb);
    if(c->i == NULL) return NULL;
    ret->tag = 3;
    ret->var = (char*)c;
    ret = reduce_cmp(ret);
    break;
  case 1:
    ia = (MP_INT*)a->var;
    ib = (MP_INT*)b->var;
    iq = (MP_INT*)malloc(sizeof(MP_INT));
    if(iq == NULL) return NULL;  
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    mpz_init(iq);
    mpz_sub(iq,ia,ib);
    ret->tag = 1;
    ret->var = (char*)iq;
  }
    return ret;
}

struct GMP_VAR* imul2(a,b)
     struct GMP_VAR *a,*b;
{
  MP_INT *ia,*ib,*iq;
  struct MP_CMP *c;
  struct GMP_VAR *ret,*rea,*ima,*reb,*imb,*t1,*t2;

  switch (maxtype(a->tag,b->tag)){
  case 3:
    rea = get_real(a);
    if(rea == NULL) return NULL;
    ima = get_imag(a);
    if(ima == NULL) return NULL;
    reb = get_real(b);
    if(reb == NULL) return NULL;
    imb = get_imag(b);
    if(imb == NULL) return NULL;
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    c = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(c == NULL) return NULL;  
    t1 = imul2(rea,reb);
    if(t1 == NULL) return NULL;  
    t2 = imul2(ima,imb);
    if(t2 == NULL) return NULL;  
    c->r = isub2(t1,t2);
    if(c->r == NULL) return NULL;  
    t1 = imul2(rea,imb);
    if(t1 == NULL) return NULL;  
    t2 = imul2(ima,reb);
    if(t2 == NULL) return NULL;  
    c->i = iadd2(t1,t2);
    if(c->i == NULL) return NULL;  
    ret->tag = 3;
    ret->var = (char*)c;
    ret = reduce_cmp(ret);
    break;
  case 1:
    ia = (MP_INT*)a->var;
    ib = (MP_INT*)b->var;
    iq = (MP_INT*)malloc(sizeof(MP_INT));
    if(iq == NULL) return NULL;  
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    mpz_init(iq);
    mpz_mul(iq,ia,ib);
    ret->tag = 1;
    ret->var = (char*)iq;
  }
    return ret;
}

struct GMP_VAR* idiv2(a,b)
     struct GMP_VAR *a,*b;
{
  MP_INT *ia,*ib,*iq;
  struct MP_CMP *c;
  struct GMP_VAR *ret,*rea,*ima,*reb,*imb,*t1,*t2,*den;

  switch (maxtype(a->tag,b->tag)){
  case 3:
    rea = get_real(a);
    if(rea == NULL) return NULL;
    ima = get_imag(a);
    if(ima == NULL) return NULL;
    reb = get_real(b);
    if(reb == NULL) return NULL;
    imb = get_imag(b);
    if(imb == NULL) return NULL;

    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    c = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(c == NULL) return NULL;  

    den = iadd2(imul2(reb,reb),imul2(imb,imb));

    t1 = imul2(rea,reb);
    if(t1 == NULL) return NULL;  
    t2 = imul2(ima,imb);
    if(t2 == NULL) return NULL;  
    c->r = idiv2(iadd2(t1,t2),den);
    if(c->r == NULL) return NULL; 
    t1 = imul2(rea,imb);
    if(t1 == NULL) return NULL;  
    t2 = imul2(ima,reb);
    if(t2 == NULL) return NULL;  
    c->i = idiv2(isub2(t2,t1),den);
    if(c->i == NULL) return NULL;  
    ret->tag = 3;
    ret->var = (char*)c;
    ret = reduce_cmp(ret);
    break;
  case 1:
    ia = (MP_INT*)a->var;
    ib = (MP_INT*)b->var;
    iq = (MP_INT*)malloc(sizeof(MP_INT));
    if(iq == NULL) return NULL;  
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    mpz_init(iq);
    mpz_div(iq,ia,ib);
    ret->tag = 1;
    ret->var = (char*)iq;
  }
    return ret;
}

struct GMP_VAR* igcd2(a,b)
     struct GMP_VAR *a,*b;
{
  MP_INT *ia,*ib,*iq;
  struct MP_CMP *c;
  struct GMP_VAR *ret,*rea,*ima,*reb,*imb,*t1,*t2,*den;

  switch (maxtype(a->tag,b->tag)){
  case 3:
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    iq = (MP_INT*)malloc(sizeof(MP_INT));
    if(iq == NULL) return NULL;  
    mpz_init_set_str(iq,"1",10);
    break;
  case 1:
    ia = (MP_INT*)a->var;
    ib = (MP_INT*)b->var;
    iq = (MP_INT*)malloc(sizeof(MP_INT));
    if(iq == NULL) return NULL;  
    ret = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(ret == NULL) return NULL;  
    mpz_init(iq);
    mpz_gcd(iq,ia,ib);
  }
    ret->tag = 1;
    ret->var = (char*)iq;
    return ret;
}

LOGICAL make_int_var(sr,si,q,iq)
     char *sr,*si;
     FRGN *q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *v,*r,*i;
  MP_RAT *rr,*ri;
  struct MP_CMP *c;
  LOGICAL sts;
  
  sts = cespFLInew(sizeof(struct GMP_VAR),&space);
  if(CESPFLIisException(sts)) CESPFLIexception; 
  
  rr = (MP_RAT*)malloc(sizeof(MP_RAT));
  if(rr==NULL) CESPFLIexception;  
  r = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
  if(r==NULL) CESPFLIexception;  
  mpz_init_set_str(rr,sr,10);
  r->tag = 1;
  r->var = (char*)rr;

  *iq = if_int(r);
  if (strcmp(si,"0")==0 ||strcmp(si,"")==0){
    v = r;
  }else{
    ri = (MP_RAT*)malloc(sizeof(MP_RAT));
    if(ri==NULL) CESPFLIexception;  
    v = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(v==NULL) CESPFLIexception;  
    c = (struct MP_CMP*)malloc(sizeof(struct MP_CMP));
    if(c==NULL) CESPFLIexception;  
    i = (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if(i==NULL) CESPFLIexception;  
    mpz_init_set_str(ri,si,10);
    i->tag = 1;
    i->var = (char*)ri;
    c->r = r;
    c->i = i;
    v->var = (char*)c;
    v->tag = 3;
  }
  *space = (UNIT)v;
  *q = space;
  CESPFLIsuccess;
}

LOGICAL iadd(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  if (chk_int(ga)+chk_int(gb) == 0) {
    gq = iadd2(ga,gb);
    if(gq == NULL) CESPFLIexception;
    sts = cespFLInew(sizeof(struct GMP_VAR),&space);  
    if(CESPFLIisException(sts)) CESPFLIexception;  

    *iq = if_int(gq);
    *space = (UNIT)gq;
    *q = space;
  }else CESPFLIfail;
  CESPFLIsuccess;
}

LOGICAL isub(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  if (chk_int(ga)+chk_int(gb) == 0) {
    gq = isub2(ga,gb);
    *iq = if_int(gq);
    sts = cespFLInew(sizeof(struct GMP_VAR),&space);  
    if(CESPFLIisException(sts)) CESPFLIexception;  
    *space = (UNIT)gq;
    *q = space;
  }else CESPFLIfail;
  CESPFLIsuccess;
}

LOGICAL imul(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  if (chk_int(ga)+chk_int(gb) == 0) {
    gq = imul2(ga,gb);
    if(gq == NULL) CESPFLIexception;
    *iq = if_int(gq);
    sts = cespFLInew(sizeof(struct GMP_VAR),&space);  
    if(CESPFLIisException(sts)) CESPFLIexception;  
    *space = (UNIT)gq;
    *q = space;
  }else CESPFLIfail;
  CESPFLIsuccess;
}

LOGICAL idiv(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  if (chk_int(ga)+chk_int(gb) == 0) {
    gq = idiv2(ga,gb);
    *iq = if_int(gq);
    sts = cespFLInew(sizeof(struct GMP_VAR),&space);  
    if(CESPFLIisException(sts)) CESPFLIexception;  
    *space = (UNIT)gq;
    *q = space;
  }else CESPFLIfail;
  CESPFLIsuccess;
}

LOGICAL igcd(a,b,q,iq)
     FRGN *a,*b,*q;
     int *iq;
{
  FRGN space;
  struct GMP_VAR *ga,*gb,*gq;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;
  if (chk_int(ga)+chk_int(gb) == 0) {
    gq = igcd2(ga,gb);
    *iq = if_int(gq);
    sts = cespFLInew(sizeof(struct GMP_VAR),&space);  
    if(CESPFLIisException(sts)) CESPFLIexception;  
    *space = (UNIT)gq;
    *q = space;
  }else CESPFLIfail;
  CESPFLIsuccess;
}

LOGICAL igcd_ext(a,b,g,qa,qb,ig,ia,ib)
     FRGN *a,*b,*g,*qa,*qb;
     int *ig,*ia,*ib;
{
  FRGN spg,spa,spb;
  struct GMP_VAR *ga,*gb,*gqg,*gqa,*gqb;
  MP_INT *rqg,*rqa,*rqb;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;

  if (chk_int(ga)+chk_int(gb) == 0) {

    rqg =  (MP_INT*)malloc(sizeof(MP_INT));
    if(rqg == NULL) CESPFLIexception;
    rqa =  (MP_INT*)malloc(sizeof(MP_INT));
    if(rqa == NULL) CESPFLIexception;
    rqb =  (MP_INT*)malloc(sizeof(MP_INT));
    if(rqb == NULL) CESPFLIexception;

    gqg = igcd2(ga,gb);
    if(gqg == NULL) CESPFLIexception;
    gqa = idiv2(ga,gqg);
    if(gqa == NULL) CESPFLIexception;
    gqb = idiv2(gb,gqg);
    if(gqb == NULL) CESPFLIexception;
    *ig = if_int(gqg);
    *ia = if_int(gqa);
    *ib = if_int(gqb);

    sts = cespFLInew(sizeof(struct GMP_VAR),&spg);  
    if(CESPFLIisException(sts)) CESPFLIexception;  
    sts = cespFLInew(sizeof(struct GMP_VAR),&spa);  
    if(CESPFLIisException(sts)) CESPFLIexception; 
    sts = cespFLInew(sizeof(struct GMP_VAR),&spb);  
    if(CESPFLIisException(sts)) CESPFLIexception; 

    *spg = (UNIT)gqg;
    *g = spg;
    *spa = (UNIT)gqa;
    *qa = spa;
    *spb = (UNIT)gqb;
    *qb = spb;

  }else CESPFLIfail;
  CESPFLIsuccess;
}


LOGICAL idivo(a,b,q,r,iq,ir)
     FRGN *a,*b,*q,*r;
     int *iq,*ir;
{
  FRGN spq,spr;
  struct GMP_VAR *ga,*gb,*gqq,*gqr;
  MP_INT *rqq,*rqr;
  LOGICAL sts;
  
  ga = (struct GMP_VAR*)*a;
  gb = (struct GMP_VAR*)*b;

  if (chk_int(ga)+chk_int(gb) == 0) {

    rqq =  (MP_INT*)malloc(sizeof(MP_INT));
    if( rqq == NULL ) CESPFLIexception;
    rqr =  (MP_INT*)malloc(sizeof(MP_INT));
    if( rqr == NULL ) CESPFLIexception;
    gqq =  (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if( gqq == NULL ) CESPFLIexception;
    gqr =  (struct GMP_VAR*)malloc(sizeof(struct GMP_VAR));
    if( gqr == NULL ) CESPFLIexception;
    mpz_init(rqq);
    mpz_init(rqr);

    mpz_divmod(rqq,rqr,ga->var,gb->var);
    gqq->tag = 1;
    gqr->tag = 1;
    gqq->var = (char*)rqq;
    gqr->var = (char*)rqq;

    *iq = if_int(gqq);
    *ir = if_int(gqr);

    sts = cespFLInew(sizeof(struct GMP_VAR),&spq);  
    if(CESPFLIisException(sts)) CESPFLIexception;  
    sts = cespFLInew(sizeof(struct GMP_VAR),&spr);  
    if(CESPFLIisException(sts)) CESPFLIexception;  

    *spq = (UNIT)gqq;
    *q = spq;
    *spr = (UNIT)gqr;
    *r = spr;

  }else CESPFLIfail;
  CESPFLIsuccess;
}
