/*
**			COPYRIGHT (c)  1991 BY
**		AI LANGUAGE RESEARCH INSTITUTE LTD.
**
** THIS SOFTWARE IS  FURNISHED UNDER  LICENSE AND MAY BE USED AND  COPIED
** ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE
** INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE  OR  ANY OTHER
** COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
** OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY
** TRANSFERRED.
**
** THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE
** AND SHOULD  NOT  BE CONSTRUED AS A  COMMITMENT BY AI LANGUAGE RESEARCH
** INSTITUTE LTD.
**/
/*
**++
**  FACILITY:
**	Common ESP
**
**  ABSTRACT:
**
**
**  AUTHORS:
**
**
**  CREATION DATE:    1991-04-01
**
**  MODIFICATION HISTORY:
**
**
**--
**/


/* version.h */
/*****************************************************************************
	CESP_V30 : CESP version 3.0
	CESP_V20 : CESP version 2.0
	CESP_V13 : CESP version 1.3
******************************************************************************/
#define CESP_V30
/* #define CESP_V20 */
/* #define CESP_V13 */

#ifdef CESP_V30
#define CESPversion3
#define CESP_V20
#endif

#ifdef CESP_V20
#ifdef MCG
#undef CESPversion1
#undef CESPemulator
#else
#ifdef TE
#undef CESPversion1
#define CESPemulator
#else
#define CESPversion1
#define CESPemulator
#endif TE
#endif MCG
#endif CESP_V20

#ifdef CESP_V13
#define CESPversion1
#undef CESPemulator
#endif CESP_V13


/* type.h */
typedef unsigned long UNIT;
typedef unsigned short HALF;
typedef unsigned char BYTE;
typedef char SINT;
typedef int BOOL;
typedef int LOGICAL;
typedef UNIT ATOM;
typedef UNIT *TERM;
typedef UNIT *FRGN;

typedef struct fb_cache {
    ATOM name;
    struct foreign_bank_def *bank;
} FLIFBCACHE;

typedef struct fli_class_def {
    ATOM classID;
    ATOM bankName;
} FLICLDEF;

typedef struct foreign_bank_def {
    ATOM name;
    UNIT date;		/* create date (copy from *.esp) */
    UNIT time;		/* create time (copy from *.esp) */
    UNIT natureN;
    struct nature_def *nature;
    struct nature_link_cell *natureLink;
#ifdef CESPversionX
    UNIT selfN;		/* self-order in nature */
#endif CESPversionX
    UNIT typeN;
    struct type_def *type;
    UNIT language;	/* language number(c:1, fortran:2) */
    UNIT linkN;
    ATOM *linkFile;
    UNIT libN;
    ATOM *libFile;
    UNIT makeN;
    ATOM *makeFile;
    UNIT exHeadN;
    struct fli_ex_header_def *exHeader;
    UNIT imHeadN;
    struct fli_im_header_def *imHeader;
} FLIFBDEF;

typedef struct nature_def {
    ATOM name;
    struct foreign_bank_def *bank;
} FLINATUREDEF;

typedef struct nature_link_cell {
    struct nature_link_cell *next;
    struct foreign_bank_def **wordp;
} FLINATURECELL;

typedef struct fli_ex_header_def {
    ATOM name;
    UNIT arity;
    struct header_arg_def *arg;
    struct func_def *func;
    struct foreign_bank_def *bank;
    struct fli_ex_header_frame_cell *frameCell;
} FLIEXHDDEF;

typedef struct fli_im_header_def {
    ATOM name;
    UNIT arity;
    UNIT objType;	/* FLI_CLASS / FLI_INSTANCE */
    struct header_arg_def *arg;
    struct foreign_bank_def *bank;
    struct object_descriptor *objDsc;	/* inactive -> FLI_NULL */
} FLIIMHDDEF;

typedef struct header_arg_def {
    TERM var;	/* CESP-Var-Addr(call-out) / C-Var-Addr(call-in) */
    UNIT mode;
    TERM type;	/* ATOM -> unlinked */
} FLIHDARGDEF;

typedef struct func_def {
    double ( *addr )();
    ATOM name;
    TERM type;	/* FLI_LOGICAL/FLI_VOID/FLI_NONE */
    struct header_arg_def *ret;
    UNIT argN;
    struct header_arg_def **arg;
} FLIFUNCDEF;

typedef struct type_def {
    ATOM name;
    TERM def;	/* ATOM -> unlinked */
    struct type_cell *next;
} FLITYPEDEF;

typedef struct type_cell {
    struct type_cell *next;
    TERM *defp;
} FLITYPECELL;

typedef struct {
    UNIT *var;
    FLIHDARGDEF *arg;
} FLIVARTAB;

typedef struct fli_ex_header_frame {
    ATOM bankName;
    ATOM headName;
    UNIT arity;
    struct fli_ex_header_def *header;
} FLIEXHDFRAME;

typedef struct fli_ex_header_frame_cell {
    struct fli_ex_header_frame_cell *next;
    struct fli_ex_header_frame *frame;
} FLIEXHDFRAMECELL;

typedef struct object_descriptor {
    struct object_descriptor *next;
    struct object_descriptor *prev;
    struct fli_im_header_def *imHeader;
    ATOM classID;
    UNIT objType;			/* FLI_CLASS / FLI_INSTANCE */
    UNIT objOffset;			/* for object */
} *OBJECT, OBJECTA, *INSTANCE;

typedef struct stack_table {
    UNIT mode;
    UNIT type;
    struct header_arg_def *hdArg;
    UNIT *data;
} FLISTCKTAB;


/* def.h */
#ifndef RISC
#ifdef SUN4
#define RISC
#endif SUN4
#ifdef MIPS
#define RISC
#endif MIPS
#ifdef AV
#define RISC
#endif AV
#endif

#define CALLOUT		1
#define CALLIN		2
#define CALLBACK	3

#define FLI_LANG_C	1
#define FLI_LANG_FORT	2
#define MAXFORTNAMLEN	16
#define FLTARGPOSLMT	3

#define MAXCLTAB		100		/* Max. C-Class num. */
#define MAXFBTAB		100		/* Max. FB num. */
#define MAXTPTAB		30		/* Max. TYPE num. */
#define MAXFLIARGN		16		/* Max. FLI argument num. */
#define MAXEXHDFRM		1000		/* Max. FLI header-frame */
#define MAXWORKAREA		64*1024		/* FLI data area 64K words */
#define WORKAREABITS		20		/* Max. FLI work size (bits) */
#define WORKAREAMASK		(((UNIT)0xffffffff)>>(32-WORKAREABITS))
						/* Max. FLI area mask */
#define MAXWORKTABLESIZE	(1<<(32-WORKAREABITS))
						/* FLI work table entrys */
#define MAXFLIWORKU		10240		/* FLI UNIT work area */
#define MAXFLIWORKB		5120		/* FLI BYTE work area */
#define MAXFLISTRLEN		256		/* FLI string size */
#define MAXFNAMLEN		512		/* Max. file-name len. */
#define MAXLINKN		16		/* Max. link-file num. */
#define MAXLIBN			16		/* Max. library-file num. */
#define MAXSTRLEN		2048		/* Max. string len. */
#define MAXWORKEND		0xffffffff
#define MAXARITY		32

#define NATURE_AREA		1
#define TYPE_AREA		2
#define LINK_FILE_AREA		3
#define LIBRARY_FILE_AREA      	4
#define MAKE_FILE_AREA      	5
#define EXHEAD_AREA		6
#define IMHEAD_AREA		7

#define CALL			1
#define REDO			2

#define FLI_FREE		(-1)	/* free mark */
#define FLI_NULL		NULL	/* null mark */

#ifndef STR_TYPE_8
#define STR_TYPE_8		0
#define STR_TYPE_16		1
#endif

#define FLI_NONE		(( 0<<3)|1)
/* basic data type */
#define FLI_INT			(( 1<<3)|1)
#define FLI_ATOM		(( 2<<3)|1)
#define FLI_STRING		(( 3<<3)|1)
#define FLI_FLOAT		(( 4<<3)|1)
#define FLI_FOREIGN		(( 5<<3)|1)
#define FLI_CLASS		(( 6<<3)|1)
#define FLI_INSTANCE		(( 7<<3)|1)
#define FLI_TERM		(( 8<<3)|1)
#define FLI_ASCII		(( 9<<3)|1)
#define FLI_KANJI		((10<<3)|1)
#define FLI_LOGICAL		((51<<3)|1)
#define FLI_VOID		((52<<3)|1)
#define FLI_CLI_V1		((53<<3)|1)
/* complex data type */
#define FLI_STRUCT_OF		((91<<3)|1)
#define FLI_ARRAY_OF		((92<<3)|1)
#define FLI_ELEMENT_OF		((93<<3)|1)
/* add for FORTRAN */
#define FLI_SHORT_FLOAT		((21<<3)|1)
#define FLI_COMPLEX		((22<<3)|1)
#define FLI_SHORT_COMPLEX	((23<<3)|1)
#define FLI_BOOL		((24<<3)|1)

#define FLI_MODE_NONE		0
#define FLI_MODE_INPUT		1
#define FLI_MODE_OUTPUT		2
#define FLI_MODE_RETURN		3
#define FLI_MODE_REFERENCE	4

#define FLI_TYPE_REF		0x0	/* 00 */
#define FLI_TYPE_BASIC		0x1	/* 01 */
#define FLI_TYPE_CONSTANT	0x1	/* 01, Basic & Name */
#define FLI_TYPE_COMPLEX	0x3	/* 11 */
#define FLI_TYPE_STRUCT_OF	0x1	/* 01 */
#define FLI_TYPE_ARRAY_OF	0x2	/* 10 */
#define FLI_TYPE_ELEMENT_OF	0x3	/* 11 */
#define FLI_TYPE_SIZE		2	/* 2bit */
#define FLI_TYPE_MASK		(0xffffffff<<FLI_TYPE_SIZE)
#define FLI_TYPE_FIELD		~FLI_TYPE_MASK
#define FLI_DATATYPE_SIZE	(8+FLI_TYPE_SIZE+1)
#define FLI_DATATYPE_MASK	(0xffffffff<<FLI_DATATYPE_SIZE)
#define FLI_DATATYPE_FIELD	~FLI_DATATYPE_MASK

#define FLI_ADDR( x )		( (UNIT*)( (UNIT)(x) & FLI_TYPE_MASK ) )
#define FLI_TYPE( x )		( (UNIT)(x) & FLI_TYPE_FIELD )
#define FLI_SIZE( x )		( (int)(x) << FLI_TYPE_SIZE )
#define FLI_SIZE_GET( x )	( (int)(x) >> FLI_TYPE_SIZE )
#define FLI_DATATYPE( x )	( (UNIT)(x) & FLI_DATATYPE_FIELD )
#define FLI_STR_SIZE( x )	( (UNIT)(x) >> FLI_DATATYPE_SIZE )
#define VALID_FLI_PTR( x )	cespFLIisValidPtr( x )
#define IsOnHeap( x )		( start_of_Heap <= (word*)(x) && \
				  reg_topH > (word*)(x) )
#define IsOnGlobalStack( x )	( start_of_Global <= (word*)(x) && \
				  reg_topG > (word*)(x) )
#define IsOnEnvironmentStack( x )	( start_of_Env <= (word*)(x) && \
					  reg_topE > (word*)(x) )

#define SIZE_UNIT		( (int)sizeof( UNIT ) )
#define CESP_WORDS( n )		( ( (int)(n) - 1 ) / SIZE_UNIT + 1 )

#define SIZE_CLDEF		CESP_WORDS( sizeof( FLICLDEF ) )
#define SIZE_FBDEF		CESP_WORDS( sizeof( FLIFBDEF ) )
#define SIZE_NATUREDEF		CESP_WORDS( sizeof( FLINATUREDEF ) )
#define SIZE_NATURECELL		CESP_WORDS( sizeof( FLINATURECELL ) )
#define SIZE_EXHDDEF		CESP_WORDS( sizeof( FLIEXHDDEF ) )
#define SIZE_IMHDDEF		CESP_WORDS( sizeof( FLIIMHDDEF ) )
#define SIZE_HDARGDEF		CESP_WORDS( sizeof( FLIHDARGDEF ) )
#define SIZE_FUNCDEF		CESP_WORDS( sizeof( FLIFUNCDEF ) )
#define SIZE_TYPEDEF		CESP_WORDS( sizeof( FLITYPEDEF ) )
#define SIZE_TYPECELL		CESP_WORDS( sizeof( FLITYPECELL ) )
#define SIZE_EXHDFRM		CESP_WORDS( sizeof( FLIEXHDFRAME ) )
#define SIZE_EXHDFRMCELL	CESP_WORDS( sizeof( FLIEXHDFRAMECELL ) )
#define SIZE_OBJECTDSCRP	CESP_WORDS( sizeof( OBJECTA ) )
#define SIZE_STCKTAB		CESP_WORDS( sizeof( FLISTCKTAB ) )

#define MallocUNIT( n ) \
	(UNIT*)malloc( (n) * SIZE_UNIT );

#define AllocUNIT( n ) \
	(UNIT*)cespFLIalloc( n )
#define AllocBYTE( n ) \
	(BYTE*)cespFLIalloc( ((n) - 1) / SIZE_UNIT + 1 )
#define AllocCLDEF( n ) \
	(FLICLDEF*)cespFLIalloc( SIZE_CLDEF * (n) )
#define AllocFBDEF( n ) \
	(FLIFBDEF*)cespFLIalloc( SIZE_FBDEF * (n) )
#define AllocNATUREDEF( n ) \
	(FLINATUREDEF*)cespFLIalloc( SIZE_NATUREDEF * (n) )
#define AllocNATURECELL( n ) \
	(FLINATURECELL*)cespFLIalloc( SIZE_NATURECELL * (n) )
#define AllocEXHDDEF( n ) \
	(FLIEXHDDEF*)cespFLIalloc( SIZE_EXHDDEF * (n) )
#define AllocIMHDDEF( n ) \
	(FLIIMHDDEF*)cespFLIalloc( SIZE_IMHDDEF * (n) )
#define AllocHDARGDEF( n ) \
	(FLIHDARGDEF*)cespFLIalloc( SIZE_HDARGDEF * (n) )
#define AllocFUNCDEF( n ) \
	(FLIFUNCDEF*)cespFLIalloc( SIZE_FUNCDEF * (n) )
#define AllocTYPEDEF( n ) \
	(FLITYPEDEF*)cespFLIalloc( SIZE_TYPEDEF * (n) )
#define AllocTYPECELL( n ) \
	(FLITYPECELL*)cespFLIalloc( SIZE_TYPECELL * (n) )
#define AllocEXHDFRM( n ) \
	(FLIEXHDFRAME*)cespFLIalloc( SIZE_EXHDFRM * (n) )
#define AllocEXHDFRMCELL( n ) \
	(FLIEXHDFRAMECELL*)cespFLIalloc( SIZE_EXHDFRMCELL * (n) )
#define AllocOBJECTDSCRP( n ) \
	(OBJECT)cespFLIalloc( SIZE_OBJECTDSCRP * (n) )
#define AllocSTCKTAB( n ) \
	(FLISTCKTAB*)cespFLIalloc( SIZE_STCKTAB * (n) )

#define ErrMan( code, fac, arg ) \
	return( errMan( (code), (fac), (arg) ) )
#define ErrMan4( code, fac, arg1, arg2 ) \
	return( errMan( (code), (fac), (arg1), (arg2) ) )

#ifndef forever
#define forever		for (;;)
#endif


/* FLI Macros */
#define CESPFLIsuccess		return( cespFLInormalReturn( 1 ) )
#define CESPFLIfail		return( cespFLInormalReturn( 0 ) )
#define CESPFLIexception	return(-1)
#define CESPFLIreturn( x )	return( cespFLIreturn( x ) )

#define CESPFLIisSuccess( sts )		( (sts) > 0 )
#define CESPFLIisFail( sts )		( (sts) == 0 )
#define CESPFLIisException( sts )	( (sts) < 0 )

#define CESPFLIcase( sts, lblS, lblF, lblE ) \
	{   LOGICAL __sts__; \
	    if ( ( __sts__ = (LOGICAL)(sts) ) > 0 ) goto lblS; \
	    else if ( __sts__ == 0 ) goto lblF; \
	    else goto lblE; \
	} \
	forever	/* switch ( sts ) */

#define CESPFLIisValidData( x )	\
	( cespFLIisValidData( &(x) ) == SUCCESS )

/* FLI Macros */

#define CESP_DATA_REF		1000
#define CESP_DATA_UNDF		CESP_DATA_REF
#define CESP_DATA_INT		1010
#define CESP_DATA_ATOM		1011
#define CESP_DATA_LIST		1020
#define CESP_DATA_FLOAT		1030
#define CESP_DATA_IVCT		1031
#define CESP_DATA_SIVCT		1032
#define CESP_DATA_PVCT		1033
#define CESP_DATA_SPVCT		1034
#define CESP_DATA_ISTR		1035
#define CESP_DATA_SISTR		1036
#define CESP_DATA_PSTR		1037
#define CESP_DATA_SPSTR		1038
#define CESP_DATA_OBJ		1039
#define CESP_DATA_FRGN		1040
#define CESP_DATA_HTBL		1041

#ifndef KANA_SHIFT_CODE
#define KANA_SHIFT_CODE		0x8e
#define GAIJI_SHIFT_CODE	0x8f
#endif

#define CESPFLI_EXC_illegal_input	(-1001)
#define CESPFLI_EXC_range_overflow	(-1002)
#define CESPFLI_EXC_out_of_bounds	(-1003)
#define CESPFLI_EXC_malloc_error	(-1004)
#define CESPFLI_EXC_heap_alloc_error	(-1005)
#define CESPFLI_EXC_global_alloc_error	(-1006)

#ifndef MAX( x, y )
#define MAX( x, y )		( ( (x) > (y) ) ? (x) : (y) )
#define MIN( x, y )		( ( (x) < (y) ) ? (x) : (y) )
#endif

extern UNIT *cespFLIalloc();
extern void cespFLIfree();
extern LOGICAL cespFLIreturn();
extern LOGICAL cespFLInormalReturn();
extern LOGICAL cespFLIexception();

/* FLI Library functions */
extern LOGICAL cespFLIisVar();
extern LOGICAL cespFLInewVar();
extern LOGICAL cespFLIisNil();
extern LOGICAL cespFLInewNil();
extern LOGICAL cespFLIisInt();
extern LOGICAL cespFLIgetInt();
extern LOGICAL cespFLInewInt();
extern LOGICAL cespFLIisAtom();
extern LOGICAL cespFLIgetAtomName();
extern LOGICAL cespFLIgetAtomNumber();
extern LOGICAL cespFLInewAtom();
extern LOGICAL cespFLIisList();
extern LOGICAL cespFLIunifyCar();
extern LOGICAL cespFLIunifyCdr();
extern LOGICAL cespFLInewList();
extern LOGICAL cespFLIisFloat();
extern LOGICAL cespFLIgetFloat();
extern LOGICAL cespFLInewFloat();
extern LOGICAL cespFLIisImpureString();
extern LOGICAL cespFLIgetImpureString();
extern LOGICAL cespFLIsetImpureString();
extern LOGICAL cespFLInewImpureString();
extern LOGICAL cespFLIisImpureVector();
extern LOGICAL cespFLIgetImpureVectorSize();
extern LOGICAL cespFLIgetImpureVectorElement();
extern LOGICAL cespFLIsetImpureVectorElement();
extern LOGICAL cespFLInewImpureVector();
extern LOGICAL cespFLIisPureVector();
extern LOGICAL cespFLIgetPureVectorSize();
extern LOGICAL cespFLIunifyPureVectorElement();
extern LOGICAL cespFLInewPureVector();
extern LOGICAL cespFLInew();
extern LOGICAL cespFLIdelete();
extern LOGICAL cespFLIunify();
extern LOGICAL cespFLImethod();
extern LOGICAL cespFLIredo();
extern LOGICAL cespFLIgetClassObject();
extern LOGICAL cespFLIgetClassName();
extern LOGICAL cespFLIisClassObject();
extern LOGICAL cespFLIisInstanceObject();
extern LOGICAL cespFLIisValidData();
extern LOGICAL cespFLIgetLastErrorInfo();
/* FLI Library functions */
