/* PD624 code file: CH6.PL
   master 'explain' file, as described in Chapter 6 of
   PD624: Knowledge Engineering
   The format for explanations is
   <pattern> explained_by <text-list>
   Where <pattern> is any valid Prolog term, typically a string or a
list, which is normally passed in to the operator 'query' in a
MIKE rule.  <text-list> is a list of atoms or quoted strings
*/
'What is the name of the patient' explained_by
  ['In order to carry out a diagnosis, we first need',nl,
  'to determine the name of the patient',
   nl,'in question',nl].
the name of patient explained_by
   ['In order to carry out a diagnosis, we first need',nl,
   'to determine the name of the patient in question',nl].
'does the patient show positive reaction to allergens' explained_by
  ['Answering this question will help MIKE determine whether the',nl,
  'patient is suffering from hay fever (seasonal allergic rhinitis)',
   nl,'or if the symptoms are instead indicative of a common cold',nl].
'does the patient show signs of erythematous larynx' explained_by
      ['Answering this question will help MIKE determine whether the',nl,
      'patient is suffering from laryngitis',nl].
goal(hypothesize) explained_by
        ['Given a particular set of symptoms, MIKE is trying to',
        nl,'determine which are the possible "candidates"', nl].
goal(discriminate) explained_by
  ['Attempting to trim down the set of possible "candidates"',nl].
goal(choose_winner) explained_by
  ['Determine which of the possible candidates is/are the winner(s)',nl].
possible(laryngitis) explained_by
  ['the patient has fever, dry cough, and malaise',nl,
  'and therefore laryngitis is a possible ailment',nl].
possible(influenza) explained_by
  ['the patient has fever, a dry cough, and malaise',nl,
  'and therefore influenza is a possible ailment',nl].
possible(common_cold) explained_by
  ['the patient is sneezing, and has a runny nose and fever',
  nl,'therefore a possible explanation is a common cold',nl].
possible(hay_fever_1) explained_by
['the patient is sneezing and has a blocked nose',nl,
'therefore hay fever is a possibility',nl].
possible(hay_fever_2) explained_by
['the patient is sneezing and has a runny nose',nl,
'therefore hay fever is a possible ailment',nl].
likely(X) explained_by
['Using the known symptoms of the patient ',X,
nl,'was identified as a possible source of the complaint',
nl,'After this more descriminating tests were applied.',nl,
X,' passed these further criteria, and thus is deemed',nl,
'a likely cause of the patient''s condition',nl].
passes_discriminating_test(influenza) explained_by
['The answer helps indicate whether it is likely that the',nl,
'patient has influenza',nl].
'does the patient show positive reactions to allergens'
explained_by ['The answer to this question is important for
determining whether', nl,'the patient is suffering from a common
cold',nl].
passes_discriminating_test(laryngitis) explained_by ['The
answer to this questions is important for determing',nl, 'whether
the patient is suffering from laryngitis',nl].

['Is there solid evidence of ', D, '?']
      explained_by
['Having worked our way down through the hierarchy of disease classes and',
nl,
'subclasses all the way down to individual instances, we are at last in a',
nl,
'position to make a discrimination among all of the final contenders',
nl,
'by performing a critical test.  This particular test, namely evidence of',
nl,
D,nl,
'will help us home in on a final choice'].


