
/* PD624 code file: CH5-3.PL
More powerful frame and rule-based medical diagnosis system
from Section 5.3 of PD624 'Knowledge Engineering'
*/
/* patient database */
patient subclass_of person with
  symptoms: [],
  history: [],
  signs: [].

adam instance_of patient with
  symptoms: [fever, systemic_upset,purulent_sputum],
  history: [previous_lung_disease],
  signs : [finger_clubbing,halitosis].

bob instance_of patient with
  symptoms: [sneezing, runny_nose],
  history: [],
  signs: [red_itchy_watery_eyes].

carol instance_of patient with
  symptoms: [cough, sneezing, fever, dry_throat],
  history: [],
  signs: [hoarse_voice].

/* donna and earl are undiagnosable in this db... you'll have to augment
it to work out what they have! */

donna instance_of patient with
  symptoms: [cough, sneezing, fever, shivering],
  history: [],
  signs: [].

earl instance_of patient with
  symptoms: [],
  history: [post_operative, ageing],
  signs: [].

/* diseases */
respiratory_tract_disease subclass_of disease with
  indicators: [productive_cough, dry_cough, breathlessness, sneezing,
               runny_nose, fever],
  physical_signs: [],
  typical_histories_or_contexts: [],
  discriminators: [].

upper_rtd subclass_of respiratory_tract_disease with
  indicators: [fever, dry_cough, sneezing, runny_nose],
  physical_signs: [],
  typical_histories_or_contexts: [],
  discriminators: [].

lower_rtd subclass_of respiratory_tract_disease with
  indicators: [productive_cough, breathlessness, fever],
  physical_signs: [],
  typical_histories_or_contexts: [],
  discriminators: [].

pneumonia subclass_of lower_rtd with
  indicators: [productive_cough, fever, systemic_upset,
             purulent_sputum, mucoid_sputum],
  physical_signs: [],
  typical_histories_or_contexts: [],
  discriminators: [].

bacterial_pneumonia subclass_of pneumonia with
  indicators: [purulent_sputum],
  physical_signs: [],
  typical_histories_or_contexts: [],

  discriminators: [].

non_bacterial_pneumonia subclass_of pneumonia with
  indicators: [mucoid_sputum],
  physical_signs: [],
  typical_histories_or_contexts: [],
  discriminators: [].

staphylococcal_pneumonia instance_of bacterial_pneumonia with
  indicators: [fever, purulent_sputum, malaise ],
  physical_signs: [crepitations ],
  typical_histories_or_contexts: [previous_respiratory_disease],
  discriminators: [gram_positive_cocci].

bronchiectasis instance_of lower_rtd with
  indicators: [fever, systemic_upset, purulent_sputum],
  physical_signs: [finger_clubbing, halitosis, breathlessness, cyanosis],
  typical_histories_or_contexts: [previous_lung_disease],
  discriminators: ['bronchiectasis seen on bronchiogram'].

lung_abscess  instance_of lower_rtd with
  indicators: [fever, systemic_upset, purulent_sputum],
  physical_signs: [consolidation, halitosis, finger_clubbing],
  typical_histories_or_contexts: [unresolving_pneumonia],
  discriminators: [pulmonary_cavitation_with_fluid_levels].

hay_fever instance_of upper_rtd with
  indicators: [sneezing, runny_nose],
  physical_signs: [red_itchy_watery_eyes],
  typical_histories_or_contexts: [],
  discriminators: [positive_reaction_to_allergens].

laryngitis instance_of upper_rtd with
  indicators: [fever, dry_cough, malaise],
  physical_signs: [hoarse_voice],
  typical_histories_or_contexts: [],
  discriminators: [inflamed_larynx ].

common_cold instance_of upper_rtd with
  indicators: [runny_nose, sneezing, fever],
  physical_signs: [headache],
  typical_histories_or_contexts: [],
  discriminators: [negative_reaction_to_allergens].

influenza instance_of upper_rtd with
  indicators: [fever, dry_cough, malaise],
  physical_signs: [discomfort],
  typical_histories_or_contexts: [],
  discriminators: [sore_throat_and_persistent_dry_cough].

/* control rules */

/*
Notice how rules init1, init2, and init3 below are structured.
In particular, init1 displays an opening screen using 'announce',
then uses 'single_choice_menu' to display a pop-up menu of choices,
of which only one may be selected (using the arrow keys on the
keypad, then the 'ENTER' key, or mouse left-button).
Rule init2 uses 'query' to display a dialogue box into which a name
can be typed, and 'multiple_choice_menu' to display a pop-up menu of
choices, of which several may be selected (using the arrow keys on
the keypad, then the 'ENTER' key (or mouse left-button) to 'toggle'
the 'tick-mark' on the far right 'on' or 'off', then the 'ESC' key
(or mouse right-button) to indicate that the selection is complete.

The format for these menu primitives is as follows:

   single_choice_menu(MessageList, ChoiceList, SingleResult).
   multiple_choice_menu(MessageList, ChoiceList, AllResults).

In both cases, MessageList is a list of elements just like those used
by announce (except you want to make sure that it fits on one line),
to appear at the top of the pop-up menu.  ChoiceList is the list of
items which the user will be asked to select from.  SingleResult should
be a variable of your own choosing (e.g. Ans) which will take as its
value the single menu choice ultimately made by the user at run-time.
AllResults, analogously, will take as its value a *LIST* of all choices
made by the user at run-time.  The rules init1 and init2 indicate
typical ways in which you might want to use the result of the user choices,
namely noting the information directly into frame memory.  Alternatively,
you might want to use 'add' to place the information into working memory,
e.g.    add [current_patient, is_called, Name]
*/

rule init1 forward
  if
    start
  then
    announce
     [        '         R E S P I R A T O R Y ',  nl,
              '             D I S E A S E' ,      nl,
              '          D I A G N O S T I C',    nl,
              '              S Y S T E M ',       nl,
              '         { V E R S I O N - 3 }',   nl,
              '                         ',     nl,
              'For illustrative purposes only, namely',  nl,
              'teaching  about  Knowledge Engineering,',   nl,
              '*NOT*  medical  diagnosis!   No  other',      nl,
              'purpose  intended  or  implied.'
     ] &
    single_choice_menu(
          ['What is the patient''s name?'],
          [adam, bob, carol, donna, earl, 'other...'],
          Name) &
    note the name of patient is Name.

rule init2 forward
  if
    start &
    the name of patient is 'other...'
  then
    query [' Please enter the name below: '] receives_answer X &
    note the name of patient is X &  /* replaces 'other...' with X */
    multiple_choice_menu(
          [' Select main symptom(s): '],
          [fever, systemic_upset, purulent_sputum, mucoid_sputum, malaise,
           dry_cough, runny_nose, sneezing, cough, hoarse_voice,
           red_itchy_watery_eyes, breathlessness, shivering],
          S) &   /* S will have as its value the list of all user-choices! */
    note (X instance_of patient with symptoms: S) & /* stores all symptoms */
    remove start &
    add goal(hypothesize).

rule init3 forward  /* this rule only selected if name is NOT 'other...' */
  if
    start &
    the name of patient is X
  then
    remove start &
    add goal(hypothesize).


rule switch_strategies_1 forward
  if
    goal(hypothesize)
  then
    remove goal(hypothesize) &
    add goal(refine).

rule switch_strategies_2 forward
  if
    goal(refine)
  then
    remove goal(refine) &
    add goal(discriminate).

rule switch_strategies_3 forward
  if
    goal(discriminate)
  then
    remove goal(discriminate) &
    add goal(choose_winner).

rule switch_strategies_4 forward
  if
    goal(choose_winner)
  then
    remove goal(choose_winner) &
    halt.               /* <=== This is where the whole thing ends  */

/* forward chaining diagnosis rules */
rule ordinary_diagnosis forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is Symp &  /* now find ANY symptom Symp */
    D subclass_of disease &  /* and any category of disease...  */
    -- possible(D) &  /* that we haven't suggested already...  */
    the indicators of D is Symp   /* which might be indicated by Symp */
  then
    add possible(D).  /* place it in working memory */

rule refinement_to_subclass forward
  if
    goal(refine) &
    possible(DiseaseClass) &  /* given this candidate */
    Subclass subclass_of DiseaseClass &   /* find a subclass of it...  */
    -- possible(Subclass) &  /* which we haven't dealt with yet */
  deduce allowable(Subclass)
  then
  announce ['just refined down to subclass ',Subclass] &
    add possible(Subclass).  /* if so, add to set of 'possibles' */

rule refinement_to_instance forward  /* as above, but only for instances */
  if
    goal(refine) &
    possible(DiseaseClass) &  /* given this candidate */
    Disease instance_of DiseaseClass &   /* find an instance of it...  */
    -- possible(Disease) &  /* which we haven't dealt with yet */
    deduce passes_phys_sign_test(Disease)  /* see if it passes further tests */
  then
  announce ['just passed physical sign for disease instance ',Disease] &
    add possible_instance(Disease).  /* if so, add to set of 'possibles' */

rule eliminate forward
  if
    goal(discriminate) &
    possible_instance(X) &
    deduce passes_discriminating_test(X)
  then
  announce ['a highly likely candidate after discriminating test is ',X] &
    add likely(X).

rule simple_selection forward  /* specifity prefers above rule to this one */
  if
    goal(choose_winner) &
    likely(X)
  then
    remove likely(X) &
    announce ['A likely diagnosis is that the patient has ', X].


/* ---------------- backward chaining 'filters'---------------------- */

rule allowable_1 backward
 if
   the name of patient is N &
   the indicators of Disease is Ind &
   the symptoms of N is Ind     /* one symptom in common with indicators */
 then
   allowable(Disease).


rule necessary_sign_test backward
  if
    the physical_signs of Disease is Sign &  /* get any sign */
    the name of patient is N &
    the signs of N is Sign /* see if patient has got it */
  then
    passes_phys_sign_test(Disease).

rule discriminatory_diagnosis backward
  if
    the discriminators of X is D &
    query ['Is there solid evidence of ', D, '?']
        receives_answer yes
  then
    passes_discriminating_test(X).
