/* PD624 Code for answer to exercise 5-1
Rule-based medical diagnosis system from
Section 5.1 of PD624 'Knowledge Engineering'
*/
/* ================ I M P O R T A N T   M E S S A G E ================== */
/* The way the database is set up at the moment, only one person
   (namely 'baker') has a diagnosable disease!!!  It is your responsibility
   to augment both the frames and the rules if you wish them to 'mesh'
   on more cases (as in course exercise 5.1) . */

patient subclass_of person with
  symptoms: [].   /* deliberately empty as 'reminder' about this slot */

abel instance_of patient with
  symptoms: [cough, sneezing, fever, hoarse_voice].

baker instance_of patient with         /* baker has hay_fever_2 */
  symptoms: [sneezing, runny_nose, red_itchy_watery_eyes].

charlie instance_of patient with
  symptoms: [cough, sneezing, fever, dry_throat].

david instance_of patient with
  symptoms: [cough, sneezing, fever, shivering].


rule init forward
  if
    start
  then
    remove start &
    query the name of patient receives_answer X &
                           /* automatically notes the name! */
    add goal(hypothesize). /* see course text for explanation of 'goals' */

/* strategy-switching rules only get selected when there's nothing better! */
rule switch_strategies_1 forward
  if
    goal(hypothesize)
  then
    remove goal(hypothesize) &
    add goal(discriminate).

rule switch_strategies_2 forward
  if
    goal(discriminate)
  then
    remove goal(discriminate) &
    add goal(choose_winner).

rule switch_strategies_3 forward
  if
    goal(choose_winner)
  then
    remove goal(choose_winner) &
    halt.                 /* This is where the whole thing ends  */

rule hypothesize_laryngitis forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is fever &
    the symptoms of N is dry_cough &
    the symptoms of N is malaise
  then
    add possible(laryngitis).  /* place it in working memory */

rule hypothesize_influenza forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is fever &
    the symptoms of N is dry_cough &
    the symptoms of N is malaise
  then
    add possible(influenza).  /* place it in working memory */

rule hypothesize_cold forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is sneezing &
    the symptoms of N is runny_nose&
    the symptoms of N is fever
  then
    add possible(common_cold).  /* place it in working memory */

rule hypothesize_hay_fever_1 forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is sneezing &
    the symptoms of N is blocked_nose
  then
    add possible(hay_fever_1).  /* place it in working memory */

rule hypothesize_hay_fever_2 forward
  if
    goal(hypothesize) &  /* in 'hypothesis' mode? */
    the name of patient is N &  /* retrieve name */
    the symptoms of N is sneezing &
    the symptoms of N is runny_nose
  then
    add possible(hay_fever_2).  /* place it in working memory */

rule eliminate forward
  if
    goal(discriminate) &
    possible(X) &
    deduce passes_discriminating_test(X)
  then
    add likely(X).

rule simple_selection forward
  if
    goal(choose_winner) &
    likely(X)
  then
    announce ['A likely diagnosis is that the patient has ', X].

rule prove_laryngitis backward
  if
    query 'does the patient show signs of inflamed larynx'
        receives_answer yes
  then
    passes_discriminating_test(laryngitis).

rule prove_hay_fever_1 backward
  if
    query 'does the patient show positive reaction to allergens'
        receives_answer yes
  then
    passes_discriminating_test(hay_fever_1).

rule prove_hay_fever_2 backward
  if
    query 'does the patient show positive reaction to allergens'
        receives_answer yes
  then
    passes_discriminating_test(hay_fever_2).

rule prove_cold backward
  if
    query 'does the patient show positive reaction to allergens'
        receives_answer no
  then
    passes_discriminating_test(common_cold).

rule prove_influenza backward
  if
    query 'does the patient show signs of shivering or aches'
         receives_answer yes
  then
    passes_discriminating_test(influenza).

