/* PD624 Code for answer to exercise 7.1 */

/* to make it work you must answer that the chain_of_lights1 is
the problematic device */

/* Static causal model for connected devices */

chain_of_lights1 instance_of series_circuit with
      components: [bulb1, bulb2, bulb3, plug1, fuse1],
      last_element: bulb3.

bulb1 instance_of bulb with
      comes_from: plug1,
      goes_to: bulb2.

bulb2 instance_of bulb with
      comes_from: bulb1,
      goes_to: bulb3.

bulb3 instance_of bulb with
      comes_from: bulb2.

plug1 instance_of plug with
      comes_from: fuse1,
      goes_to: bulb1.

fuse1 instance_of fuse with
      comes_from: mains,
      goes_to: plug1.

/* The rules for "no chain is stronger than its weakest link" */

rule init forward
     if
       start
     then
       remove start &
       single_choice_menu(['Please select the problematic device:'],
                          [chain_of_lights1, chain_of_lights2, toaster],
                          Device) &
       add [Device,is,broken].

rule begin_chaining forward
     if
       [D,is,broken] &
       D instance_of series_circuit &
       the last_element of D is Last
     then
       add [follow,the,chain,from,Last].

rule continue_chaining forward
     if
       [follow,the,chain,from,Item] &
       [Item,is,ok] &
       the comes_from of Item is PreviousItem
     then
       remove [follow,the,chain,from,Item] &
       add [follow,the,chain,from,PreviousItem].

rule dead_end forward
     if
       [follow,the,chain,from,Item] &
       [Item,is,ok] &
       -- the comes_from of Item is PreviousItem
     then
       announce ['Sorry, but ', Item, ' is as far back in the chain',nl,
                 'as I can go.  I give up.'] &
       halt.

rule ask_it forward
     if
       [follow,the,chain,from,Item] &
       -- [Item,is,ok] &         /* not definitely ok... */
       -- [Item,is,kaput]        /* not definitely kaput */
     then
      single_choice_menu(
         ['What happens with ',Item,' in a working circuit?'],  /* Ques */
         [ok, kaput],                                           /* Choices */
         Ans) &                      /* third argument is variable outcome */
      add [Item,is,Ans].          /* stores answer in working memory */

rule found_culprit forward
     if
       [Item,is,kaput]
     then
       announce ['OK: ',Item,' is your source of difficulty', nl,
                 'so you should replace it with a known working one.'] &
       halt.

