/* PD624 Code for the answer to exercise 3.7 */

/* We store the type and cardinality restrictions at the 'class' level,
in this case with the class called 'patient'.  We use 'value:unknown'
because we don't need to store a default value for any of these slots.
Notice the arbitrariness of the slot names-- there is a lot of freedom
in this type of representation.  In particular, there is a tradeoff
between having simple binary (yes/no) attributes, and storing a
larger range of values.  For example, if a patient has a persistent cough and
a runny nose, you could choose to represent this information either as

          ...
          persistent_cough: yes,
          runny_nose: yes,
          ...

or alternatively as

          ...
          coughing: persistent,
          nose: runny,

(and of course numerous other representations are possible).  The
representation below is 'mixed', in that sometimes it opts for the
simple binary attributes (with richer slot names such as 'hoarse_voice'),
and sometimes it opts for a larger range of values (with simpler slot
names such as 'nose').  This is just to give you an idea of different
styles of representation.

Remember that when the 'type' facet has a list of elements in it, such as
[persistent, intermittent, dry, non_dry], then any of these elements is
considered to be a 'legal' filler for the value facet (along with the
special filler 'unknown' and the empty list [] ).

If the 'cardinality' facet specifies 'any', then any number of fillers
can occupy the value facet.  A cardinality of '1', of course, means that
only one filler can occupy the value facet.

Violations of type and cardinality specifications are only checked when
you use 'note' in a running program, and even then only warning messages
are provided to remind you of the type and cardinality restrictions.

*/

patient subclass_of person with
  coughing:
    [value: unknown,
     type: [persistent,intermittent,dry,non_dry],  /* legal fillers */
     cardinality: any],                            /* any number allowed */
  nose:
    [value: unknown,
     type: [runny,blocked,bleeding,broken,lacerated],
     cardinality: any],
  sneezing:
    [value: unknown,                 /* default case is unknown */
     type: [yes,no],                 /* simple 'yes' or 'no' expected */
     cardinality : 1],               /* naturally, only 1 is allowed */
  throat:
    [value: unknown,
     type: [dry,sore],
     cardinality: 1],
  hoarse_voice:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  laryngeal_discomfort:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  fever:
    [value: unknown,
     type: [yes,no,slight,intermittent],
     cardinality : 1],
  shivering:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  muzzy_feeling_head:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  eyes:          /* could have used 'red_itchy_watery_eyes: yes' instead */
    [value: unknown,
     type: [red, itchy, watery],
     cardinality: any],
  malaise:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  headache :
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  aches_and_pains:
    [value: unknown,
     type: [yes,no],
     cardinality: 1],
  back:                    /* an extra slot, not actually relevant, but... */
    [value: unknown,       /* used to cater for patient alice below */
     type: [sore, stiff],
     cardinality: any].



/*  ============ specific patients ================================ */

alice instance_of patient with
  nose: [runny, blocked],
  sneezing: yes,
  eyes: [red, itchy, watery],
/* alice may also report other features e.g. a sore back which may or not
   be relevant */
  back: sore.

bob instance_of patient with
  nose: blocked,
  coughing: [persistent,dry],
/* maybe the coughing also gave him a headache */
  headache: yes,
  hoarse_voice: yes,
  laryngeal_discomfort: yes,
  fever: yes,
  malaise: yes.

christine instance_of patient with
  nose: runny,
  sneezing: yes,
  throat: dry,
  fever: [slight, intermittent],
  muzzy_feeling_head: yes.

david instance_of patient with
  coughing: [persistent,dry],
  throat: sore,
  fever: yes,
  shivering: yes,
  malaise: yes,
  headache: yes,
  aches_and_pains: yes.
