/* PD624 Unit2 Code : code for exercise 2.7 */

rule initialisation_rule forward
  if
    start
  then
    add 'kettle is plugged in' &
    add 'sugar required' &
    add 'milk required' &
    add 'teacup is empty' &
    add 'kettle is switched off' &
    add 'cups required'(5) &
    add 'kettle contains'(3).

rule boilingWater_UnplugKettle forward
  if
    'kettle is plugged in'
  then
    remove 'kettle is plugged in' &
    add 'kettle is not plugged in'.

rule boilingWater_FillKettle forward
  if
   'cups required'(Cups) &
   'kettle contains'(Contents) &
   'kettle is not plugged in'    &
   Cups > Contents     /* only true if kettle isn't full enough! */
   /* N.B. MIKE 2.0 & higher no longer needs   prolog(Cups > Contents) */
  then
   remove 'kettle contains'(Contents) &
   add 'kettle contains'(Cups) &    /* simulates the act of 'filling up' */
   add 'kettle is filled'.

rule boilingWater_PlugInKettle forward
  if
    'kettle is filled' &
    'kettle is not plugged in'
  then
    remove 'kettle is not plugged in' &
    add 'kettle is plugged in'.

rule boilingWater_SwitchOn forward
  if
    'kettle is plugged in'
  then
    remove 'kettle is switched off' &
    add 'kettle is switched on'.

rule boilingWater_WaterBoiled forward
  if
    'kettle is plugged in' &
    'kettle is switched on'
  then
    add 'water is boiled'.

rule makingTea_AddTeabag forward
  if
    'teacup is empty'
  then
    add 'teabag in cup'.

rule makingTea_AddBoilingWater forward
  if
    'teabag in cup' &
    'water is boiled'
  then
    add 'boiling water in cup'.

rule makingTea_BrewingTea forward
  if  'teabag in cup' &
    'boiling water in cup'
  then
    add 'tea has brewed'.

rule makingTea_RemoveTeaBag forward
  if
    'teabag in cup' &
    'tea has brewed'
  then
    remove 'teabag in cup' &
    add 'teabag removed'.

rule makingTea_MilkAndSugar forward
  if
    'teabag removed' &
    'milk required' &
    'sugar required'
  then
    add 'milk requirement satisfied' &
    add 'sugar requirement satisfied'.

rule makingTea_MilkRequired forward
  if
    'teabag removed' &
    'milk required'
  then
    add 'milk requirement satisfied'.

rule makingTea_SugarRequired forward
  if
    'teabag removed' &
    'sugar required'
  then
    add 'sugar requirement satisfied'.

rule makingTea_StirringMilkAndSugar forward
  if
    'milk requirement satisfied' &
    'sugar requirement satisfied'
  then
    add 'tea has been stirred'.

rule makingTea_StirringMilk forward
  if
    'milk requirement satisfied'
  then
    add 'tea has been stirred'.

rule makingTea_StirringSugar forward
  if
    'sugar requirement satisfied'
  then
    add 'tea has been stirred'.

rule makingTea_StirringTea forward
  if
    'teabag removed'
  then
    add 'tea has been stirred'.

rule makingTea_TeaIsMade forward
  if
    'tea has been stirred' &
    'kettle contains'(X)
  then
    add 'tea is ready' &
    announce [nl,'THE TEA IS READY !!!  ',nl,X,' CUPS BREWED',nl,nl] &
    halt.

/* The next line initialises one of MIKE's tracing options: */
?- reverse_option('show new working memory elements or frame changes',enable).
?- write('[Tracing option 5 (show new working memory elements or').
?- nl, write(' frame changes) has been enabled in file ANS2-7.PL]').
