/* PD624 Unit2 Code : code for answer to exercise 2.6 */

/* the following seeds the database as appropriate */
/* the '?- ' in this file means that the command is automatically
executed when you load the file.  Thus the effect of reconsulting this
file is to seed working memory with the following 6 items */
  ?- initialise.   /* clears out existing working memory */
  ?- add 'kettle is empty'.
  ?- add 'kettle is plugged in'.
  ?- add 'sugar required'.
  ?- add 'milk required'.
  ?- add 'teacup is empty'.
  ?- add 'kettle is switched off'.

/* the rules are as follows */
/* to run the system type
  deduce 'tea is ready'
  */

rule deduce_boilingWater_UnplugKettle
backward
if 'kettle is empty' &
   'kettle is plugged in'
then  'kettle is not plugged in'.


rule deduce_boilingWater_FillKettle
backward
if 'kettle is empty' &
   'kettle is not plugged in'
then 'kettle is full'.

rule deduce_boilingWater_PlugInKettle
backward
if 'kettle is full' &
   'kettle is not plugged in'
then 'kettle is plugged in'.

rule deduce_boilingWater_SwitchOn
backward
if 'kettle is full' &
   'kettle is plugged in'
then  'kettle is switched on'.


rule deduce_boilingWater_WaterBoiled
backward
if 'kettle is full' &
   'kettle is plugged in' &
   'kettle is switched on'
then  'water is boiled'.

rule deduce_makingTea_AddTeabag
backward
if 'teacup is empty'
then  'teabag in cup'.

rule deduce_makingTea_AddBoilingWater
backward
if 'teabag in cup' &
   'water is boiled'
then  'boiling water in cup'.


rule deduce_makingTea_BrewingTea
backward
if 'teabag in cup' &
   'boiling water in cup'
then  'tea has brewed'.

rule deduce_makingTea_RemoveTeaBag
backward
if 'teabag in cup' &
   'tea has brewed'
then  'teabag removed'.

rule deduce_makingTea_MilkRequired
backward
if 'teabag removed' &
   'milk required'
then  'milk requirement satisfied'.

rule deduce_makingTea_SugarRequired
backward
if 'teabag removed' &
   'sugar required'
then 'sugar requirement satisfied'.

rule deduce_makingTea_StirringMilkAndSugar
backward
if 'milk requirement satisfied' &
   'sugar requirement satisfied'
then  'tea has been stirred'.


/* this rule is the one that triggers the deduction */
rule deduce_makingTea_TeaIsMade
backward
if 'tea has been stirred'
then  'tea is ready'.





