/* PD624 Unit2 Code : sample solution for exercise 2.11 */
/*
example symptom descriptors might be as follows

Alice has a dry throat, a muzzy feeling in the head, a runny nose, sneezing
and a slight transient fever, i.e. nothing worse than the common cold.  In
MIKE list style syntax this would look like the following :

[alice, has, dry_throat]
[alice, has, muzzy_feeling_head]
[alice, has, runny_nose]
[alice, is, sneezing]
[alice, has, slight_transient_fever]

Bert has a blocked and runny nose, he is sneezing, and his eyes are red,
itchey, and watering.  Bert is thus a hay-fever sufferer.  The MIKE for the
following is listed below.

[bert, has, runny_nose]
[bert, has, blocked_nose]
[bert, is, sneezing]
[bert, has, red_itchy_watery_eyes]

Another sufferer of the common cold in Charlie.  He has a dry throat, a
muzzy feeling in the head, a runny nose and sneezing, and has a slight
transient fever.  A MIKE version follows.

[charlie, has, dry_throat]
[charlie, has, muzzy_feeling_head]
[charlie, has, runny_nose]
[charlie, is, sneezing]
[charlie, has, slight_transient_fever]

Poor Donna's got laryngitis.  Her symptoms are a persistent dry cough, a
hoarse voice, laryngeal discomfort, slight transient fever, and malaise.
A MIKE version follows:-

[donna, has, persistent_dry_cough]
[donna, has, hoarse_voice]
[donna, has, laryngeal_discomfort]
[donna, has, slight_transient_fever]
[donna, has, malaise]

Eva has influenza.  She has a persistent dry cough, a sore throat, slight
transient fever, shivering, malaise, a headache, and is suffering from diffuse
aches and pains.

[eva, has, persistent_dry_cough]
[eva, has, sore_throat]
[eva, has, slight_transient_fever]
[eva, is, shivering]
[eva, has, malaise]
[eva, has, headache]
[eva, has, aches_and_pains]

Finally Frank has seasonal allergic rhinitis, better known as hay fever.
He has a runny nose, a blocked nose, sneezing, and soar red eyes.

[frank, has, runny_nose]
[frank, has, blocked_nose]
[frank, is, sneezing]
[frank, has, red_itchy_watery_eyes].

To 'seed' working memory with the above facts, you would need to use
'add', as described in Appendix B, section 3.3.3.  For example:

  ?- add [frank, has, runny_nose].
  ?- add [frank, has, blocked_nose].

Alternatively, the appropriate facts could be added as part of the
right-hand side of your very first rule, e.g.
  rule init forward
    if
      start
    then
      add [frank, has, runny_nose] &
      add [frank, has, blocked_nose] &
      add [frank, is, sneezing] &
      add [frank, has, red_itchy_watery_eyes].

The file ans2-12 shows these facts being used in answer to exercise 2-12.
*/