             /* Program ELIZA */
  /* A re-working of the old standby, in PROLOG,*/
  /*		by Neil J. Rubenking		*/
  /*						*/
  /*   BE WARNED:  I'm not a PROLOG expert.	*/
  /* (Not yet!)  The program works, but don't	*/
  /* look for elegance here.			*/
             

code = 2048
domains
	words = string*
	Line = string
database
	xxresponse(integer, words, words) /* read from file ELIZA.DBA*/
predicates
	run	
	Do_Line
	repeat
	response(string)
	splitup(string, words)
	myfronttoken(string,string,string)
	part_of(words,words,words)
	append(words,words,words)
	UpLowList(words,words)
	yresponse(integer,words,words)
	rand(integer,integer)
	finish(words,words)
	conjugate(words,words)
	conj(words,words)
	WriteList(words)

	xresponse(integer,words,words)
	change(words,words)

goal
	run.
clauses
	run :-
		consult("eliza.dba"),
		MakeWindow(1,7,97,"ELIZA",0,0,25,80),
		MakeWindow(1,7,0,"",2,2,21,76),
		Write("Hello, I am ELIZA.  Please state your problem."),
		nl,
		Write("Enter a blank line to end the conversation."),
		 nl,
		Do_Line.

	Do_Line :- repeat,
		Write(":>"),
		ReadLn(Line),
		Response(Line). /* Response normally FAILS, causing	*/
				/* a repeat.  Only if the input	string	*/
				/* is empty does Response succeed.	*/

	repeat.
	repeat:-repeat.

	response(""):- /* This makes it quit on receiving a blank line */
		Write("See me again in a week!  That will be $100."), nl.

	response(UserIn) :-
		splitup(UserIn,UserList),	/* Make the input line into a list	*/
		Part_Of(OneKey,Rest,UserList),	/* Split the list up into parts		*/
		UpLowList(Ups,OneKey),		/* Upper-case the KEY part		*/
		yresponse(_,Ups,OutList),!,	/* Check it agains the database -- CUT	*/
						/*   as soon as you get an answer.	*/
		finish(OutList,Rest),!,fail.	/* Patch together a response.		*/


	response(_) if response("NOKEYZXQ").	/* IF you make it past the previous,	*/
						/* was no key, so get one of the "no	*/
						/* key" responses.			*/

/* Split up the input string into a LIST of strings */
	splitup(S,[H|T]) if myfronttoken(S,H,S1),!,splitup(S1,T).
	splitup(_,[]).
	
/* Just like fronttoken, but it	 keeps contractions in one piece.*/
	myFrontToken(Str,Sym,Str1):-	
	fronttoken(Str,Sym1,Str1a),	
	fronttoken(Str1a,"'",Str1b),
	fronttoken(Str1b,Sym2,Str1),
	concat(Sym1,"'",Sym1a),
	concat(Sym1a,Sym2,Sym).
	
	myFrontToken(Str,Sym,Str1):-
	fronttoken(Str,Sym,Str1).


/* X is a part of Y if X is an ordered sub-list of Y.  W is the	*/
/* part of Y that follows X.  We will use this to break down the*/
/* input for the keyword search.				*/

	part_of(X,W,Y) if append(X,W,Y).	
	part_of(X,W,[_|Z]) if part_of(X,W,Z).

/* Note that the append here is somewhat different from that in	*/
/* most textbooks.  First, append([],X,X) FAILS -- don't need to*/
/* find [] twice.  Second, append(X,Y,[some list]), with the    */
/* list bound and X and Y free, will generate the LONGEST lists */
/* for X first.  We use this, e.g., to find "You are" before we */
/* find just plain "you".					*/

	append([X|L1], L2, [X|L3]) if append(L1,L2,L3).
	append([X],L,[X|L]).

/* Upper-to-lower case conversion for a LIST of strings.*/
	UpLowList([],[]).
	UpLowList([X|T],[Y|U]) if upper_lower(X,Y) and UpLowList(T,U).

/* This routine "decides" randomly which response to use for	*/
/* a given keyword.  The data is arranged so that the LARGEST	*/
/* number is encountered first.  Yresponse is always called 	*/
/* with Num FREE, so Num gets instantiated to the largest.  It	*/
/* then gets processed by Rand into a new number between 1 and  */
/* Num, and we return the response that goes with that number.	*/
	yresponse(Num,Key,Resp) :-
		xresponse(Num,Key,_),!,
		rand(Num,NewNum),
		xresponse(NewNum,Key,Resp).

/* (i,o), returns a number from 1 to X.  (i,i), returns true	*/
/* 1/Xth of the time.						*/
	rand(X,Y) if random(Z), Y=(X-1)*Z + 1.

/* If the response list begins with a "*", we are to take the	*/
/* part of the input string following the keyword, conjugate it,*/
/* and append it to the output before writing the output.  If	*/
/* no "*", we just write the output.				*/
	finish(["*"|OList],Rest) IF
		conjugate(Rest, Rest2),
		append(OList,Rest2,OutMost),
		write("ELIZA: "),
		not(WriteList(OutMost)).

	finish(OList,_) IF write("ELIZA: "), not(WriteList(OList)).

/* Before trying to conjugate a string, we stick begin and end	*/
/* markers on it.  I didn't use these much, but they could come	*/
/* in handy.  Note how nicely append can be used both to stick	*/
/* the markers on and to take them off afterward!		*/
	conjugate(InList, OutList) :-
		append(["ZXQbegin"],InList,List2),
		append(List2,["ZXQend"],List3),
		conj(List3,NewList),
		append(List4,["ZXQend"],NewList),
		append(["ZXQbegin"],OutList,List4).

/* The heart of the conjugation scheme.  [] conjugates to [].	*/
/* Append splits X up into Z1 and R1.  IF we can change Z1 into	*/
/* Z2, and IF we can conj R1 into R2, then we stick Z2 and R2	*/
/* together and return them as Y.				*/

	conj([],[]).

	conj(X,Y) :-
		append(Z1,R1,X),
		change(Z1,Z2),!,
		conj(R1,R2),
		append(Z2,R2,Y).

/* Write a list of words as a single line.  Needs the "fail" to stop!	*/
	WriteList([]).
	WriteList([H|T]) if write(H," ") and WriteList(T) and nl and fail.


/* xresponse calls on the database xxresponse.  First, if a key is	*/
/* found, it just returns that response.  If the desired key is not	*/
/* found, a number of rules follow that basically give synonyms for	*/
/* items in the database.						*/

	xresponse(N,Key,Resp) if xxresponse(N,Key,Resp).
	xresponse(N,["YOU'RE"],X) if xxresponse(N,["YOU","ARE"],X).
	xresponse(N,["YOURE"],X) if xxresponse(N,["YOU","ARE"],X).
	xresponse(N,["WHY","DONT","YOU"],X) if xxresponse(N,["WHY","DON'T","YOU"],X).
	xresponse(N,["WHY","CANT","I"],X) if xxresponse(N,["WHY","CAN'T","I"],X).
	xresponse(N,["I","CANT"],X) if xxresponse(N,["I","CAN'T"],X).
	xresponse(N,["IM"],X) IF xxresponse(N,["I","AM"],X).
	xresponse(N,["I'M"],X) IF xxresponse(N,["I","AM"],X).
	xresponse(N,["WHO"],X) if xxresponse(N,["WHAT"],X).
	xresponse(N,["COMPUTER"],X) if xxresponse(N,["MACHINE"],X).
	xresponse(N,["WHEN"],X) if xxresponse(N,["WHAT"],X).
	xresponse(N,["HOW"],X) if xxresponse(N,["WHAT"],X).
	xresponse(N,["WHERE"],X) if xxresponse(N,["WHAT"],X).
	xresponse(N,["WHY"],X) if xxresponse(N,["WHAT"],X).
	xresponse(N,["BECAUSE"],X) if xxresponse(N,["CAUSE"],X).
	xresponse(N,["HI"],X) if xxresponse(N,["HELLO"],X).
	xresponse(N,["FATHER"],X) if xxresponse(N,["MOTHER"],X).
	xresponse(N,["SISTER"],X) if xxresponse(N,["MOTHER"],X).
	xresponse(N,["BROTHER"],X) if xxresponse(N,["MOTHER"],X).

/* change is used for conjugation.  Notice that there is a catchall	*/
/* "change(X,X)", so change always succeeds.				*/

	change(["You","are"],["I","am"]).
	change(["you","are"],["I","am"]).
	change(["I","am"],["you","are"]).
	change(["ZXQbegin","I","am"],["ZXQbegin","You","are"]).
	change(["you're"],["I'm"]).
	change(["You're"],["I'm"]).
	change(["I'm"],["you're"]).
	change(["ZXQbegin","I'm"],["ZXQbegin","you're"]).
	change(["you","."],["me","."]).
	change(["you","?"],["me","?"]).
	change(["you","!"],["me","!"]).
	change(["you","ZXQend"],["me","ZXQend"]).
	change(["to","you"],["to","me"]).
	change(["for","you"],["for","me"]).
	change(["of","you"],["of","me"]).
	change(["are","you"],["am","I"]).
	change(["Are","you"],["Am","I"]).
	change(["am","I"],["are","you"]).
	change(["Am","I"],["Are","you"]).
	change(["me"],["you"]).
	change(["you"],["I"]).
	change(["ZXQbegin","I"],["ZXQbegin","You"]).
	change(["I"],["you"]).
	change(["your"],["my"]).
	change(["my"],["your"]).
	change(["yours"],["mine"]).
	change(["mine"],["yours"]).
	change(["yourself"],["myself"]).
	change(["myself"],["yourself"]).
	change(X,X). /* The "catchall" -- X changes to X */
	
