
#|----------------------------------------------------------------------------
Artificial Intelligence, Second Edition
Elaine Rich and Kevin Knight
McGraw Hill, 1991

This code may be freely copied and used for educational or research purposes.
All software written by Kevin Knight.
Comments, bugs, improvements to knight@cs.cmu.edu
----------------------------------------------------------------------------|#

#|----------------------------------------------------------------------------
			    HOPFIELD NETWORKS
			     "hopfield.lisp"
----------------------------------------------------------------------------|#

;; -------------------------------------------------------------------------

;; Structure HOPNET defines a Hopfield network.  It consists of a number of 
;; units, a set of activations (a 1-d matrix), and a set of connections 
;; (a 2-d matrix).

(defstruct hopnet 
  size
  activations
  connections)


;; Variable *SAMPLE-NET* represents the network shown on page 490 of 
;; Artificial Intelligence.

(defvar *SAMPLE-NET* nil)

(setq *SAMPLE-NET*
  (make-hopnet
	:size 7
	:activations (make-array 7 
				 :initial-contents '(0 1 0 0 1 0 0))
	:connections (make-array '(7 7) 
				 :initial-contents
				      '((0 -1 1 -1 0 0 0)
					(-1 0 0 3 0 0 0)
					(1 0 -1 2 1 0 0)
					(-1 3 -1 0 0 -2 3)
					(0 0 2 0 0 1 0)
					(0 0 1 -2 1 0 -1)
					(0 0 0 3 0 -1 0)))))

;; Function PUT-NET-INTO-RANDOM-STATE scrambles the activation levels of the 
;; units in a network.

(defun put-net-into-random-state (net)
  (let ((size (hopnet-size net))
	(activations (hopnet-activations net)))
     (dotimes (i size) 
         (setf (aref activations i) (random 2)))
     (hopnet-activations net)))


;; Function SETTTLE implements Hopfield's algorithm for letting a network
;; settle into a stable state.

(defun settle (net epochs)
  (let ((size (hopnet-size net))
        (activations (hopnet-activations net))
        (connections (hopnet-connections net)))
    (dotimes (e (1+ epochs))
       (format t "Epoch ~4d:  " e)
       (print-activations net)
       (let ((u (random size))
	     (weighted-input 0))
	 (dotimes (i size)
	    (setq weighted-input
	          (+ weighted-input (* (aref activations i)
				       (aref (hopnet-connections net) u i)))))
	 (cond ((> weighted-input 0)
	        (setf (aref activations u) 1))
	       (t
	        (setf (aref activations u) 0)))))))


;; Function PRINT-ACTIVATIONS prints the activation levels of the units.

(defun print-activations (net)
  (dotimes (i (hopnet-size net))
     (format t "~2d" (aref (hopnet-activations net) i)))
  (format t "~%"))

