
/* this file will include those functions directly relevant to selecting the
animal's behaviour at each moment in time */


#include <stdio.h>
#include <math.h>
/*gn*/
#include <suntool/sunview.h>
/*gn*/
#include <suntool/panel.h>
/*gn*/
#include <suntool/canvas.h>
#include "../sim_env/structures.h"
#include "../sim_env/util_fns.h"
#include "../sim_env/env_defs.h"
#include "../sim_env/env_spec.h"
#include "../sim_env/animal_defs.h"
#include "asm_defs.h"
#include "asm_decs.h"


/* this function gets run every timestep in order to control the animal's
behaviour */
int select_action(arg1, arg2, arg3, arg4, arg5_1, arg5_2, arg6_1, arg6_2,
arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17,
arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25)
double arg1;			/* shortage of fat */
double arg2;			/* shortage of carbo */
double arg3;			/* shortage of protein */
double arg4;			/* shortage of water */
double arg5_1;			/* how much animal temp is below desirable */
double arg5_2;			/* how much animal temp is above desirable */
double arg6_1;			/* how much square temp is below desirable */
double arg6_2;			/* how much square temp is above desirable */
double arg7;			/* 'courtedness' of mate */
double arg8;			/* how clean the animal is */
double arg9;			/* closeness of nightfall */
double arg10;			/* estimated variance of the animal's position */
double arg11;			/* estimated distance from the animal to its den */
double *arg12;			/* stimulus of perceived food in all directions */
double *arg13;			/* stimulus of remembered food in all directions */
double *arg14;			/* stimulus of perceived water in all directions */
double *arg15;			/* stimulus of remembered water in all directions */
double *arg16;			/* stimulus of perceived shelter in all directions */
double *arg17;			/* stimulus of perceived shade in all directions */
double *arg18;			/* stimulus of perceived p1 in all directions */
double *arg19;			/* stimulus of perceived p2 in all directions */
double *arg20;			/* stimulus of perceived dp in all directions */
double *arg21;			/* stimulus of perceived irr in all directions */
double *arg22;			/* stimulus of perceived mate in all directions */
double *arg23;			/* stimulus of perceived den in all directions */
double *arg24;			/* stimulus of remembered den in all directions */
double *arg25;			/* stimulus of perceived edge in all directions */
{

  int i;

  /* assign parameters passed to behave_choice to global variables to be
  used for all behaviour functions */
  fat_minus = arg1;
  carbo_minus = arg2;
  protein_minus = arg3;
  water_minus = arg4;
  an_temp_minus= arg5_1;
  an_temp_plus = arg5_2;
  sqr_temp_minus= arg6_1;
  sqr_temp_plus = arg6_2;
  mate_courtedness = arg7;
  cleanliness = arg8;
  night_prox = arg9;
  variance = arg10;
  den_distance = arg11;

  /* get the maximums (and directions of them) for all direction dependent
  stimuli */
  get_maxs_and_dirs(arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19,
	arg20, arg21, arg22, arg23, arg24, arg25);



  /* <<< insert functions to choose action here >>> */



/*g*/  /* update the strategy display */
/*g*/  update_strategy_display();
/*g*/
  return(action);
}


/*g*//* function to update the strategy display */
/*g*/void update_strategy_display()
/*g*/{
/*g*/
/*g*/  update_long_profile();
/*g*/}
/*g*/
/*g*/
/* function to move the animal so that it approaches a particular square */
void approach(direction)
int direction;
{

  switch(direction) {

	case(N):  action = MOVE_N;
			  break;
	case(NW): action = MOVE_NW;
			  break;
	case(W):  action = MOVE_W;
			  break;
	case(SW): action = MOVE_SW;
			  break;
	case(S):  action = MOVE_S;
			  break;
	case(SE): action = MOVE_SE;
			  break;
	case(E):  action = MOVE_E;
			  break;
	case(NE): action = MOVE_NE;
			  break;
	case(SAME_SQUARE): action = RESTING;
			  break;
	default:  printf("bad direction passed to approach (%d)\n",
	  direction);
 }
}


/* function to move the animal so that it avoids a particular square */
void avoid(direction, stimulus)
int direction;
double *stimulus;
{

  int opp_direction, opp_direction_m1, opp_direction_p1;

  if (direction == SAME_SQUARE) {
	explore();
  }

  else {

	opp_direction = direction + 4;
	if (opp_direction >= 9)
	  opp_direction -= 8;

	/* if there is another instance of the feature to be avoided in the
	opposite direction then try one of the directions adjacent to the
	opposite one */ 
	if (stimulus[opp_direction] > 0.3) {

	  opp_direction_m1 = direction - 1;
	  if (opp_direction_m1 == 0)
		opp_direction_m1 = 8;
	  opp_direction_p1 = direction + 1;
	  if (opp_direction_p1 == 9)
		opp_direction_p1 = 1;

	  if (stimulus[opp_direction_m1] < 0.3)
		opp_direction = opp_direction_m1;
	  else if (stimulus[opp_direction_p1] < 0.3)
		opp_direction = opp_direction_p1;
	}

	switch(opp_direction) {

	  case(N):  action = MOVE_N;
				break;
	  case(NW): action = MOVE_NW;
				break;
	  case(W):  action = MOVE_W;
				break;
	  case(SW): action = MOVE_SW;
				break;
	  case(S):  action = MOVE_S;
				break;
	  case(SE): action = MOVE_SE;
				break;
	  case(E):  action = MOVE_E;
				break;
	  case(NE): action = MOVE_NE;
				break;
	  default:  printf("bad direction passed to avoid (%d)\n",
				  direction);
	}
  }
}


/* function to move the animal so that it runs away from a particular square */
void run_away_from(direction, stimulus)
int direction;
double *stimulus;
{

  int opp_direction, opp_direction_m1, opp_direction_p1;

  if (direction == SAME_SQUARE) {
	explore();
  }

  else {

	opp_direction = direction + 4;
	if (opp_direction >= 9)
	  opp_direction -= 8;

	/* if there is another instance of the feature to be avoided in the
	opposite direction then try one of the directions adjacent to the
	opposite one */ 
	if (stimulus[opp_direction] > 0.3) {

	  opp_direction_m1 = direction - 1;
	  if (opp_direction_m1 == 0)
		opp_direction_m1 = 8;
	  opp_direction_p1 = direction + 1;
	  if (opp_direction_p1 == 9)
		opp_direction_p1 = 1;

	  if (stimulus[opp_direction_m1] < 0.3)
		opp_direction = opp_direction_m1;
	  else if (stimulus[opp_direction_p1] < 0.3)
		opp_direction = opp_direction_p1;
	}

	switch(opp_direction) {

	  case(N):  action = MOVE2_N;
				break;
	  case(NW): action = MOVE2_NW;
				break;
	  case(W):  action = MOVE2_W;
				break;
	  case(SW): action = MOVE2_SW;
				break;
	  case(S):  action = MOVE2_S;
				break;
	  case(SE): action = MOVE2_SE;
				break;
	  case(E):  action = MOVE2_E;
				break;
	  case(NE): action = MOVE2_NE;
				break;
	  default:  printf("bad direction passed to run_away_from (%d)\n",
				  direction);
	}
  }
}


/* function to make the animal explore the environment */
void explore()
{

  static int counter;
  static int direction;
  double north_prob, east_prob, south_prob, west_prob;
  int c_change, r_change;

  if (counter > 6)
	counter = 0;

  /* set new random direction */
  if (counter == 0)
	direction = (int) rnd(8.0);

  counter++;

  action = RESTING;

  /* the animal does not stay still when exploring */
  while (action == RESTING) {

	/* use the direction to set probabilities of movement in different
	directions */
	switch (direction) {

      case (0): north_prob = 0.7;
                east_prob  = 0.1;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (1): north_prob = 0.4;
                east_prob  = 0.4;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (2): north_prob = 0.1;
                east_prob  = 0.7;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (3): north_prob = 0.1;
                east_prob  = 0.4;
                south_prob = 0.4;
                west_prob  = 0.1;
                break;
      case (4): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.7;
                west_prob  = 0.1;
                break;
      case (5): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.4;
                west_prob  = 0.4;
                break;
      case (6): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.1;
                west_prob  = 0.7;
                break;
      case (7): north_prob = 0.4;
                east_prob  = 0.1;
                south_prob = 0.1;
			    west_prob  = 0.4;
                break;
	}

	c_change = 0;
	r_change = 0;

	/* decide which direction to move in */
	if (drand48() < east_prob)
      c_change++;
	if (drand48() < west_prob)
      c_change--;
	if (drand48() < north_prob)
      r_change--;
	if (drand48() < south_prob)
      r_change++;

	if (c_change > 0) {
      if (r_change > 0)
		action = MOVE_SE;
      else if (r_change == 0)
		action = MOVE_E;
      else
		action = MOVE_NE;
	}
	else if (c_change == 0) {
	  if (r_change > 0)
		action = MOVE_S;
	  else if (r_change == 0)
		action = RESTING;
	  else
		action = MOVE_N;
	}
	else {
      if (r_change > 0)
		action = MOVE_SW;
      else if (r_change == 0)
		action = MOVE_W;
      else
		action = MOVE_NW;
	}
  }
}


/* this function gets called once at the beginning of the program to
initialise strategy variables */ 
void set_up_strategy()
{

/*g*/  /* also initialise a longitudinal profiles display */
/*g*/  set_up_long_profile();
}


/* function to look through the stimuli strengths for each type of stimulus
in each direction, and pick out the maximums of each type (over all
directions).  The direction of the maximum in each case is also calculated */
void get_maxs_and_dirs(food_perc_stimulus, food_memory_stimulus,
water_perc_stimulus, water_memory_stimulus, shelter_perc_stimulus,
shade_perc_stimulus, p1_perc_stimulus, p2_perc_stimulus, dp_perc_stimulus,
irr_perc_stimulus, mate_perc_stimulus, den_perc_stimulus,
den_memory_stimulus, edge_perc_stimulus)
double *food_perc_stimulus;
double *food_memory_stimulus;
double *water_perc_stimulus;
double *water_memory_stimulus;
double *shelter_perc_stimulus;
double *shade_perc_stimulus;
double *p1_perc_stimulus;
double *p2_perc_stimulus;
double *dp_perc_stimulus;
double *irr_perc_stimulus;
double *mate_perc_stimulus;
double *den_perc_stimulus;
double *den_memory_stimulus;
double *edge_perc_stimulus;
{

  int i;

  food_dir = -1;
  remembered_food_dir = -1;
  water_dir = -1;
  remembered_water_dir = -1;
  shelter_dir = -1;
  shade_dir = -1;
  p1_dir = -1;
  p2_dir = -1;
  dp_dir = -1;
  irr_dir = -1;
  mate_dir = -1;
  den_dir = -1;
  remembered_den_dir = -1;
  edge_dir = -1;

  max_food_perc_stimulus = 0.00001;
  max_food_memory_stimulus = 0.00001;
  max_water_perc_stimulus = 0.00001;
  max_water_memory_stimulus = 0.00001;
  max_shelter_perc_stimulus = 0.00001;
  max_shade_perc_stimulus = 0.00001;
  max_p1_perc_stimulus = 0.00001;
  max_p2_perc_stimulus = 0.00001;
  max_dp_perc_stimulus = 0.00001;
  max_irr_perc_stimulus = 0.00001;
  max_mate_perc_stimulus = 0.00001;
  max_den_perc_stimulus = 0.00001;
  max_den_memory_stimulus = 0.00001;
  max_edge_perc_stimulus = 0.00001;

  for (i = 0; i < NUM_DIRECTIONS; i++) {

	if (food_perc_stimulus[i] > max_food_perc_stimulus) {
	  max_food_perc_stimulus = food_perc_stimulus[i];
	  food_dir = i;
	}
	if (food_memory_stimulus[i] > max_food_memory_stimulus) {
	  max_food_memory_stimulus = food_memory_stimulus[i];
	  remembered_food_dir = i;
	}
	if (water_perc_stimulus[i] > max_water_perc_stimulus) {
	  max_water_perc_stimulus = water_perc_stimulus[i];
	  water_dir = i;
	}
	if (water_memory_stimulus[i] > max_water_memory_stimulus) {
	  max_water_memory_stimulus = water_memory_stimulus[i];
	  remembered_water_dir = i;
	}
	if (shelter_perc_stimulus[i] > max_shelter_perc_stimulus) {
	  max_shelter_perc_stimulus = shelter_perc_stimulus[i];
	  shelter_dir = i;
	}
	if (shade_perc_stimulus[i] > max_shade_perc_stimulus) {
	  max_shade_perc_stimulus = shade_perc_stimulus[i];
	  shade_dir = i;
	}
	if (p1_perc_stimulus[i] > max_p1_perc_stimulus) {
	  max_p1_perc_stimulus = p1_perc_stimulus[i];
	  p1_dir = i;
	}
	if (p2_perc_stimulus[i] > max_p2_perc_stimulus) {
	  max_p2_perc_stimulus = p2_perc_stimulus[i];
	  p2_dir = i;
	}
	if (dp_perc_stimulus[i] > max_dp_perc_stimulus) {
	  max_dp_perc_stimulus = dp_perc_stimulus[i];
	  dp_dir = i;
	}
	if (irr_perc_stimulus[i] > max_irr_perc_stimulus) {
	  max_irr_perc_stimulus = irr_perc_stimulus[i];
	  irr_dir = i;
	}
	if (mate_perc_stimulus[i] > max_mate_perc_stimulus) {
	  max_mate_perc_stimulus = mate_perc_stimulus[i];
	  mate_dir = i;
	}
	if (den_perc_stimulus[i] > max_den_perc_stimulus) {
	  max_den_perc_stimulus = den_perc_stimulus[i];
	  den_dir = i;
	}
	if (den_memory_stimulus[i] > max_den_memory_stimulus) {
	  max_den_memory_stimulus = den_memory_stimulus[i];
	  remembered_den_dir = i;
	}
	if (edge_perc_stimulus[i] > max_edge_perc_stimulus) {
	  max_edge_perc_stimulus = edge_perc_stimulus[i];
	  edge_dir = i;
	}
  }

  /* make very small stimuli equal to zero */
  if (max_food_perc_stimulus <= 0.00002)
	max_food_perc_stimulus = 0.0;
  if (max_food_memory_stimulus <= 0.00002)
	max_food_memory_stimulus = 0.0;
  if (max_water_perc_stimulus <= 0.00002)
	max_water_perc_stimulus = 0.0;
  if (max_water_memory_stimulus <= 0.00002)
	max_water_memory_stimulus = 0.0;
  if (max_shelter_perc_stimulus <= 0.00002)
	max_shelter_perc_stimulus = 0.0;
  if (max_shade_perc_stimulus <= 0.00002)
	max_shade_perc_stimulus = 0.0;
  if (max_p1_perc_stimulus <= 0.00002)
	max_p1_perc_stimulus = 0.0;
  if (max_p2_perc_stimulus <= 0.00002)
	max_p2_perc_stimulus = 0.0;
  if (max_dp_perc_stimulus <= 0.00002)
	max_dp_perc_stimulus = 0.0;
  if (max_irr_perc_stimulus <= 0.00002)
	max_irr_perc_stimulus = 0.0;
  if (max_mate_perc_stimulus <= 0.00002)
	max_mate_perc_stimulus = 0.0;
  if (max_den_perc_stimulus <= 0.00002)
	max_den_perc_stimulus = 0.0;
  if (max_den_memory_stimulus <= 0.00002)
	max_den_memory_stimulus = 0.0;
  if (max_edge_perc_stimulus <= 0.00002)
	max_edge_perc_stimulus = 0.0;
}


/* function to give the animal the appropriate action to look in a certain
direction */
void look_in_direction(dir)
int dir;
{

  switch(dir) {
	case(SAME_SQUARE):  action = RESTING;
			  break;
	case(N):  action = LOOKING_N;
			  break;
	case(NW): action = LOOKING_NW;
			  break;
	case(W):  action = LOOKING_W;
			  break;
	case(SW): action = LOOKING_SW;
			  break;
	case(S):  action = LOOKING_S;
			  break;
	case(SE): action = LOOKING_SE;
			  break;
	case(E):  action = LOOKING_E;
			  break;
	case(NE): action = LOOKING_NE;
			  break;
  }
}


/*g*//* function to initialise a display for longitudinal profiles for each */
/*g*//* sub-problem, showing motivational levels and occurrences of relevant */
/*g*//* actions */
/*g*/void set_up_long_profile()
/*g*/{
/*g*/
/*g*/  int i;
/*g*/
/*g*/  lpd_position = 0;
/*g*/
/*g*/  /* define a font for the display */
/*g*/  screen_r_7 = pf_open("/usr/lib/fonts/fixedwidthfonts/screen.r.7");
/*g*/
/*g*/  long_profile_frame = window_create(NULL, FRAME,
/*g*/    WIN_SHOW, FALSE,
/*g*/    FRAME_LABEL, "Longitudinal Profiles",
/*g*/    WIN_X, 400,
/*g*/    WIN_Y, 200,
/*g*/    WIN_WIDTH, LDP_WIDTH+10,
/*g*/    WIN_HEIGHT, (NUM_SYSTEMS_FOR_LPD*(LPD_ROW_HEIGHT+3)+3+25),
/*g*/    0);
/*g*/
/*g*/  long_profile_canvas = window_create(long_profile_frame, CANVAS,
/*g*/    WIN_SHOW, TRUE,
/*g*/    CANVAS_AUTO_SHRINK, TRUE,
/*g*/    CANVAS_AUTO_EXPAND, TRUE,
/*g*/    WIN_X, 0,
/*g*/    WIN_Y, 3,
/*g*/    WIN_WIDTH, LDP_WIDTH+6,
/*g*/    WIN_HEIGHT, (NUM_SYSTEMS_FOR_LPD*(LPD_ROW_HEIGHT+3)+3),
/*g*/    0);
/*g*/
/*g*/  long_profile_pw = canvas_pixwin(long_profile_canvas);
/*g*/
/*g*/  /* attach colourmap to pixwin */
/*g*/  pw_setcmsname(long_profile_pw, "doesntmatter");
/*g*/  pw_putcolormap(long_profile_pw, 0, CMAP_SIZE, red, green, blue);
/*g*/
/*g*/  /* draw in blank graphs for each system */
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/
/*g*/	pw_vector(long_profile_pw, 3, (3+i*(3+LPD_ROW_HEIGHT)), (LDP_WIDTH-3),
/*g*/	  (3+i*(3+LPD_ROW_HEIGHT)), (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (3+i*(3+LPD_ROW_HEIGHT)), 3, 
/*g*/	  (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)), (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (LDP_WIDTH-3), (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0); 
/*g*/	pw_vector(long_profile_pw, (LDP_WIDTH-3), (3+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (LDP_WIDTH-3), (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (3+i*(3+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT),
/*g*/	  (LDP_WIDTH-3), (3+i*(3+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/  }
/*g*/
/*g*/  /* write in the names of each profile */
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+0*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Get Food");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+1*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Get Water");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+2*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Cool Down");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+3*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Warm Up");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+4*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Escape Predator 1");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+5*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Escape Predator 2");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+6*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Dangerous Place");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+7*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Irrelevant Animal");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+8*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Reproduce");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+9*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Reduce Variance");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+10*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Sleep in Den");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+11*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Clean");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+12*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Edge");
/*g*/  
/*g*/  /*pw_text (animal_pw, 44, 261, (PIX_SRC|PIX_COLOR(30)), serif_r_12, "Fatal");*/
/*g*/}
/*g*/
/*g*/
/*g*//* function to update each of the longitudinal profiles */
/*g*/void update_long_profile()
/*g*/{
/*g*/
/*g*/  int i, lpd_x = (4 + lpd_position), lpd_y;
/*g*/  static int old_lpd_x, old_lpd_y[NUM_SYSTEMS_FOR_LPD]; 
/*g*/
/*g*/  /* for each profile */
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/
/*g*/	/* calculate y-position of graph point (dependent on some measure */
/*g*/	/* of activation of the system) */
/*g*/
/*g*/	/* <<< look at ../drives/asm_functions.c for some idea of what to */
/*g*/	/* insert here >>> */
/*g*/
/*g*/	/* delete anything currently in the relevant part of the display */
/*g*/	pw_rop(long_profile_pw, lpd_x, (4+i*(3+LPD_ROW_HEIGHT)), 13,
/*g*/	  (LPD_GRAPH_HEIGHT-1), PIX_CLR, 0, 0, 0); 
/*g*/
/*g*/	/* draw in a small symbol to represent the current activation of */
/*g*/	/* the system (as long as not just gone back to beginning) */
/*g*/	if ((lpd_x-old_lpd_x) == 2)
/*g*/	  pw_vector(long_profile_pw, old_lpd_x, old_lpd_y[i], lpd_x, lpd_y,
/*g*/		(PIX_SRC|PIX_COLOR(40)), 0);
/*g*/
/*g*/	old_lpd_y[i] = lpd_y;
/*g*/  }
/*g*/
/*g*/  old_lpd_x = lpd_x;
/*g*/
/*g*/  /* delete any current blobs */
/*g*/  delete_lpd_blobs();
/*g*/
/*g*/  /* <<< look at ../drives/asm_functions.c for some idea of what to */
/*g*/  /* insert here >>> */
/*g*/
/*g*/  lpd_position = (lpd_position+2) % (LDP_WIDTH-20);
/*g*/}
/*g*/
/*g*/
/*g*//* function to draw a little blob when an action relevant to the */ 
/*g*//* system is chosen */
/*g*/void draw_lpd_blob(profile_number)
/*g*/int profile_number;
/*g*/{
/*g*/
/*g*/  int blob_x, blob_y;
/*g*/
/*g*/  /* calculate coordinates of blob (to go just beneath bar for relevant */
/*g*/  /* system, at current time */
/*g*/  blob_x = (3+lpd_position);
/*g*/  blob_y = 3+profile_number*(3+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT+1; 
/*g*/
/*g*/  pw_rop(long_profile_pw, blob_x, blob_y, 2, 3,
/*g*/	(PIX_SRC|PIX_COLOR(40)), 0, 0, 0); 
/*g*/}
/*g*/
/*g*/
/*g*//* function to delete any existing blobs */
/*g*/void delete_lpd_blobs()
/*g*/{
/*g*/
/*g*/  int i, blob_x, blob_y;
/*g*/
/*g*/  blob_x = (4 + lpd_position);
/*g*/
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/	blob_y = 3 + i*(3+LPD_ROW_HEIGHT) + LPD_GRAPH_HEIGHT + 1;
/*g*/	pw_rop(long_profile_pw, blob_x, blob_y, 13, 3, PIX_CLR, 0, 0, 0);
/*g*/  }
/*g*/}
/*g*/
/*g*/
/*g*/void profile_change_proc()
/*g*/{
/*g*/
/*g*/  if (window_get(long_profile_frame, WIN_SHOW) == FALSE) {
/*g*/	turn_on(long_profile_frame);
/*g*/	profile_display_on = TRUE;
/*g*/  }
/*g*/  else {
/*g*/	turn_off(long_profile_frame);
/*g*/	profile_display_on = FALSE;
/*g*/  }
/*g*/}
/*g*/
/*g*/
  
