
/* file containing function to liase with master process on another machine
via sockets */

#include "slave.h"


main(argc, argv)
int argc;
char *argv[];
{

  int i, b_c;
  struct rlimit core_desc;

  /* don't allow the program to dump core */
  getrlimit(&core_desc, RLIMIT_CORE);
  core_desc.rlim_cur = 0;
  setrlimit(&core_desc, RLIMIT_CORE);

  /* give the random number generator a random seed based on the time */
  set_rand_seed();

  /* open a slave socket and connect it the master */
  master_socket_id = make_slave_socket(MASTER_NAME, MASTER_PORTNUM);

  /* register with the master (send a dummy results packet) */
  reply_packet.gf = -1.0;
  reply_packet.indvdl_number = -1;
  gethostname(reply_packet.slave_name);
  send_message(master_socket_id, &reply_packet, sizeof(struct gf_struct));

  /* get a work packet (i.e. number of individual) from the master */
  get_message(master_socket_id, &work_packet, sizeof(struct work_struct));
  printf("starting number %d (type %d)\n", work_packet.indvdl_number,
	work_packet.slave_type); 
  fflush(stdout);

  sim_env_version = work_packet.slave_type;

  /* connection with master now established and first work packet received
  so proceed to do some work */ 

  /* loop */
  while (TRUE) {

	/* if the master does not want the slave to wait a little while and try
	again (there is no more useful work in this generation) */
	if (work_packet.indvdl_number != -1) {

	  /* calculate one evaluation of the action selection mechanimsm in the
	  simulated environment */
	  reply_packet.gf = ((double) behave(argc, argv));
	  reply_packet.lifespan = ((double) lifespan);

	  close(master_socket_id);

	  printf("gf = %g, lifespan = %g\n", reply_packet.gf,
		reply_packet.lifespan); 

	  /* try and make a connection with the master again */
	  master_socket_id = make_slave_socket(MASTER_NAME, MASTER_PORTNUM);

	  /* return result */
	  reply_packet.indvdl_number = work_packet.indvdl_number;
	  reply_packet.slave_type = sim_env_version;

	  b_c = send_message(master_socket_id, &reply_packet,
			sizeof(struct gf_struct)); 

	  /* get a new work packet (i.e. number of individual) from the master*/
	  b_c = get_message(master_socket_id, &work_packet,
			sizeof(struct work_struct));
	  printf("starting number %d (type %d)\n", work_packet.indvdl_number,
		work_packet.slave_type); 
	  fflush(stdout);

	  sim_env_version = work_packet.slave_type;

	  close(master_socket_id);
	}

	else {				/* if master wants slave to wait a while and then
						try again */

	  /* sleep for a minute */
	  sleep(60);

	  /* make g_f equal to -1 to show just re-registering */
	  reply_packet.gf = -1.0;

	  close(master_socket_id);

	  /* try and make a connection with the master again */
	  master_socket_id = make_slave_socket(MASTER_NAME, MASTER_PORTNUM);

	  b_c = send_message(master_socket_id, &reply_packet,
			sizeof(struct gf_struct));

	  /* get a new work packet (i.e. number of individual) from the master*/ 
	  b_c = get_message(master_socket_id, &work_packet,	sizeof(struct
		work_struct)); 
	  printf("starting number %d (type %d)\n", work_packet.indvdl_number,
		work_packet.slave_type); 
	  fflush(stdout);

	  sim_env_version = work_packet.slave_type;

	  close(master_socket_id);
	} 
  }
}


