
/*  this file contains external declarations for variables in the bits of
program that define how the environment works */


#include "env_spec.h"

extern int animal_alive;        /* boolean to indicate whether animal is
                                alive or dead */

extern int env_weather,
/*g*/    weather_display_on,         /* boolean to show if weather being displayed*/
/*g*/    paused,         	/* boolean to show if pause activated */
    timestep,
    daystep,
    part_of_day;

int first_den_c, first_den_r;	/* coordinates of the first den */

/*g*/extern FILE *analysis_info_f;

extern double rainfall_history,         /* average of recent rainfall */
      recent_rainfall[R_H_LENGTH],  /* rainfall totals for previous days */
      env_rainfall,             /* rainfall at a point in the day */
      total_day_rainfall,       /* sum of all rainfall during a day */      
      temp_history,             /* average of recent temperature */
      recent_temp[T_H_LENGTH],  /* recent temperatures */
      env_temp,                 /* temperature at a time in the day */
      total_day_temp,           /* sum of temperatures at ten times in day */
      min_temp,                 /* min. possible temperature for this weather*/
      max_temp,                 /* max. possible temperature for this weather*/
      env_dryness;              /* a measure of the lack of rainfall and
                                evaporation due to heat during recent past */

extern int den_r, den_c;		/* coordinates of the den */

extern char text[100];			/* general purpose text buffer */

/*g*/extern Frame weather_frame,
/*g*/             perception_frame,
/*g*/             nav_frame,
/*g*/             map_frame,
/*g*/             animal_frame;
/*g*/
/*g*/extern Canvas weather_canvas,
/*g*/              perception_canvas,
/*g*/              nav_canvas,
/*g*/              map_canvas,
/*g*/              animal_canvas;
/*g*/
/*g*/extern Pixwin *env_pw,
/*g*/              *weather_pw,
/*g*/              *perception_pw,
/*g*/              *nav_pw,
/*g*/              *map_pw,
/*g*/              *animal_pw;
/*g*/
/*g*/extern Panel weather_panel;
/*g*/
/*g*/extern Panel_item temp_slider,
/*g*/           temp_history_slider,
/*g*/           rainfall_slider,
/*g*/           rainfall_history_slider,
/*g*/           time_message,
/*g*/           day_message,
/*g*/           action_message,
/*g*/           daynight_message;
/*g*/
/*g*//* pixrects containing pictures of different environmental features */
/*g*/extern struct pixrect *feature_pr[NUM_FEATURE_TYPES];
/*g*/
/*g*//* pixrects containing weather images */
/*g*/extern struct pixrect *rain_pr, *cloud_pr, *ssun_pr;
/*g*/
/*g*/extern colormap_t *null_cmap;   /* null colormap */
/*g*/
/*g*//* fonts for program */
/*g*/extern struct pixfont *serif_r_12, *serif_r_14;
/*g*/
/*g*//* arrays for colourmap */
/*g*/extern u_char red[CMAP_SIZE], green[CMAP_SIZE], blue[CMAP_SIZE];
/*g*/
/*g*//* foreground and background colour */
/*g*/extern struct singlecolor fg_clr, *fg_clr_ptr, bg_clr, *bg_clr_ptr;
/*g*/
/*g*//* array of integers to hold rasterops */
/*g*/extern int op[CMAP_SIZE];
/*g*/
void process_command_line_args(),
/*g*/     read_in_images(),
/*g*/     set_up_graphics(),
/*g*/     set_up_fonts(),
/*g*/     env_win_proc(),
/*g*/     set_colourmap(),
/*g*/     set_ops(),
     init_feature_lists(),
     f_list_add(),
     f_list_remove(),
     init_weather(),
     init_rainfall(),
     init_temp(),
     init_dryness(),
     set_up_env(),
     get_rnd_pos(),
     get_rnd_pos_near_water(),
     get_rnd_side_pos(),
/*g*/     redraw_square(),
/*g*/     add_to_square(),
     update_1_env(),
     update_10_env(),
     update_day_env(),
     update_20day_env(),
     update_weather(),
     update_rainfall(),
     update_temp(),
/*g*/     update_weather_display(),
     update_1_cereal_food(),
     update_1_cover(),
     update_1_fruit_food(),
     update_1_shade(),
     update_1_water(),
     update_1_irrelevant(),
     update_1_mate(),
     update_1_predator_1(),
     update_1_predator_2(),
     update_1_prey(),
     update_10_water(),
     update_graded_features(),
     update_day_rainfall(),
     update_day_temp(),
     update_day_dryness(),
     update_day_cereal_food(),
     update_day_fruit_food(),
     update_day_water();
/*g*/void make_icon(),
/*g*/     set_up_weather_display(),
/*g*/     set_up_key_display(),
/*g*/     weather_change_proc(),
/*g*/     key_change_proc(),
/*g*/     quit_proc(),
/*g*/     pause_proc(),
/*g*/     restart_proc(),
/*g*/     faster_proc(),
/*g*/     slower_proc(),
/*g*/     turn_off_weather_proc();

double get_cereal_food_conditions();
double get_cereal_food_value();
double get_cereal_food_toxicity();
int get_cereal_food_toxicity_delay();

double get_cover_thickness();

double get_fruit_food_conditions();
int get_fruit_food_cycle_length();
double get_fruit_food_ripe_time();
int get_fruit_food_cycle_state();
double get_fruit_food_value();
double get_fruit_food_toxicity();
int get_fruit_food_toxicity_delay();

double get_irrelevant_north_prob();
double get_irrelevant_east_prob();
double get_irrelevant_south_prob();
double get_irrelevant_west_prob();

int get_mate_receptive();
int get_mate_courted();
double get_mate_north_prob();
double get_mate_east_prob();
double get_mate_south_prob();
double get_mate_west_prob();

double get_predator_1_size();
double get_predator_1_damage();
double get_predator_1_persistence();
double get_predator_1_time_chasing();
int get_predator_1_animal_spotted();
int get_predator_1_chasing_animal();
int get_predator_1_hungry();
double get_predator_1_north_prob();
double get_predator_1_east_prob();
double get_predator_1_south_prob();
double get_predator_1_west_prob();

double get_predator_2_damage();
double get_predator_2_persistence();
double get_predator_2_time_chasing();
int get_predator_2_animal_spotted();
int get_predator_2_chasing_animal();
int get_predator_2_hungry();
double get_predator_2_north_prob();
double get_predator_2_east_prob();
double get_predator_2_south_prob();
double get_predator_2_west_prob();

double get_prey_value();
double get_prey_north_prob();
double get_prey_east_prob();
double get_prey_south_prob();
double get_prey_west_prob();

double get_shade_thickness();

double get_water_average_size();
double get_water_value();
double get_water_toxicity();
int get_water_toxicity_delay();

int square_in_env();

int min_dist_to_water_source();

void head_to_nearest_water_source();

/* the environment consists of a 2D-array of structures containing
descriptions of the individual areas */
ENV_SQUARE env_arr[ENV_ARR_COLS][ENV_ARR_ROWS];

/* make an array of feature_lists, one for each type of feature (some will
not be used) */ 
FEATURE_LIST f_list[NUM_FEATURE_TYPES];

/* functions that return instantiated environmental features */
void get_cereal_food(),
     get_cover(),
     get_dangerous_places(),
     get_dens(),
     get_fruit_food(),
     get_irrelevants(),
     get_landmarks(),
     get_mates(),
     get_predator_1s(),
     get_predator_2s(),
     get_prey(),
     get_shade(),
     get_water();

/* packs */
IRRELEVANT_PACK_STRUCT irrelevant_pack[MAX_NUM_IRRELEVANT_PACKS];
PREDATOR_1_PACK_STRUCT predator_1_pack[MAX_NUM_PREDATOR_1_PACKS];

/* number of packs for each feature currently in env. */
extern int current_num_irrelevant_packs;
extern int current_num_predator_1_packs;

void go_direction();





