
/*  this file contains definitions related to the bits of program that
define how the environment works. (those definitions which have a large
effect on the nature of the environment, ie. the problem the animnal faces,
are in env_spec.h) */


/*g*//* the height of the 'control' panel */
/*gn*/
#define PANEL_HEIGHT    70
/*g*/
/*g*//* minimum allowable 'viewing box' dimensions */
/*gn*/
#define MIN_WIN_WIDTH   100
/*gn*/
#define MIN_WIN_HEIGHT  100
/*g*/
/*g*//* screen dimensions */
/*gn*/
#define SCREEN_WIDTH    		1152
/*gn*/
#define SCREEN_HEIGHT   		900
/*g*/
/*g*//* number of colours in colourmap */
/*gn*/
#define CMAP_SIZE       		128
/*gn*/
/*g*//* the length of the side of the square used for each env_array element */
/*gn*/
#define SQUARE_SIZE				31
/*g*/
/*g*//* the length of the side of the square used for plotting each env_array
/*g*//*element (shouldn't be larger than twice SQUARE_SIZE unless "redraw_square"
/*g*//*is changed) */ 
/*gn*/
#define IMAGE_SQUARE_SIZE		31

/* allot numbers for each type of feature (for when using arrays, etc) */
#define WATER_N                 0
#define TOXIC_N                 1
#define COVER_N                 2
#define SHADE_N                 3
#define DANGEROUS_PLACE_N       4
#define LANDMARK_N              5
#define CEREAL_FOOD_N           6
#define FRUIT_FOOD_N            7
#define DEN_N                   8
#define IRRELEVANT_N            9
#define MATE_N                  10
#define PREDATOR_1_N            11
#define PREDATOR_2_N            12
#define PREY_N                  13

/* allot a number for the animal (should be 1 greater than the number for
the last feature type) */
#define ANIMAL_N                14

/* allot a number to show that the square is outside the limits of the
environment */
#define OUTSIDE_ENV_N           15

/* the number of different types of environmental feature */
#define NUM_FEATURE_TYPES       16

/* allot numbers for the animal features in a separate ranking */
#define IRRELEVANT_A_N          0
#define MATE_A_N                1
#define PREDATOR_1_A_N          2
#define PREDATOR_2_A_N          3
#define PREY_A_N                4
#define ANIMAL_A_N				5

/* number of features types which are animal (as opposed to physical) */
#define NUM_ANIMAL_F_TYPES		6

/* function to test for whether a feature is a physical one */
#define PHYSICAL_FEATURE(F)		((F==WATER_N)||(F==COVER_N)||(F==SHADE_N)||\
(F==DANGEROUS_PLACE_N)||(F==LANDMARK_N)||(F==CEREAL_FOOD_N)||\
(F==FRUIT_FOOD_N)||(F==DEN_N))

/* function to test for whether a feature is an animal one */
#define ANIMAL_FEATURE(F)		((F==ANIMAL_N)||(F==IRRELEVANT_N)||\
(F==MATE_N)||(F==PREDATOR_1_N)||(F==PREDATOR_2_N)||(F==PREY_N))

/*g*//* function to test for whether a feature is graded by colour */
/*gn*/
#define COLOUR_GRADED(F)		((F==WATER_N)||(F==COVER_N)||(F==SHADE_N)||\
/*gn*/\
(F==CEREAL_FOOD_N)||(F==FRUIT_FOOD_N))

/* maximum likely number of occurrences of each type of environmental
feature */
#define MAX_NUM_CEREAL_FOOD     200
#define MAX_NUM_COVER           300
#define MAX_NUM_DANGEROUS_PLACE 200
#define MAX_NUM_DEN             100
#define MAX_NUM_FRUIT_FOOD      200
#define MAX_NUM_IRRELEVANT      200
#define MAX_NUM_LANDMARK        200
#define MAX_NUM_MATE            200
#define MAX_NUM_PREDATOR_1      200
#define MAX_NUM_PREDATOR_2      200
#define MAX_NUM_PREY            300
#define MAX_NUM_SHADE           200
#define MAX_NUM_WATER           300
#define MAX_NUM_TOXIC           500

/* maximum number of any type of feature (ie. largest of above) */
#define MAX_NUM_ANY_FEATURE_TYPE        500

/*g*//* the number of grades of a distinguishing colour to be used for features
/*g*//*for which important attributes (eg food_value) differ */
/*gn*/
#define NUM_COLOUR_BANDS        5

/* the optimum average rainfall for plant growth */
#define OPT_DRYNESS             0.825

/* true and false */
#define TRUE                    1
#define FALSE                   0

/* used to show that a feature exists in a square when there is no structure
to be pointed to */
#define NOT_NULL                (NULL+1)

/* pi */
#define PI                      3.1415927

/* allot numbers for the separate parts of the day/night cycle */
#define NIGHT			0
#define SUNRISE			1
#define MORNING			2
#define MIDDAY			3
#define AFTERNOON		4
#define SUNSET			5

/* times (floating point values) of sunrise and sunset (ie. timestep values
at those occasions) */
#define SUNRISE_TIME	((double) ((int) (2.0 * ((double) DAY_LENGTH) / 12.0)))
#define SUNSET_TIME		((double) ((int) (10.0 * ((double) DAY_LENGTH) / 12.0)))

/* flag for trace file to show that a new event is about to be described */
#define NEW_EVENT_FLAG	9898989898



