/* program to remove from files all lines beginning with /*g*/
/* and to remove all lines immediately after /*gn*/
/* i.e. all those lines which are required only for graphics output */
/* the program then puts the resulting file in the ../no_graphics directory */
/* this is a special version to work on files going from ../asm/ to
../asm_ng/ */

#define MAX_LINE_LENGTH         1000

#include <stdio.h>

int getline_from_file();
FILE *fopenwithcheck();

char text[200];
char line_string[MAX_LINE_LENGTH];
char text1[MAX_LINE_LENGTH];
char *beg_str_ptr;
char *strstr();

FILE *in_file, *out_file;

main(argc, argv)
int argc;
char *argv[];
{

  int i, j;
  int copied_count;
  int removed_count;
  int str_len;

  if (argc < 2) {

	printf("no arguments (no files to degraph and cp to ../no_graphics/)\n");
	exit(0);
  }

  for (i = 1; i < argc; ++i) {

	copied_count = 0;
	removed_count = 0;

	sprintf(text, "../asm/%s", argv[i]);
    in_file = fopenwithcheck(text, "r");

	sprintf(text, "../asm_ng/%s", argv[i]);
	out_file = fopenwithcheck(text, "w");

    while ((str_len = getline_from_file(line_string, MAX_LINE_LENGTH)) > 0) {

	  /* don't copy line into file if it begins with /*g*/
      if ((line_string[0] == '/') &&
          (line_string[1] == '*') &&
          (line_string[2] == 'g') &&
          (line_string[3] == '*') &&
          (line_string[4] == '/')) {

		/* do nothing */

		removed_count++;
	  }

	  /* don't copy next line into file either if this begins with /*gn*/
	  else if ((line_string[0] == '/') &&
          	   (line_string[1] == '*') &&
          	   (line_string[2] == 'g') &&
          	   (line_string[3] == 'n') &&
          	   (line_string[4] == '*') &&
          	   (line_string[5] == '/')) {

		getline_from_file(line_string, MAX_LINE_LENGTH);

        removed_count += 2;
	  }

	  /* if line contains string "../asm/" then convert that into
	  "../asm_ng/" and then copy line to output file */
	  else if (strstr(line_string, "../asm/") != NULL) {
		/* copy up to beginning of string into text */
		j = 0;
		beg_str_ptr = (char *) strstr(line_string, "../asm/");
		while ((&(line_string[j])) != beg_str_ptr) {
		  text1[j] = line_string[j];
		  j++;
		}
		/* put in new middle bit */
		text1[j+0] = '.';
		text1[j+1] = '.';
		text1[j+2] = '/';
		text1[j+3] = 'a';
		text1[j+4] = 's';
		text1[j+5] = 'm';
		text1[j+6] = '_';
		text1[j+7] = 'n';
		text1[j+8] = 'g';
		text1[j+9] = '/';
		/* copy in end of string */
		for (j = j+7; j < str_len; j++)
		  text1[j+3] = line_string[j];
		printf("%s\n", text1);
		for (j = 0; j < (str_len+3); ++j)
          fprintf(out_file, "%c", text1[j]);
	  }

	  /* if line contains string "../sim_env/" then convert that into
	  "../no_graphics/" and then copy line to output file */
	  else if (strstr(line_string, "../sim_env/") != NULL) {
		/* copy up to beginning of string into text */
		j = 0;
		beg_str_ptr = (char *) strstr(line_string, "../sim_env/");
		while ((&line_string[j]) != beg_str_ptr) {
		  text1[j] = line_string[j];
		  j++;
		}
		/* put in new middle bit */
		text1[j+0] = '.';
		text1[j+1] = '.';
		text1[j+2] = '/';
		text1[j+3] = 'n';
		text1[j+4] = 'o';
		text1[j+5] = '_';
		text1[j+6] = 'g';
		text1[j+7] = 'r';
		text1[j+8] = 'a';
		text1[j+9] = 'p';
		text1[j+10] = 'h';
		text1[j+11] = 'i';
		text1[j+12] = 'c';
		text1[j+13] = 's';
		text1[j+14] = '/';
		/* copy in end of string */
		for (j = j+11; j < str_len; j++)
		  text1[j+4] = line_string[j];
		printf("%s\n", text1);
		for (j = 0; j < (str_len+4); ++j)
          fprintf(out_file, "%c", text1[j]);
	  }

	  /* otherwise line is normal and so copy it into output file */
	  else {

        for (j = 0; j < str_len; ++j)
          fprintf(out_file, "%c", line_string[j]);

        copied_count++;
      }

	  /* clear line_string */
	  for (j = 0; j < 50; j++)
		line_string[j] = ' ';
    }

    fclose(in_file);
    fclose(out_file);

	printf("\nto_no_graphics completed: %d lines copied, %d lines removed",
	  copied_count, removed_count);
	printf(" from %s\n", argv[i]);
  }
}


/*******************************************************************************
*       FUNCTION TO OPEN FILES WITH ERROR MESSAGES IF THEY CAN'T BE OPENED     *
*******************************************************************************/

FILE *fopenwithcheck(filename, type)
char filename[];			/* name of file to be opened */
char *type;			/* mode for which to open file */
{

	FILE *file;		/* file to be opened */
	char message[100];	/* error message if file can't be opened */

	/* if it is not possible to open file */
	if ((file = fopen(filename, type)) == NULL) {

		/* create and print an error message and then quit */
		sprintf(message, "%s does not exist or cannot be opened\n",
		filename);
		printf(message);
		exit(0);
	}

	/* else return a pointer to the opened file */
	return(file);
}


/* function to read in a line of the file into a buffer */
int getline_from_file(s, lim)
char s[];
int lim;
{

  int i;
  char c;

  for (i=0; i<lim-1; ++i) 

    if (fscanf(in_file, "%c", &c) == EOF) {

      s[i] = '\0';

      return(0);
    }

    else if (c == '\n') {

      s[i] = c;

      return(i+1);
    }

    else

      s[i] = c;
}



