

/* This file contains those definitions relating to the interactions of the
animal with the environment (those definitions which have a large effect on
the nature of the environment, ie. the problem the animnal faces, are in
env_spec.h) */


/*g*//* dimensions of animal perception display */
/*gn*/
#define PERC_WIN_WIDTH          ((2*M_A_P+1)*IMAGE_SQUARE_SIZE+30)
/*gn*/
#define PERC_WIN_HEIGHT         ((2*M_A_P+1)*IMAGE_SQUARE_SIZE+60)

/* identifiers for the different animal actions; lowest-level first then
higher, more abstract, descriptions */
#define SLEEPING                0
#define RESTING                 1
#define FREEZING                2
#define EATING_CF               3
#define EATING_FF               4
#define DRINKING                5
#define CLEANING				6
#define COURT_DISPLAYING        7
#define MATING                  8
#define POUNCING                9
#define LOOKING_AROUND			10
/* 8 looking-in-a-direction actions */
#define LOOKING_N				11
#define LOOKING_NE				12
#define LOOKING_E				13
#define LOOKING_SE				14
#define LOOKING_S				15
#define LOOKING_SW				16
#define LOOKING_W				17
#define LOOKING_NW				18
/* 8 moving actions */
#define MOVE_N					19
#define MOVE_NE					20
#define MOVE_E					21
#define MOVE_SE					22
#define MOVE_S					23
#define MOVE_SW					24
#define MOVE_W					25
#define MOVE_NW					26
/* 8 moving fast actions */
#define MOVE2_N					27
#define MOVE2_NE				28
#define MOVE2_E					29
#define MOVE2_SE				30
#define MOVE2_S					31
#define MOVE2_SW				32
#define MOVE2_W					33
#define MOVE2_NW				34

/* the number of different possible animal actions */
#define NUM_LOW_LEVEL_ACTIONS   35

/* macros to calculate if an action is of a certain type */
#define MOVE_ACTION(I)					((I==MOVE_N)||(I==MOVE_NW)||(I==MOVE_W)||\
(I==MOVE_SW)||(I==MOVE_S)||(I==MOVE_SE)||(I==MOVE_E)||(I==MOVE_NE))

#define MOVE_FAST_ACTION(J)				((J==MOVE2_N)||(J==MOVE2_NW)||(J==MOVE2_W)||\
(J==MOVE2_SW)||(J==MOVE2_S)||(J==MOVE2_SE)||(J==MOVE2_E)||(J==MOVE2_NE))

#define DIRECTED_LOOK_ACTION(K)			((K==LOOKING_N)||(K==LOOKING_NW)||\
(K==LOOKING_W)||(K==LOOKING_SW)||(K==LOOKING_S)||(K==LOOKING_SE)||(K==LOOKING_E)||\
(K==LOOKING_NE))

#define EAT_ACTION(L)					((L==EATING_CF)||(L==EATING_FF)||\
(L==POUNCING))

/* the maximum number of features that are ever likely to occur in the field
of perception for the animal */
#define MAX_NUM_PERC_FEATURES	(3*(2*(M_A_P*2+1)*(M_A_P*2+1)))

/* the maximum number of any individual type of feature that is likely to
occur at any one time in the field of perception for the animal */
#define MAX_NUM_SINGLE_PERC_FEATURE     50

/* the maximum likely value of the variable 'genetic_fitness'.  This will be
used in order to draw the genetic fitness graph on the animal stats display */
#define MAX_LIKELY_G_F			25.0

/* minimum value of food or water, below which it is not worth the animal
eating or drinking from that source */
#define MIN_WORTHWHILE_VALUE	0.01

/* maximum value of toxicity in food or water, above which it is not worth
the animal eating or drinking from that source */
#define MAX_ACCEPTABLE_TOXICITY	0.40

/* time for which the animal should ignore water or a food type if it has
been visited recently with unsuccessful results */
#define IGNORE_USELESS_TIME		10

/* minimum thickness of cover, below which it is not worth the animal using 
the cover to hide in */ 
#define MIN_WORTHWHILE_COVER	0.30

/* allot a number to each food constituent */
#define FAT_N							0
#define CARBO_N							1
#define PROTEIN_N						2

/* numbers for each direction */
#define SAME_SQUARE						0
#define N								1
#define NE								2
#define E								3
#define SE								4
#define S								5
#define SW								6
#define W								7
#define NW								8

#define NUM_DIRECTIONS					9

#define STD                     0
#define V1                      1
#define V2                      2
#define V3                      3

