
/* This file contains definitions for those variables, functions, etc used in
the behavioral choice programs */


#include "animal_defs.h"

int animal_c, animal_r;         /* coordinates of animal */
int c_change, r_change;         /* changes in above at each timestep */
int prev_animal_c, prev_animal_r;  /* previous coordinates of animal */

int animal_action;				/* the action the animal chooses */

/*g*/int perc_display_on;    /* 'boolean' to show if display is off or on */
/*g*/int animal_display_on;  /* 'boolean' to show if display is off or on */
/*g*/int map_display_on;     /* 'boolean' to show if display is off or on */
/*g*/int nav_display_on;     /* 'boolean' to show if display is off or on */

double animal_age;			/* age of animal */

double animal_water,
      animal_fat,
      animal_carbo,
      animal_protein,
      animal_temp,
      animal_health,
	  animal_perm_inj,			/* the amount of permanently harmful injury
								(eg broken bones) the animal has incurred */
	  animal_max_health;		/* this is a function of age and injury and
								is equal to the health value if all
								homeostatic variables are in their ranges */

double animal_conspicuousness;   /* between 0.0 and 1.0, higher = more
                                conspicuous */

double animal_escape_prob;		/* between 0.0 and 1.0, higher = more likely
								to be able to escape an attack this timestep */

int genetic_fitness;

double animal_cleanliness;

/* times since various types of feature unsuccessfully visited */
int time_since_useless_cereal_food;
int time_since_useless_fruit_food;
int time_since_useless_water;

/*g*/Frame perception_frame,
/*g*/	  nav_frame,
/*g*/	  map_frame,
/*g*/      animal_frame;

/*g*/Canvas perception_canvas,
/*g*/	   nav_canvas,
/*g*/	   map_canvas,
/*g*/       animal_canvas;

/*g*/Pixwin *perception_pw,
/*g*/	   *nav_pw,
/*g*/	   *map_pw,
/*g*/       *animal_pw;

/*g*//* foreground and background colour */
/*g*/extern struct singlecolor fg_clr, *fg_clr_ptr, bg_clr, *bg_clr_ptr;
/*g*/

void set_up_animal(),
/*g*/     set_up_animal_display(),
/*g*/     set_up_perc_display(),
	 set_up_navigation(),
	 animal_perception(),
/*g*/     update_animal_display(),
	 animal_change_to_env(),
	 update_animal_map(),
	 env_change_to_animal(),
     strategy_choice(),
/*g*/     animal_change_proc(),
/*g*/     perception_change_proc(),
/*g*/     map_change_proc(),
/*g*/     nav_change_proc(),
     init_perc_struct(),
     sqr_to_perc_struct(),
	 rearrange_sqr(),
	 rearrange_int_sqr(),
     change_feature_props(),
	 delete_perc_instance(),
     make_up_perc_instance(),
/*g*/     draw_perc_square(),
	 animal_effect_on_cereal_food(),
	 cover_effect_on_animal(),
	 dangerous_place_effect_on_animal(),
	 den_effect_on_animal(),
	 animal_effect_on_fruit_food(),
	 landmark_effect_on_animal(),
	 shade_effect_on_animal(),
	 animal_effect_on_water(),
	 irrelevant_effect_on_animal(),
     animal_effect_on_mate(),
     mate_effect_on_animal(),
	 predator_1_effect_on_animal(),
	 predator_2_effect_on_animal(),
	 animal_effect_on_prey(),
     outside_env_effect_on_animal(),
	 calc_animal_health(),
     get_conspicuousness(),
	 get_escape_prob(),
	 update_action_message(),
	 add_contrib_causes_to_analysis();
/*g*/void     destroy_animal_windows(),
/*g*/	 draw_memory(),
/*g*/	 draw_map();

extern int select_action();

int get_adj_square();

double get_rnd_multiplier();

int physical_feature_in_square(),
	feature_matches_memory_entry();

void update_recognised_feature(),
	 print_memory_entry(),
	 create_new_feature_memory(),
	 sort_map();
        
/* the direction in which the animal is looking (or sensing) if it's action
is 'LOOKING_DIRECTION' */
int direction_of_look;

/* structure containing everything that the animal can perceive */
PERC anim_perc;

/* array to hold details of delayed effects of toxic food/water */
TOXIC_INST toxic_array[100];

/* counter for number of cases in above */
int toxic_counter;

/* temperature in square (related to that in environment) */
double sqr_temp;
  
/* array of place memories = navigation memory = `map' */
PLACE_MEMORY *map[MAP_SIZE];

/* the number of memories that have been put in the memory so far - this
will be equal to the size of the map after a short time */
int num_active_memories;

/* the animal's estimate of its current position */
double est_an_c, est_an_r;
double prev_est_an_c, prev_est_an_r;

/* how accurate the animal's estimate of its position is likely to be */
double an_pos_variance;

/* the number of uncertain steps the animal has taken since it left the den.
This value gets changed if the animal visits previously known places */
double num_uncertain_steps;

/* "boolean" to indicate whether the animal recognises this place (matches
it to a previous memory) or not */
int this_place_recognised;

/* "boolean" to indicate whether the animal has a memory of this feature in
its map (will not be the case if variane too high for instance).  The
variable `this_place` wil otherwise have a value of -1 */
int this_place_now_in_map;

/* index into map for the memory of this place (if there is one) */
int this_place;

/* two "boolean" variables to signify whether the animal has eaten or drunk
a sizeable amount this timestep */
int animal_eating;
int animal_drinking;

void regurgitate();

double action_effect_on_perc();

int move_action_chosen(),
	move_fast_action_chosen(),
	eat_action_chosen();

/* properties of current situation of environment */
double fat_shortage,
	  carbo_shortage,
	  protein_shortage,
	  water_shortage,
	  an_low_temp,
	  an_high_temp,
	  sqr_low_temp,
	  sqr_high_temp,
	  mate_courted,
	  night_proximity,
	  an_variance,
	  distance_from_den;

/* properties of current situation of environment which are dependent on
direction */
double food_perc_stimulus[9],
	   food_memory_stimulus[9],
	   water_perc_stimulus[9],
	   water_memory_stimulus[9],
	   shelter_perc_stimulus[9],
	   shade_perc_stimulus[9],
	   p1_perc_stimulus[9],
	   p2_perc_stimulus[9],
	   dp_perc_stimulus1[9],
	   dp_perc_stimulus2[9],
	   irr_perc_stimulus1[9],
	   irr_perc_stimulus2[9],
	   mate_perc_stimulus[9],
	   den_perc_stimulus[9],
	   den_memory_stimulus[9],
	   edge_perc_stimulus[9];

void calc_env_properties();

/* functions to calculate values describing current situation in environment*/
void zero_property_values(),
	 check_property_values(),
	 calc_fat_shortage(),
	 calc_carbo_shortage(),
	 calc_protein_shortage(),
	 calc_food_perc_stimulus(),
	 calc_food_memory_stimulus(),
	 calc_water_shortage(),
	 calc_water_perc_stimulus(),
	 calc_water_memory_stimulus(),
	 calc_low_temp(),
	 calc_shelter_perc_stimulus(),
	 calc_high_temp(),
	 calc_shade_perc_stimulus(),
	 calc_p1_perc_stimulus(),
	 calc_p2_perc_stimulus(),
	 calc_dp_perc_stimulus(),
	 calc_irr_perc_stimulus(),
	 calc_mate_perc_stimulus(),
	 calc_mate_courted(),
	 calc_night_proximity(),
	 calc_an_variance(),
	 calc_distance_from_den(),
	 calc_den_perc_stimulus(),
	 calc_den_memory_stimulus(),
	 calc_edge_perc_stimulus();

int time_since_animal_mated;
int time_since_animal_courting_rejected;

int desperate_for_food(),
	will_increase_food_imbalance();

int move_action_selected();
int move_fast_action_selected();
int eat_action_selected();

void find_toxic_food(),
	 find_toxic_water();

int food_toxic, water_toxic;

int food_value_too_low(),
	water_value_too_low();

int get_target_dir();

/* array to keep a record of how often each action has been performed during
the animal's lifetime */
int action_record[NUM_LOW_LEVEL_ACTIONS];

int prey_in_animal_square,
	cf_in_animal_square,
	ff_in_animal_square;

extern double stimuli_record[25];

extern int num_times_get_food_chosen;
extern int num_times_cleaning_chosen;

extern double drive_record[14];

int time_since_scanned;
double time_since_last_scan;

double min_distance_to_cover;
double distance_to_cover;

void update_distance_to_cover();

double est_last_cover_c, est_last_cover_r;

void free_animal_memory();

double prev_animal_temp;

int time_since_predator_perceived;
double time_since_last_pred;

int map_sze;
double nav_err;

extern int sim_env_version;

/*g*/void perc_display();
/*g*/void perc_copy();

extern FILE *tob_f;
