
/* this file contains functions to setup/initialise stuff for Pattie Maes's
behaviour selection mechanism */

#include <stdio.h>
#include <math.h>
/*gn*/
#include <suntool/sunview.h>
/*gn*/
#include <suntool/panel.h>
/*gn*/
#include <suntool/canvas.h>
#include "../sim_env/structures.h"
#include "../sim_env/util_fns.h"
#include "../sim_env/env_defs.h"
#include "../sim_env/env_spec.h"
#include "../sim_env/animal_defs.h"
#include "asm_defs.h"
#include "asm_decs.h"


/* this function gets run every timestep in order to control the animal's
behaviour */
int select_action(arg1, arg2, arg3, arg4, arg5_1, arg5_2, arg6_1, arg6_2,
arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17,
arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28,
arg29, arg30, arg31, arg32)
double arg1;			/* shortage of fat */
double arg2;			/* shortage of carbo */
double arg3;			/* shortage of protein */
double arg4;			/* shortage of water */
double arg5_1;			/* how much animal temp is below desirable */
double arg5_2;			/* how much animal temp is above desirable */
double arg6_1;			/* how much square temp is below desirable */
double arg6_2;			/* how much square temp is above desirable */
double arg7;			/* 'courtedness' of mate */
double arg8;			/* how clean the animal is */
double arg9;			/* closeness of nightfall */
double arg10;			/* estimated variance of the animal's position */
double arg11;			/* estimated distance from the animal to its den */
double *arg12;			/* stimulus of perceived food in all directions */
double *arg13;			/* stimulus of remembered food in all directions */
double *arg14;			/* stimulus of perceived water in all directions */
double *arg15;			/* stimulus of remembered water in all directions */
double *arg16;			/* stimulus of perceived shelter in all directions */
double *arg17;			/* stimulus of perceived shade in all directions */
double *arg18;			/* stimulus of perceived p1 in all directions */
double *arg19;			/* stimulus of perceived p2 in all directions */
double *arg20;			/* stimulus of perceived dp in all directions
						   (adjacent squares) */
double *arg21;			/* stimulus of perceived irr in all directions
						   (adjacent squares) */
double *arg22;			/* stimulus of perceived mate in all directions */
double *arg23;			/* stimulus of perceived den in all directions */
double *arg24;			/* stimulus of remembered den in all directions */
double *arg25;			/* stimulus of perceived edge in all directions */
double arg26;			/* how long it is since scanning for predators */
double arg27;			/* distance from cover */
double arg28;			/* time since predator last perceived */
double arg29;			/* animal health */
double arg30;			/* animal permanent injury */
double *arg31;			/* stimulus of perceived dp in all directions
						   (non-adjacent squares) */
double *arg32;			/* stimulus of perceived irr in all directions
						   (non-adjacent squares) */
{

  int i, j;
  int first_time;
  int cycle_count = 0;

  /* assign parameters passed to behave_choice to global variables to be
  used for all behaviour functions */
  fat_minus = arg1;
  carbo_minus = arg2;
  protein_minus = arg3;
  water_minus = arg4;
  an_temp_minus= arg5_1;
  an_temp_plus = arg5_2;
  sqr_temp_minus= arg6_1;
  sqr_temp_plus = arg6_2;
  mate_courtedness = arg7;
  cleanliness = arg8;
  night_prox = arg9;
  variance = arg10;
  den_distance = arg11;
  scan_time = arg26;
  cover_distance = arg27;
  time_since_predator = arg28;
  health = arg29;
  p_injury = arg30;

  /* reset value of last chosen node (it will now be slightly less likely to be
  chosen in the next timestep) */
  nodes[chosen_node].activation = 0.0;

  /* normalise all other activation levels */
  normalise_activation_levels();

  /* get the maximums (and directions of them) for all direction dependent
  stimuli */
  get_maxs_and_dirs(&(arg12[0]), &(arg13[0]), &(arg14[0]), &(arg15[0]),
	&(arg16[0]), &(arg17[0]), &(arg18[0]), &(arg19[0]), &(arg20[0]),
	&(arg21[0]), &(arg22[0]), &(arg23[0]), &(arg24[0]), &(arg25[0])); 

  /* work out which propositions about the environment are true and which
  false */
  calc_env_conditions(arg14, arg16, arg17);

  /* work out what the strengths of the animal's goals are */
  calc_animal_goals();

  /* reset the global threshold to its starting value */
  global_activation_threshold = theta;

  first_time = TRUE;

  while ((no_node_executable() == TRUE) || (first_time == TRUE)) {

	for (i = 0; i < num_nodes; i++)
	  num_inputs[i] = 0;

	cycle_count++;

	/* set post_spreading activation to current */
	for (i = 0; i < num_nodes; i++) {
	  if (nodes[i].activation < 0.0)
		nodes[i].activation = 0.0;
	  nodes[i].post_spreading_activation = nodes[i].activation;
	}

	input_excitation_from_env();

	input_excitation_from_goals();

	take_out_excitation_from_protected_goals();

	spread_excitation_to_predecessors();

	spread_excitation_to_successors();

	spread_excitation_to_conflictors();

	/* set current activation to post-spreading (this is needed so as to
	stop order of updating nodes being important) */
	for (i = 0; i < num_nodes; i++) {
	  if (nodes[i].post_spreading_activation < 0.0)
		nodes[i].post_spreading_activation = 0.0;
	  nodes[i].activation = nodes[i].post_spreading_activation;
	}

/*g*/	/* print out info. about inputs to nodes */
/*g*//*	for (i = 0; i < num_nodes; i++)*/
/*g*//*	  if ((i == 8) || (i == 10) || (i == 12) || (i == 27) || (i == 1) ||*/
/*g*//*		  (i == 2) || (i == 0)) {*/
/*g*//*		printf("%s (%.3f) >>>:\n", nodes[i].name, nodes[i].activation);*/
/*g*//*		for (j = 0; j < num_inputs[i]; j++)*/
/*g*//*		  printf("  %.3f along %s from %s\n", inputs[i][j].excitation,*/
/*g*//*			inputs[i][j].type_name, inputs[i][j].sender_name);*/
/*g*//*	  }*/
/*g*/
	if (first_time == FALSE)
	  reduce_global_threshold();

	first_time = FALSE;
  }

  largest_current_activation = 0.0;
  for (i = 0; i < num_nodes; i++)
	if ((nodes[i].activation > largest_current_activation) &&
		(all_node_preconditions_true(i) == TRUE))
	  largest_current_activation = nodes[i].activation;

/*g*//*  printf("after %d cycles: \n", cycle_count);*/
/*g*/

  /* execute chosen node */
  execute_module(arg18, arg19, arg20, arg21, arg25);

  return(action);
}


void set_up_strategy()
{

  chosen_node = 0;

  /* get values for the global parameters */
  init_global_parameters();

  /* input a set of nodes */
  init_node_list();

  /* input propositions (logical statements about the environment and the
  animal, ie. everything, which can be TRUE or FALSE) */
  init_propositions();

  /* initialise preconditions, add lists and delete lists for nodes */
  init_node_preconditions();
  init_node_add_lists();
  init_node_delete_lists();

  /* specify which propositions are environmental conditions or goals */
  init_env_conditions();
  init_goals();

  /* calculate how many predecessors each node has */
  calc_num_predecessors();

  global_activation_threshold = theta;

  init_node_activations();
/*g*/
/*g*/  /* also initialise a longitudinal profiles display */
/*g*/  set_up_long_profile();
}


/* this function reads in the values of the four global parameters from a
file of the form:
# theta (starting value of threshold)
<value>
# phi   (importance of activation input from environment)
<value>
# gamma (importance of activation input from goals)
<value>
# delta (importance of activation decrement from protected goals)
<value>
*/
void init_global_parameters()
{

  char text[200];
  FILE *f;

  f = fopenwithcheck(GLOBAL_PARAMS_FNAME, "r");

  getline(f, text, MAX_LINE_LENGTH);
  fscanf(f, "%lf\n", &theta);
  getline(f, text, MAX_LINE_LENGTH);
  fscanf(f, "%lf\n", &phi);
  getline(f, text, MAX_LINE_LENGTH);
  fscanf(f, "%lf\n", &gammaa);
  getline(f, text, MAX_LINE_LENGTH);
  fscanf(f, "%lf\n", &delta);
  fclose(f);
/*g*/
/*g*/  printf("4 global parameters read in\n");
}


/* this function reads in a list of all the nodes (and their names).  The
file will have the format:
<node name>
...[repeated as many times as necessary]
*/
void init_node_list()
{

  int i = -1;
  FILE *f;

  f = fopenwithcheck(NODE_LIST_FNAME, "r");

  num_nodes = 0;
  while (getline(f, nodes[num_nodes].name, MAX_LINE_LENGTH) != 0)
	num_nodes++;

  /* initialise fields in node structures */
  for (i = 0; i < num_nodes; i++) {
	nodes[i].num_preconditions = 0;
	nodes[i].add_list_size = 0;
	nodes[i].delete_list_size = 0;
	nodes[i].num_predecessors = 0;
	nodes[i].num_successors = 0;
	nodes[i].num_conflictors = 0;
  }

  fclose(f);
/*g*/
/*g*/  printf("%d nodes read in\n", num_nodes);
}


/* this function reads in a list of all propositions (logical statements
about the environment and the animal, ie. everything, which can be TRUE or
FALSE) and their names.  The format of the file will be:
<proposition name>
...[repeated as many times as necessary]
*/
void init_propositions()
{

  int i = 0;
  FILE *f;

  f = fopenwithcheck(PROPOSITIONS_FNAME, "r");

  while (getline(f, prop_names[i], MAX_LINE_LENGTH) != 0)
	i++;

  num_props = i;

  fclose(f);
/*g*/
/*g*/  printf("%d propositions read in\n", num_props);
}


/* this function reads in the preconditions for each node from a file with
the format:
<node name>
<precondition 1>
<precondition 2>
..
-1
..[repeated]
*/
void init_node_preconditions()
{

  char precondition[50];
  char node[50];
  int i, j;
  FILE *f;
  int precon_number;
  int node_number;
  int count = 0;

  f = fopenwithcheck(PRECONDITIONS_FNAME, "r");

  /* read in preconditions for each node */
  while (getline(f, node, MAX_LINE_LENGTH) != 0) {
	node_number = -1;
	for (i = 0; i < num_nodes; i++)
	  if (strcmp(node, nodes[i].name) == 0)
		node_number = i;
	if (node_number == -1)
	  printf("**error**: %s not recognised\n", node);
	getline(f, precondition, MAX_LINE_LENGTH);
	while (strcmp(precondition, "-1") != 0) {
	  precon_number = -1;
	  for (i = 0; i < num_props; i++)
		if (strcmp(precondition, prop_names[i]) == 0)
		  precon_number = i;
	  if (precon_number == -1)
		printf("**error**: %s not recognised\n", precondition);
	  nodes[node_number].preconditions[nodes[node_number].num_preconditions] =
		precon_number;
	  nodes[node_number].num_preconditions++;
	  getline(f, precondition, MAX_LINE_LENGTH);
	  count++;
	}
  }

  fclose(f);
/*g*/
/*g*/  printf("%d preconditions read in\n", count);

  /* create a record of how many times each proposition appears in different
  precondition lists */
  for (i = 0; i < num_props; i++)
	prop_precon_count[i] = 0;
  for (i = 0; i < num_nodes; i++)
	for (j = 0; j < nodes[i].num_preconditions; j++)
	  prop_precon_count[nodes[i].preconditions[j]]++;
}


/* this function reads in the add list for each node from a file with the
format:
<node name>
<add list element 1>
<add list element 2>
..
-1
..[repeated]
*/
void init_node_add_lists()
{

  char add_element[50];
  char node[50];
  int i, j;
  FILE *f;
  int add_number;
  int node_number;
  int count = 0;

  f = fopenwithcheck(ADD_LISTS_FNAME, "r");

  /* read in add lists for each node */
  while (getline(f, node, MAX_LINE_LENGTH) != 0) {
	node_number = -1;
	for (i = 0; i < num_nodes; i++)
	  if (strcmp(node, nodes[i].name) == 0)
		node_number = i;
	if (node_number == -1)
	  printf("**error**: %s not recognised\n", node);
	getline(f, add_element, MAX_LINE_LENGTH);
	while (strcmp(add_element, "-1") != 0) {
	  add_number = -1;
	  for (i = 0; i < num_props; i++)
		if (strcmp(add_element, prop_names[i]) == 0)
		  add_number = i;
	  if (add_number == -1)
		printf("**error**: %s not recognised\n", add_element);
	  nodes[node_number].add_list[nodes[node_number].add_list_size] =
		add_number;
	  nodes[node_number].add_list_size++;
	  getline(f, add_element, MAX_LINE_LENGTH);
	  count++;
	}
  }

  fclose(f);
/*g*/
/*g*/  printf("%d add list elements read in\n", count);

  /* create a record of how many times each proposition appears in different
  add lists */
  for (i = 0; i < num_props; i++)
	prop_add_list_count[i] = 0;
  for (i = 0; i < num_nodes; i++)
	for (j = 0; j < nodes[i].add_list_size; j++)
	  prop_add_list_count[nodes[i].add_list[j]]++;
}


/* this function reads in the delete list for each node from a file with the
format:
<node name>
<delete list element 1>
<delete list element 2>
..
-1
..[repeated]
*/
void init_node_delete_lists()
{

  char delete_element[50];
  char node[50];
  int i, j;
  FILE *f;
  int delete_number;
  int node_number;
  int count = 0;

  f = fopenwithcheck(DELETE_LISTS_FNAME, "r");

  /* read in delete lists for each node */
  while (getline(f, node, MAX_LINE_LENGTH) != 0) {
	node_number = -1;
	for (i = 0; i < num_nodes; i++)
	  if (strcmp(node, nodes[i].name) == 0)
		node_number = i;
	if (node_number == -1)
	  printf("**error**: %s not recognised\n", node);
	getline(f, delete_element, MAX_LINE_LENGTH);
	while (strcmp(delete_element, "-1") != 0) {
	  delete_number = -1;
	  for (i = 0; i < num_props; i++)
		if (strcmp(delete_element, prop_names[i]) == 0)
		  delete_number = i;
	  if (delete_number == -1)
		printf("**error**: %s not recognised\n", delete_element);
	  nodes[node_number].delete_list[nodes[node_number].delete_list_size] =
		delete_number;
	  nodes[node_number].delete_list_size++;
	  getline(f, delete_element, MAX_LINE_LENGTH);
	  count++;
	}
  }

  fclose(f);
/*g*/
/*g*/  printf("%d delete list elements read in\n", count);

  /* create a record of how many times each proposition appears in different
  delete lists */
  for (i = 0; i < num_props; i++)
	prop_delete_list_count[i] = 0;
  for (i = 0; i < num_nodes; i++)
	for (j = 0; j < nodes[i].delete_list_size; j++)
	  prop_delete_list_count[nodes[i].delete_list[j]]++;
}


/* function to specify which propositions are conditions about the
environment */
void init_env_conditions()
{

  char env_c[50];
  int i;
  FILE *f;
  int prop_number;
  int count = 0;

  f = fopenwithcheck(ENV_CONDITIONS_FNAME, "r");

  /* read in environment conditions */
  num_env_conditions = 0;
  while (getline(f, env_c, MAX_LINE_LENGTH) != 0) {
	prop_number = -1;
	for (i = 0; i < num_props; i++)
	  if (strcmp(env_c, prop_names[i]) == 0)
		prop_number = i;
	if (prop_number == -1)
	  printf("**error**: %s not recognised\n", env_c);
	env_conditions[num_env_conditions] = prop_number;
	num_env_conditions++;
	count++;
  }

  fclose(f);
/*g*/
/*g*/  printf("%d conditions about the environment read in\n", count);
}


/* function to specify which propositions are possible goals of the animal */
void init_goals()
{

  char goal[50];
  int i;
  FILE *f;
  int prop_number;
  int count = 0;

  f = fopenwithcheck(GOALS_FNAME, "r");

  /* read in goals */
  num_goals = 0;
  while (getline(f, goal, MAX_LINE_LENGTH) != 0) {
	prop_number = -1;
	for (i = 0; i < num_props; i++)
	  if (strcmp(goal, prop_names[i]) == 0)
		prop_number = i;
	if (prop_number == -1)
	  printf("**error**: %s not recognised\n", goal);
	goals[num_goals] = prop_number;
	num_goals++;
	count++;
  }

  fclose(f);
/*g*/
/*g*/  printf("%d goals read in\n", count);
}


/* this function initialises all the node activations */
void init_node_activations()
{

  int i;

  for (i = 0; i < num_nodes; i++)
	nodes[i].activation = 0.0;
}


/* function to read in a line from a file and put it in the array of chars
whose address is provided.  The function returns the length of the line, or
0 if the end of the file has been reached */
int getline(f, line, max_length)
FILE *f;
char *line;
int max_length;
{

  char c;
  int i, scan_result;

  i = 0;
  scan_result = fscanf(f, "%c", &c);

  /* while the first character is a percentage sign (comment) then read rest
  of line (without storing) and start another */
  while ((c == '%') && (scan_result != EOF)) {
	/* read rest of line without putting in buffer */
	while ((c != '\n') && (scan_result != EOF))
	  scan_result = fscanf(f, "%c", &c);
	/* read in the first character of the next line */
	scan_result =fscanf(f, "%c", &c);
  }

  while ((i < max_length) && (c != '\n') && (scan_result != EOF)) {
	line[i] = c;
	i++;
	scan_result = fscanf(f, "%c", &c);
  }

  line[i] = '\0';

  return(i);
}


/* function to look through the stimuli strengths for each type of stimulus
in each direction, and pick out the maximums of each type (over all
directions).  The direction of the maximum in each case is also calculated */
void get_maxs_and_dirs(food_perc_stimulus, food_memory_stimulus,
water_perc_stimulus, water_memory_stimulus, shelter_perc_stimulus,
shade_perc_stimulus, p1_perc_stimulus, p2_perc_stimulus, dp_perc_stimulus,
irr_perc_stimulus, mate_perc_stimulus, den_perc_stimulus,
den_memory_stimulus, edge_perc_stimulus)
double *food_perc_stimulus;
double *food_memory_stimulus;
double *water_perc_stimulus;
double *water_memory_stimulus;
double *shelter_perc_stimulus;
double *shade_perc_stimulus;
double *p1_perc_stimulus;
double *p2_perc_stimulus;
double *dp_perc_stimulus;
double *irr_perc_stimulus;
double *mate_perc_stimulus;
double *den_perc_stimulus;
double *den_memory_stimulus;
double *edge_perc_stimulus;
{

  int i;

  food_dir = -1;
  remembered_food_dir = -1;
  water_dir = -1;
  remembered_water_dir = -1;
  shelter_dir = -1;
  shade_dir = -1;
  p1_dir = -1;
  p2_dir = -1;
  dp_dir = -1;
  irr_dir = -1;
  mate_dir = -1;
  den_dir = -1;
  remembered_den_dir = -1;
  edge_dir = -1;

  max_food_perc_stimulus = 0.00001;
  max_food_memory_stimulus = 0.00001;
  max_water_perc_stimulus = 0.00001;
  max_water_memory_stimulus = 0.00001;
  max_shelter_perc_stimulus = 0.00001;
  max_shade_perc_stimulus = 0.00001;
  max_p1_perc_stimulus = 0.00001;
  max_p2_perc_stimulus = 0.00001;
  max_dp_perc_stimulus = 0.00001;
  max_irr_perc_stimulus = 0.00001;
  max_mate_perc_stimulus = 0.00001;
  max_den_perc_stimulus = 0.00001;
  max_den_memory_stimulus = 0.00001;
  max_edge_perc_stimulus = 0.00001;

  for (i = 0; i < NUM_DIRECTIONS; i++) {

	if ((i != 0) && (food_perc_stimulus[i] > max_food_perc_stimulus)) {
	  max_food_perc_stimulus = food_perc_stimulus[i];
	  food_dir = i;
	}
	if ((i != 0) && (food_memory_stimulus[i] > max_food_memory_stimulus)) {
	  max_food_memory_stimulus = food_memory_stimulus[i];
	  remembered_food_dir = i;
	}
	if ((i != 0) && (water_perc_stimulus[i] > max_water_perc_stimulus)) {
	  max_water_perc_stimulus = water_perc_stimulus[i];
	  water_dir = i;
	}
	if ((i != 0) && (water_memory_stimulus[i] > max_water_memory_stimulus)) {
	  max_water_memory_stimulus = water_memory_stimulus[i];
	  remembered_water_dir = i;
	}
	if ((i != 0) && (shelter_perc_stimulus[i] > max_shelter_perc_stimulus)) {
	  max_shelter_perc_stimulus = shelter_perc_stimulus[i];
	  shelter_dir = i;
	}
	if ((i != 0) && (shade_perc_stimulus[i] > max_shade_perc_stimulus)) {
	  max_shade_perc_stimulus = shade_perc_stimulus[i];
	  shade_dir = i;
	}
	if (p1_perc_stimulus[i] > max_p1_perc_stimulus) {
	  max_p1_perc_stimulus = p1_perc_stimulus[i];
	  p1_dir = i;
	}
	if (p2_perc_stimulus[i] > max_p2_perc_stimulus) {
	  max_p2_perc_stimulus = p2_perc_stimulus[i];
	  p2_dir = i;
	}
	if (dp_perc_stimulus[i] > max_dp_perc_stimulus) {
	  max_dp_perc_stimulus = dp_perc_stimulus[i];
	  dp_dir = i;
	}
	if (irr_perc_stimulus[i] > max_irr_perc_stimulus) {
	  max_irr_perc_stimulus = irr_perc_stimulus[i];
	  irr_dir = i;
	}
	if ((i != 0) && (mate_perc_stimulus[i] > max_mate_perc_stimulus)) {
	  max_mate_perc_stimulus = mate_perc_stimulus[i];
	  mate_dir = i;
	}
	if ((i != 0) && (den_perc_stimulus[i] > max_den_perc_stimulus)) {
	  max_den_perc_stimulus = den_perc_stimulus[i];
	  den_dir = i;
	}
	if ((i != 0) && (den_memory_stimulus[i] > max_den_memory_stimulus)) {
	  max_den_memory_stimulus = den_memory_stimulus[i];
	  remembered_den_dir = i;
	}
	if (edge_perc_stimulus[i] > max_edge_perc_stimulus) {
	  max_edge_perc_stimulus = edge_perc_stimulus[i];
	  edge_dir = i;
	}
  }

  /* make very small stimuli equal to zero */
  if (max_food_perc_stimulus <= 0.00002)
	max_food_perc_stimulus = 0.0;
  if (max_food_memory_stimulus <= 0.00002)
	max_food_memory_stimulus = 0.0;
  if (max_water_perc_stimulus <= 0.00002)
	max_water_perc_stimulus = 0.0;
  if (max_water_memory_stimulus <= 0.00002)
	max_water_memory_stimulus = 0.0;
  if (max_shelter_perc_stimulus <= 0.00002)
	max_shelter_perc_stimulus = 0.0;
  if (max_shade_perc_stimulus <= 0.00002)
	max_shade_perc_stimulus = 0.0;
  if (max_p1_perc_stimulus <= 0.00002)
	max_p1_perc_stimulus = 0.0;
  if (max_p2_perc_stimulus <= 0.00002)
	max_p2_perc_stimulus = 0.0;
  if (max_dp_perc_stimulus <= 0.00002)
	max_dp_perc_stimulus = 0.0;
  if (max_irr_perc_stimulus <= 0.00002)
	max_irr_perc_stimulus = 0.0;
  if (max_mate_perc_stimulus <= 0.00002)
	max_mate_perc_stimulus = 0.0;
  if (max_den_perc_stimulus <= 0.00002)
	max_den_perc_stimulus = 0.0;
  if (max_den_memory_stimulus <= 0.00002)
	max_den_memory_stimulus = 0.0;
  if (max_edge_perc_stimulus <= 0.00002)
	max_edge_perc_stimulus = 0.0;

  mate_in_same_square_stimulus = mate_perc_stimulus[SAME_SQUARE];
}


/* function to calculate which of the environmental propositions are true */
void calc_env_conditions(water_p_s, shelter_p_s, shade_p_s)
double *water_p_s;
double *shelter_p_s;
double *shade_p_s;
{

  int i;

  /* initialise all drive strengths */
  for (i = 0; i < num_env_conditions; i++)
	env_condition_values[env_conditions[i]] = FALSE;

  /* decide which conditions about the environment are TRUE and which
  FALSE */
  calc_cf_in_square();
  calc_ff_in_square();
  calc_prey_in_square();
  calc_food_perceived();
  calc_food_remembered();
  calc_food_not_in_square();
  calc_water_in_square(water_p_s);
  calc_water_perceived();
  calc_water_remembered();
  calc_shelter_in_square(shelter_p_s);
  calc_shelter_perceived();
  calc_shade_in_square(shade_p_s);
  calc_shade_perceived();
  calc_p1_perceived_strongly();
  calc_p1_perceived_weakly();
  calc_p2_perceived_strongly();
  calc_p2_perceived_weakly();
  calc_dp_perceived_strongly();
  calc_irr_perceived_strongly();
  calc_receptive_mate_perceived();
  calc_receptive_mate_in_square();
  calc_courted_mate_in_square();
  calc_den_perceived();
  calc_den_in_square();
  calc_den_not_in_square();
  calc_den_remembered();
  calc_sunset_or_night();
  calc_edge_perceived_strongly();
  calc_shade_or_shelter_in_square(shelter_p_s, shade_p_s);
  calc_p1_or_p2_perceived_strongly();
  calc_not_in_cover(shelter_p_s, shade_p_s);
}


/* function to calculate the stengths of the animal's goals */
void calc_animal_goals()
{

  int i;

  /* initialise all drive strengths */
  for (i = 0; i < num_goals; i++)
	goal_strengths[goals[i]] = 0.0;

  /* set strength of goal to make the animal's food level satisfactory */
  set_health_not_too_low_goal_strength();
  set_food_okay_goal_strength();
  set_water_okay_goal_strength();
  set_not_too_hot_goal_strength();
  set_not_too_cold_goal_strength();
  set_no_p1s_goal_strength();
  set_no_p2s_goal_strength();
  set_no_dps_goal_strength();
  set_no_irrs_goal_strength();
  set_sleeping_in_den_goal_strength();
  set_no_edges_goal_strength();
  set_variance_okay_goal_strength();
  set_clean_goal_strength();
  set_just_mated_goal_strength();
  set_recently_scanned_for_predators_goal_strength();
  set_no_predator_since_last_scan_goal_strength();
  set_close_to_cover_goal_strength();
}


/* function to determine if any of the nodes are executable (ie. (i) all
their preconditions are true, (ii) their excitation is greater than the
global threshold, and (iii) their excitation is greater than all others for
which (i) and (ii) is true) */
int no_node_executable()
{

  int i;
  int result;

  result = TRUE;

  /* for each node */
  for (i = 0; i < num_nodes; i++) {

/*	if (all_node_preconditions_true(i) == TRUE)
	  printf("***");
	printf(" %s activation = %g\n", nodes[i].name, nodes[i].activation);	
*/
	/* if it has an activation greater than the global threshold and if all
	of its preconditions are TRUE */
	if ((nodes[i].activation > global_activation_threshold) &&
		(all_node_preconditions_true(i) == TRUE))

	  result = FALSE;
  }

  return(result);
}


/* function to divide all the activation levels of the nodes by two.  This
is to ensure that unsuitable nodes can't creep up towards the amount
required to pass the global threshold */
void normalise_activation_levels()
{

  int i;
  double act_sum;

  /* calculate the sum of activations */
  act_sum = 0.0;
  for (i = 0; i < num_nodes; i++)
	if (nodes[i].activation > 0.0)
	  act_sum += nodes[i].activation;

  /* 'normalise' activations so that sum is always less than or equal to a
  certain value */
  if (act_sum != 0.0)
	for (i = 0; i < num_nodes; i++)
	  nodes[i].activation *= (NORMALISED_SUM / act_sum);  
}


/* function to inject activation from the sensors of the environment to the
network */
void input_excitation_from_env()
{

  int i, j;
  int precondition_prop_num;

  /* for each node */
  for (i = 0; i < num_nodes; i++)
	
	/* for each precondition of that node */
	for (j = 0; j < nodes[i].num_preconditions; j++) {

	  precondition_prop_num = nodes[i].preconditions[j];

	  /* if the precondition is true then add some activation to the node */
	  if (env_condition_values[precondition_prop_num] == TRUE) {

		/* amount of activation to be added depends on a global constant,
		the number of other modules with the same precondition, and the
		number of preconditions this module has */
		nodes[i].post_spreading_activation += (phi
		  / ((double) nodes[i].num_preconditions));

/*		nodes[i].activation += (phi /
                                ((double) nodes[i].num_preconditions));
*/
		inputs[i][num_inputs[i]].excitation = (phi /
                                ((double) nodes[i].num_preconditions));
		sprintf(inputs[i][num_inputs[i]].type_name, "env connection");
		inputs[i][num_inputs[i]].type = ENV_CONNECTION;
		sprintf(inputs[i][num_inputs[i]].sender_name, "%s",
		  prop_names[precondition_prop_num]);
		num_inputs[i]++;
	  }
	}
}


/* function to inject activation from the animal's goals to the network */
void input_excitation_from_goals()
{

  int i, j;
  int goal_prop_num;

  /* for each node */
  for (i = 0; i < num_nodes; i++)
	
	/* for each element in the add list of that node */
	for (j = 0; j < nodes[i].add_list_size; j++)

	  /* if that proposition is a goal */
	  if (proposition_is_goal(nodes[i].add_list[j]) == TRUE) {

		goal_prop_num = nodes[i].add_list[j];

		/* amount of activation to be added depends on the strength of the
		goal, a global constant, the number of other modules with the same
		goal in their add list, and the number of add list elements this
		module has */
		nodes[i].post_spreading_activation += (goal_strengths[goal_prop_num]
		  * gammaa); 

/*		nodes[i].activation += (goal_strengths[goal_prop_num] * gammaa);
*/
		inputs[i][num_inputs[i]].excitation = (goal_strengths[goal_prop_num]
									  / ((double) nodes[i].add_list_size)
									  * gammaa);
		sprintf(inputs[i][num_inputs[i]].type_name, "goal connection");
		inputs[i][num_inputs[i]].type = GOAL_CONNECTION;
		sprintf(inputs[i][num_inputs[i]].sender_name, "%s",
		  prop_names[goal_prop_num]);
		num_inputs[i]++;
	  }
}


/* function to take out activation due to the animal's protected goals */
void take_out_excitation_from_protected_goals()
{

  int i, j;
  int prot_goal_prop_num;

  /* for each node */
  for (i = 0; i < num_nodes; i++)
	
	/* for each element in the delete list of that node */
	for (j = 0; j < nodes[i].delete_list_size; j++)

	  /* if that proposition is a goal */
	  if (proposition_is_goal(nodes[i].delete_list[j]) == TRUE) {

		prot_goal_prop_num = nodes[i].delete_list[j];

		/* amount of activation to be subtracted depends on the strength of 
		the goal, a global constant, the number of other modules with the
		same goal in their delete list, and the number of delete list
		elements this module has */ 
		nodes[i].post_spreading_activation -=
		  (goal_strengths[prot_goal_prop_num] * delta); 
		inputs[i][num_inputs[i]].excitation =
		  0.0 - (goal_strengths[prot_goal_prop_num] * delta
				 / ((double) nodes[i].delete_list_size));
		sprintf(inputs[i][num_inputs[i]].type_name,
		  "protected goal connection");
		inputs[i][num_inputs[i]].type = PROT_GOAL_CONNECTION;
		sprintf(inputs[i][num_inputs[i]].sender_name, "%s",
		  prop_names[prot_goal_prop_num]);
		num_inputs[i]++;
	  }
}


/* function to spread activation along the predecessor links */
void spread_excitation_to_predecessors()
{

  int i, j, k, l;

  /* for each node */
  for (i = 0; i < num_nodes; i++)

	/* for each precondition of the node */
	for (j = 0; j < nodes[i].num_preconditions; j++)

	  /* if the precondition is FALSE */
	  if (env_condition_values[nodes[i].preconditions[j]] == FALSE)

		/* for each node */
		for (k = 0; k < num_nodes; k++)

		  /* for every add list element of that node */
		  for (l = 0; l < nodes[k].add_list_size; l++)

			/* if the add list element and precondition are the same (i.e.
			if the second node will achieve the first's precondition) */
			if (nodes[i].preconditions[j] == nodes[k].add_list[l]) {

			  /* spread some activation from the first to the second */
			  nodes[k].post_spreading_activation += 0.5 *
				(nodes[i].activation +
				 (nodes[i].activation / ((double) nodes[k].add_list_size)));

/*			  nodes[k].post_spreading_activation += nodes[i].activation;
*/
			  inputs[k][num_inputs[k]].excitation = nodes[i].activation /
						((double) nodes[k].add_list_size);
			  sprintf(inputs[k][num_inputs[k]].type_name, "predecessor");
			  inputs[k][num_inputs[k]].type = PREDECESSOR;
			  sprintf(inputs[k][num_inputs[k]].sender_name, "%s",
				nodes[i].name);
			  num_inputs[k]++;
			}
}


/* function to spread activation along the successor links */
void spread_excitation_to_successors()
{

  int i, j, k, l;

  /* for each node */
  for (i = 0; i < num_nodes; i++)

	/* if the node is executable */
	if (all_node_preconditions_true(i) == TRUE)

	  /* for each add list element of the node */
	  for (j = 0; j < nodes[i].add_list_size; j++)

		/* for each node */
		for (k = 0; k < num_nodes; k++)

		  /* for every precondition of that node */
		  for (l = 0; l < nodes[k].num_preconditions; l++)

			/* if the two are one and the same (i.e. if the second depends
			on the success of the first to become executable) */
			if (nodes[i].add_list[j] == nodes[k].preconditions[l])

			  /* if the proposition is FALSE */
			  if (env_condition_values[nodes[i].preconditions[j]] == FALSE) {

				/* spread some activation from the first to the second */
				nodes[k].post_spreading_activation += (nodes[i].activation
					* (phi / gammaa)
					/ ((double) nodes[k].num_preconditions));

/*				nodes[k].post_spreading_activation += (nodes[i].activation
					* (phi / gammaa)
                    / ((double) nodes[k].num_predecessors));
*/
				inputs[k][num_inputs[k]].excitation = (nodes[i].activation
                    * (phi / gammaa)
                    / ((double) nodes[k].num_predecessors));
				sprintf(inputs[k][num_inputs[k]].type_name, "successor");
				inputs[k][num_inputs[k]].type = SUCCESSOR;
				sprintf(inputs[k][num_inputs[k]].sender_name, "%s",
				  nodes[i].name);
				num_inputs[k]++;
			  }
}


/* function to spread activation along the conflictor links */
void spread_excitation_to_conflictors()
{

  int i, j, k, l;
  int num_conflicts = 0;
  int opposite_conflictor_exists;
  int opposite_conflictor;
  int senders[100];
  int receivers[100];
  double amounts[100];

  /* for each node */
  for (i = 0; i < num_nodes; i++)

	/* for each precondition of the node */
	for (j = 0; j < nodes[i].num_preconditions; j++)

	  /* for each node */
	  for (k = 0; k < num_nodes; k++)

		/* if the two nodes are not the same */ 
		if (i != k)

		  /* for every delete list element of that node */
		  for (l = 0; l < nodes[k].delete_list_size; l++)

			/* if the delete list element and precondition are the same
			(i.e. if the second node will undo the first's precondition) */
			if (nodes[i].preconditions[j] == nodes[k].delete_list[l]) {

			  /* record inhibition to travel along conflictor but don't
			  enact yet */
			  senders[num_conflicts] = i;
			  receivers[num_conflicts] = k;

			  amounts[num_conflicts] = 0.5 *
				((nodes[i].activation * (delta / gammaa)) +
				 (nodes[i].activation * (delta / gammaa) /
				  ((double) nodes[k].delete_list_size)));

/*			  amounts[num_conflicts] = (nodes[i].activation
				* (delta / gammaa));
*/
			  num_conflicts++;
			}

  /* now enact each transfer of conflictor inhibition, except when two nodes
  each conflict the other, in which case enact only the one from the
  stronger node to the weaker node */
  for (i = 0; i < num_conflicts; i++) {

	/* find out if there is a conflictor link in the opposite direction */
	opposite_conflictor_exists = FALSE;
	for (j = 0; j < num_conflicts; j++)
	  if ((senders[i] == receivers[j]) &&
		  (senders[j] == receivers[i])) {
		opposite_conflictor_exists = TRUE;
		opposite_conflictor = j;
	  }

	/* if there is a conflictor link in the opposite direction and the
	sender of the opposite has higher activation then don't enact this
	inhibition */
	if ((opposite_conflictor_exists == TRUE) &&
		(nodes[senders[opposite_conflictor]].activation >
		 nodes[senders[i]].activation)) {

	  /* do nothing */
/*	  printf("<<<>>>>conflictor inhibition not enacted %d-->%d\n", i,
		opposite_conflictor);
*/	}

	/* if no opposite conflictor, or if it's sender is less activated, then
	enact this inhibition */
	else {

	  nodes[receivers[i]].post_spreading_activation -= amounts[i];

	  /* subtract activation from the receiver */
	  inputs[receivers[i]][num_inputs[receivers[i]]].excitation =
		0.0 - amounts[i];
	  sprintf(inputs[receivers[i]][num_inputs[receivers[i]]].type_name,
		"conflictor");
	  inputs[receivers[i]][num_inputs[receivers[i]]].type = CONFLICTOR;
	  sprintf(inputs[receivers[i]][num_inputs[receivers[i]]].sender_name,
		"%s", nodes[senders[i]].name); 
	  num_inputs[receivers[i]]++;
	}
  }
}


/* function to calculate the truth or falsity of the environmental
proposition "cf in square" */
void calc_cf_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "cf in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (cf_in_animal_square == TRUE)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "ff in square" */
void calc_ff_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "ff in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (ff_in_animal_square == TRUE)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "prey in square" */
void calc_prey_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "prey in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (prey_in_animal_square == TRUE)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "food perceived" */
void calc_food_perceived()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "food perceived");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_food_perc_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "food remembered" */
void calc_food_remembered()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "food remembered");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_food_memory_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "food not in square" */
void calc_food_not_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "food not in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((cf_in_animal_square == FALSE) && (ff_in_animal_square == FALSE) &&
	  (prey_in_animal_square == FALSE))
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "water in square" */
void calc_water_in_square(water_p_s)
double *water_p_s;
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "water in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (water_p_s[0] > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "water perceived" */
void calc_water_perceived()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "water perceived");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_water_perc_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "water remembered" */
void calc_water_remembered()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "water remembered");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_water_memory_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "shelter in square" */
void calc_shelter_in_square(shelter_p_s)
double *shelter_p_s;
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "shelter in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (shelter_p_s[0] > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "shelter perceived" */
void calc_shelter_perceived()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "shelter perceived");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_shelter_perc_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "shade in square" */
void calc_shade_in_square(shade_p_s)
double *shade_p_s;
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "shade in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (shade_dir == SAME_SQUARE)
    condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "shade perceived" */
void calc_shade_perceived()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "shade perceived");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_shade_perc_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "p1 perceived strongly" */
void calc_p1_perceived_strongly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "p1 perceived strongly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_p1_perc_stimulus > 0.4)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "p1 perceived weakly" */
void calc_p1_perceived_weakly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "p1 perceived weakly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((max_p1_perc_stimulus > 0.1) &&
	  (max_p1_perc_stimulus < 0.4))
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "p2 perceived strongly" */
void calc_p2_perceived_strongly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "p2 perceived strongly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_p1_perc_stimulus > 0.4)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "p2 perceived weakly" */
void calc_p2_perceived_weakly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "p2 perceived weakly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((max_p2_perc_stimulus > 0.1) &&
	  (max_p2_perc_stimulus < 0.4))

	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "dp perceived strongly" */
void calc_dp_perceived_strongly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "dp perceived strongly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_dp_perc_stimulus > 0.4)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "irr perceived strongly" */
void calc_irr_perceived_strongly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "irr perceived strongly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_irr_perc_stimulus > 0.4)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "receptive mate perceived" */
void calc_receptive_mate_perceived()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "receptive mate perceived");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_mate_perc_stimulus > 0.1)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "receptive mate in square" */
void calc_receptive_mate_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "receptive mate in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (mate_dir == SAME_SQUARE)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "courted mate in square" */
void calc_courted_mate_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "courted mate in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((mate_dir == SAME_SQUARE) && (mate_courtedness >= 0.5))
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "den perceived" */
void calc_den_perceived()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "den perceived");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_den_perc_stimulus > 0.2)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "den in square" */
void calc_den_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "den in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (den_dir == SAME_SQUARE)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "den not in square" */
void calc_den_not_in_square()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "den not in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (den_dir != SAME_SQUARE)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "den remembered" */
void calc_den_remembered()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "den remembered");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_den_memory_stimulus > 0.05)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "sunset or night" */
void calc_sunset_or_night()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "sunset or night");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (night_prox > 0.75)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "edge perceived strongly" */
void calc_edge_perceived_strongly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "edge perceived strongly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if (max_edge_perc_stimulus > 0.6)
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "shade or shelter in square" */
void calc_shade_or_shelter_in_square(shelter_p_s, shade_p_s)
double *shelter_p_s;
double *shade_p_s;
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "shade or shelter in square");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((shelter_dir == SAME_SQUARE) || (shade_dir == SAME_SQUARE))
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "p1 or p2 perceived strongly" */
void calc_p1_or_p2_perceived_strongly()
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "p1 or p2 perceived strongly");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((max_p1_perc_stimulus > 0.4) ||
	  (max_p2_perc_stimulus > 0.4))
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to calculate the truth or falsity of the environmental
proposition "not in cover" */
void calc_not_in_cover(shelter_p_s, shade_p_s)
double *shelter_p_s;
double *shade_p_s;
{

  int i;
  int condition_number = -1;
  int condition_value = FALSE;
  char condition_name[30];

  strcpy(condition_name, "not in cover");

  for (i = 0; i < num_env_conditions; i++)
	if (strcmp(prop_names[env_conditions[i]], condition_name) == 0)
	  condition_number = env_conditions[i];

  if (condition_number == -1) {
	printf("error: environmental condition %s not recognised\n",
	  condition_name); 
	exit(0);
  }

  if ((shelter_p_s[0] > 0.2) || (shade_p_s[0] > 0.2) ||
	  (den_dir == SAME_SQUARE))
	condition_value = TRUE;

  env_condition_values[condition_number] = condition_value;
}


/* function to set the strength of the goal to increase the animal's health
in the short term because of risk of death */
void set_health_not_too_low_goal_strength()
{

  int i;
  int goal_number = -1;
  double health_not_too_low_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "health not too low");

  health_not_too_low_goal_strength = 0.30 * (1.0 - health);

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = health_not_too_low_goal_strength;
}


/* function to set the strength of the goal to keep the animal's food level
satisfactory */
void set_food_okay_goal_strength()
{

  int i;
  int goal_number = -1;
  double food_okay_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "food okay");

  /* food deficit some combination of need for fat, carbohydrate and
  protein */
  food_okay_goal_strength = fat_minus;
  if (carbo_minus > food_okay_goal_strength)
    food_okay_goal_strength = carbo_minus;
  if (protein_minus > food_okay_goal_strength)
    food_okay_goal_strength = protein_minus;
  food_okay_goal_strength *= 1.20;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = food_okay_goal_strength;
}


/* function to set the strength of the goal to keep the animal's water level
satisfactory */
void set_water_okay_goal_strength()
{

  int i;
  int goal_number = -1;
  double water_okay_goal_strength;
  char goal_name[30];

  water_okay_goal_strength = 1.35 * water_minus;

  strcpy(goal_name, "water okay");

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = water_okay_goal_strength;
}


/* function to set the strength of the goal to keep the animal not too hot */
void set_not_too_hot_goal_strength()
{

  int i;
  int goal_number = -1;
  double not_too_hot_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "not too hot");

  not_too_hot_goal_strength = (0.8*an_temp_plus) + (0.2*sqr_temp_plus);

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = not_too_hot_goal_strength;
}


/* function to set the strength of the goal to keep the animal not too cold */
void set_not_too_cold_goal_strength()
{

  int i;
  int goal_number = -1;
  double not_too_cold_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "not too cold");

  not_too_cold_goal_strength = (0.8*an_temp_minus) + (0.2*sqr_temp_minus);

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = not_too_cold_goal_strength;
}


/* function to set the strength of the goal to keep away from p1s */
void set_no_p1s_goal_strength()
{

  int i;
  int goal_number = -1;
  double no_p1s_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "no p1s perceived strongly");

  if (max_p1_perc_stimulus > 0.5)
	no_p1s_goal_strength = 0.99;
  if (max_p1_perc_stimulus > 0.25)
	no_p1s_goal_strength = max_p1_perc_stimulus + 0.40;
  else
	no_p1s_goal_strength = 0.0;
  no_p1s_goal_strength *= 3.9;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = no_p1s_goal_strength;
}


/* function to set the strength of the goal to keep away from p2s */
void set_no_p2s_goal_strength()
{

  int i;
  int goal_number = -1;
  double no_p2s_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "no p2s perceived strongly");

  if (max_p2_perc_stimulus > 0.5)
	no_p2s_goal_strength = 0.99;
  if (max_p2_perc_stimulus > 0.25)
	no_p2s_goal_strength = max_p2_perc_stimulus + 0.40;
  else
	no_p2s_goal_strength = 0.0;
  no_p2s_goal_strength *= 4.0;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = no_p2s_goal_strength;
}


/* function to set the strength of the goal to keep away from dps */
void set_no_dps_goal_strength()
{

  int i;
  int goal_number = -1;
  double no_dps_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "no dps perceived strongly");

  if (max_dp_perc_stimulus > 0.5)
	no_dps_goal_strength = 0.98;
  else if (max_dp_perc_stimulus > 0.2)
    no_dps_goal_strength = max_dp_perc_stimulus;
  else
	no_dps_goal_strength = 0.0;
  no_dps_goal_strength *= 3.0;
  no_dps_goal_strength *= 3.0;

  if (den_dir == SAME_SQUARE)
    no_dps_goal_strength = 0.0;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = no_dps_goal_strength;
}


/* function to set the strength of the goal to keep away from irrs */
void set_no_irrs_goal_strength()
{

  int i;
  int goal_number = -1;
  double no_irrs_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "no irrs perceived strongly");

  if (max_irr_perc_stimulus > 0.5)
	no_irrs_goal_strength = 0.98;
  else if (max_irr_perc_stimulus > 0.2)
	no_irrs_goal_strength = max_irr_perc_stimulus;
  else
	no_irrs_goal_strength = 0.0;
  no_irrs_goal_strength *= 3.0;

  if (den_dir == SAME_SQUARE)
	no_irrs_goal_strength = 0.0;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = no_irrs_goal_strength;
}


/* function to set the strength of the goal to get to the den square and
sleep there */
void set_sleeping_in_den_goal_strength()
{

  int i;
  int goal_number = -1;
  double sleeping_in_den_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "sleeping in den");

  sleeping_in_den_goal_strength = (4.25 * pow(night_prox, 10.0));
  if (sleeping_in_den_goal_strength > 0.5)
	sleeping_in_den_goal_strength += (1.00 * den_distance);

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = sleeping_in_den_goal_strength;
}


/* function to set the strength of the goal to keep away from edges */
void set_no_edges_goal_strength()
{

  int i;
  int goal_number = -1;
  double no_edges_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "no edges perceived strongly");

  no_edges_goal_strength = 0.8 * max_edge_perc_stimulus;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = no_edges_goal_strength;
}


/* function to set the strength of the goal to keep the animal's variance low */
void set_variance_okay_goal_strength()
{

  int i;
  int goal_number = -1;
  double variance_okay_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "variance okay");

  variance_okay_goal_strength = 3.0 * variance;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = variance_okay_goal_strength;
}


/* function to set the strength of the goal to keep the animal clean */
void set_clean_goal_strength()
{

  int i;
  int goal_number = -1;
  double clean_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "clean");

  clean_goal_strength = (1.15 * (1.0-cleanliness));
  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = clean_goal_strength;
}


/* function to set the strength of the goal to mate */
void set_just_mated_goal_strength()
{

  int i;
  int goal_number = -1;
  double just_mated_goal_strength;
  char goal_name[30];
  double max_mate_stim;

  max_mate_stim = max_mate_perc_stimulus;
  if (mate_in_same_square_stimulus > max_mate_perc_stimulus)
	max_mate_stim = mate_in_same_square_stimulus;

  strcpy(goal_name, "just mated");

  just_mated_goal_strength = 1.40;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = just_mated_goal_strength;
}


/* function to set the strength of the goal to scan for predators because
the animal hasn't scanned recently */
void set_recently_scanned_for_predators_goal_strength()
{

  int i;
  int goal_number = -1;
  double recently_scanned_for_predators_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "recently scanned for predators");

  recently_scanned_for_predators_goal_strength = (0.90 * scan_time);

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] =
	recently_scanned_for_predators_goal_strength; 
}


/* function to set the strength of the goal to scan because a predator has
been sighted since hte last scan */
void set_no_predator_since_last_scan_goal_strength()
{

  int i;
  int goal_number = -1;
  double no_predator_since_last_scan_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "no predator since last scan");

  if ((time_since_predator < scan_time) && (time_since_predator < 0.4))
    no_predator_since_last_scan_goal_strength = (0.2 * 1.0);
  else if ((time_since_predator < scan_time) && (time_since_predator < 0.8))
    no_predator_since_last_scan_goal_strength = (0.2 * 0.5);
  else
    no_predator_since_last_scan_goal_strength = 0.0;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] =
	no_predator_since_last_scan_goal_strength;
}


/* function to set the strength of the goal to mate */
void set_close_to_cover_goal_strength()
{

  int i;
  int goal_number = -1;
  double close_to_cover_goal_strength;
  char goal_name[30];

  strcpy(goal_name, "close to cover");

  close_to_cover_goal_strength = 0.90 * cover_distance;

  for (i = 0; i < num_goals; i++)
	if (strcmp(prop_names[goals[i]], goal_name) == 0)
	  goal_number = goals[i];

  if (goal_number == -1) {
	printf("error: goal %s not recognised\n", goal_name);
	exit(0);
  }

  goal_strengths[goal_number] = close_to_cover_goal_strength;
}


/* function to determine if all the preconditions of the node are TRUE or
not */
int all_node_preconditions_true(node_number)
int node_number;
{

  int i;
  int result;

  result = TRUE;

  /* for each precondition of the node */
  for (i = 0; i < nodes[node_number].num_preconditions; i++)

	/* if the precondition is false */
	if (env_condition_values[nodes[node_number].preconditions[i]] == FALSE)
	  result = FALSE;

  return(result);
}


/* function to reduce the global threshold by 10% */
void reduce_global_threshold()
{

  global_activation_threshold *= 0.9;
}


/* function to determine which of the executable modules has the highest
activation and then execute it */
void execute_module(p1_perc_stimulus, p2_perc_stimulus, dp_perc_stimulus,
irr_perc_stimulus, outside_env_perc_stimulus)
double *p1_perc_stimulus;
double *p2_perc_stimulus;
double *dp_perc_stimulus;
double *irr_perc_stimulus;
double *outside_env_perc_stimulus;
{

  int i;
  double highest_activation = -1.0;

  chosen_node = -1;

  /* for each node */
  for (i = 0; i < num_nodes; i++) {

	/* if executable and higher activation than all previous */
	if ((all_node_preconditions_true(i) == TRUE) &&
		(nodes[i].activation > global_activation_threshold) &&
		(nodes[i].activation > highest_activation)) {

	  highest_activation = nodes[i].activation;

	  chosen_node = i;
	}
  }

  if (highest_activation == -1.0) {
	printf("error: tried to choose node but none executable\n");
	exit(0);
  }
/*g*/
/*g*//*  printf("**************************************************\n");*/
/*g*//*  printf("module chosen = %s\n", nodes[chosen_node].name);*/
/*g*//*  printf("**************************************************\n");*/

  if (strcmp("eat cf", nodes[chosen_node].name) == 0)
	action = EATING_CF;
  else if (strcmp("eat ff", nodes[chosen_node].name) == 0)
	action = EATING_FF;
  else if (strcmp("pounce", nodes[chosen_node].name) == 0)
	action = POUNCING;
  else if (strcmp("approach perceived food", nodes[chosen_node].name) == 0)
	approach(food_dir);
  else if (strcmp("approach remembered food", nodes[chosen_node].name) == 0)
	approach(remembered_food_dir);
  else if (strcmp("drink", nodes[chosen_node].name) == 0)
	action = DRINKING;
  else if (strcmp("approach perceived water", nodes[chosen_node].name) == 0)
	approach(water_dir);
  else if (strcmp("approach remembered water", nodes[chosen_node].name) == 0)
	approach(remembered_water_dir);
  else if (strcmp("rest", nodes[chosen_node].name) == 0)
	action = RESTING;
  else if (strcmp("approach perceived shade", nodes[chosen_node].name) == 0)
	approach(shade_dir);
  else if (strcmp("approach perceived shelter", nodes[chosen_node].name) == 0)
	approach(shelter_dir);
  else if (strcmp("look towards p1", nodes[chosen_node].name) == 0)
	look_in_direction(p1_dir);
  else if (strcmp("freeze", nodes[chosen_node].name) == 0)
	action = FREEZING;
  else if (strcmp("run away from p1", nodes[chosen_node].name) == 0)
	run_away_from(p1_dir, p1_perc_stimulus);
  else if (strcmp("look towards p2", nodes[chosen_node].name) == 0)
	look_in_direction(p2_dir);
  else if (strcmp("run away from p2", nodes[chosen_node].name) == 0)
	run_away_from(p2_dir, p2_perc_stimulus);
  else if (strcmp("avoid dp", nodes[chosen_node].name) == 0)
	avoid(dp_dir, dp_perc_stimulus);
  else if (strcmp("avoid irr", nodes[chosen_node].name) == 0)
	avoid(irr_dir, irr_perc_stimulus);
  else if (strcmp("approach perceived mate", nodes[chosen_node].name) == 0)
	approach(mate_dir);
  else if (strcmp("court", nodes[chosen_node].name) == 0)
	action = COURT_DISPLAYING;
  else if (strcmp("mate", nodes[chosen_node].name) == 0)
	action = MATING;
  else if (strcmp("sleep", nodes[chosen_node].name) == 0)
	action = SLEEPING;
  else if (strcmp("approach perceived den", nodes[chosen_node].name) == 0)
	approach(den_dir);
  else if (strcmp("approach remembered den", nodes[chosen_node].name) == 0)
	approach(remembered_den_dir);
  else if (strcmp("clean", nodes[chosen_node].name) == 0)
	action = CLEANING;
  else if (strcmp("avoid edge", nodes[chosen_node].name) == 0)
	avoid(edge_dir, outside_env_perc_stimulus);
  else if (strcmp("look around", nodes[chosen_node].name) == 0)
	action = LOOKING_AROUND;
  else if (strcmp("approach cover", nodes[chosen_node].name) == 0)
      approach(shelter_dir);
  else if (strcmp("explore", nodes[chosen_node].name) == 0)
    explore();
  else {
	printf("node string doesn't match any node's name (%s)\n",
	  nodes[chosen_node].name);
	exit(0);
  }
}


/* function to move the animal so that it approaches a particular square */
void approach(direction)
int direction;
{

  switch(direction) {

	case(N):  action = MOVE_N;
			  break;
	case(NW): action = MOVE_NW;
			  break;
	case(W):  action = MOVE_W;
			  break;
	case(SW): action = MOVE_SW;
			  break;
	case(S):  action = MOVE_S;
			  break;
	case(SE): action = MOVE_SE;
			  break;
	case(E):  action = MOVE_E;
			  break;
	case(NE): action = MOVE_NE;
			  break;
	case(SAME_SQUARE): action = RESTING;
			  break;
	default:  printf("bad direction passed to approach (%d)\n",
	  direction);
 }
}


/* function to move the animal so that it avoids a particular square */
void avoid(direction, stimulus)
int direction;
double *stimulus;
{

  int opp_direction, opp_direction_m1, opp_direction_p1;

  if (direction == SAME_SQUARE) {
	explore();
  }

  else {

	opp_direction = direction + 4;
	if (opp_direction >= 9)
	  opp_direction -= 8;

	/* if there is another instance of the feature to be avoided in the
	opposite direction then try one of the directions adjacent to the
	opposite one */ 
	if (stimulus[opp_direction] > 0.3) {

	  opp_direction_m1 = direction - 1;
	  if (opp_direction_m1 == 0)
		opp_direction_m1 = 8;
	  opp_direction_p1 = direction + 1;
	  if (opp_direction_p1 == 9)
		opp_direction_p1 = 1;

	  if (stimulus[opp_direction_m1] < 0.3)
		opp_direction = opp_direction_m1;
	  else if (stimulus[opp_direction_p1] < 0.3)
		opp_direction = opp_direction_p1;
	}

	switch(opp_direction) {

	  case(N):  action = MOVE_N;
				break;
	  case(NW): action = MOVE_NW;
				break;
	  case(W):  action = MOVE_W;
				break;
	  case(SW): action = MOVE_SW;
				break;
	  case(S):  action = MOVE_S;
				break;
	  case(SE): action = MOVE_SE;
				break;
	  case(E):  action = MOVE_E;
				break;
	  case(NE): action = MOVE_NE;
				break;
	  default:  printf("bad direction passed to avoid (%d)\n",
				  direction);
	}
  }
}


/* function to move the animal so that it runs away from a particular square */
void run_away_from(direction, stimulus)
int direction;
double *stimulus;
{

  int opp_direction, opp_direction_m1, opp_direction_p1;

  if (direction == SAME_SQUARE) {
	opp_direction = N + ((int) (rnd(8.0)));
  }

  else {

	opp_direction = direction + 4;
	if (opp_direction >= 9)
	  opp_direction -= 8;

	/* if there is another instance of the feature to be avoided in the
	opposite direction then try one of the directions adjacent to the
	opposite one */ 
	if (stimulus[opp_direction] > 0.3) {

	  opp_direction_m1 = direction - 1;
	  if (opp_direction_m1 == 0)
		opp_direction_m1 = 8;
	  opp_direction_p1 = direction + 1;
	  if (opp_direction_p1 == 9)
		opp_direction_p1 = 1;

	  if (stimulus[opp_direction_m1] < 0.3)
		opp_direction = opp_direction_m1;
	  else if (stimulus[opp_direction_p1] < 0.3)
		opp_direction = opp_direction_p1;
	}
  }

  switch(opp_direction) {

	case(N):  action = MOVE2_N;
			  break;
	case(NW): action = MOVE2_NW;
			  break;
	case(W):  action = MOVE2_W;
			  break;
	case(SW): action = MOVE2_SW;
			  break;
	case(S):  action = MOVE2_S;
			  break;
	case(SE): action = MOVE2_SE;
			  break;
	case(E):  action = MOVE2_E;
			  break;
	case(NE): action = MOVE2_NE;
			  break;
	default:  printf("bad direction passed to run_away_from (%d)\n",
			direction);
  }
}


/* function to make the animal explore the environment */
void explore()
{

  static int counter;
  static int direction;
  double north_prob, east_prob, south_prob, west_prob;
  int c_change, r_change;

  if (counter > 6)
	counter = 0;

  /* set new random direction */
  if (counter == 0)
	direction = ((int) rnd(8.0));

  counter++;

  action = RESTING;

  /* the animal does not stay still when exploring */
  while (action == RESTING) {

	/* use the direction to set probabilities of movement in different
	directions */
	switch (direction) {

      case (0): north_prob = 0.7;
                east_prob  = 0.1;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (1): north_prob = 0.4;
                east_prob  = 0.4;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (2): north_prob = 0.1;
                east_prob  = 0.7;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (3): north_prob = 0.1;
                east_prob  = 0.4;
                south_prob = 0.4;
                west_prob  = 0.1;
                break;
      case (4): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.7;
                west_prob  = 0.1;
                break;
      case (5): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.4;
                west_prob  = 0.4;
                break;
      case (6): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.1;
                west_prob  = 0.7;
                break;
      case (7): north_prob = 0.4;
                east_prob  = 0.1;
                south_prob = 0.1;
			    west_prob  = 0.4;
                break;
	}

	c_change = 0;
	r_change = 0;

	/* decide which direction to move in */
	if (drand48() < east_prob)
      c_change++;
	if (drand48() < west_prob)
      c_change--;
	if (drand48() < north_prob)
      r_change--;
	if (drand48() < south_prob)
      r_change++;

	if (c_change > 0) {
      if (r_change > 0)
		action = MOVE_SE;
      else if (r_change == 0)
		action = MOVE_E;
      else
		action = MOVE_NE;
	}
	else if (c_change == 0) {
	  if (r_change > 0)
		action = MOVE_S;
	  else if (r_change == 0)
		action = RESTING;
	  else
		action = MOVE_N;
	}
	else {
      if (r_change > 0)
		action = MOVE_SW;
      else if (r_change == 0)
		action = MOVE_W;
      else
		action = MOVE_NW;
	}
  }
}


/* function to give the animal the appropriate action to look in a certain
direction */
void look_in_direction(dir)
int dir;
{

  switch(dir) {
	case(SAME_SQUARE):  action = RESTING;
			  break;
	case(N):  action = LOOKING_N;
			  break;
	case(NW): action = LOOKING_NW;
			  break;
	case(W):  action = LOOKING_W;
			  break;
	case(SW): action = LOOKING_SW;
			  break;
	case(S):  action = LOOKING_S;
			  break;
	case(SE): action = LOOKING_SE;
			  break;
	case(E):  action = LOOKING_E;
			  break;
	case(NE): action = LOOKING_NE;
			  break;
  }
}


/* function to determine if the proposition supplied is a goal of the
animal */
int proposition_is_goal(prop_num)
int prop_num;
{

  int i;
  int result = FALSE;

  for (i = 0; i < num_goals; i++)
	if (goals[i] == prop_num)
	  result = TRUE;

  return(result);
}

/*g*//* function to update the slider values on the strategy display */
/*g*/void update_strategy_display()
/*g*/{
/*g*/
/*g*/  update_long_profile();
/*g*/}
/*g*/
/*g*/
/*g*//* function to initialise a display for longitudinal profiles for each */
/*g*//* sub-problem, showing motivational levels and occurrences of relevant */
/*g*//* actions */
/*g*/void set_up_long_profile()
/*g*/{
/*g*/
/*g*/  int i;
/*g*/
/*g*/  lpd_position = 0;
/*g*/
/*g*/  /* define a font for the display */
/*g*/  screen_r_7 = pf_open("/usr/lib/fonts/fixedwidthfonts/screen.r.7");
/*g*/
/*g*/  long_profile_frame = window_create(NULL, FRAME,
/*g*/    WIN_SHOW, FALSE,
/*g*/    FRAME_LABEL, "Longitudinal Profiles (values scaled to fit in graphs)",
/*g*/    WIN_X, 700,
/*g*/    WIN_Y, 0,
/*g*/    WIN_WIDTH, LDP_WIDTH+10,
/*g*/    WIN_HEIGHT, (NUM_SYSTEMS_FOR_LPD*(LPD_ROW_HEIGHT+2)+2+25),
/*g*/    0);
/*g*/
/*g*/  long_profile_canvas = window_create(long_profile_frame, CANVAS,
/*g*/    WIN_SHOW, TRUE,
/*g*/    CANVAS_AUTO_SHRINK, TRUE,
/*g*/    CANVAS_AUTO_EXPAND, TRUE,
/*g*/    WIN_X, 0,
/*g*/    WIN_Y, 3,
/*g*/    WIN_WIDTH, LDP_WIDTH+6,
/*g*/    WIN_HEIGHT, (NUM_SYSTEMS_FOR_LPD*(LPD_ROW_HEIGHT+2)+2),
/*g*/    0);
/*g*/
/*g*/  long_profile_pw = canvas_pixwin(long_profile_canvas);
/*g*/
/*g*/  /* attach colourmap to pixwin */
/*g*/  pw_setcmsname(long_profile_pw, "doesntmatter");
/*g*/  pw_putcolormap(long_profile_pw, 0, CMAP_SIZE, red, green, blue);
/*g*/
/*g*/  /* draw in blank graphs for each system */
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/
/*g*/	pw_vector(long_profile_pw, 3, (2+i*(2+LPD_ROW_HEIGHT)), (LDP_WIDTH-3),
/*g*/	  (2+i*(2+LPD_ROW_HEIGHT)), (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (2+i*(2+LPD_ROW_HEIGHT)), 3, 
/*g*/	  (2+LPD_ROW_HEIGHT+i*(2+LPD_ROW_HEIGHT)), (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (2+LPD_ROW_HEIGHT+i*(2+LPD_ROW_HEIGHT)),
/*g*/	  (LDP_WIDTH-3), (2+LPD_ROW_HEIGHT+i*(2+LPD_ROW_HEIGHT)),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0); 
/*g*/	pw_vector(long_profile_pw, (LDP_WIDTH-3), (2+i*(2+LPD_ROW_HEIGHT)),
/*g*/	  (LDP_WIDTH-3), (2+LPD_ROW_HEIGHT+i*(2+LPD_ROW_HEIGHT)),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (2+i*(2+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT),
/*g*/	  (LDP_WIDTH-3), (2+i*(2+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/  }
/*g*/
/*g*/  /* write in the names of each profile */
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+0*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Eat CF");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+1*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Eat FF");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+2*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Pounce");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+3*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Perceived Food");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+4*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Remembered Food");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+5*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Drink");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+6*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Perceived Water");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+7*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Remembered Water");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+8*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Rest");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+9*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Perceived Shade");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+10*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Perceived Shelter");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+11*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Look Towards P1");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+12*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Freeze");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+13*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Run Away From P1");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+14*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Look Towards P2");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+15*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Run Away From P2");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+16*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Dangerous Place");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+17*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Irrelevant");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+18*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Perceived Mate");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+19*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Court");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+20*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Mate");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+21*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Sleep");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+22*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Perceived Den");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+23*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Remembered Den");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+24*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Clean");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+25*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Edge");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+26*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Explore");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+27*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Look Around");
/*g*/  pw_text(long_profile_pw, 5, (2+LPD_ROW_HEIGHT+28*(2+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Cover");
/*g*/}
/*g*/
/*g*/
/*g*//* function to update each of the longitudinal profiles */
/*g*/void update_long_profile()
/*g*/{
/*g*/
/*g*/  int i, lpd_x = (4 + lpd_position), lpd_y;
/*g*/  static int old_lpd_x, old_lpd_y[NUM_SYSTEMS_FOR_LPD]; 
/*g*/
/*g*/  /* for each profile */
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/
/*g*/	/* calculate y-position of graph point (dependent on some measure */
/*g*/	/* of activation of the system) */
/*g*/
/*g*/	if (all_node_preconditions_true(i))
/*g*/	  lpd_acts[i] = nodes[i].activation / largest_current_activation;
/*g*/	else
/*g*/	  lpd_acts[i] = 0.0;
/*g*/	lpd_y = 2 + i*(2+LPD_ROW_HEIGHT) + LPD_GRAPH_HEIGHT -
/*g*/	  ((int) (lpd_acts[i] * ((double) (LPD_GRAPH_HEIGHT-2))));
/*g*/
/*g*/	/* delete anything currently in the relevant part of the display */
/*g*/	pw_rop(long_profile_pw, lpd_x, (3+i*(2+LPD_ROW_HEIGHT)), 13,
/*g*/	  (LPD_GRAPH_HEIGHT-1), PIX_CLR, 0, 0, 0); 
/*g*/
/*g*/	/* draw in a small symbol to represent the current activation of */
/*g*/	/* the system (as long as not just gone back to beginning) */
/*g*/	if ((lpd_x-old_lpd_x) > 0)
/*g*/	  pw_vector(long_profile_pw, old_lpd_x, old_lpd_y[i], lpd_x, lpd_y,
/*g*/		(PIX_SRC|PIX_COLOR(40)), 0);
/*g*/
/*g*/	old_lpd_y[i] = lpd_y;
/*g*/  }
/*g*/
/*g*/  old_lpd_x = lpd_x;
/*g*/
/*g*/  /* delete any current blobs */
/*g*/  delete_lpd_blobs();
/*g*/
/*g*/  draw_lpd_blob(chosen_node);
/*g*/
/*g*/  lpd_position = (lpd_position+4) % (LDP_WIDTH-20);
/*g*/}
/*g*/
/*g*/
/*g*//* function to draw a little blob when an action relevant to the */ 
/*g*//* system is chosen */
/*g*/void draw_lpd_blob(profile_number)
/*g*/int profile_number;
/*g*/{
/*g*/
/*g*/  int blob_x, blob_y;
/*g*/
/*g*/  /* calculate coordinates of blob (to go just beneath bar for relevant */
/*g*/  /* system, at current time */
/*g*/  blob_x = (3+lpd_position);
/*g*/  blob_y = 2+profile_number*(2+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT+1; 
/*g*/
/*g*/  pw_rop(long_profile_pw, blob_x, blob_y, 4, 3,
/*g*/	(PIX_SRC|PIX_COLOR(40)), 0, 0, 0); 
/*g*/}
/*g*/
/*g*/
/*g*//* function to delete any existing blobs */
/*g*/void delete_lpd_blobs()
/*g*/{
/*g*/
/*g*/  int i, blob_x, blob_y;
/*g*/
/*g*/  blob_x = (4 + lpd_position);
/*g*/
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/	blob_y = 2 + i*(2+LPD_ROW_HEIGHT) + LPD_GRAPH_HEIGHT + 1;
/*g*/	pw_rop(long_profile_pw, blob_x, blob_y, 13, 3, PIX_CLR, 0, 0, 0);
/*g*/  }
/*g*/}
/*g*/
/*g*/
/*g*/void profile_change_proc()
/*g*/{
/*g*/
/*g*/  if (window_get(long_profile_frame, WIN_SHOW) == FALSE) {
/*g*/	turn_on(long_profile_frame);
/*g*/	profile_display_on = TRUE;
/*g*/  }
/*g*/  else {
/*g*/	turn_off(long_profile_frame);
/*g*/	profile_display_on = FALSE;
/*g*/  }
/*g*/}
/*g*/
/*g*/
void calc_num_predecessors()
{

  int i, j, k, l;

  /* for each node */
  for (i = 0; i < num_nodes; i++)

	/* for each precondition of the node */
	for (j = 0; j < nodes[i].num_preconditions; j++)

		/* for each node */
		for (k = 0; k < num_nodes; k++)

		  /* for every add list element of that node */
		  for (l = 0; l < nodes[k].add_list_size; l++)

			/* if the add list element and precondition are the same (i.e.
			if the second node will achieve the first's precondition) */
			if (nodes[i].preconditions[j] == nodes[k].add_list[l])

			  /* node k is a predecessor of node i so add 1 to number of
			  predecessors for node i */
			  nodes[i].num_predecessors++;
}



	  