
/* this file will include those functions directly relevant to selecting the
animal's behaviour at each moment in time */


#include <stdio.h>
#include <math.h>
/*gn*/
#include <suntool/sunview.h>
/*gn*/
#include <suntool/panel.h>
/*gn*/
#include <suntool/canvas.h>
#include "../sim_env/structures.h"
#include "../sim_env/util_fns.h"
#include "../sim_env/env_defs.h"
#include "../sim_env/env_spec.h"
#include "../sim_env/animal_defs.h"
#include "asm_defs.h"
#include "asm_decs.h"


/* this function gets run every timestep in order to control the animal's
behaviour */
int select_action(arg1, arg2, arg3, arg4, arg5_1, arg5_2, arg6_1, arg6_2,
arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17,
arg18, arg19, arg20, arg21, arg22, arg23, arg24, arg25, arg26, arg27, arg28,
arg29, arg30, arg31, arg32)
double arg1;			/* shortage of fat */
double arg2;			/* shortage of carbo */
double arg3;			/* shortage of protein */
double arg4;			/* shortage of water */
double arg5_1;			/* how much animal temp is below desirable */
double arg5_2;			/* how much animal temp is above desirable */
double arg6_1;			/* how much square temp is below desirable */
double arg6_2;			/* how much square temp is above desirable */
double arg7;			/* 'courtedness' of mate */
double arg8;			/* how clean the animal is */
double arg9;			/* closeness of nightfall */
double arg10;			/* estimated variance of the animal's position */
double arg11;			/* estimated distance from the animal to its den */
double *arg12;			/* stimulus of perceived food in all directions */
double *arg13;			/* stimulus of remembered food in all directions */
double *arg14;			/* stimulus of perceived water in all directions */
double *arg15;			/* stimulus of remembered water in all directions */
double *arg16;			/* stimulus of perceived shelter in all directions */
double *arg17;			/* stimulus of perceived shade in all directions */
double *arg18;			/* stimulus of perceived p1 in all directions */
double *arg19;			/* stimulus of perceived p2 in all directions */
double *arg20;			/* stimulus of perceived dp in all directions
						   (adjacent squares) */
double *arg21;			/* stimulus of perceived irr in all directions
						   (adjacent squares) */
double *arg22;			/* stimulus of perceived mate in all directions */
double *arg23;			/* stimulus of perceived den in all directions */
double *arg24;			/* stimulus of remembered den in all directions */
double *arg25;			/* stimulus of perceived edge in all directions */
double arg26;			/* how long it is since scanning for predators */
double arg27;			/* distance from cover */
double arg28;			/* time since predator last perceived */
double arg29;			/* animal health */
double arg30;			/* animal permanent injury */
double *arg31;			/* stimulus of perceived dp in all directions
						   (non-adjacent squares) */
double *arg32;			/* stimulus of perceived irr in all directions
						   (non-adjacent squares) */
{

  int i;

  /* assign parameters passed to behave_choice to global variables to be
  used for all behaviour functions */
  fat_minus = arg1;
  carbo_minus = arg2;
  protein_minus = arg3;
  water_minus = arg4;
  an_temp_minus= arg5_1;
  an_temp_plus = arg5_2;
  sqr_temp_minus= arg6_1;
  sqr_temp_plus = arg6_2;
  mate_courtedness = arg7;
  cleanliness = arg8;
  night_prox = arg9;
  variance = arg10;
  den_distance = arg11;
  scan_time = arg26;
  cover_distance = arg27;
  time_since_predator = arg28;
  health = arg29;
  p_injury = arg30;

  /* function to 'flush out' (i.e. empty) any reservoirs for systems in
  which the consummatory action has just been executed, or some other
  criterion has just been met */
  empty_reservoirs();

  /* get the maximums (and directions of them) for all direction dependent
  stimuli */
  get_maxs_and_dirs(&(arg12[0]), &(arg13[0]), &(arg14[0]), &(arg15[0]),
	&(arg16[0]), &(arg17[0]), &(arg18[0]), &(arg19[0]), &(arg20[0]),
	&(arg21[0]), &(arg22[0]), &(arg23[0]), &(arg24[0]), &(arg25[0]));

  /* calculate values of the animal's drives from properties of the
  environment */
  transfer_from_properties_to_drives(&(arg12[0]), &(arg14[0]), &(arg18[0]),
	&(arg19[0]), &(arg20[0]), &(arg21[0]), &(arg25[0]));

  /* choose the highest drive */
  choose_highest_drive();

  /* use the highest drive to decide the behaviour of the animal */
  get_behaviour_for_drive(&(arg12[0]), &(arg13[0]), &(arg14[0]), &(arg15[0]),
    &(arg16[0]), &(arg17[0]), &(arg18[0]), &(arg19[0]), &(arg20[0]),
    &(arg21[0]), &(arg22[0]), &(arg23[0]), &(arg24[0]), &(arg25[0]));

/*g*/  /* update the strategy display */
/*g*/  update_strategy_display();
/*g*/
  return(action);
}


/* function to transfer from the values of the properties describing the
state of the environment to the values of the drives of the animal */
void transfer_from_properties_to_drives(a12, a14, a18, a19, a20, a21, a25)
double *a12;
double *a14;
double *a18;
double *a19;
double *a20;
double *a21;
double *a25;
{

  calc_get_food_drive(a12);
  calc_get_water_drive(a14);
  calc_cool_down_drive();
  calc_warm_up_drive();
  calc_escape_predator_1_drive(a18);
  calc_escape_predator_2_drive(a19);
  calc_avoid_dangerous_place_drive(a20);
  calc_avoid_irrelevant_drive(a21);
  calc_approach_mate_drive();
  calc_reduce_variance_drive();
  calc_sleep_in_den_drive();
  calc_cleaning_drive();
  calc_avoid_edge_drive(a25);
  calc_scan_for_predators_drive();
  calc_stay_close_to_cover_drive();
}


/* function to choose the drive with the highest value for determining the
animal's behaviour */
void choose_highest_drive()
{

  highest_drive = GET_FOOD_DRIVE;
  highest_drive_value = get_food_drive;

  if (get_water_drive > highest_drive_value) {
	highest_drive = GET_WATER_DRIVE;
	highest_drive_value = get_water_drive;
  }
  if (cool_down_drive > highest_drive_value) {
    highest_drive = COOL_DOWN_DRIVE;
    highest_drive_value = cool_down_drive;
  }

  if (warm_up_drive > highest_drive_value) {
    highest_drive = WARM_UP_DRIVE;
    highest_drive_value = warm_up_drive;
  }

  if (escape_predator_1_drive > highest_drive_value) {
    highest_drive = ESCAPE_PREDATOR_1_DRIVE;
    highest_drive_value = escape_predator_1_drive;
  }

  if (escape_predator_2_drive > highest_drive_value) {
    highest_drive = ESCAPE_PREDATOR_2_DRIVE;
    highest_drive_value = escape_predator_2_drive;
  }

  if (avoid_dangerous_place_drive > highest_drive_value) {
    highest_drive = AVOID_DANGEROUS_PLACE_DRIVE;
    highest_drive_value = avoid_dangerous_place_drive;
  }

  if (avoid_irrelevant_drive > highest_drive_value) {
    highest_drive = AVOID_IRRELEVANT_DRIVE;
    highest_drive_value = avoid_irrelevant_drive;
  }

  if (approach_mate_drive > highest_drive_value) {
    highest_drive = APPROACH_MATE_DRIVE;
    highest_drive_value = approach_mate_drive;
  }

  if (reduce_variance_drive > highest_drive_value) {
    highest_drive = REDUCE_VARIANCE_DRIVE;
    highest_drive_value = reduce_variance_drive;
  }

  if (sleep_in_den_drive > highest_drive_value) {
    highest_drive = SLEEP_IN_DEN_DRIVE;
    highest_drive_value = sleep_in_den_drive;
  }

  if (cleaning_drive > highest_drive_value) {
    highest_drive = CLEANING_DRIVE;
	highest_drive_value = cleaning_drive;
  }

  if (avoid_edge_drive > highest_drive_value) {
    highest_drive = AVOID_EDGE_DRIVE;
    highest_drive_value = avoid_edge_drive;
  }

  if (scan_for_predators_drive >= highest_drive_value) {
    highest_drive = SCAN_FOR_PREDATORS_DRIVE;
    highest_drive_value = scan_for_predators_drive;
  }

  if (stay_close_to_cover_drive >= highest_drive_value) {
    highest_drive = STAY_CLOSE_TO_COVER_DRIVE;
    highest_drive_value = stay_close_to_cover_drive;
  }
}


/* function to calculate the behaviour of the animal depending upon which
drive has the highest value */
int get_behaviour_for_drive(p1_perc_stimulus, p2_perc_stimulus,
dp_perc_stimulus, irr_perc_stimulus, outside_env_perc_stimulus)
double *p1_perc_stimulus;
double *p2_perc_stimulus;
double *dp_perc_stimulus;
double *irr_perc_stimulus;
double *outside_env_perc_stimulus;
{

  switch(highest_drive) {

	case(GET_FOOD_DRIVE)				: try_to_get_food();
										  break;
	case(GET_WATER_DRIVE)				: try_to_get_water();
										  break;
	case(COOL_DOWN_DRIVE)				: try_to_cool_down();
										  break;
	case(WARM_UP_DRIVE)					: try_to_warm_up();
										  break;
	case(ESCAPE_PREDATOR_1_DRIVE)		:
		try_to_escape_predator_1(p1_perc_stimulus); 
										  break;
	case(ESCAPE_PREDATOR_2_DRIVE)		:
		try_to_escape_predator_2(p2_perc_stimulus); 
										  break;
	case(AVOID_DANGEROUS_PLACE_DRIVE)	:
		try_to_avoid_dangerous_place(dp_perc_stimulus); 
										  break;
	case(AVOID_IRRELEVANT_DRIVE)		:
		try_to_avoid_irrelevant(irr_perc_stimulus); 
										  break;
	case(APPROACH_MATE_DRIVE)			: try_to_approach_mate();
										  break;
	case(REDUCE_VARIANCE_DRIVE)			: try_to_reduce_variance();
										  break;
	case(SLEEP_IN_DEN_DRIVE)			: try_to_sleep_in_den();
										  break;
	case(CLEANING_DRIVE)				: try_to_clean();
										  break;
	case(AVOID_EDGE_DRIVE)				:
		try_to_avoid_edge(outside_env_perc_stimulus); 
										  break;
	case(SCAN_FOR_PREDATORS_DRIVE) : try_to_scan_for_predators(); 
										  break;
	case(STAY_CLOSE_TO_COVER_DRIVE): try_to_approach_cover(); 
										  break;
  }
}


/* function to calculate a drive value from the animal's shortage of fat,
carbohydrate and protein */
void calc_get_food_drive(food_perc_stimulus)
double *food_perc_stimulus;
{

  double food_minus;
  double combined_food_stimulus;
  double total_force_on_valve;

  /* food deficit some combination of need for fat, carbohydrate and
  protein */
  food_minus = fat_minus;
  if (carbo_minus > food_minus)
	food_minus = carbo_minus;
  if (protein_minus > food_minus)
	food_minus = protein_minus;

  scale_pan_force[0] = (10.0 * food_perc_stimulus[SAME_SQUARE]) +
					(5.0 * max_food_perc_stimulus) + 
					(3.0 * max_food_memory_stimulus);

  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[0] += (2.2 * food_minus);

  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	if (health < 0.25)
      reservoir_force[0] += (0.25-health);

  total_force_on_valve = (scale_pan_force[0] + reservoir_force[0]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  get_food_drive = total_force_on_valve;
}


/* function to calculate a drive value from the animal's shortage of water */
void calc_get_water_drive(water_perc_stimulus)
double *water_perc_stimulus;
{

  double combined_water_stimulus;
  double total_force_on_valve;

  /* stimulus from water equals some weighted average of stimulus from
  perceived and remembered water */
  combined_water_stimulus = maxi(max_water_perc_stimulus,
								 max_water_memory_stimulus);

  scale_pan_force[1] = (10.0 * water_perc_stimulus[SAME_SQUARE]) +
					(5.0 * max_water_perc_stimulus) + 
					(3.0 * max_water_memory_stimulus);

  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[1] += (1.9 * water_minus);

  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	if (health < 0.25)
      reservoir_force[1] += (0.25-health);

  total_force_on_valve = (scale_pan_force[1] + reservoir_force[1]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  get_water_drive = total_force_on_valve;
}


/* function to calculate a drive value from the animal's high temperature
and the square's high temperature */
void calc_warm_up_drive()
{

  double total_force_on_valve;

  scale_pan_force[2] = 0.0;
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[2] += (4.0 * sqr_temp_minus);
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[2] += (1.0 * an_temp_minus);

  total_force_on_valve = (scale_pan_force[2] + reservoir_force[2]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  warm_up_drive = total_force_on_valve;
}


/* function to calculate a drive value from the animal's low temperature 
and the square's low temperature */
void calc_cool_down_drive()
{

  double total_force_on_valve;

  scale_pan_force[3] = 0.0;
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[3] += (4.0 * sqr_temp_plus);
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
    reservoir_force[3] += (1.0 * an_temp_plus);
	
  total_force_on_valve = (scale_pan_force[3] + reservoir_force[3]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  cool_down_drive = total_force_on_valve;
}


/* function to calculate a drive value from the perceptual stimulus of a
predator_1 */
void calc_escape_predator_1_drive(p1_perc_stimulus)
double *p1_perc_stimulus;
{

  double total_force_on_valve;

  if (max_p1_perc_stimulus > 0.20)
	scale_pan_force[4] = (340.0 * p1_perc_stimulus[SAME_SQUARE]) +
					(320.0 * max_p1_perc_stimulus);
  else
	scale_pan_force[4] = 0.0;
  reservoir_force[4] += 0.0;

  total_force_on_valve = (scale_pan_force[4] + reservoir_force[4]);
  escape_predator_1_drive = total_force_on_valve;
}


/* function to calculate a drive value from the perceptual stimulus of a
predator_2 */
void calc_escape_predator_2_drive(p2_perc_stimulus)
double *p2_perc_stimulus;
{

  double total_force_on_valve;

  if (max_p2_perc_stimulus > 0.20)
	scale_pan_force[5] = (380.0 * p2_perc_stimulus[SAME_SQUARE]) +
					(360.0 * max_p2_perc_stimulus);
  else
	scale_pan_force[5] = 0.0;
  reservoir_force[5] += 0.0;

  total_force_on_valve = (scale_pan_force[5] + reservoir_force[5]);
  escape_predator_2_drive = total_force_on_valve;
}


/* function to calculate a drive value from the perceptual stimulus of a
dangerous place feature */
void calc_avoid_dangerous_place_drive(dp_perc_stimulus)
double *dp_perc_stimulus;
{

  double total_force_on_valve;

  if (max_dp_perc_stimulus > 0.20)
	scale_pan_force[6] = (300.0 * dp_perc_stimulus[SAME_SQUARE]) +
					(280.0 * max_dp_perc_stimulus);
  else
	scale_pan_force[6] = 0.0;
  reservoir_force[6] += 0.0;

  total_force_on_valve = (scale_pan_force[6] + reservoir_force[6]);
  avoid_dangerous_place_drive = total_force_on_valve;
}


/* function to calculate a drive value from the perceptual stimulus of an
irrelevant animal feature */
void calc_avoid_irrelevant_drive(irr_perc_stimulus)
double *irr_perc_stimulus;
{

  double total_force_on_valve;

  if (max_irr_perc_stimulus > 0.20)
	scale_pan_force[7] = (260.0 * irr_perc_stimulus[SAME_SQUARE]) +
					(240.0 * max_irr_perc_stimulus);
  else
	scale_pan_force[7] = 0.0;
  reservoir_force[7] += 0.0;

  total_force_on_valve = (scale_pan_force[7] + reservoir_force[7]);
  avoid_irrelevant_drive = total_force_on_valve;
}


/* function to calculate a drive value from the perceptual stimulus of a
mate, plus a resting level */
void calc_approach_mate_drive()
{

  double total_force_on_valve;

  if (mate_courtedness >= 0.5)
    scale_pan_force[8] = 100.0;
  else if ((max_mate_perc_stimulus > 0.1) && (mate_dir == SAME_SQUARE))
    scale_pan_force[8] = 90.0;
  else
	scale_pan_force[8] = (50.0 * max_mate_perc_stimulus);

  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[8] += 0.65;

  total_force_on_valve = (scale_pan_force[8] + reservoir_force[8]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  approach_mate_drive = total_force_on_valve;
}


/* function to calculate a drive value from the animal's variance */
void calc_reduce_variance_drive()
{

  double total_force_on_valve;

  scale_pan_force[9] = 0.0;
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[9] += (4.0 * variance);

  total_force_on_valve = (scale_pan_force[9] + reservoir_force[9]);
  reduce_variance_drive = total_force_on_valve;
}


/* function to calculate a drive value from the time left before nightfall */
void calc_sleep_in_den_drive()
{

  double total_force_on_valve;

  scale_pan_force[10] = (400.0 * pow(night_prox, 16.0));
  reservoir_force[10] += 0.0;

  total_force_on_valve = (scale_pan_force[10] + reservoir_force[10]);
  sleep_in_den_drive = total_force_on_valve;
}


/* function to calculate a drive value from the animal's 'dirtiness' or lack
of condition of fur/amount of infestation with parasites, etc */
void calc_cleaning_drive()
{

  double total_force_on_valve;

  scale_pan_force[11] = 0.0;
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[11] += (2.0 * (1.0-cleanliness));
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	if (health < 0.25)
      reservoir_force[11] += (0.8 * 4.0 * (0.25-health));

  total_force_on_valve = (scale_pan_force[11] + reservoir_force[11]); 
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  cleaning_drive = total_force_on_valve;
}


/* function to calculate a drive value from the proximity of the edge of the
environment */
void calc_avoid_edge_drive(edge_perc_stimulus)
double *edge_perc_stimulus;
{

  double total_force_on_valve;

  if (max_edge_perc_stimulus > 0.20)
	scale_pan_force[12] = (140.0 * edge_perc_stimulus[SAME_SQUARE]) +
					(120.0 * max_edge_perc_stimulus);
  else
	scale_pan_force[12] = 0.0;
  reservoir_force[12] += 0.0;

  total_force_on_valve = (scale_pan_force[12] + reservoir_force[12]);
  avoid_edge_drive = total_force_on_valve;
}


/* function to calculate a drive value from the time since the animal last
scanned for predators and the presence or absence of the den and the time
since a predator was last perceived */
void calc_scan_for_predators_drive()
{

  double total_force_on_valve;

  if ((time_since_predator < scan_time) &&
	  (time_since_predator < 0.4))
	scale_pan_force[13] = 0.96;
  else if ((time_since_predator < scan_time) &&
		   (time_since_predator >= 0.4) &&
		   (time_since_predator < 1.0))
	scale_pan_force[13] = 0.50;
  else if ((time_since_predator >= scan_time) &&
		   (time_since_predator < 1.0))
	scale_pan_force[13] = 0.35;
  else
	scale_pan_force[13] = 0.0;

  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[13] += 6.5;

  total_force_on_valve = (scale_pan_force[13] + reservoir_force[13]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  scan_for_predators_drive = total_force_on_valve;
}


/* function to calculate a drive value from the distance to cover */
void calc_stay_close_to_cover_drive()
{

  double total_force_on_valve;

  scale_pan_force[14] = 0.0;
  if (timestep > SUNRISE_TIME && timestep < SUNSET_TIME)
	reservoir_force[14] += (6.0 * cover_distance);

  total_force_on_valve = (scale_pan_force[14] + reservoir_force[14]);
  if (total_force_on_valve > 200.0)
	total_force_on_valve = 200.0;
  stay_close_to_cover_drive = total_force_on_valve;
}


/* function to calculate the animal's behaviour when the highest drive is
due to a shortage in food */
void try_to_get_food()
{

  /* if stimuli from both perception and memory are too low then explore
  instead */
  if ((max_food_perc_stimulus < 0.15) && (max_food_memory_stimulus < 0.15))
	explore();

  /* if food perception stimulus is higher than food memory stimulus */
  else if (max_food_perc_stimulus >= max_food_memory_stimulus) {

	/* if there is food in the animal's square */
	if (food_dir == SAME_SQUARE) {
	  /* eat (or pounce for prey) */
	  if ((prey_in_animal_square == TRUE) && (den_dir != SAME_SQUARE))
		action = POUNCING;
	  else if (cf_in_animal_square == TRUE)
		action = EATING_CF;
	  else if (ff_in_animal_square == TRUE)
		action = EATING_FF;
	  else
		explore();
	}
	else	{	/* best perceived food not in square */
	  approach(food_dir);
	}
  }

  else {		/* if food memory stimulus higher */
	approach(remembered_food_dir);
  }	
}


/* function to calculate the animal's behaviour when the highest drive is
due to a shortage in water */
void try_to_get_water()
{

  /* if stimuli from both perception and memory are too low then explore
  instead */
  if ((max_water_perc_stimulus < 0.15) && (max_water_memory_stimulus < 0.15))
	explore();

  /* if water perception stimulus is higher than water memory stimulus */
  else if (max_water_perc_stimulus >= max_water_memory_stimulus) {

	/* if there is water in the animal's square */
	if (water_dir == SAME_SQUARE) {
	  action = DRINKING;
	}
	else {		/* best perceived water not in square */
	  approach(water_dir);
	}
  }

  else {		/* if water memory stimulus higher */
	approach(remembered_water_dir);
  }	
}


/* function to calculate the animal's behaviour when the highest drive is
due to the animal being too hot */
void try_to_cool_down()
{

  /* if in reasonable shade then rest, else if can see reasonable shade then
  head towards it, else rest */
  if (max_shade_perc_stimulus < 0.1)
	explore();
  else if (shade_dir == SAME_SQUARE)
	action = RESTING;
  else
	approach(shade_dir);
}


/* function to calculate the animal's behaviour when the highest drive is
due to the animal being too cold */
void try_to_warm_up()
{

  /* if in reasonable shelter then rest, else if can see reasonable shelter
  then head towards it, else explore */
  if (max_shelter_perc_stimulus < 0.1)
	explore();
  else if ((shelter_dir == SAME_SQUARE) && (den_dir != SAME_SQUARE))
	action = POUNCING;			/* just something with high degree of
								exertion */
  else if (den_dir == SAME_SQUARE)
	action = RESTING;
  else {
	approach(shelter_dir);
  }
}


/* function to calculate the animal's behaviour when the highest drive is
due to a predator_1 being close */
void try_to_escape_predator_1(p1_perc_stimulus)
double *p1_perc_stimulus;
{

  /* if in reasonable cover then remain motionless, else if can see
  reasonable cover then head towards it if it is not in the same direction
  as the predator, else run away from the predator.  If stimulus from
  predator not very large then look in its direction */
  if (max_p1_perc_stimulus < 0.3)
	look_in_direction(p1_dir);
  else if (max_shelter_perc_stimulus > 0.6) {
	if (den_dir == SAME_SQUARE)
	  action = RESTING;
	else if (shelter_dir == SAME_SQUARE)
	  action = FREEZING;
	else if (not_similar_directions(p1_dir, shelter_dir) == TRUE)
	  approach(shelter_dir);
	else
	  run_away_from(p1_dir, p1_perc_stimulus);
  }
  else
	run_away_from(p1_dir, p1_perc_stimulus);
}


/* function to calculate the animal's behaviour when the highest drive is
due to a predator_2 being close */
void try_to_escape_predator_2(p2_perc_stimulus)
double *p2_perc_stimulus;
{

  /* if in reasonable cover then remain motionless, else if can see
  reasonable cover then head towards it if it is not in the same direction
  as the predator, else run away from the predator */
  if (max_p2_perc_stimulus < 0.3)
	look_in_direction(p2_dir);
  else if (max_shelter_perc_stimulus > 0.6) {
	if (den_dir == SAME_SQUARE)
	  action = RESTING;
	else if (shelter_dir == SAME_SQUARE)
	  action = FREEZING;
	else if (not_similar_directions(p2_dir, shelter_dir) == TRUE)
	  approach(shelter_dir);
	else
	  run_away_from(p2_dir, p2_perc_stimulus);
  }
  else
	run_away_from(p2_dir, p2_perc_stimulus);
}


/* function to calculate the animal's behaviour when the highest drive is
due to it being too close to a dangerous place */
void try_to_avoid_dangerous_place(dp_perc_stimulus)
double *dp_perc_stimulus;
{

  /* move away from the largest stimulus dangerous place (making sure to
  avoid other instances as well if possible) */
  avoid(dp_dir, dp_perc_stimulus);
}


/* function to calculate the animal's behaviour when the highest drive is
due to it being too close to an irrelevant animal */
void try_to_avoid_irrelevant(irr_perc_stimulus)
double *irr_perc_stimulus;
{

  /* move away from the largest stimulus irrelevant (making sure to avoid
  other instances as well if possible) */
  avoid(irr_dir, irr_perc_stimulus);
}


/* function to calculate the animal's behaviour when the highest drive is
for the animal to mate */
void try_to_approach_mate()
{

  /* if no mate reliably seen then explore, else head towards mate if not in
  square, else court mate if not receptive, else mate */
  if (max_mate_perc_stimulus < 0.1)
	explore();
  else if (mate_dir == SAME_SQUARE) {
	if (den_dir == SAME_SQUARE)
	  explore();
	else if (mate_courtedness >= 0.5)
	  action = MATING;
	else
	  action = COURT_DISPLAYING;
  }
  else
	approach(mate_dir);
}


/* function to calculate the animal's behaviour when the highest drive is
due to wanting to reduce variance */
void try_to_reduce_variance()
{

  /* if in den then rest, else if can see it well then move towards it, else
  move towards where it is thought to be */
  if ((max_den_perc_stimulus < 0.2) && (max_den_memory_stimulus < 0.05))
	explore();
  else if (max_den_perc_stimulus < 0.2)
	approach(remembered_den_dir);
  else if (den_dir == SAME_SQUARE)
	action = RESTING;
  else
	approach(den_dir);
}


/* function to calculate the animal's behaviour when the highest drive is
due to nightfall approaching */
void try_to_sleep_in_den()
{

  /* if in den then sleep, else if can see it then move towards it, else
  move towards where it is thought to be */
  if (den_dir == SAME_SQUARE)
	action = SLEEPING;
  else if (max_den_perc_stimulus >= 0.2)
	approach(den_dir);
  else if ((max_den_memory_stimulus >= 0.05) &&
		   (remembered_den_dir != SAME_SQUARE))
	approach(remembered_den_dir);
  else
	explore();
}


/* function to calculate the animal's behaviour when the highest drive is
due to the animal's "cleanliness" being quite low */
void try_to_clean()
{

  /* if the animal is in its den then explore, else clean */
  if (den_dir == SAME_SQUARE)
	explore();
  else
	action = CLEANING;
}


/* function to calculate the animal's behaviour when the highest drive is
due to the animal being too close to the edge of the environment */
void try_to_avoid_edge(outside_env_perc_stimulus)
double *outside_env_perc_stimulus;
{

  /* move away from edge */
  avoid(edge_dir, outside_env_perc_stimulus);
}


/* function to calculate the animal's behaviour when the highest drive is
due to the animal wanting to scan for predators */
void try_to_scan_for_predators()
{

  double max_p_stimulus = 0.0;
  int p_dir;

  if (max_p1_perc_stimulus > max_p_stimulus) {
	max_p_stimulus = max_p1_perc_stimulus;
	p_dir = p1_dir;
  }
  if (max_p2_perc_stimulus > max_p_stimulus) {
	max_p_stimulus = max_p2_perc_stimulus;
	p_dir = p2_dir;
  }

  /* look towards a predator if there is a reasonably large stimulus for
  one */
  if (max_p_stimulus > 0.2)
	look_in_direction(p_dir);

  /* else just look around generally */
  else
	action = LOOKING_AROUND;
}


/* function to calculate the animal's behaviour when the highest drive is
due to the animal being too far from protection from predators */
void try_to_approach_cover()
{

  /* if can see protective vegetation then move towards it */
  if (max_shelter_perc_stimulus > 0.20) {
	approach(shelter_dir);
  }
  else if (max_den_memory_stimulus > 0.1) {
	/* else move back towards den */
	approach(remembered_den_dir);
  }
  else
	explore();
}


/*g*//* function to update the slider values on the strategy display */
/*g*/void update_strategy_display()
/*g*/{
/*g*/
/*g*/  /* update slider values for properties of environment */
/*g*/  panel_set(fat_shortage_slider, PANEL_VALUE,
/*g*/	((int) (fat_minus * 100.0)), 0);
/*g*/  panel_set(carbo_shortage_slider, PANEL_VALUE,
/*g*/	((int) (carbo_minus * 100.0)), 0);
/*g*/  panel_set(protein_shortage_slider, PANEL_VALUE,
/*g*/	((int) (protein_minus * 100.0)), 0);
/*g*/  panel_set(water_shortage_slider, PANEL_VALUE,
/*g*/	((int) (water_minus * 100.0)), 0);
/*g*/  panel_set(low_temp_slider, PANEL_VALUE, ((int) (an_temp_minus * 100.0)), 0);
/*g*/  panel_set(high_temp_slider, PANEL_VALUE, ((int) (an_temp_plus * 100.0)), 0);
/*g*/  panel_set(p1_perc_stimulus_slider, PANEL_VALUE,
/*g*/	((int) (max_p1_perc_stimulus * 100.0)), 0);
/*g*/  panel_set(p2_perc_stimulus_slider, PANEL_VALUE,
/*g*/	((int) (max_p2_perc_stimulus * 100.0)), 0);
/*g*/  panel_set(dp_perc_stimulus_slider, PANEL_VALUE,
/*g*/	((int) (max_dp_perc_stimulus * 100.0)), 0);
/*g*/  panel_set(irr_perc_stimulus_slider, PANEL_VALUE,
/*g*/	((int) (max_irr_perc_stimulus * 100.0)), 0);
/*g*/  panel_set(mate_perc_stimulus_slider, PANEL_VALUE,
/*g*/	((int) (max_mate_perc_stimulus * 100.0)), 0);
/*g*/  panel_set(night_proximity_slider, PANEL_VALUE,
/*g*/	((int) (night_prox * 100.0)), 0);
/*g*/  panel_set(edge_perc_stimulus_slider, PANEL_VALUE,
/*g*/	((int) (max_edge_perc_stimulus * 100.0)), 0);
/*g*/
/*g*/  /* update slider values for drive levels */
/*g*/  panel_set(get_food_drive_slider, PANEL_VALUE,
/*g*/	((int) (get_food_drive * 100.0)), 0);
/*g*/  panel_set(get_water_drive_slider, PANEL_VALUE,
/*g*/	((int) (get_water_drive * 100.0)), 0);
/*g*/  panel_set(cool_down_drive_slider, PANEL_VALUE,
/*g*/	((int) (cool_down_drive * 100.0)), 0);
/*g*/  panel_set(warm_up_drive_slider, PANEL_VALUE,
/*g*/	((int) (warm_up_drive * 100.0)), 0);
/*g*/  panel_set(escape_predator_1_drive_slider, PANEL_VALUE,
/*g*/	((int) (escape_predator_1_drive * 100.0)), 0);
/*g*/  panel_set(escape_predator_2_drive_slider, PANEL_VALUE,
/*g*/	((int) (escape_predator_2_drive * 100.0)), 0);
/*g*/  panel_set(avoid_dangerous_place_drive_slider, PANEL_VALUE,
/*g*/	((int) (avoid_dangerous_place_drive * 100.0)), 0);
/*g*/  panel_set(avoid_irrelevant_drive_slider, PANEL_VALUE,
/*g*/	((int) (avoid_irrelevant_drive * 100.0)), 0);
/*g*/  panel_set(approach_mate_drive_slider, PANEL_VALUE,
/*g*/	((int) (approach_mate_drive * 100.0)), 0);
/*g*/  panel_set(reduce_variance_drive_slider, PANEL_VALUE,
/*g*/	((int) (reduce_variance_drive * 100.0)), 0);
/*g*/  panel_set(sleep_in_den_drive_slider, PANEL_VALUE,
/*g*/	((int) (sleep_in_den_drive * 100.0)), 0);
/*g*/  panel_set(avoid_edge_drive_slider, PANEL_VALUE,
/*g*/	((int) (avoid_edge_drive * 100.0)), 0);
/*g*/
/*g*/  window_fit(strategy_panel1);
/*g*/  window_fit(strategy_panel2);
/*g*/  window_fit(strategy_frame);
/*g*/
/*g*/  update_long_profile();
/*g*/}
/*g*/
/*g*/
/* function to move the animal so that it approaches a particular square */
void approach(direction)
int direction;
{

  switch(direction) {

	case(N):  action = MOVE_N;
			  break;
	case(NW): action = MOVE_NW;
			  break;
	case(W):  action = MOVE_W;
			  break;
	case(SW): action = MOVE_SW;
			  break;
	case(S):  action = MOVE_S;
			  break;
	case(SE): action = MOVE_SE;
			  break;
	case(E):  action = MOVE_E;
			  break;
	case(NE): action = MOVE_NE;
			  break;
	case(SAME_SQUARE): action = RESTING;
			  break;
	default:  printf("bad direction passed to approach (%d)\n",
	  direction);
 }
}


/* function to move the animal so that it avoids a particular square */
void avoid(direction, stimulus)
int direction;
double *stimulus;
{

  int opp_direction, opp_direction_m1, opp_direction_p1;

  if (direction == SAME_SQUARE) {
	explore();
  }

  else {

	opp_direction = direction + 4;
	if (opp_direction >= 9)
	  opp_direction -= 8;

	/* if there is another instance of the feature to be avoided in the
	opposite direction then try one of the directions adjacent to the
	opposite one */ 
	if (stimulus[opp_direction] > 0.3) {

	  opp_direction_m1 = direction - 1;
	  if (opp_direction_m1 == 0)
		opp_direction_m1 = 8;
	  opp_direction_p1 = direction + 1;
	  if (opp_direction_p1 == 9)
		opp_direction_p1 = 1;

	  if (stimulus[opp_direction_m1] < 0.3)
		opp_direction = opp_direction_m1;
	  else if (stimulus[opp_direction_p1] < 0.3)
		opp_direction = opp_direction_p1;
	}

	switch(opp_direction) {

	  case(N):  action = MOVE_N;
				break;
	  case(NW): action = MOVE_NW;
				break;
	  case(W):  action = MOVE_W;
				break;
	  case(SW): action = MOVE_SW;
				break;
	  case(S):  action = MOVE_S;
				break;
	  case(SE): action = MOVE_SE;
				break;
	  case(E):  action = MOVE_E;
				break;
	  case(NE): action = MOVE_NE;
				break;
	  default:  printf("bad direction passed to avoid (%d)\n",
				  direction);
	}
  }
}


/* function to move the animal so that it runs away from a particular square */
void run_away_from(direction, stimulus)
int direction;
double *stimulus;
{

  int opp_direction, opp_direction_m1, opp_direction_p1;

  if (direction == SAME_SQUARE) {
	opp_direction = N + ((int) (rnd(8.0)));
  }

  else {

	opp_direction = direction + 4;
	if (opp_direction >= 9)
	  opp_direction -= 8;

	/* if there is another instance of the feature to be avoided in the
	opposite direction then try one of the directions adjacent to the
	opposite one */ 
	if (stimulus[opp_direction] > 0.3) {

	  opp_direction_m1 = direction - 1;
	  if (opp_direction_m1 == 0)
		opp_direction_m1 = 8;
	  opp_direction_p1 = direction + 1;
	  if (opp_direction_p1 == 9)
		opp_direction_p1 = 1;

	  if (stimulus[opp_direction_m1] < 0.3)
		opp_direction = opp_direction_m1;
	  else if (stimulus[opp_direction_p1] < 0.3)
		opp_direction = opp_direction_p1;
	}
  }

  switch(opp_direction) {

	case(N):  action = MOVE2_N;
			  break;
	case(NW): action = MOVE2_NW;
			  break;
	case(W):  action = MOVE2_W;
			  break;
	case(SW): action = MOVE2_SW;
			  break;
	case(S):  action = MOVE2_S;
			  break;
	case(SE): action = MOVE2_SE;
			  break;
	case(E):  action = MOVE2_E;
			  break;
	case(NE): action = MOVE2_NE;
			  break;
	default:  printf("bad direction passed to run_away_from (%d)\n",
			direction);
  }
}


/* function to make the animal explore the environment */
void explore()
{

  static int counter;
  static int direction;
  double north_prob, east_prob, south_prob, west_prob;
  int c_change, r_change;

  if (counter > 6)
	counter = 0;

  /* set new random direction */
  if (counter == 0)
	direction = ((int) rnd(8.0));

  counter++;

  action = RESTING;

  /* the animal does not stay still when exploring */
  while (action == RESTING) {

	/* use the direction to set probabilities of movement in different
	directions */
	switch (direction) {

      case (0): north_prob = 0.7;
                east_prob  = 0.1;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (1): north_prob = 0.4;
                east_prob  = 0.4;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (2): north_prob = 0.1;
                east_prob  = 0.7;
                south_prob = 0.1;
                west_prob  = 0.1;
                break;
      case (3): north_prob = 0.1;
                east_prob  = 0.4;
                south_prob = 0.4;
                west_prob  = 0.1;
                break;
      case (4): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.7;
                west_prob  = 0.1;
                break;
      case (5): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.4;
                west_prob  = 0.4;
                break;
      case (6): north_prob = 0.1;
                east_prob  = 0.1;
                south_prob = 0.1;
                west_prob  = 0.7;
                break;
      case (7): north_prob = 0.4;
                east_prob  = 0.1;
                south_prob = 0.1;
			    west_prob  = 0.4;
                break;
	}

	c_change = 0;
	r_change = 0;

	/* decide which direction to move in */
	if (drand48() < east_prob)
      c_change++;
	if (drand48() < west_prob)
      c_change--;
	if (drand48() < north_prob)
      r_change--;
	if (drand48() < south_prob)
      r_change++;

	if (c_change > 0) {
      if (r_change > 0)
		action = MOVE_SE;
      else if (r_change == 0)
		action = MOVE_E;
      else
		action = MOVE_NE;
	}
	else if (c_change == 0) {
	  if (r_change > 0)
		action = MOVE_S;
	  else if (r_change == 0)
		action = RESTING;
	  else
		action = MOVE_N;
	}
	else {
      if (r_change > 0)
		action = MOVE_SW;
      else if (r_change == 0)
		action = MOVE_W;
      else
		action = MOVE_NW;
	}
  }
}


/* this function gets called once at the beginning of the program to set up
the strategy displays and to initialise strategy variables */
void set_up_strategy()
{

  int i;

/*g*/  destroy(strategy_frame);
/*g*/
/*g*/  strategy_frame = window_create(NULL, FRAME,
/*g*/    WIN_SHOW, FALSE,
/*g*/    FRAME_LABEL, "Behavioural Choice Strategy Display",
/*g*/    WIN_WIDTH, 800,
/*g*/    WIN_HEIGHT, 600,
/*g*/    WIN_X, 50,
/*g*/    WIN_Y, 200,
/*g*/    0);
/*g*/
/*g*/  strategy_panel1 = window_create(strategy_frame, PANEL,
/*g*/    WIN_SHOW, TRUE,
/*g*/    WIN_X, 0,
/*g*/    WIN_Y, 3,
/*g*/    WIN_WIDTH, 400,
/*g*/    WIN_HEIGHT, 550,
/*g*/    0);
/*g*/
/*g*/  /* label */
/*g*/  panel_create_item(strategy_panel1, PANEL_MESSAGE,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 1,
/*g*/	PANEL_LABEL_STRING, "PROPERTIES OF ENVIRONMENT",
/*g*/	0);
/*g*/
/*g*/  /* slider for fat shortage */
/*g*/  fat_shortage_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 20,
/*g*/    PANEL_LABEL_STRING, "Fat Shortage               ",
/*g*/    PANEL_VALUE, ((int) (fat_minus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for carbohydrate shortage */
/*g*/  carbo_shortage_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 40,
/*g*/    PANEL_LABEL_STRING, "Carbohydrate Shortage      ",
/*g*/    PANEL_VALUE, ((int) (carbo_minus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for protein shortage */
/*g*/  protein_shortage_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 60,
/*g*/    PANEL_LABEL_STRING, "Protein Shortage           ",
/*g*/    PANEL_VALUE, ((int) (protein_minus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for food perception */
/*g*/  food_perc_stimulus_slider = panel_create_item(strategy_panel1,
/*g*/	PANEL_SLIDER,  
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 80,
/*g*/    PANEL_LABEL_STRING, "Food Perception            ",
/*g*/    PANEL_VALUE, ((int) (max_food_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for food memory */
/*g*/  food_memory_stimulus_slider = panel_create_item(strategy_panel1,
/*g*/	PANEL_SLIDER, 
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 100,
/*g*/    PANEL_LABEL_STRING, "Food Memory                ",
/*g*/    PANEL_VALUE, ((int) (max_food_memory_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for water shortage */
/*g*/  water_shortage_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 120,
/*g*/    PANEL_LABEL_STRING, "Water Shortage             ",
/*g*/    PANEL_VALUE, ((int) (water_minus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for water perception stimulus */
/*g*/  water_perc_stimulus_slider = panel_create_item(strategy_panel1,
/*g*/	PANEL_SLIDER, 
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 140,
/*g*/    PANEL_LABEL_STRING, "Water Perception           ",
/*g*/    PANEL_VALUE, ((int) (max_water_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for water memory stimulus */
/*g*/  water_memory_stimulus_slider = panel_create_item(strategy_panel1,
/*g*/	PANEL_SLIDER, 
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 160,
/*g*/    PANEL_LABEL_STRING, "Water Memory               ",
/*g*/    PANEL_VALUE, ((int) (max_water_memory_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for low temperature */
/*g*/  low_temp_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 180,
/*g*/    PANEL_LABEL_STRING, "Low Temperature            ",
/*g*/    PANEL_VALUE, ((int) (an_temp_minus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for shelter perception stimulus */
/*g*/  shelter_perc_stimulus_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 200,
/*g*/    PANEL_LABEL_STRING, "Shelter Perception         ",
/*g*/    PANEL_VALUE, ((int) (max_shelter_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for high temperature */
/*g*/  high_temp_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 220,
/*g*/    PANEL_LABEL_STRING, "High Temperature           ",
/*g*/    PANEL_VALUE, ((int) (an_temp_plus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for shade perception stimulus */
/*g*/   shade_perc_stimulus_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 240,
/*g*/    PANEL_LABEL_STRING, "Shade Perception           ",
/*g*/    PANEL_VALUE, ((int) (max_shade_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of predator_1s */
/*g*/  p1_perc_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 260,
/*g*/    PANEL_LABEL_STRING, "Predator_1 Perception      ",
/*g*/    PANEL_VALUE, ((int) (max_p1_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of predator_1s */
/*g*/  p2_perc_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 280,
/*g*/    PANEL_LABEL_STRING, "Predator_2 Perception      ",
/*g*/    PANEL_VALUE, ((int) (max_p2_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of dangerous places */
/*g*/  dp_perc_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 300,
/*g*/    PANEL_LABEL_STRING, "Dangerous Place Perception ",
/*g*/    PANEL_VALUE, ((int) (max_dp_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of irrelevant animals */
/*g*/  irr_perc_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 320,
/*g*/    PANEL_LABEL_STRING, "Irrelevant Perception      ",
/*g*/    PANEL_VALUE, ((int) (max_irr_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of mates */
/*g*/  mate_perc_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 340,
/*g*/    PANEL_LABEL_STRING, "Mate Perception            ",
/*g*/    PANEL_VALUE, ((int) (max_mate_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for 'courtedness' of mate */
/*g*/  mate_courted_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 360,
/*g*/    PANEL_LABEL_STRING, "Mate Courted               ",
/*g*/    PANEL_VALUE, ((int) (mate_courtedness * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of den */
/*g*/  den_perc_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 380,
/*g*/    PANEL_LABEL_STRING, "Den Perception             ",
/*g*/    PANEL_VALUE, ((int) (max_den_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for perception of mates */
/*g*/  den_memory_stimulus_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 400,
/*g*/    PANEL_LABEL_STRING, "Dem Memory                 ",
/*g*/    PANEL_VALUE, ((int) (max_den_memory_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for animal's variance */
/*g*/  animal_variance_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 420,
/*g*/    PANEL_LABEL_STRING, "Animal Variance            ",
/*g*/    PANEL_VALUE, ((int) (variance / 2.0 * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for how close it is to sunset */
/*g*/  night_proximity_slider =
/*g*/		panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 440,
/*g*/    PANEL_LABEL_STRING, "Closeness to Sunset        ",
/*g*/    PANEL_VALUE, ((int) (night_prox * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for proximity of the edge of the environment */
/*g*/  edge_perc_stimulus_slider = panel_create_item(strategy_panel1, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 460,
/*g*/    PANEL_LABEL_STRING, "Edge Perception            ",
/*g*/    PANEL_VALUE, ((int) (max_edge_perc_stimulus * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  strategy_panel2 = window_create(strategy_frame, PANEL,
/*g*/    WIN_SHOW, TRUE,
/*g*/    WIN_X, 400,
/*g*/    WIN_Y, 3,
/*g*/    WIN_WIDTH, 400,
/*g*/    WIN_HEIGHT, 550,
/*g*/    0);
/*g*/
/*g*/  /* label */
/*g*/  panel_create_item(strategy_panel2, PANEL_MESSAGE,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 1,
/*g*/	PANEL_LABEL_STRING, "INTENSITIES OF DRIVES",
/*g*/	0);
/*g*/
/*g*/  /* slider for get_food_drive */
/*g*/  get_food_drive_slider = panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 100,
/*g*/    PANEL_LABEL_STRING, "Get Food               ",
/*g*/    PANEL_VALUE, ((int) (get_food_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for get_water_drive */
/*g*/  get_water_drive_slider = panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 160,
/*g*/    PANEL_LABEL_STRING, "Get Water              ",
/*g*/    PANEL_VALUE, ((int) (get_water_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for warm_up_drive */
/*g*/  warm_up_drive_slider = panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 200,
/*g*/    PANEL_LABEL_STRING, "Warm Up                ",
/*g*/    PANEL_VALUE, ((int) (warm_up_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for cool_down_drive */
/*g*/  cool_down_drive_slider = panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 240,
/*g*/    PANEL_LABEL_STRING, "Cool Down              ",
/*g*/    PANEL_VALUE, ((int) (cool_down_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for escape_predator_1_drive */
/*g*/  escape_predator_1_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 260,
/*g*/    PANEL_LABEL_STRING, "Escape Predator_1      ",
/*g*/    PANEL_VALUE, ((int) (escape_predator_1_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for escape_predator_2_drive */
/*g*/  escape_predator_2_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 280,
/*g*/    PANEL_LABEL_STRING, "Escape Predator_2      ",
/*g*/    PANEL_VALUE, ((int) (escape_predator_2_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for avoid_dangerous_place_drive */
/*g*/  avoid_dangerous_place_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 300,
/*g*/    PANEL_LABEL_STRING, "Avoid Dangerous Place  ",
/*g*/    PANEL_VALUE, ((int) (avoid_dangerous_place_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for avoid_irrelevant_drive */
/*g*/  avoid_irrelevant_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 320,
/*g*/    PANEL_LABEL_STRING, "Avoid Irrelevant Animal",
/*g*/    PANEL_VALUE, ((int) (avoid_irrelevant_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for approach_mate_drive */
/*g*/  approach_mate_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 360,
/*g*/    PANEL_LABEL_STRING, "Mating                 ",
/*g*/    PANEL_VALUE, ((int) (approach_mate_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for look_for_den_drive */
/*g*/  reduce_variance_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 420,
/*g*/    PANEL_LABEL_STRING, "Reduce Variance        ",
/*g*/    PANEL_VALUE, ((int) (reduce_variance_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for look_for_den_drive */
/*g*/  sleep_in_den_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 440,
/*g*/    PANEL_LABEL_STRING, "Sleep in Den           ",
/*g*/    PANEL_VALUE, ((int) (sleep_in_den_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  /* slider for avoid_edge_drive */
/*g*/  avoid_edge_drive_slider =
/*g*/		panel_create_item(strategy_panel2, PANEL_SLIDER,
/*g*/	PANEL_ITEM_X, 1,
/*g*/	PANEL_ITEM_Y, 460,
/*g*/    PANEL_LABEL_STRING, "Avoid Edge             ",
/*g*/    PANEL_VALUE, ((int) (avoid_edge_drive * 100.0)),
/*g*/    PANEL_SHOW_RANGE, FALSE,
/*g*/    PANEL_SLIDER_WIDTH, 100,
/*g*/    PANEL_NOTIFY_PROC, do_nothing_proc,
/*g*/    0);
/*g*/
/*g*/  window_fit(strategy_panel1);
/*g*/  window_fit(strategy_panel2);
/*g*/  window_fit(strategy_frame);
/*g*/
/*g*/  /* also initialise a longitudinal profiles display */
/*g*/  set_up_long_profile();

  for (i = 0; i < NUM_DRIVES; i++) {
	scale_pan_force[i] = 0.0;
	reservoir_force[i] = 0.0;
  }
}


/* function to return TRUE if the two directions are opposite, or almost so,
and FALSE otherwise.  For example, if dir1 = 3 (East), then dir2 needs to =
6 (SW), 7 (West) or 8 (NW) otherwise the function returns FALSE */
int not_similar_directions(dir1, dir2)
int dir1;
int dir2;
{

  register int d1, d2, d3;

  if (((dir1 == 0) && (dir2 != 0)) ||
	  ((dir1 != 0) && (dir2 == 0)))

	return(TRUE);

  else if ((dir1 == 0) && (dir2 == 0))

	return(FALSE);

  else {

	switch(dir1) {

	  case(1): d1 = 4;
			   d2 = 5;
			   d3 = 6;
			   break;
	  case(2): d1 = 5;
			   d2 = 6;
			   d3 = 7;
			   break;
	  case(3): d1 = 6;
			   d2 = 7;
			   d3 = 8;
			   break;
	  case(4): d1 = 7;
			   d2 = 8;
			   d3 = 1;
			   break;
	  case(5): d1 = 8;
			   d2 = 1;
			   d3 = 2;
			   break;
	  case(6): d1 = 1;
			   d2 = 2;
			   d3 = 3;
			   break;
	  case(7): d1 = 2;
			   d2 = 3;
			   d3 = 4;
			   break;
	  case(8): d1 = 3;
			   d2 = 4;
			   d3 = 5;
			   break;
	}

	if ((dir2 == d1) || (dir2 == d2) ||(dir2 == d3))
	  return(TRUE);

	else
	  return(FALSE);
  }
}

	  
/* function to look through the stimuli strengths for each type of stimulus
in each direction, and pick out the maximums of each type (over all
directions).  The direction of the maximum in each case is also calculated */
void get_maxs_and_dirs(food_perc_stimulus, food_memory_stimulus,
water_perc_stimulus, water_memory_stimulus, shelter_perc_stimulus,
shade_perc_stimulus, p1_perc_stimulus, p2_perc_stimulus, dp_perc_stimulus,
irr_perc_stimulus, mate_perc_stimulus, den_perc_stimulus,
den_memory_stimulus, edge_perc_stimulus)
double *food_perc_stimulus;
double *food_memory_stimulus;
double *water_perc_stimulus;
double *water_memory_stimulus;
double *shelter_perc_stimulus;
double *shade_perc_stimulus;
double *p1_perc_stimulus;
double *p2_perc_stimulus;
double *dp_perc_stimulus;
double *irr_perc_stimulus;
double *mate_perc_stimulus;
double *den_perc_stimulus;
double *den_memory_stimulus;
double *edge_perc_stimulus;
{

  int i;

  food_dir = -1;
  remembered_food_dir = -1;
  water_dir = -1;
  remembered_water_dir = -1;
  shelter_dir = -1;
  shade_dir = -1;
  p1_dir = -1;
  p2_dir = -1;
  dp_dir = -1;
  irr_dir = -1;
  mate_dir = -1;
  den_dir = -1;
  remembered_den_dir = -1;
  edge_dir = -1;

  max_food_perc_stimulus = 0.00001;
  max_food_memory_stimulus = 0.00001;
  max_water_perc_stimulus = 0.00001;
  max_water_memory_stimulus = 0.00001;
  max_shelter_perc_stimulus = 0.00001;
  max_shade_perc_stimulus = 0.00001;
  max_p1_perc_stimulus = 0.00001;
  max_p2_perc_stimulus = 0.00001;
  max_dp_perc_stimulus = 0.00001;
  max_irr_perc_stimulus = 0.00001;
  max_mate_perc_stimulus = 0.00001;
  max_den_perc_stimulus = 0.00001;
  max_den_memory_stimulus = 0.00001;
  max_edge_perc_stimulus = 0.00001;

  for (i = 0; i < NUM_DIRECTIONS; i++) {

	if (food_perc_stimulus[i] > max_food_perc_stimulus) {
	  max_food_perc_stimulus = food_perc_stimulus[i];
	  food_dir = i;
	}
	if (food_memory_stimulus[i] > max_food_memory_stimulus) {
	  max_food_memory_stimulus = food_memory_stimulus[i];
	  remembered_food_dir = i;
	}
	if (water_perc_stimulus[i] > max_water_perc_stimulus) {
	  max_water_perc_stimulus = water_perc_stimulus[i];
	  water_dir = i;
	}
	if (water_memory_stimulus[i] > max_water_memory_stimulus) {
	  max_water_memory_stimulus = water_memory_stimulus[i];
	  remembered_water_dir = i;
	}
	if (shelter_perc_stimulus[i] > max_shelter_perc_stimulus) {
	  max_shelter_perc_stimulus = shelter_perc_stimulus[i];
	  shelter_dir = i;
	}
	if (shade_perc_stimulus[i] > max_shade_perc_stimulus) {
	  max_shade_perc_stimulus = shade_perc_stimulus[i];
	  shade_dir = i;
	}
	if (p1_perc_stimulus[i] > max_p1_perc_stimulus) {
	  max_p1_perc_stimulus = p1_perc_stimulus[i];
	  p1_dir = i;
	}
	if (p2_perc_stimulus[i] > max_p2_perc_stimulus) {
	  max_p2_perc_stimulus = p2_perc_stimulus[i];
	  p2_dir = i;
	}
	if (dp_perc_stimulus[i] > max_dp_perc_stimulus) {
	  max_dp_perc_stimulus = dp_perc_stimulus[i];
	  dp_dir = i;
	}
	if (irr_perc_stimulus[i] > max_irr_perc_stimulus) {
	  max_irr_perc_stimulus = irr_perc_stimulus[i];
	  irr_dir = i;
	}
	if (mate_perc_stimulus[i] > max_mate_perc_stimulus) {
	  max_mate_perc_stimulus = mate_perc_stimulus[i];
	  mate_dir = i;
	}
	if (den_perc_stimulus[i] > max_den_perc_stimulus) {
	  max_den_perc_stimulus = den_perc_stimulus[i];
	  den_dir = i;
	}
	if (den_memory_stimulus[i] > max_den_memory_stimulus) {
	  max_den_memory_stimulus = den_memory_stimulus[i];
	  remembered_den_dir = i;
	}
	if (edge_perc_stimulus[i] > max_edge_perc_stimulus) {
	  max_edge_perc_stimulus = edge_perc_stimulus[i];
	  edge_dir = i;
	}
  }

  /* make very small stimuli equal to zero */
  if (max_food_perc_stimulus <= 0.00002)
	max_food_perc_stimulus = 0.0;
  if (max_food_memory_stimulus <= 0.00002)
	max_food_memory_stimulus = 0.0;
  if (max_water_perc_stimulus <= 0.00002)
	max_water_perc_stimulus = 0.0;
  if (max_water_memory_stimulus <= 0.00002)
	max_water_memory_stimulus = 0.0;
  if (max_shelter_perc_stimulus <= 0.00002)
	max_shelter_perc_stimulus = 0.0;
  if (max_shade_perc_stimulus <= 0.00002)
	max_shade_perc_stimulus = 0.0;
  if (max_p1_perc_stimulus <= 0.00002)
	max_p1_perc_stimulus = 0.0;
  if (max_p2_perc_stimulus <= 0.00002)
	max_p2_perc_stimulus = 0.0;
  if (max_dp_perc_stimulus <= 0.00002)
	max_dp_perc_stimulus = 0.0;
  if (max_irr_perc_stimulus <= 0.00002)
	max_irr_perc_stimulus = 0.0;
  if (max_mate_perc_stimulus <= 0.00002)
	max_mate_perc_stimulus = 0.0;
  if (max_den_perc_stimulus <= 0.00002)
	max_den_perc_stimulus = 0.0;
  if (max_den_memory_stimulus <= 0.00002)
	max_den_memory_stimulus = 0.0;
  if (max_edge_perc_stimulus <= 0.00002)
	max_edge_perc_stimulus = 0.0;
}


/* function to give the animal the appropriate action to look in a certain
direction */
void look_in_direction(dir)
int dir;
{

  switch(dir) {
	case(SAME_SQUARE):  action = RESTING;
			  break;
	case(N):  action = LOOKING_N;
			  break;
	case(NW): action = LOOKING_NW;
			  break;
	case(W):  action = LOOKING_W;
			  break;
	case(SW): action = LOOKING_SW;
			  break;
	case(S):  action = LOOKING_S;
			  break;
	case(SE): action = LOOKING_SE;
			  break;
	case(E):  action = LOOKING_E;
			  break;
	case(NE): action = LOOKING_NE;
			  break;
  }
}


/*g*//* function to initialise a display for longitudinal profiles for each */
/*g*//* sub-problem, showing motivational levels and occurrences of relevant */
/*g*//* actions */
/*g*/void set_up_long_profile()
/*g*/{
/*g*/
/*g*/  int i;
/*g*/
/*g*/  lpd_position = 0;
/*g*/
/*g*/  /* define a font for the display */
/*g*/  screen_r_7 = pf_open("/usr/lib/fonts/fixedwidthfonts/screen.r.7");
/*g*/
/*g*/  long_profile_frame = window_create(NULL, FRAME,
/*g*/    WIN_SHOW, FALSE,
/*g*/    FRAME_LABEL, "Longitudinal Profiles",
/*g*/    WIN_X, 400,
/*g*/    WIN_Y, 200,
/*g*/    WIN_WIDTH, LDP_WIDTH+10,
/*g*/    WIN_HEIGHT, (NUM_SYSTEMS_FOR_LPD*(LPD_ROW_HEIGHT+3)+3+25),
/*g*/    0);
/*g*/
/*g*/  long_profile_canvas = window_create(long_profile_frame, CANVAS,
/*g*/    WIN_SHOW, TRUE,
/*g*/    CANVAS_AUTO_SHRINK, TRUE,
/*g*/    CANVAS_AUTO_EXPAND, TRUE,
/*g*/    WIN_X, 0,
/*g*/    WIN_Y, 3,
/*g*/    WIN_WIDTH, LDP_WIDTH+6,
/*g*/    WIN_HEIGHT, (NUM_SYSTEMS_FOR_LPD*(LPD_ROW_HEIGHT+3)+3),
/*g*/    0);
/*g*/
/*g*/  long_profile_pw = canvas_pixwin(long_profile_canvas);
/*g*/
/*g*/  /* attach colourmap to pixwin */
/*g*/  pw_setcmsname(long_profile_pw, "doesntmatter");
/*g*/  pw_putcolormap(long_profile_pw, 0, CMAP_SIZE, red, green, blue);
/*g*/
/*g*/  /* draw in blank graphs for each system */
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/
/*g*/	pw_vector(long_profile_pw, 3, (3+i*(3+LPD_ROW_HEIGHT)), (LDP_WIDTH-3),
/*g*/	  (3+i*(3+LPD_ROW_HEIGHT)), (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (3+i*(3+LPD_ROW_HEIGHT)), 3, 
/*g*/	  (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)), (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (LDP_WIDTH-3), (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0); 
/*g*/	pw_vector(long_profile_pw, (LDP_WIDTH-3), (3+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (LDP_WIDTH-3), (3+LPD_ROW_HEIGHT+i*(3+LPD_ROW_HEIGHT)),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/	pw_vector(long_profile_pw, 3, (3+i*(3+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT),
/*g*/	  (LDP_WIDTH-3), (3+i*(3+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT),
/*g*/	  (PIX_SRC|PIX_COLOR(40)), 0);
/*g*/  }
/*g*/
/*g*/  /* write in the names of each profile */
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+0*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Get Food");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+1*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Get Water");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+2*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Cool Down");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+3*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Warm Up");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+4*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Escape Predator 1");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+5*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Escape Predator 2");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+6*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Dangerous Place");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+7*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Irrelevant Animal");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+8*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Reproduce");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+9*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Reduce Variance");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+10*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Sleep in Den");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+11*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Clean");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+12*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Avoid Edge");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+13*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Scan for Predators");
/*g*/  pw_text(long_profile_pw, 5, (3+LPD_ROW_HEIGHT+14*(3+LPD_ROW_HEIGHT)-2),
/*g*/	(PIX_SRC|PIX_COLOR(30)), screen_r_7, "Approach Cover");
/*g*/  
/*g*/  /*pw_text (animal_pw, 44, 261, (PIX_SRC|PIX_COLOR(30)), serif_r_12, "Fatal");*/
/*g*/}
/*g*/
/*g*/
/*g*//* function to update each of the longitudinal profiles */
/*g*/void update_long_profile()
/*g*/{
/*g*/
/*g*/  int i, lpd_x = (4 + lpd_position), lpd_y;
/*g*/  static int old_lpd_x, old_lpd_y[NUM_SYSTEMS_FOR_LPD]; 
/*g*/
/*g*/  /* for each profile */
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/
/*g*/	/* calculate y-position of graph point (dependent on some measure */
/*g*/	/* of activation of the system) */
/*g*/	lpd_acts[0] = get_food_drive;
/*g*/	lpd_acts[1] = get_water_drive;
/*g*/	lpd_acts[2] = cool_down_drive;
/*g*/	lpd_acts[3] = warm_up_drive;
/*g*/	lpd_acts[4] = escape_predator_1_drive;
/*g*/	lpd_acts[5] = escape_predator_2_drive;
/*g*/	lpd_acts[6] = avoid_dangerous_place_drive;
/*g*/	lpd_acts[7] = avoid_irrelevant_drive;
/*g*/	lpd_acts[8] = approach_mate_drive;
/*g*/	lpd_acts[9] = reduce_variance_drive;
/*g*/	lpd_acts[10] = sleep_in_den_drive;
/*g*/	lpd_acts[11] = cleaning_drive;
/*g*/	lpd_acts[12] = avoid_edge_drive;
/*g*/	lpd_acts[13] = scan_for_predators_drive;
/*g*/	lpd_acts[14] = stay_close_to_cover_drive;
/*g*/	lpd_y = 2 + i*(3+LPD_ROW_HEIGHT) + LPD_GRAPH_HEIGHT -
/*g*/	  ((int) (lpd_acts[i] / 400.0 * ((double) (LPD_GRAPH_HEIGHT-2))));
/*g*/
/*g*/	/* delete anything currently in the relevant part of the display */
/*g*/	pw_rop(long_profile_pw, lpd_x, (4+i*(3+LPD_ROW_HEIGHT)), 13,
/*g*/	  (LPD_GRAPH_HEIGHT-1), PIX_CLR, 0, 0, 0); 
/*g*/
/*g*/	/* draw in a small symbol to represent the current activation of */
/*g*/	/* the system (as long as not just gone back to beginning) */
/*g*/	if ((lpd_x-old_lpd_x) == 2)
/*g*/	  pw_vector(long_profile_pw, old_lpd_x, old_lpd_y[i], lpd_x, lpd_y,
/*g*/		(PIX_SRC|PIX_COLOR(40)), 0);
/*g*/
/*g*/	old_lpd_y[i] = lpd_y;
/*g*/  }
/*g*/
/*g*/  old_lpd_x = lpd_x;
/*g*/
/*g*/  /* delete any current blobs */
/*g*/  delete_lpd_blobs();
/*g*/
/*g*/  draw_lpd_blob(highest_drive);
/*g*/
/*g*/  lpd_position = (lpd_position+2) % (LDP_WIDTH-20);
/*g*/}
/*g*/
/*g*/
/*g*//* function to draw a little blob when an action relevant to the */ 
/*g*//* system is chosen */
/*g*/void draw_lpd_blob(profile_number)
/*g*/int profile_number;
/*g*/{
/*g*/
/*g*/  int blob_x, blob_y;
/*g*/
/*g*/  /* calculate coordinates of blob (to go just beneath bar for relevant */
/*g*/  /* system, at current time */
/*g*/  blob_x = (3+lpd_position);
/*g*/  blob_y = 3+profile_number*(3+LPD_ROW_HEIGHT)+LPD_GRAPH_HEIGHT+1; 
/*g*/
/*g*/  pw_rop(long_profile_pw, blob_x, blob_y, 2, 3,
/*g*/	(PIX_SRC|PIX_COLOR(40)), 0, 0, 0); 
/*g*/}
/*g*/
/*g*/
/*g*//* function to delete any existing blobs */
/*g*/void delete_lpd_blobs()
/*g*/{
/*g*/
/*g*/  int i, blob_x, blob_y;
/*g*/
/*g*/  blob_x = (4 + lpd_position);
/*g*/
/*g*/  for (i = 0; i < NUM_SYSTEMS_FOR_LPD; i++) {
/*g*/	blob_y = 3 + i*(3+LPD_ROW_HEIGHT) + LPD_GRAPH_HEIGHT + 1;
/*g*/	pw_rop(long_profile_pw, blob_x, blob_y, 13, 3, PIX_CLR, 0, 0, 0);
/*g*/  }
/*g*/}
/*g*/
/*g*/
/*g*/void profile_change_proc()
/*g*/{
/*g*/
/*g*/  if (window_get(long_profile_frame, WIN_SHOW) == FALSE) {
/*g*/	turn_on(long_profile_frame);
/*g*/	profile_display_on = TRUE;
/*g*/  }
/*g*/  else {
/*g*/	turn_off(long_profile_frame);
/*g*/	profile_display_on = FALSE;
/*g*/  }
/*g*/}
/*g*/
/*g*/
void empty_reservoirs()
{

  if ((animal_action == EATING_CF) ||
	  (animal_action == EATING_FF) ||
	  (animal_action == POUNCING))
	reservoir_force[0] -= 30.0;
  if ((fat_minus < 0.05) &&
	  (carbo_minus < 0.05) &&
	  (protein_minus < 0.05))
	reservoir_force[0] = 0.0;
  if (reservoir_force[0] < 0.0)
	reservoir_force[0] = 0.0;

  if (animal_action == DRINKING)
	reservoir_force[1] -= 30.0;
  if (water_minus < 0.05)
	reservoir_force[1] = 0.0;
  if (reservoir_force[1] < 0.0)
	reservoir_force[1] = 0.0;

  if (animal_action == RESTING)
	reservoir_force[2] -= 15.0;
  if ((sqr_temp_minus == 0.0) &&
	  (an_temp_minus == 0.0))
	reservoir_force[2] = 0.0;
  if (reservoir_force[2] < 0.0)
	reservoir_force[2] = 0.0;
  
  if (animal_action == POUNCING)
	reservoir_force[3] -= 15.0;
  if ((sqr_temp_plus == 0.0) &&
	  (an_temp_plus == 0.0))
	reservoir_force[3] = 0.0;
  if (reservoir_force[3] < 0.0)
	reservoir_force[3] = 0.0;
  
  if ((animal_action == FREEZING) ||
	  (animal_action == MOVE2_N) ||
	  (animal_action == MOVE2_NE) ||
	  (animal_action == MOVE2_E) ||
	  (animal_action == MOVE2_SE) ||
	  (animal_action == MOVE2_S) ||
	  (animal_action == MOVE2_SW) ||
	  (animal_action == MOVE2_W) ||
	  (animal_action == MOVE2_NW)) {
	reservoir_force[4] = 0.0;
	reservoir_force[5] = 0.0;
  }
  if (max_p1_perc_stimulus < 0.2)
	reservoir_force[4] = 0.0;
  if (max_p2_perc_stimulus < 0.2)
	reservoir_force[5] = 0.0;

  if (max_dp_perc_stimulus < 0.2)
	reservoir_force[6] = 0.0;

  if (max_irr_perc_stimulus < 0.2)
	reservoir_force[7] = 0.0;

  if (animal_action == MATING)
	reservoir_force[8] = 0.0;

  if (variance < 0.005)
	reservoir_force[9] = 0.0;

  if (animal_action == SLEEPING)
	reservoir_force[10] = 0.0;

  if (animal_action == CLEANING)
	reservoir_force[11] -= 20.0;
  if (cleanliness > 0.95)
	reservoir_force[11] = 0.0;
  if (reservoir_force[11] < 0.0)
	reservoir_force[11] = 0.0;

  if (max_edge_perc_stimulus < 0.2)
	reservoir_force[12] = 0.0;

  if ((animal_action == LOOKING_AROUND) ||
	  (animal_action == LOOKING_N) ||
	  (animal_action == LOOKING_NE) ||
	  (animal_action == LOOKING_E) ||
	  (animal_action == LOOKING_SE) ||
	  (animal_action == LOOKING_S) ||
	  (animal_action == LOOKING_SW) ||
	  (animal_action == LOOKING_W) ||
	  (animal_action == LOOKING_NW))
	reservoir_force[13] = 0.0;

  if ((highest_drive == STAY_CLOSE_TO_COVER_DRIVE) &&
	  ((animal_action == MOVE_N) ||
	   (animal_action == MOVE_NE) ||
	   (animal_action == MOVE_E) ||
	   (animal_action == MOVE_SE) ||
	   (animal_action == MOVE_S) ||
	   (animal_action == MOVE_SW) ||
	   (animal_action == MOVE_W) ||
	   (animal_action == MOVE_NW)))
	reservoir_force[14] -= 10.0;
  if (cover_distance == 0.0)
	reservoir_force[14] = 0.0;
  if (reservoir_force[14] < 0.0)
	reservoir_force[14] = 0.0;
}

