
/* file to define macros for functions implementing Rosenblatt & Payton's
behaviour selection mechanism */

#define INT_SENSORS_FNAME				"../asm/internal_sensors"
#define EXT_SENSORS_FNAME				"../asm/external_sensors"
#define INDET_SENSORS_FNAME				"../asm/indeterminate_sensors"
#define DIRECTED_EXT_SENSORS_FNAME		"../asm/directed_external_sensors"
#define TOP_LEVEL_NODES_FNAME			"../asm/top_level_nodes"
#define INTERMEDIATE_NODES_FNAME		"../asm/intermediate_nodes"
#define BOTTOM_LEVEL_NODES_FNAME		"../asm/bottom_level_nodes"
#define LINKS_FNAME						"../asm/links"

#define MAX_NUM_SENSORS					200

#define MAX_NUM_NODES					500

#define MAX_NUM_LINKS					2000

#define MAX_NUM_IN_LINKS				200

#define MAX_LINE_LENGTH					200

/* identifying numbers for different types of entity in the network */
#define NODE							1
#define MULTIPLE_NODE					2		/* i.e. directed */
#define INTERNAL_SENSOR					3
#define EXTERNAL_SENSOR					4
#define INDETERMINATE_SENSOR			5
#define DIRECTED_EXTERNAL_SENSOR		6

/* identifying numbers for different types of node */
#define TOP_LEVEL						1
#define INTERMEDIATE					2
#define BOTTOM_LEVEL					3


/* definitions for the longitudinal profile display */
#define LPD_ROW_HEIGHT					36
#define LPD_GRAPH_HEIGHT				(LPD_ROW_HEIGHT-18)
#define NUM_SYSTEMS_FOR_LPD				35
#define LDP_WIDTH						300		/* multiple of three */
#define EXTRA							(LDP_WIDTH+5)

/* allot a number to each drive */
#define GET_FOOD_DRIVE					0
#define GET_WATER_DRIVE					1
#define COOL_DOWN_DRIVE					2
#define WARM_UP_DRIVE					3
#define ESCAPE_PREDATOR_1_DRIVE			4
#define ESCAPE_PREDATOR_2_DRIVE			5
#define AVOID_DANGEROUS_PLACE_DRIVE		6
#define AVOID_IRRELEVANT_DRIVE			7
#define APPROACH_MATE_DRIVE				8
#define REDUCE_VARIANCE_DRIVE			9
#define SLEEP_IN_DEN_DRIVE				10
#define CLEANING_DRIVE					11
#define AVOID_EDGE_DRIVE				12
#define SCAN_FOR_PREDATORS_DRIVE		13
#define STAY_CLOSE_TO_COVER_DRIVE		14

#define NUM_DRIVES						15

