/*
 * set_utilities.h
 *
 */

#ifndef SET_UTILITIES_H_
#define SET_UTILITIES_H_

#include <vector>
#include <string>

// Return the bitmap of terminal set where each set does not overlap with any other set in the sets
std::vector<bool> terminal_set(const std::vector<std::vector<int> >& sets);

// Return whether set1 is subset of set2
int is_subset(const std::vector<int>& set1, const std::vector<int>& set2);

// Return the intersection of the two set
std::vector<int> set_intersection(const std::vector<int>& set1, const std::vector<int>& set2);

// Returns the union of the two set
std::vector<int> set_union(const std::vector<int>& set1, const std::vector<int>& set2);

// Return a new set with appended element
std::vector<int> set_append(const std::vector<int>& set, int append_element);

// Return a string of a set
std::string set_to_string(const std::vector<int>& set);

#endif /* SET_UTILITIES_H_ */
