/*
 * set_utilities.cpp
 */

// My Include
#include "set_utilities.h"

// Standard Include
#include <stdio.h>

// Return the indices of terminal set where each set does not overlap with any other set in the sets
std::vector<bool> terminal_set(const std::vector<std::vector<int> >& sets) {
	std::vector<bool> terminal_bit(sets.size(), 1);
	for (int i = 0; i < (int)sets.size()-1; ++i) {
		for (int j = i+1; j < (int)sets.size(); ++j) {
			int subset = (is_subset(sets[i], sets[j]));
			if (subset > 0) {
				terminal_bit[i] = 0;
			} else if (subset < 0) {
				terminal_bit[j] = 0;
			}
		}
	}
	return terminal_bit;
}

// Return whether set1 is subset of set2 or set2 is subset of set1
int is_subset(const std::vector<int>& set1, const std::vector<int>& set2) {
	if (set1.size() > set2.size()) {
		int issubset = 1;
		for (int i = 0; i < (int)set2.size(); ++i) {
			bool found = 0;
			int val = set2[i];
			for (int j = 0; j < (int)set1.size(); ++j) {
				if (val == set1[j]) {
					found = 1;
					break;
				}
			}

			if (!found) {
				issubset = 0;
				break;
			}
		}
		return issubset;
	} else {
		int issubset = -1;
		for (int i = 0; i < (int)set1.size(); ++i) {
			bool found = 0;
			int val = set1[i];
			for (int j = 0; j < (int)set2.size(); ++j) {
				if (val == set2[j]) {
					found = 1;
					break;
				}
			}

			if (!found) {
				issubset = 0;
				break;
			}
		}
		return issubset;
	}
}

// Return the intersection of the two set
std::vector<int> set_intersection(const std::vector<int>& set1, const std::vector<int>& set2) {
	std::vector<int> set;
	for (int i = 0; i < (int)set1.size(); ++i) {
		for (int j = 0; j < (int)set2.size(); ++j) {
			if (set1[i] == set2[j]) {
				set.push_back(set1[i]);
				break;
			}
		}
	}
	return set;
}


// Returns the union of the two set
std::vector<int> set_union(const std::vector<int>& set1, const std::vector<int>& set2) {
	std::vector<int> set;
	for (int i = 0; i < (int)set1.size(); ++i) {
		set.push_back(set1[i]);
	}
	for (int i = 0; i < (int)set2.size(); ++i) {
		bool duplicated = 0;
		for (int j = 0; j < (int)set1.size(); ++j) {
			if (set1[j] == set2[i]) {
				duplicated = 1;
				break;
			}
		}
		if (!duplicated) {
			set.push_back(set2[i]);
		}
	}
	return set;
}

// Return a new set with appended element
std::vector<int> set_append(const std::vector<int>& set, int append_element) {
	std::vector<int> s(set);
	s.push_back(append_element);
	return s;
}

// Return a string of a set
std::string set_to_string(const std::vector<int>& set) {
	std::string str;
	char buffer[50];
	for (int i = 0; i < (int)set.size(); ++i) {
		if (i > 0) {
			str.append(",");
		}
		int l = sprintf(buffer, "%d", set[i]);
		str.append(buffer, l);
	}
	return str;
}
