/*
 * permutation_utilities.h
 *
 *  Created on: Jan 24, 2012
 *      Author: Tony
 */

#ifndef PERMUTATION_UTILITIES_H_
#define PERMUTATION_UTILITIES_H_

#include <vector>

// Return a randomly selected values of integer in a bag of integers without any repeats
// For example, bag1 = { 1, 2, 3, 4}, bag2 = { 2, 3, 5 }, it will return two numbers at which
// the two numbers do not repeat
std::vector<int> uniform_sample_without_repeats(const std::vector<std::vector<int> >& lists);

// Return a random selected values of integer in a bag of integers with repeats
std::vector<int> uniform_sample_with_repeats(const std::vector<std::vector<int> >& lists);

// Return a randomly selected values of integer in a bag of integers without any repeats
// For example, bag1 = { 1, 2, 3, 4}, bag2 = { 2, 3, 5 }, it will return two numbers at which
// the two numbers do not repeat
std::vector<int> uniform_sample_without_repeats_3set(const std::vector<int>& set1, const std::vector<int>& set2, const std::vector<int>& set3);

// Return a random selected values of integer in a bag of integers with repeats
std::vector<int> uniform_sample_with_repeats_3set(const std::vector<int>& set1, const std::vector<int>& set2, const std::vector<int>& set3);



#endif /* PERMUTATION_UTILITIES_H_ */
