/*
 * permutation_utilities.cpp
 *
 *  Created on: Jan 24, 2012
 *      Author: Tony
 */

// Standard Include
#include "../cleax.h"

// My Include
#include "permutation_utilities.h"

// Includes
#include "../utilities/random/randomc.h"
#include "../utilities/random/stocc.h"
#include "../utilities/set_utilities.h"
#include <stdio.h>


// Declaring global variable
extern StochasticLib1* pRandom;

// Return a randomly selected values of integer in a bag of integers without any repeats
// For example, bag1 = { 1, 2, 3, 4}, bag2 = { 2, 3, 5 }, it will return two numbers at which
// the two numbers do not repeat
std::vector<int> uniform_sample_without_repeats(const std::vector<std::vector<int> >& lists) {
	std::vector<int> sample;
	bool isValid = 0;
	while (!isValid) {
		isValid = 1;
		sample = uniform_sample_with_repeats(lists);
		for (int i = 0; i < (int)sample.size(); ++i) {
			for (int j = i+1; j < (int)sample.size(); ++j) {
				if (sample[i] == sample[j]) {
					isValid = 0;
					break;
				}
			}
		}
	}
	return sample;
}


std::vector<int> uniform_sample_with_repeats(const std::vector<std::vector<int> >& lists) {
	std::vector<int> sample(lists.size());
	for (int i = 0; i < (int)lists.size(); ++i) {
		sample[i] = lists[i][pRandom->IRandom(0, (int)lists[i].size())];
	}
	return sample;
}

// Return a randomly selected values of integer in a bag of integers without any repeats
// For example, bag1 = { 1, 2, 3, 4}, bag2 = { 2, 3, 5 }, it will return two numbers at which
// the two numbers do not repeat
std::vector<int> uniform_sample_without_repeats_3set(const std::vector<int>& set1, const std::vector<int>& set2, const std::vector<int>& set3) {
	std::vector<int> sample;
	bool isValid = 0;
	while (!isValid) {
		isValid = 1;
		sample = uniform_sample_with_repeats_3set(set1, set2, set3);

		for (int i = 0; i < (int)sample.size(); ++i) {
			for (int j = i+1; j < (int)sample.size(); ++j) {
				if (sample[i] == sample[j]) {
					isValid = 0;
					break;
				}
			}
		}

		if ((sample[2] >= 0 && sample[0] > sample[2]) ||
			(sample[2] < 0 && sample[0] > sample[1])) {
			isValid = 0;
		}
	}
	return sample;
}
// Return a random selected values of integer in a bag of integers with repeats
std::vector<int> uniform_sample_with_repeats_3set(const std::vector<int>& set1, const std::vector<int>& set2, const std::vector<int>& set3) {
	std::vector<int> sample(3);
	sample[0] = set1[pRandom->IRandom(0, (int)set1.size()-1)];
	sample[1] = set2[pRandom->IRandom(0, (int)set2.size()-1)];
	sample[2] = set3[pRandom->IRandom(0, (int)set3.size()-1)];
	return sample;
}

