/*
 * math_utilities.cpp
 *
 *  Created on: Apr 20, 2012
 *      Author: Tony
 */

#include "math_utilities.h"

#include <math.h>

static const double LogNormalConstant = -0.5*log(6.28318531);

double logkfactorial(int k) {
	double fact = 0.0;
	for (int i = 2; i < k; ++i) {
		fact += log(i);
	}
	return fact;
}

double log_normal_pdf(double x, double mu, double sigma) {
	double logsigma = log(sigma);
	return LogNormalConstant - logsigma - 0.5*((mu-x)*(mu-x)/(sigma*sigma));
}

double log_nchoosek(int n, int k) {
	double val = 0.0;
	int r = (n-k > k) ? n-k : k;
	for (int i = r+1; i <= n; ++i) {
		val += log((double)i);
	}
	for (int i = 2; i <= n-r; ++i) {
		val += log((double)i);
	}
	return val;
}
