/*
 * entropy_utilities.h
 *
 */

#ifndef ENTROPY_UTILITIES_H_
#define ENTROPY_UTILITIES_H_

// Includes
#include <vector>

// Forward declaration
class partition;

//
double plogp(double p);

// Compute entropy
double compute_entropy(partition* pPartition, const std::vector<bool>& mask = std::vector<bool>(0));

// Compute conditional entropy
double compute_conditional_entropy(partition* pPart1, partition* pPart2, const std::vector<bool>& mask = std::vector<bool>(0));

// Is partition informative, i.e. not a null partition
bool is_informative(partition* pPartition, const std::vector<bool>& mask = std::vector<bool>(0));

// Is part1 information conditional on part2, i.e. they are not identical or mirror image of each other
bool is_identical_or_mirror(partition* pPart1, partition* pPart2, const std::vector<bool>& mask = std::vector<bool>(0));

extern int maxv;
extern std::vector<double> logmap;

#endif /* ENTROPY_UTILITIES_H_ */
