/*
 * entropy_utilities.cpp
 *
 */

// My Include
#include "../dmo/partition.h"
#include "entropy_utilities.h"

// Standard Include
#include <stdio.h>
#include <math.h>

int maxn;
std::vector<double> logmap;

//double plogp(int p, int n) {
//	if (n == maxn && p >= 0 && p < maxn) {
//		return logmap[p];
//	} else if (p > 0) {
//		double v = (double)p/(double)n;
//		return v*log2(v);
//	} else {
//		return 0;
//	}
//}

double plogp(double p) {
        if (p > 0) {
                return p*log(p);
        } else {
                return 0;
        }
}

//
//// Compute entropy
//double compute_entropy(partition* pPartition, const std::vector<bool>& mask) {
//
//	int p0=0, p1=0;
//	int n = 0;
//	for (int i = 0; i < (int)pPartition->size(); ++i) {
//		if (mask.size() == 0 || mask[i]) {
//			if (pPartition->get(i)) {
//				p1 ++;
//			} else {
//				p0 ++;
//			}
//			++n;
//		}
//	}
//
//	return -(plogp(p0, n) + plogp(p1, n));
//}

// Compute entropy
double compute_entropy(partition* pPartition, const std::vector<bool>& mask) {

        double p0=0.0, p1=0.0;
        double n = 0.0;
        for (int i = 0; i < (int)pPartition->size(); ++i) {
                if (mask.size() == 0 || mask[i]) {
                        if (pPartition->get(i)) {
                                p1 += 1.0;
                        } else {
                                p0 += 1.0;
                        }
                        ++n;
                }
        }

        p0 /= n;
        p1 /= n;

        return -(plogp(p0) + plogp(p1))/log(2.0);
}


//// Compute conditional entropy
//double compute_conditional_entropy(partition* pPart1, partition* pPart2, const std::vector<bool>& mask, bool debug) {
//	int p0=0, p1=0, p00=0, p01=0, p10=0, p11=0, n = 0;
//	for (int i = 0; i < (int)pPart1->size(); ++i) {
//		if (mask.size() == 0 || mask[i]) {
//			if (pPart2->get(i) == 0) {
//				p0 ++;
//				if (pPart1->get(i) == 0) {
//					p00 ++;
//				} else {
//					p10 ++;
//				}
//			} else {
//				p1 ++;
//				if (pPart1->get(i) == 0) {
//					p01 ++;
//				} else {
//					p11 ++;
//				}
//			}
//			++n;
//		}
//	}
//
//	if (debug) {
//		printf(" (%d %d %d %d %d %d) ", p0, p1, p00, p01, p10, p11); }
//
//	return ((plogp(p0, n) + plogp(p1,n )) - (plogp(p00, n) + plogp(p01, n) + plogp(p10, n) + plogp(p11, n)));
//}

// Compute conditional entropy
double compute_conditional_entropy(partition* pPart1, partition* pPart2, const std::vector<bool>& mask) {
	double p0=0.0, p1=0.0, p00=0.0, p01=0.0, p10=0.0, p11=0.0, n = 0.0;
	for (int i = 0; i < (int)pPart1->size(); ++i) {
			if (mask.size() == 0 || mask[i]) {
					if (pPart2->get(i) == 0) {
							p0 += 1.0;
							if (pPart1->get(i) == 0) {
									p00 += 1.0;
							} else {
									p10 += 1.0;
							}
					} else {
							p1 += 1.0;
							if (pPart1->get(i) == 0) {
									p01 += 1.0;
							} else {
									p11 += 1.0;
							}
					}
					++n;
			}
	}

	p0 /= n;
	p1 /= n;
	p00 /= n;
	p01 /= n;
	p10 /= n;
	p11 /= n;

	return ((plogp(p0) + plogp(p1)) - (plogp(p00) + plogp(p01) + plogp(p10) + plogp(p11)))/log(2.0);
}


// Is partition informative, i.e. not a null partition
bool is_informative(partition* pPartition, const std::vector<bool>& mask) {
	bool is_informative = 0, p0 = 0, p1 = 0;
	for (int i = 0; i < (int)pPartition->size(); ++i) {
		if (mask.size() == 0 || mask[i]) {

			if ((p0 && pPartition->get(i)) ||
				(p1 && !pPartition->get(i))) {
				is_informative = 1;
				break;
			} else {
				pPartition->get(i) ? p1 = 1 : p0 = 1;
			}
		}
	}

	return is_informative;
}

// Is part1 information conditional on part2, i.e. they are not identical or mirror image of each other
bool is_identical_or_mirror(partition* pPart1, partition* pPart2, const std::vector<bool>& mask) {
	bool identical = 1, p00 = 0, p01 = 0, p10 = 0, p11 = 0;
	for (int i = 0; i < (int)pPart1->size(); ++i) {
		if (mask.size() == 0 || mask[i]) {
			if (((p10 || p01) && pPart1->get(i) == pPart2->get(i)) ||
				((p11 || p00) && pPart1->get(i) != pPart2->get(i))) {
				identical = 0;
				break;
			}
			pPart2->get(i) ?
				(pPart1->get(i) ? p11 = 1 : p01 = 1) :
				(pPart1->get(i) ? p01 = 1 : p00 = 1);
		}
	}

	return identical;
}
