/*
 * properties.h
 *
 *  Created on: Aug 25, 2011
 *      Author: Tony
 */

#ifndef PROPERTIES_H_
#define PROPERTIES_H_

#include <string>
#include <map>

class properties {
private:
	//-------------------------------------------------------------------------
	// Members
	std::map<std::string, std::string> props;

public:
	properties();
	virtual ~properties();

	//-------------------------------------------------------------------------
	// Methods
public:
	// Return the property value
	const std::string get_properties(const std::string& key);

	// Set the property value
	void set_properties(const std::string& key, const std::string& value);

	// load properties from file
	void load(const std::string& filename) throw();

	// save properties to file
	void save(const std::string& filename) throw();
};

#endif /* PROPERTIES_H_ */
