/*
 * properties.cpp
 *
 *  Created on: Aug 25, 2011
 *      Author: Tony
 */

// Includes

#include <iostream>
#include <fstream>
#include <string.h>
#include "properties.h"

// Constructor
properties::properties() {
	// TODO Auto-generated constructor stub
}

// Destructor
properties::~properties() {
	// TODO Auto-generated destructor stub
}

// Return the property value
const std::string properties::get_properties(const std::string& key) {
	std::map<std::string,std::string>::iterator it;
	it = this->props.find(key);
	if (it != this->props.end()) {
		return this->props.find(key)->second;
	} else {
		return "";
	}
}

// Set the property value
void properties::set_properties(const std::string& key, const std::string& value) {
	this->props.insert(std::pair<std::string,std::string>(key, value));
}

// load properties from file
void properties::load(const std::string& filename) throw() {
	std::ifstream fin;
	fin.open(filename.data(), std::ios::in);

	int state = 0, keyidx = 0, validx = 0;
	char key[200];
	char val[200];
	char c;

	// Memory set
	memset(key, '\0', 200);
	memset(val, '\0', 200);
	while (fin.read(&c, 1) != 0) {
		if (c == '#') {
			state = 4;
		} else if (c == '\n') {
			if (state == 3) {
				this->set_properties(std::string(key), std::string(val));
				printf("Key: %s, Val: %s\n", key, val);
			}

			memset(key, '\0', 200);
			memset(val, '\0', 200);
			keyidx = 0;
			validx = 0;
			state = 0;
		} else if (std::isspace(c)) {
			if (state == 1) {
				state++;
			}
		} else {
			if (state == 0 || state == 1) {
				state = 1;
				key[keyidx++] = c;
			} else if (state == 2 || state == 3) {
				state = 3;
				val[validx++] = c;
			}
		}
	}

	if (state == 3) {
		this->set_properties(std::string(key), std::string(val));
	}

	fin.close();
}

// save properties to file
void properties::save(const std::string& filename) throw() {

}
