/*
 * partition.h
 *
 *  Created on: Aug 30, 2011
 *      Author: Tony
 */

#ifndef PARTITION_H_
#define PARTITION_H_

#include <vector>
#include <string>


class partition {
protected:
	// Store partitions
	std::vector<bool> parts;

public:
	//------------------------------------------------------------------
	// Constructors
	partition(const std::vector<bool>& pvec);
	partition(const partition& partion);
	virtual ~partition();

public:
	//------------------------------------------------------------------
	// Methods

	// Obtain base 64 string
	virtual const std::string getBase64String();

	// Obtain base 2 string
	virtual const std::string getBase2String();

	// Return size of the partition
	virtual size_t size();

	// Return the indices set of the smaller partition of the bipartition
	std::vector<int> getSmallPartition();

	// Return whether the partition is null
	bool isNull() const;

	// Return whether the partition is null or empty.  E.g. every bit is the same
	bool isEmpty() const;

	// Return whether the partition is same
	bool isEqual(const partition& pPart) const;

public:
	//------------------------------------------------------------------
	// Operators

	// Get boolean
	virtual const bool get(unsigned i) const;

	// Set boolean
	virtual void set(unsigned i, bool val);

	// Overriding == operator
	bool operator==(const partition& b);
};


class model_partition : public partition {
private:
	//------------------------------------------------------------------
	// Members
	int weight;

public:
	//------------------------------------------------------------------
	// Constructor
	model_partition(const partition& partion, int weight);
	virtual ~model_partition();

public:
	//------------------------------------------------------------------
	// Methods
	int getWeight();
};

class masked_model_partition : public model_partition {
private:
	std::vector<bool> mask;
	std::vector<int> pmap;

public:
	//------------------------------------------------------------------
	// Constructor
	masked_model_partition(const partition& partition, int weight, const std::vector<bool>& mask);
	virtual ~masked_model_partition();
public:
	//------------------------------------------------------------------
	// Methods

	// Obtain base 64 string
	//virtual const std::string getBase64String();

	// Obtain base 2 string
	//virtual const std::string getBase2String();

public:
	//------------------------------------------------------------------
	// Operators

	// Get boolean
	virtual const bool get(unsigned i) const;

	// Set boolean
	virtual void set(unsigned i, bool val);

	// Return size of the partition
	virtual size_t size();

	// Get Mask
	const std::vector<bool> getMask();

	// Has Mask
	bool hasMask();
};

class masked_model_partition_set {
private:
	std::vector<bool> mask;
	std::vector<model_partition*> models;
	int nullWeight;

public:
	//------------------------------------------------------------------
	// Constructors
	masked_model_partition_set(const std::vector<bool>& mask);
	virtual ~masked_model_partition_set();

public:
	//------------------------------------------------------------------
	// Methods

	// Add partition to set
	void add_model_partition(partition* pParts, int weight);

	// Get partition index
	model_partition* getPartition(int idx);

	// Return the number of model partition
	size_t size();

	// Set null partition
	void setNullWeight(int nullWt);

	// Get null partition weight
	int getNullWeight();

	// Return output string
	const std::string toString();

	// Sort model based on weight from larget to smallest
	void sort();

	// Mask
	const std::vector<bool> getMask();
};

#endif /* PARTITION_H_ */
