/*
 * genealogy.h
 *
 *  Created on: Sep 6, 2011
 *      Author: Tony
 */

#ifndef GENEALOGY_H_
#define GENEALOGY_H_

// Include
#include <vector>
#include <string>

// Forward Declaration
class partition;

class genealogy_branch {
	//------------------------------------------------------------------
	// Members

	// Parent of the branch
	genealogy_branch* pParent;

	// First child of the branch
	genealogy_branch* pChild1;

	// Second child of the branch
	genealogy_branch* pChild2;

	// Start and end time of the branch
	double t1, t2;

	// Representing the partition
	partition* pPartition;

	// Number of leaf this branch have under
	int numOfLeaf;

	// Population id
	int popId;

	// Event id
	int eventId;

	// DEBUG
	int uid;

public:
	//------------------------------------------------------------------
	// Constructors
	genealogy_branch(int idx, int n, int popid, int eventid);
	genealogy_branch(genealogy_branch* pChild1, genealogy_branch* pChild2, double t, int popid, int eventid);
	virtual ~genealogy_branch();

public:
	//------------------------------------------------------------------
	// Methods

	// Set parent of the branch
	void setParent(genealogy_branch* pParent);

	// Set child 1 of the branch
	void setChild1(genealogy_branch* pChild1);

	// Set child 2 of the branch
	void setChild2(genealogy_branch* pChild2);

	// Set start time of the branch
	void setStartTime(double t);

	// Set end time of the branch
	void setEndTime(double t);

	// get parent of the branch
	genealogy_branch* getParent();

	// get child 1 of the branch
	genealogy_branch* getChild1();

	// get child 2 of the branch
	genealogy_branch* getChild2();

	// get start time of the branch
	double getStartTime();

	// Get end time of the branch
	double getEndTime();

	// Get number of leaves this branch of underneath it (including itself)
	int getNumberOfLeaf();

	// Get the event in which this branch started
	int getEventId();

	// Get the population id in which this branch is in
	int getPopulationId();

	// Get partition
	partition* getPartition();

	// DEBUG
	int getUID();
};

class genealogy {
	//------------------------------------------------------------------
	// Members
	// Set of branches
	std::vector<genealogy_branch*> branches;

	// Pointer
	int pointer;

public:
	//------------------------------------------------------------------
	// Constructors
	genealogy(int n);
	virtual ~genealogy();

public:
	//------------------------------------------------------------------
	// Methods

	// add branch to genealogy
	void addBranch(genealogy_branch* pBranch);

	// get genealogy branch, NULL if over the limit
	genealogy_branch* getBranch(int i);

	// get number of branches in the genealogy
	int getBranchSize();

	// print genealogy to stdout
	void printGenealogy();

private:
	//------------------------------------------------------------------
	// Helpers
	void printGenealogyRecursive(genealogy_branch* pBranch, std::string pad, int& i);
};

#endif /* GENEALOGY_H_ */
