/*
 * genealogy.cpp
 *
 */

// My Include
#include "genealogy.h"

// Includes
#include <assert.h>
#include <stdio.h>
#include "../dmo/partition.h"

static int branch_counter = 0;

//----------------------------------------------------------------------
// Constructors
genealogy_branch::genealogy_branch(int idx, int n, int popid, int eventid) :
	pParent(NULL),
	pChild1(NULL),
	pChild2(NULL),
	t1(0),
	t2(0),
	numOfLeaf(1),
	popId(popid),
	eventId(eventid),
	uid(branch_counter++)
{
	std::vector<bool> p(n, 0);
	p[idx] = 1;
	this->pPartition = new partition(p);
}

genealogy_branch::genealogy_branch(genealogy_branch* pChild1, genealogy_branch* pChild2, double t, int popid, int eventid) :
	pParent(NULL),
	pChild1(pChild1),
	pChild2(pChild2),
	t1(t),
	t2(0),
	numOfLeaf(pChild1->numOfLeaf+pChild2->numOfLeaf),
	popId(popid),
	eventId(eventid),
	uid(branch_counter++)
{
	int n = (int)pChild1->getPartition()->size();
	std::vector<bool> p(n, 0);
	for (int i = 0; i < n; ++i) {
		p[i] = pChild1->getPartition()->get(i) | pChild2->getPartition()->get(i);
	}
	this->pPartition = new partition(p);
}

genealogy_branch::~genealogy_branch() {
	delete this->pPartition;
}

//----------------------------------------------------------------------
// Methods

// Set parent of the branch
void genealogy_branch::setParent(genealogy_branch* pParent) {
	this->pParent = pParent;
}

// Set child 1 of the branch
void genealogy_branch::setChild1(genealogy_branch* pChild1) {
	this->pChild1 = pChild1;
}

// Set child 2 of the branch
void genealogy_branch::setChild2(genealogy_branch* pChild2) {
	this->pChild2 = pChild2;
}

// Set start time of the branch
void genealogy_branch::setStartTime(double t) {
	this->t1 = t;
}

// Set end time of the branch
void genealogy_branch::setEndTime(double t) {
	this->t2 = t;
}

// Set parent of the branch
genealogy_branch* genealogy_branch::getParent() {
	return this->pParent;
}

// Set child 1 of the branch
genealogy_branch* genealogy_branch::getChild1() {
	return this->pChild1;
}

// Set child 2 of the branch
genealogy_branch* genealogy_branch::getChild2() {
	return this->pChild2;
}

// Set start time of the branch
double genealogy_branch::getStartTime() {
	return this->t1;
}

// Set end time of the branch
double genealogy_branch::getEndTime() {
	return this->t2;
}

// Get number of leaves this branch of underneath it (including itself)
int genealogy_branch::getNumberOfLeaf() {
	return this->numOfLeaf;
}

// Get the event in which this branch started
int genealogy_branch::getEventId() {
	return this->eventId;
}

// Get the population id in which this branch is in
int genealogy_branch::getPopulationId() {
	return this->popId;
}

// Get partition
partition* genealogy_branch::getPartition() {
	return this->pPartition;
}

// DEBUG
int genealogy_branch::getUID() {
	return this->uid;
}
//----------------------------------------------------------------------
// GENEALOGY

genealogy::genealogy(int n) : branches(std::vector<genealogy_branch*>(n)), pointer(0) {
	branch_counter = 0;
}

genealogy::~genealogy() {
	for (int i = 0; i < (int)branches.size(); ++i) {
		delete branches[i];
	}
	branches.clear();
}

// add branch to genealogy
void genealogy::addBranch(genealogy_branch* pBranch) {
	if (pointer >= (int)branches.size()) {
		printf("%d %d", pointer, branches.size());
	}
	assert(pointer < (int)branches.size());
	this->branches[pointer++] = pBranch;
}

// get genealogy branch, NULL if over the limit
genealogy_branch* genealogy::getBranch(int i) {
	if (i < pointer && pointer >= 0) {
		return branches[i];
	}
	return NULL;
}

// get number of branches in the genealogy
int genealogy::getBranchSize() {
	return pointer;
}

// print genealogy to stdout
void genealogy::printGenealogy() {
	for (int i = 0; i < (int)branches.size(); ++i) {
		printf("%i(%d) ", i, branches[i]->getUID());
		fflush(stdout);
	}
	printf("\n");
	genealogy_branch* pRoot = branches[pointer-1];
	printf("branches: %d\n", pointer);
	fflush(stdout);
	printf("%3d:%s\n", pRoot->getUID(), pRoot->getPartition()->getBase64String().data());
	fflush(stdout);
	int i = 1;
	printGenealogyRecursive(pRoot, std::string(" "), i);
}

//------------------------------------------------------------------
// Helpers
void genealogy::printGenealogyRecursive(genealogy_branch* pBranch, std::string pad, int& i) {
	if (pBranch != NULL) {
		pad.push_back(' ');
		if (pBranch->getChild1() != NULL) {
			++i;
			printf("%3d:%s%s(%3.1f-%3.1f)\n", pBranch->getChild1()->getUID(), pad.data(), pBranch->getChild1()->getPartition()->getBase64String().data(), pBranch->getChild1()->getStartTime()*40000.0, pBranch->getChild1()->getEndTime()*40000.0);
			fflush(stdout);
			printGenealogyRecursive(pBranch->getChild1(), pad, i);
		}

		if (pBranch->getChild2() != NULL) {
			++i;
			printf("%3d:%s%s(%3.1f-%3.1f)\n", pBranch->getChild2()->getUID(), pad.data(), pBranch->getChild2()->getPartition()->getBase64String().data(), pBranch->getChild2()->getStartTime()*40000.0, pBranch->getChild2()->getEndTime()*40000.0);
			fflush(stdout);
			printGenealogyRecursive(pBranch->getChild2(), pad, i);
		}
	}
}
